/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.structure;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.structure.StructureObjectCopyOptions;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class StructureObjectDAO {
    private static final String PREFIX = "structure/object";

    public static StructureObject get(Transaction trx, int id) {
        return (StructureObject)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureObject.class);
    }

    public static StructureObject[] get(Transaction trx, int ... ids) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get/trx=%s", PREFIX, trx, ids)).request().post(Entity.json((Object)ids)).readEntity(StructureObject[].class);
    }

    public static Map<Integer, StructureObject> getAsMap(Transaction trx) {
        StructureObject[] objects = StructureObjectDAO.getAll(trx);
        HashMap<Integer, StructureObject> map = new HashMap<Integer, StructureObject>();
        StructureObject[] structureObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            StructureObject var = structureObjectArray[n2];
            map.put(var.getId(), var);
            ++n2;
        }
        return map;
    }

    public static Map<Integer, StructureObject> getAsMap(Transaction trx, int[] ids) {
        StructureObject[] objects = StructureObjectDAO.get(trx, ids);
        HashMap<Integer, StructureObject> map = new HashMap<Integer, StructureObject>();
        StructureObject[] structureObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            StructureObject var = structureObjectArray[n2];
            map.put(var.getId(), var);
            ++n2;
        }
        return map;
    }

    public static StructureObject get(Transaction trx, String key) {
        return (StructureObject)Client.getWebTarget().path(String.format("%s/get/trx=%s&key=%s", PREFIX, trx, key)).request().get(StructureObject.class);
    }

    public static StructureObject[] getAll(Transaction trx) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(StructureObject[].class);
    }

    public static StructureObject[] getRoots(Transaction trx) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_roots/trx=%s", PREFIX, trx)).request().get(StructureObject[].class);
    }

    public static StructureObject[] getRootParents(Transaction trx, StructureObject object) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_root_parents/trx=%s&id=%d", PREFIX, trx, object.getId())).request().get(StructureObject[].class);
    }

    public static StructureObject[] getChildren(Transaction trx, StructureObject object) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_children/trx=%s&id=%d", PREFIX, trx, object.getId())).request().get(StructureObject[].class);
    }

    public static StructureObject[] getAllChildren(Transaction trx, StructureObject object) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_all_children/trx=%s&id=%d", PREFIX, trx, object.getId())).request().get(StructureObject[].class);
    }

    public static StructureObject[] getTopChildrenOfClass(Transaction trx, StructureObject object, StructureClass structureClass) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_top_children/trx=%s&id=%d&class_id=%d", PREFIX, trx, object.getId(), structureClass.getId())).request().get(StructureObject[].class);
    }

    public static StructureObject[] findObjects(Transaction trx, StructureObject object, StructureClass structureClass, SearchPolicy searchPolicy) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/find_objects/trx=%s&id=%d&class_id=%d&policy=%s", PREFIX, trx, object.getId(), structureClass.getId(), searchPolicy != null ? searchPolicy.name() : "")).request().get(StructureObject[].class);
    }

    public static boolean isSubchild(Transaction trx, StructureObject parent, StructureObject child) {
        return (Boolean)Client.getWebTarget().path(String.format("%s/is_subchild/trx=%s&parent_id=%d&child_id=%d", PREFIX, trx, parent.getId(), child.getId())).request().get(Boolean.class);
    }

    public static void createMissingVariableInstances(Transaction trx, StructureObject object) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/create_missing_variable_instances/trx=%s&id=%d", PREFIX, trx, object.getId())).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static int saveOrUpdate(Transaction trx, StructureObject structureObject) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)structureObject));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static int createCopy(Transaction trx, StructureObject srcObject, StructureObjectCopyOptions copyOptions) throws DAOOperationException {
        String url = String.format("%s/create_copy/trx=%s&src_id=%d", PREFIX, trx, srcObject.getId());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)copyOptions));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

