/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.time;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.PhaseType;
import de.elpro.ewms.core.time.Timeline;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class PhaseTypeDAO {
    private static final String PREFIX = "timeline/phase_type";

    public static PhaseType get(Transaction trx, int id) {
        return (PhaseType)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(PhaseType.class);
    }

    public static PhaseType[] getAll(Transaction trx) {
        return (PhaseType[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(PhaseType[].class);
    }

    public static PhaseType[] getAll(Transaction trx, Timeline timeline) {
        return (PhaseType[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&timeline_key=%s", PREFIX, trx, timeline.getKey())).request().get(PhaseType[].class);
    }

    public static int saveOrUpdate(Transaction trx, PhaseType phaseType) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)phaseType));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, PhaseType pt) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, pt.getId())).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

