/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.utils;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.structure.StructureTreeSearchException;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.PropertyInstanceReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;

public class StructureUtils {
    public static FormulaNode resolveDependencies(StructureObject structureObject, FormulaNode formulaNode) throws StructureTreeSearchException {
        Transaction trx = Transactions.begin();
        try {
            FormulaNode formulaNode2 = StructureUtils.resolveDependencies(trx, structureObject, formulaNode);
            return formulaNode2;
        }
        finally {
            Transactions.close(trx);
        }
    }

    private static FormulaNode resolveDependencies(Transaction trx, StructureObject structureObject, FormulaNode formulaNode) throws StructureTreeSearchException {
        FormulaNode copy = new FormulaNode(formulaNode.getName());
        switch (formulaNode.getType()) {
            case PropertyRef: {
                Object refObject = formulaNode.getNodeObject();
                if (refObject instanceof PropertyReference) {
                    PropertyReference propertyReference = (PropertyReference)refObject;
                    Property property = PropertyDAO.get(trx, propertyReference.getProperty().getGroup().getKey(), propertyReference.getProperty().getKey());
                    if (property == null) {
                        throw new StructureTreeSearchException(String.format("Cannot find property for %s", propertyReference));
                    }
                    PropertyGroup pg = PropertyGroupDAO.get(trx, property.getGroup().getKey());
                    StructureObject[] pvObject = StructureObjectDAO.findObjects(trx, structureObject, pg.getStructureClass(), propertyReference.getSearchPolicy());
                    if (pvObject.length != 1) {
                        throw new StructureTreeSearchException(String.format("Cannot find structure object for reference %s", propertyReference));
                    }
                    PropertyValue pv = pvObject[0].getPropertyValue(property);
                    try {
                        MeasuringUnitValue value = (MeasuringUnitValue)pv.getTypeValue();
                        if (value == null) {
                            return new FormulaNode(Double.toString(Double.NaN));
                        }
                        return new FormulaNode(Double.toString(value.getValue()));
                    }
                    catch (Exception exc) {
                        throw new StructureTreeSearchException(exc.getMessage());
                    }
                }
                if (!(refObject instanceof PropertyInstanceReference)) break;
                PropertyInstanceReference propertyInstanceReference = (PropertyInstanceReference)refObject;
                Property property = PropertyDAO.get(trx, propertyInstanceReference.getProperty().getGroup().getKey(), propertyInstanceReference.getProperty().getKey());
                if (property == null) {
                    throw new StructureTreeSearchException(String.format("Cannot find property for %s", propertyInstanceReference));
                }
                PropertyGroupDAO.get(trx, property.getGroup().getKey());
                StructureObject pvObject = StructureObjectDAO.get(trx, propertyInstanceReference.getStructureObjectKey());
                if (pvObject == null) {
                    throw new StructureTreeSearchException(String.format("Cannot find structure object for reference %s", propertyInstanceReference));
                }
                PropertyValue pv = pvObject.getPropertyValue(property);
                try {
                    MeasuringUnitValue value = (MeasuringUnitValue)pv.getTypeValue();
                    if (value == null) {
                        return new FormulaNode(Double.toString(Double.NaN));
                    }
                    return new FormulaNode(Double.toString(value.getValue()));
                }
                catch (Exception exc) {
                    throw new StructureTreeSearchException(exc.getMessage());
                }
            }
        }
        int i = 0;
        while (i < formulaNode.getParameters().size()) {
            copy.getParameters().add(StructureUtils.resolveDependencies(trx, structureObject, (FormulaNode)formulaNode.getParameters().get(i)));
            ++i;
        }
        return copy;
    }
}

