/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.variable;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.IVariableRole;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableRole;

public class VariableRoleDAO {
    public static final String PREFIX = "variable/role";

    public static VariableRole get(String id) {
        return (VariableRole)Client.getWebTarget().path(String.format("%s/get/id=%s", PREFIX, id)).request().get(VariableRole.class);
    }

    public static VariableRole[] getAll(Transaction trx) {
        return (VariableRole[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(VariableRole[].class);
    }

    public static VariableRole[] getAll(Transaction trx, StructureClass structureClass) {
        return (VariableRole[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(VariableRole[].class);
    }

    public static VariableRole[] getAll(Transaction trx, StructureClass structureClass, PhysicalUnit unit) {
        return (VariableRole[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&class_id=%d&pu_key=%s", PREFIX, trx, structureClass.getId(), unit.getKey())).request().get(VariableRole[].class);
    }

    public static Variable[] getVariables(Transaction trx, String variableRoleId) {
        return (Variable[])Client.getWebTarget().path(String.format("%s/get_variables/trx=%s&role_id=%s", PREFIX, trx, variableRoleId)).request().get(Variable[].class);
    }

    private static Variable getUniqueVariableInternal(Transaction trx, String roleId) {
        return (Variable)Client.getWebTarget().path(String.format("%s/get_variable/trx=%s&role_id=%s", PREFIX, trx, roleId)).request().get(Variable.class);
    }

    public static Variable getUniqueVariable(Transaction trx, IVariableRole variableRole) throws IllegalConfigException {
        Variable variable = VariableRoleDAO.getUniqueVariableInternal(trx, variableRole.getId());
        if (variable == null) {
            throw new IllegalConfigException(String.format("No unique variable for role '%s' found", VariableRoleDAO.toString(variableRole), variableRole.getId()));
        }
        return variable;
    }

    public static Variable getUniqueVariable(Transaction trx, String variableRoleId) throws IllegalConfigException {
        Variable variable = VariableRoleDAO.getUniqueVariableInternal(trx, variableRoleId);
        if (variable == null) {
            throw new IllegalConfigException(String.format("No unique variable for role '%s' found", variableRoleId));
        }
        return variable;
    }

    private static VariableInstance getVariableInstanceInternal(Transaction trx, String variableRoleId, StructureObject structureObject) {
        return (VariableInstance)Client.getWebTarget().path(String.format("%s/get_variable_instance/trx=%s&role_id=%s&obj_id=%d", PREFIX, trx, variableRoleId, structureObject.getId())).request().get(VariableInstance.class);
    }

    public static VariableInstance getVariableInstance(Transaction trx, IVariableRole role, StructureObject structureObject) throws IllegalConfigException {
        VariableInstance instance = VariableRoleDAO.getVariableInstanceInternal(trx, role.getId(), structureObject);
        if (instance == null) {
            throw new IllegalConfigException(String.format("No variable instance for role '%s' and object '%s' found", VariableRoleDAO.toString(role), structureObject));
        }
        return instance;
    }

    public static VariableInstance getVariableInstance(Transaction trx, String variableRoleId, StructureObject structureObject) throws IllegalConfigException {
        VariableInstance instance = VariableRoleDAO.getVariableInstanceInternal(trx, variableRoleId, structureObject);
        if (instance == null) {
            throw new IllegalConfigException(String.format("No variable instance for role '%s' and object '%s' found", variableRoleId, structureObject));
        }
        return instance;
    }

    private static VariableInstance getVariableInstanceInternal(Transaction trx, String variableRoleId, String objectKey) {
        return (VariableInstance)Client.getWebTarget().path(String.format("%s/get_variable_instance/trx=%s&role_id=%s&obj_key=%s", PREFIX, trx, variableRoleId, objectKey)).request().get(VariableInstance.class);
    }

    public static VariableInstance getVariableInstance(Transaction trx, IVariableRole role, String objectKey) throws IllegalConfigException {
        VariableInstance instance = VariableRoleDAO.getVariableInstanceInternal(trx, role.getId(), objectKey);
        if (instance == null) {
            throw new IllegalConfigException(String.format("No variable instance for role '%s' and object key '%s' found", VariableRoleDAO.toString(role), objectKey));
        }
        return instance;
    }

    public static VariableInstance getVariableInstance(Transaction trx, String variableRoleId, String objectKey) throws IllegalConfigException {
        VariableInstance instance = VariableRoleDAO.getVariableInstanceInternal(trx, variableRoleId, objectKey);
        if (instance == null) {
            throw new IllegalConfigException(String.format("No variable instance for role '%s' and object key '%s' found", variableRoleId, objectKey));
        }
        return instance;
    }

    private static String toString(IVariableRole role) {
        return String.format("%s [%s], Str.Class(%s)", role.getName(), role.getPhysicalUnit().getName(), role.getClassRoleId());
    }
}

