/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.worker;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.worker.BackgroundWorkerDescriptor;
import de.elpro.ewms.core.worker.BackgroundWorkerGroup;
import javax.ws.rs.client.Entity;

public class BackgroundWorkerDAO {
    public static final String PREFIX = "background_worker";

    public static BackgroundWorkerGroup[] getBackgroundWorkerGroups() {
        String url = String.format("%s/get_background_worker_groups", PREFIX);
        BackgroundWorkerGroup[] result = (BackgroundWorkerGroup[])Client.getWebTarget().path(url).request().get(BackgroundWorkerGroup[].class);
        return result;
    }

    public static BackgroundWorkerDescriptor[] getBackgroundWorkers(BackgroundWorkerGroup group) {
        String url = String.format("%s/get_background_workers/group_id=%s", PREFIX, group.getId());
        BackgroundWorkerDescriptor[] result = (BackgroundWorkerDescriptor[])Client.getWebTarget().path(url).request().get(BackgroundWorkerDescriptor[].class);
        return result;
    }

    public static BackgroundWorkerDescriptor[] getBackgroundWorkers(String ... ids) {
        String url = String.format("%s/get_background_workers", PREFIX);
        BackgroundWorkerDescriptor[] result = (BackgroundWorkerDescriptor[])Client.getWebTarget().path(url).request().post(Entity.json((Object)ids), BackgroundWorkerDescriptor[].class);
        return result;
    }

    public static void startAsync(String workerId) throws DAOOperationException {
        String url = String.format("%s/background_worker/start_async/id=%s", PREFIX, workerId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            result.raiseException();
        }
    }

    public static void stopAsync(String workerId) throws DAOOperationException {
        String url = String.format("%s/background_worker/stop_async/id=%s", PREFIX, workerId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            result.raiseException();
        }
    }

    public static void pause(String workerId) throws DAOOperationException {
        String url = String.format("%s/background_worker/pause/id=%s", PREFIX, workerId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            result.raiseException();
        }
    }

    public static void resume(String workerId) throws DAOOperationException {
        String url = String.format("%s/background_worker/resume/id=%s", PREFIX, workerId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            result.raiseException();
        }
    }

    public static void restartAsync(String workerId) throws DAOOperationException {
        String url = String.format("%s/background_worker/restart_async/id=%s", PREFIX, workerId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            result.raiseException();
        }
    }

    public static void terminate(String workerId) throws DAOOperationException {
        String url = String.format("%s/background_worker/terminate/id=%s", PREFIX, workerId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            result.raiseException();
        }
    }
}

