/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.formula.hover;

import de.elpro.ewms.core.fx.editors.formula.FormulaInput;
import de.elpro.ewms.core.fx.editors.formula.services.AnalysisService;
import de.elpro.ewms.core.lang.model.HoverInformation;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.text.hover.DefaultHoverInfoType;
import org.eclipse.fx.text.hover.DocumentHoverProvider;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.hover.HoverInfoType;
import org.eclipse.fx.text.hover.HtmlString;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;

public class EOSExHoverProvider
implements DocumentHoverProvider {
    private final FormulaInput fInput;
    private final AnalysisService analysis;

    @Inject
    public EOSExHoverProvider(Input<?> input, AnalysisService analysis) {
        this.fInput = (FormulaInput)input;
        this.analysis = analysis;
    }

    private Optional<Position> findPosition(IDocument document, int offset) {
        try {
            String[] stringArray = document.getPositionCategories();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                Position[] positionArray = document.getPositions(cat);
                int n3 = positionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Position p = positionArray[n4];
                    if (p.offset >= offset && p.offset + p.length < offset) {
                        return Optional.of(p);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    public Set<HoverInfo> getHoverInfo(IDocument document, int offset) {
        try {
            String htmlText;
            HoverInformation[] hovers;
            Region region;
            ITypedRegion partition = document.getPartition(offset);
            String partitionType = partition.getType();
            Optional<Position> position = this.findPosition(document, offset);
            Region region2 = region = position.isPresent() ? new Region(position.get().offset, position.get().length) : new Region(offset, 0);
            if ("__dftl_partition_content_type".equals(partitionType) && (hovers = this.analysis.getHovers(this.fInput.getData(), offset)).length > 0 && (htmlText = hovers[0].getDoc()) != null && !htmlText.isEmpty()) {
                HtmlString html = new HtmlString(htmlText);
                return Collections.singleton(new HoverInfo((HoverInfoType)DefaultHoverInfoType.DOCUMENTATION, (IRegion)region, (CharSequence)html, null));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return Collections.emptySet();
    }
}

