/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.formula.marker;

import de.elpro.ewms.core.fx.editors.formula.FormulaInput;
import de.elpro.ewms.core.fx.editors.formula.marker.ActivePairAnnotation;
import de.elpro.ewms.core.fx.editors.formula.marker.EOSExAnnotation;
import de.elpro.ewms.core.fx.editors.formula.pair.PairManager;
import de.elpro.ewms.core.fx.editors.formula.pair.PairType;
import de.elpro.ewms.core.fx.editors.formula.pair.PairTypeProvider;
import de.elpro.ewms.core.fx.editors.formula.services.AnalysisService;
import de.elpro.ewms.core.lang.model.AnalysisError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.services.EditingContext;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

public class EOSExAnnotationModel
extends AnnotationModel {
    private final ThreadSynchronize synchronize;
    private final EditingContext editingContext;
    private final IDocument document;
    private final FormulaInput input;
    private final PairManager pairManager;
    private final AnalysisService analysis;
    private ActivePairAnnotation activePairAnnotation = null;

    @Inject
    public EOSExAnnotationModel(IDocument document, EditingContext editingContext, Input<?> input, ThreadSynchronize synchronize, AnalysisService analysis) {
        this.synchronize = synchronize;
        this.document = document;
        this.editingContext = editingContext;
        this.input = (FormulaInput)input;
        this.analysis = analysis;
        this.pairManager = new PairManager(document, editingContext, new PairTypeProvider());
        this.input.formulaTextProperty().addListener((o, ov, nv) -> this.updateErrors((String)nv));
        this.updateErrors(this.input.getData());
        this.editingContext.registerOnCaretOffsetChanged(this::onCaretOffsetChanged);
    }

    private void setActivePairAnnotation(Optional<IRegion> region) {
        if (this.activePairAnnotation != null) {
            this.removeAnnotation(this.activePairAnnotation);
        }
        if (region.isPresent()) {
            this.activePairAnnotation = new ActivePairAnnotation();
            this.addAnnotation(this.activePairAnnotation, region.map(r -> new Position(r.getOffset(), r.getLength())).get());
        }
    }

    private void onCaretOffsetChanged(int caretOffset) {
        Optional<PairType.Pair> caretPair = this.pairManager.getHighlightPair(caretOffset);
        Optional<PairType.Pair> opposite = caretPair.map(p -> p.getOpposite());
        Optional<IRegion> oppositeRegion = opposite.map(p -> p.getRegion());
        this.setActivePairAnnotation(oppositeRegion);
    }

    private void updateErrors(String formula) {
        this.synchronize.asyncExec(() -> {
            AnalysisError[] errors = this.analysis.getErrors(formula);
            Iterator annotationIterator = this.getAnnotationIterator();
            ArrayList<Annotation> removed = new ArrayList<Annotation>();
            while (annotationIterator.hasNext()) {
                Object next = annotationIterator.next();
                if (!(next instanceof EOSExAnnotation)) continue;
                removed.add((Annotation)next);
            }
            HashMap<EOSExAnnotation, Position> added = new HashMap<EOSExAnnotation, Position>();
            AnalysisError[] analysisErrorArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                AnalysisError e = analysisErrorArray[n2];
                added.put(new EOSExAnnotation(e), new Position(e.getLocation().getOffset(), e.getLocation().getLength()));
                ++n2;
            }
            this.replaceAnnotations(removed.toArray(new Annotation[0]), added);
        });
    }
}

