/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.formula.pair;

import de.elpro.ewms.core.fx.editors.formula.pair.PairType;
import de.elpro.ewms.core.fx.editors.formula.pair.PairTypeProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.fx.code.editor.services.EditingContext;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class PairManager {
    private IDocument document;
    private EditingContext editingContext;
    private PairTypeProvider provider;
    private boolean spacesForTab = false;
    private int tabAdvance = 4;

    public PairManager(IDocument document, EditingContext editingContext, PairTypeProvider provider) {
        this.document = document;
        this.editingContext = editingContext;
        this.provider = provider;
        provider.init(document);
    }

    private Map<Integer, Integer> buildIndentMap() {
        HashMap<Integer, Integer> indentMap = new HashMap<Integer, Integer>();
        int indent = 0;
        int lineIndex = 0;
        while (lineIndex < this.document.getNumberOfLines()) {
            int delta = 0;
            for (PairType t : this.provider.getIntendationPairTypes()) {
                List<PairType.Pair> pairsInLine = t.getPairsInLine(lineIndex);
                delta = (int)((long)delta + pairsInLine.stream().filter(p -> p.getSide() == PairType.PairSide.LEFT).count());
                delta = (int)((long)delta - pairsInLine.stream().filter(p -> p.getSide() == PairType.PairSide.RIGHT).count());
            }
            if (delta < 0) {
                indent += delta;
            }
            indentMap.put(lineIndex, indent);
            if (delta > 0) {
                indent += delta;
            }
            ++lineIndex;
        }
        return indentMap;
    }

    public void autoformat() {
        this.autoNewLines();
        this.autoIndent();
    }

    public void autoNewLines() {
        try {
            String formatted = "";
            int lineIndex = 0;
            while (lineIndex < this.document.getNumberOfLines()) {
                int lI = lineIndex;
                List pairsInLine = this.provider.getAutoFormatEnterPairTypes().stream().flatMap(p -> p.getPairsInLine(lI).stream()).sorted((a, b) -> a.getRegion().getOffset() - b.getRegion().getOffset()).collect(Collectors.toList());
                IRegion lineInformation = this.document.getLineInformation(lineIndex);
                if (pairsInLine.size() > 1) {
                    int cur = lineInformation.getOffset();
                    for (PairType.Pair pair : pairsInLine) {
                        String part = this.document.get(cur, pair.getRegion().getOffset() + pair.getRegion().getLength() - cur);
                        formatted = String.valueOf(formatted) + part;
                        formatted = String.valueOf(formatted) + "\n";
                        cur = pair.getRegion().getOffset() + pair.getRegion().getLength();
                    }
                    String lastPart = this.document.get(cur, lineInformation.getOffset() + lineInformation.getLength() - cur);
                    formatted = String.valueOf(formatted) + lastPart;
                } else {
                    String string = this.document.get(lineInformation.getOffset(), lineInformation.getLength());
                    formatted = String.valueOf(formatted) + string;
                }
                String lineDelimiter = this.document.getLineDelimiter(lineIndex);
                if (lineDelimiter != null) {
                    formatted = String.valueOf(formatted) + lineDelimiter;
                }
                ++lineIndex;
            }
            this.document.set(formatted);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void fixIndentationOnEnter(boolean fixAlsoNextLine) {
        try {
            int caretOffset = this.editingContext.getCaretOffset();
            int lineIndex = this.document.getLineOfOffset(caretOffset);
            this.document.replace(caretOffset, 0, "\n");
            Map<Integer, Integer> indentMap = this.buildIndentMap();
            int indent = indentMap.get(lineIndex + 1);
            String tabs = this.getTabs(indent);
            this.document.replace(caretOffset + 1, 0, tabs);
            if (fixAlsoNextLine) {
                int indent2 = indentMap.get(lineIndex + 2);
                String tabs2 = this.getTabs(indent2);
                IRegion lf = this.document.getLineInformation(lineIndex + 2);
                String line = this.document.get(lf.getOffset(), lf.getLength());
                line = line.replaceAll("^\\s*", "");
                line = String.valueOf(tabs2) + line;
                this.document.replace(lf.getOffset(), lf.getLength(), line);
            }
            this.editingContext.setCaretOffset(caretOffset + 1 + tabs.length());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<PairType.Pair> getHighlightPair(int offset) {
        for (PairType t : this.provider.getHighlightPairTypes()) {
            Optional<PairType.Pair> pairAtOffset = t.getPairAtOffset(offset);
            if (!pairAtOffset.isPresent()) continue;
            return pairAtOffset;
        }
        return Optional.empty();
    }

    public void autoIndent() {
        Map<Integer, Integer> indentMap = this.buildIndentMap();
        try {
            String formatted = "";
            int lineIndex = 0;
            while (lineIndex < this.document.getNumberOfLines()) {
                int count = indentMap.get(lineIndex);
                IRegion lineInformation = this.document.getLineInformation(lineIndex);
                String string = this.document.get(lineInformation.getOffset(), lineInformation.getLength());
                string = string.replaceAll("^\\s*", this.getTabs(count));
                formatted = String.valueOf(formatted) + string;
                String lineDelimiter = this.document.getLineDelimiter(lineIndex);
                if (lineDelimiter != null) {
                    formatted = String.valueOf(formatted) + lineDelimiter;
                }
                ++lineIndex;
            }
            this.document.set(formatted);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Inject
    public void setTabAdvance(@Preference(nodePath="org.eclipse.fx.code.editor", key="tabAdvance") Integer tabAdvance) {
        this.tabAdvance = tabAdvance;
    }

    @Inject
    public void setInsertSpacesForTab(@Preference(nodePath="org.eclipse.fx.code.editor", key="spacesForTab") Boolean spacesForTab) {
        this.spacesForTab = spacesForTab;
    }

    private String repeat(String s, int count) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < count) {
            result.append(s);
            ++i;
        }
        return result.toString();
    }

    private String getTabString() {
        if (this.spacesForTab) {
            return this.repeat(" ", this.tabAdvance);
        }
        return "\t";
    }

    private String getTabs(int count) {
        return this.repeat(this.getTabString(), count);
    }
}

