/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.formula.pair;

import de.elpro.ewms.core.fx.editors.formula.pair.PairType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class PatternPairType
implements PairType {
    private final IDocument document;
    private final Pattern pattern;
    private Map<IRegion, PairType.Pair> pairIndex = new HashMap<IRegion, PairType.Pair>();

    public PatternPairType(IDocument document, String left, String right) {
        this.pattern = Pattern.compile("(" + Pattern.quote(left) + ")|(" + Pattern.quote(right) + ")");
        this.document = document;
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                PatternPairType.this.buildPairIndex();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.buildPairIndex();
    }

    private void buildPairIndex() {
        this.pairIndex.clear();
        Stack<IRegion> leftSide = new Stack<IRegion>();
        Matcher matcher = this.pattern.matcher(this.document.get());
        while (matcher.find()) {
            IRegion left;
            if (matcher.group(1) != null) {
                left = new Region(matcher.start(1), matcher.end(1) - matcher.start(1));
                leftSide.push(left);
                continue;
            }
            if (matcher.group(2) == null || leftSide.isEmpty()) continue;
            left = (IRegion)leftSide.pop();
            Region right = new Region(matcher.start(2), matcher.end(2) - matcher.start(2));
            PairType.Pair pair = PairType.Pair.create(this, PairType.PairSide.LEFT, left, (IRegion)right);
            this.pairIndex.put(left, pair);
            this.pairIndex.put((IRegion)right, pair.getOpposite());
        }
    }

    private boolean contains(IRegion region, int offset) {
        return region.getOffset() <= offset && region.getOffset() + region.getLength() >= offset;
    }

    private boolean contains(IRegion region, IRegion test) {
        return this.contains(region, test.getOffset()) && this.contains(region, test.getOffset() + test.getLength());
    }

    @Override
    public Optional<PairType.Pair> getPairAtOffset(int offset) {
        for (IRegion r : this.pairIndex.keySet()) {
            if (!this.contains(r, offset)) continue;
            return Optional.of(this.pairIndex.get(r));
        }
        return Optional.empty();
    }

    @Override
    public List<PairType.Pair> getPairsInLine(int lineIndex) {
        ArrayList<PairType.Pair> pairsInLine = new ArrayList<PairType.Pair>();
        try {
            IRegion lineInformation = this.document.getLineInformation(lineIndex);
            for (IRegion r : this.pairIndex.keySet()) {
                if (!this.contains(lineInformation, r)) continue;
                pairsInLine.add(this.pairIndex.get(r));
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(pairsInLine, (a, b) -> a.getRegion().getOffset() - b.getRegion().getOffset());
        return pairsInLine;
    }
}

