/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.formula.presenter;

import de.elpro.ewms.core.fx.editors.formula.marker.EOSExBreakpointAnnotation;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.text.ui.source.ILineRulerAnnotationPresenter;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class BreakpointIcon
implements ILineRulerAnnotationPresenter {
    private GraphicsLoader loader;
    private IAnnotationModel model;
    private IDocument document;
    private DoubleProperty width = new SimpleDoubleProperty(16.0);
    private Image image;

    public BreakpointIcon(GraphicsLoader loader, IAnnotationModel model, IDocument document) {
        this.loader = loader;
        this.model = model;
        this.document = document;
    }

    public DoubleProperty getWidth() {
        return this.width;
    }

    public ILineRulerAnnotationPresenter.LayoutHint getLayoutHint() {
        return ILineRulerAnnotationPresenter.LayoutHint.ALIGN_CENTER;
    }

    public int getOrder() {
        return 40;
    }

    public boolean isApplicable(Annotation annotation) {
        return annotation instanceof EOSExBreakpointAnnotation;
    }

    private ImageView getImageView(Node node) {
        return (ImageView)((BorderPane)node).getCenter();
    }

    public Node createNode() {
        BorderPane area = new BorderPane();
        area.setMinWidth(16.0);
        area.setMinHeight(16.0);
        ImageView i = new ImageView();
        Tooltip tt = new Tooltip();
        Tooltip.install((Node)i, (Tooltip)tt);
        i.setUserData((Object)tt);
        area.setCenter((Node)i);
        return area;
    }

    private Image getImage() {
        if (this.image == null) {
            this.image = this.loader.getImage(URI.createPlatformPluginURI((String)"at.bestsolution.dart.editor", (String)"css/icons/16/brkp_obj.png"));
        }
        return this.image;
    }

    private void updateImageView(ImageView view, EOSExBreakpointAnnotation a) {
        view.setImage(this.getImage());
    }

    private void updateNode(Node node, EOSExBreakpointAnnotation a) {
        this.updateImageView(this.getImageView(node), a);
        node.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.model.removeAnnotation((Annotation)a);
                e.consume();
            }
        });
    }

    public void updateNode(Node node, Set<Annotation> annotation) {
        annotation.stream().map(a -> (EOSExBreakpointAnnotation)((Object)a)).findFirst().ifPresent(a -> this.updateNode(node, (EOSExBreakpointAnnotation)((Object)a)));
    }

    public String toString() {
        return "DartStatusIconAP@" + this.hashCode();
    }

    private Position computePosition(int lineIdx) throws BadLocationException {
        IRegion lineInformation = this.document.getLineInformation(lineIdx);
        return new Position(lineInformation.getOffset(), lineInformation.getLength());
    }

    private void onLineRulerClick(int lineIdx, MouseEvent e) {
        if (e.getClickCount() == 2) {
            try {
                EOSExBreakpointAnnotation a = new EOSExBreakpointAnnotation();
                System.err.println("adding annotation " + (Object)((Object)a) + "   " + System.identityHashCode((Object)a));
                this.model.addAnnotation((Annotation)a, this.computePosition(lineIdx));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void initialize(ILineRulerAnnotationPresenter.LineRuler lineRuler) {
        lineRuler.subscribeMouseClicked(this::onLineRulerClick);
    }
}

