/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.formula.presenter;

import de.elpro.ewms.core.fx.editors.formula.marker.EOSExAnnotation;
import de.elpro.ewms.core.lang.model.AnalysisError;
import de.elpro.ewms.core.lang.model.AnalysisErrorType;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.text.ui.source.ILineRulerAnnotationPresenter;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.jface.text.source.Annotation;

public class LineRulerStatusIcon
implements ILineRulerAnnotationPresenter {
    private GraphicsLoader loader;
    private DoubleProperty width = new SimpleDoubleProperty(16.0);
    private Comparator<AnalysisError> importance = (o1, o2) -> o2.getSeverity().compareTo((Enum)o1.getSeverity());
    private Image taskImage;
    private Image errorImage;
    private Image warningImage;
    private Image infoImage;

    public LineRulerStatusIcon(GraphicsLoader loader) {
        this.loader = loader;
    }

    public ILineRulerAnnotationPresenter.LayoutHint getLayoutHint() {
        return ILineRulerAnnotationPresenter.LayoutHint.ALIGN_CENTER;
    }

    public int getOrder() {
        return 50;
    }

    public boolean isApplicable(Annotation annotation) {
        return annotation instanceof EOSExAnnotation;
    }

    public Node createNode() {
        ImageView i = new ImageView();
        Tooltip tt = new Tooltip();
        Tooltip.install((Node)i, (Tooltip)tt);
        i.setUserData((Object)tt);
        return i;
    }

    private Image getTaskImage() {
        if (this.taskImage == null) {
            this.taskImage = this.loader.getImage(URI.createPlatformPluginURI((String)"de.elpro.ewms.core.fx.editors", (String)"css/icons/16/showtsk_tsk.png"));
        }
        return this.taskImage;
    }

    private Image getErrorImage() {
        if (this.errorImage == null) {
            this.errorImage = this.loader.getImage(URI.createPlatformPluginURI((String)"de.elpro.ewms.core.fx.editors", (String)"css/icons/validation_error.png"));
        }
        return this.errorImage;
    }

    private Image getWarningImage() {
        if (this.warningImage == null) {
            URI uri = URI.createPlatformPluginURI((String)"de.elpro.ewms.core.fx.editors", (String)"css/icons/validation_warning.png");
            this.warningImage = this.loader.getImage(uri);
        }
        return this.warningImage;
    }

    private Image getInfoImage() {
        if (this.infoImage == null) {
            this.infoImage = this.loader.getImage(URI.createPlatformPluginURI((String)"de.elpro.ewms.core.fx.editors", (String)"css/validation_info.png"));
        }
        return this.infoImage;
    }

    private Image getImage(AnalysisError error) {
        Image image = null;
        if (error.getType() == AnalysisErrorType.TODO) {
            image = this.getTaskImage();
        } else {
            switch (error.getSeverity()) {
                case ERROR: {
                    image = this.getErrorImage();
                    break;
                }
                case INFO: {
                    image = this.getInfoImage();
                    break;
                }
                case WARNING: {
                    image = this.getWarningImage();
                    break;
                }
            }
        }
        return image;
    }

    private void updateLabel(Label node, Set<EOSExAnnotation> annotation) {
        Image image = null;
        List<AnalysisError> byImportance = annotation.stream().map(EOSExAnnotation::getError).sorted(this.importance).collect(Collectors.toList());
        if (!byImportance.isEmpty()) {
            image = this.getImage((AnalysisError)byImportance.get(0));
        }
        ((ImageView)node.getGraphic()).setImage(image);
        String message = this.computeMessage(byImportance);
        if (message == null || message.isEmpty()) {
            node.setTooltip(null);
        } else {
            Tooltip tt = node.getTooltip();
            if (tt == null) {
                tt = new Tooltip(message);
                node.setTooltip(tt);
            } else {
                tt.setText(message);
            }
        }
    }

    private void updateImageView(ImageView node, Set<EOSExAnnotation> annotation) {
        Image image = null;
        List<AnalysisError> byImportance = annotation.stream().map(EOSExAnnotation::getError).sorted(this.importance).collect(Collectors.toList());
        if (!byImportance.isEmpty()) {
            image = this.getImage((AnalysisError)byImportance.get(0));
        }
        node.setImage(image);
        String message = this.computeMessage(byImportance);
        if (message == null || message.isEmpty()) {
            Tooltip tt = (Tooltip)node.getUserData();
            tt.setText("");
        } else {
            Tooltip tt = (Tooltip)node.getUserData();
            tt.setText(message);
        }
    }

    public void updateNode(Node node, Set<Annotation> annotation) {
        this.updateImageView((ImageView)node, annotation.stream().map(a -> (EOSExAnnotation)((Object)a)).collect(Collectors.toSet()));
    }

    private String computeMessage(List<AnalysisError> byImportance) {
        return byImportance.stream().map(e -> e.getSeverity() + ": " + e.getMessage()).collect(Collectors.joining("\n"));
    }

    public DoubleProperty getWidth() {
        return this.width;
    }
}

