/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.richtext;

import de.elpro.ewms.core.client.resources.ResourcesDAO;
import de.elpro.ewms.core.editors.model.ResourceImageURL;
import de.elpro.ewms.core.resources.ResourceLoader;
import de.elpro.ui.fx.utils.FXUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ImageDialog
extends Dialog<ButtonType> {
    private final ObservableList<ResourceImageURL> resources = FXCollections.observableArrayList();
    private final ListView<ResourceImageURL> resourcesView = new ListView(this.resources);

    public ImageDialog(Window window) {
        this.initOwner(window);
        this.resourcesView.setCellFactory(cf -> new ImagePreviewCell());
        this.resources.setAll((Collection)Arrays.stream(ResourcesDAO.getResources((String)"shared")).map(file -> ResourceImageURL.sharedImageURL((String)file)).collect(Collectors.toList()));
        this.getDialogPane().setContent(this.resourcesView);
        this.getDialogPane().setPrefSize(800.0, 800.0);
        ButtonType uploadImage = new ButtonType("Upload", ButtonBar.ButtonData.HELP_2);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{uploadImage, ButtonType.OK, ButtonType.CLOSE});
        Button uploadImageBtn = (Button)this.getDialogPane().lookupButton(uploadImage);
        uploadImageBtn.setText("Upload Image");
        FontIcon uploadIcon = new FontIcon((Ikon)MaterialDesign.MDI_CLOUD_UPLOAD);
        uploadIcon.setIconSize(20);
        uploadImageBtn.setGraphic((Node)uploadIcon);
        FXUtils.addOnMouseDoubleClickListener(this.resourcesView, ResourceImageURL.class, e -> {
            if (e != null) {
                this.setResult(ButtonType.OK);
                this.close();
            }
        });
        uploadImageBtn.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Image", new String[]{"*.png", ".jpeg", ".gif"}));
            File file = fileChooser.showOpenDialog(window);
            if (file != null) {
                ResourcesDAO.uploadResource((String)ResourceImageURL.sharedImageURL((String)file.getName()).getURL(), (File)file);
            }
            this.resources.setAll((Collection)Arrays.stream(ResourcesDAO.getResources((String)"shared")).map(fileName -> ResourceImageURL.sharedImageURL((String)fileName)).collect(Collectors.toList()));
        });
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)this.resourcesView.getSelectionModel().selectedItemProperty()));
        this.setOnCloseRequest(e -> {
            if (this.getResult() == uploadImage) {
                e.consume();
            }
        });
    }

    public ResourceImageURL getSelectedResource() {
        return (ResourceImageURL)this.resourcesView.getSelectionModel().getSelectedItem();
    }

    private static class ImagePreviewCell
    extends ListCell<ResourceImageURL> {
        private ImagePreviewCell() {
        }

        protected void updateItem(ResourceImageURL item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null) {
                this.setGraphic(null);
                this.setText(null);
            } else {
                String cachedIconPath = ResourceLoader.getCachedIconPath((String)item.getURL());
                Image image = new Image(cachedIconPath);
                if (image == null || image.getException() != null) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    BorderPane borderPane = new BorderPane();
                    Label fileNameLabel = new Label(item.getFile());
                    fileNameLabel.setPadding(new Insets(5.0));
                    ImageView preview = new ImageView(image);
                    double width = image.getWidth();
                    double height = image.getHeight();
                    double heigthRatio = 200.0 / height;
                    double widthRatio = 400.0 / width;
                    double ratio = Math.min(Math.min(heigthRatio, widthRatio), 1.0);
                    preview.setFitHeight(height * ratio);
                    preview.setFitWidth(width * ratio);
                    borderPane.setLeft((Node)new BorderPane((Node)fileNameLabel));
                    borderPane.setRight((Node)preview);
                    this.setGraphic((Node)borderPane);
                }
            }
        }
    }
}

