/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.editors.richtext;

import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.action.Action;
import com.gluonhq.richtextarea.action.DecorateAction;
import com.gluonhq.richtextarea.action.ParagraphDecorateAction;
import com.gluonhq.richtextarea.action.TextDecorateAction;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.TableDecoration;
import com.gluonhq.richtextarea.model.TextDecoration;
import de.elpro.ewms.core.editors.model.ResourceImageDecoration;
import de.elpro.ewms.core.fx.editors.richtext.ImageDialog;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.lineawesome.LineAwesomeSolid;

public class RichTextEditor
extends BorderPane {
    private final Label textLengthLabel = new Label();
    private final RichTextArea editor = new RichTextArea();

    public RichTextEditor() {
        this.editor.textLengthProperty().addListener((o, ov, nv) -> this.textLengthLabel.setText("Text length: " + nv));
        ComboBox presets = new ComboBox();
        presets.getItems().setAll((Object[])Presets.values());
        presets.setValue((Object)Presets.DEFAULT);
        presets.setPrefWidth(100.0);
        presets.setConverter((StringConverter)new StringConverter<Presets>(){

            public String toString(Presets presets) {
                return presets.getName();
            }

            public Presets fromString(String s) {
                return Presets.valueOf(s.replaceAll(" ", ""));
            }
        });
        presets.getSelectionModel().selectedItemProperty().addListener((observableValue, ov, nv) -> {
            this.editor.getActionFactory().decorate(new Decoration[]{TextDecoration.builder().presets().fontSize((double)nv.getFontSize()).fontWeight(nv.getWeight()).build(), ParagraphDecoration.builder().presets().alignment(nv.getTextAlignment()).build()}).execute(new ActionEvent());
            this.editor.requestFocus();
        });
        ComboBox fontFamilies = new ComboBox();
        fontFamilies.getItems().setAll((Collection)Font.getFamilies());
        fontFamilies.setValue((Object)"System");
        fontFamilies.setPrefWidth(100.0);
        new TextDecorateAction(this.editor, fontFamilies.valueProperty(), TextDecoration::getFontFamily, (builder, a) -> builder.fontFamily(a).build());
        ComboBox fontSize = new ComboBox();
        fontSize.setEditable(true);
        fontSize.setPrefWidth(60.0);
        fontSize.getItems().addAll((Collection)IntStream.range(1, 100).filter(i -> i % 2 == 0 || i < 18).asDoubleStream().boxed().collect(Collectors.toList()));
        new TextDecorateAction(this.editor, fontSize.valueProperty(), TextDecoration::getFontSize, (builder, a) -> builder.fontSize(a.doubleValue()).build());
        fontSize.setConverter((StringConverter)new StringConverter<Double>(){

            public String toString(Double aDouble) {
                return Integer.toString(aDouble.intValue());
            }

            public Double fromString(String s) {
                return Double.parseDouble(s);
            }
        });
        fontSize.setValue((Object)12.0);
        ColorPicker textForeground = new ColorPicker();
        textForeground.getStyleClass().add((Object)"foreground");
        new TextDecorateAction(this.editor, textForeground.valueProperty(), TextDecoration::getForeground, (builder, a) -> builder.foreground(a).build());
        textForeground.setValue((Object)Color.BLACK);
        ColorPicker textBackground = new ColorPicker();
        textBackground.getStyleClass().add((Object)"background");
        new TextDecorateAction(this.editor, textBackground.valueProperty(), TextDecoration::getBackground, (builder, a) -> builder.background(a).build());
        textBackground.setValue((Object)Color.TRANSPARENT);
        ToolBar toolbar = new ToolBar();
        toolbar.getItems().setAll((Object[])new Node[]{this.actionButton((Ikon)LineAwesomeSolid.CUT, this.editor.getActionFactory().cut()), this.actionButton((Ikon)LineAwesomeSolid.COPY, this.editor.getActionFactory().copy()), this.actionButton((Ikon)LineAwesomeSolid.PASTE, this.editor.getActionFactory().paste()), new Separator(Orientation.VERTICAL), this.actionButton((Ikon)LineAwesomeSolid.UNDO, this.editor.getActionFactory().undo()), this.actionButton((Ikon)LineAwesomeSolid.REDO, this.editor.getActionFactory().redo()), new Separator(Orientation.VERTICAL), this.actionImage((Ikon)LineAwesomeSolid.IMAGE), this.actionHyperlink((Ikon)LineAwesomeSolid.LINK), this.actionTable((Ikon)LineAwesomeSolid.TABLE, td -> this.editor.getActionFactory().insertTable(td)), new Separator(Orientation.VERTICAL)});
        ToolBar fontsToolbar = new ToolBar();
        fontsToolbar.getItems().setAll((Object[])new Node[]{presets, fontFamilies, fontSize, this.createToggleButton((Ikon)LineAwesomeSolid.BOLD, property -> new TextDecorateAction(this.editor, property, d -> d.getFontWeight() == FontWeight.BOLD, (builder, a) -> builder.fontWeight(a != false ? FontWeight.BOLD : FontWeight.NORMAL).build())), this.createToggleButton((Ikon)LineAwesomeSolid.ITALIC, property -> new TextDecorateAction(this.editor, property, d -> d.getFontPosture() == FontPosture.ITALIC, (builder, a) -> builder.fontPosture(a != false ? FontPosture.ITALIC : FontPosture.REGULAR).build())), this.createToggleButton((Ikon)LineAwesomeSolid.STRIKETHROUGH, property -> new TextDecorateAction(this.editor, property, TextDecoration::isStrikethrough, (builder, a) -> builder.strikethrough(a).build())), this.createToggleButton((Ikon)LineAwesomeSolid.UNDERLINE, property -> new TextDecorateAction(this.editor, property, TextDecoration::isUnderline, (builder, a) -> builder.underline(a).build())), textForeground, textBackground, new Separator(Orientation.VERTICAL)});
        ToolBar paragraphToolbar = new ToolBar();
        paragraphToolbar.getItems().setAll((Object[])new Node[]{this.createToggleButton((Ikon)LineAwesomeSolid.ALIGN_LEFT, property -> new ParagraphDecorateAction(this.editor, property, d -> d.getAlignment() == TextAlignment.LEFT, (builder, a) -> builder.alignment(TextAlignment.LEFT).build())), this.createToggleButton((Ikon)LineAwesomeSolid.ALIGN_CENTER, property -> new ParagraphDecorateAction(this.editor, property, d -> d.getAlignment() == TextAlignment.CENTER, (builder, a) -> builder.alignment(a != false ? TextAlignment.CENTER : TextAlignment.LEFT).build())), this.createToggleButton((Ikon)LineAwesomeSolid.ALIGN_RIGHT, property -> new ParagraphDecorateAction(this.editor, property, d -> d.getAlignment() == TextAlignment.RIGHT, (builder, a) -> builder.alignment(a != false ? TextAlignment.RIGHT : TextAlignment.LEFT).build())), this.createToggleButton((Ikon)LineAwesomeSolid.ALIGN_JUSTIFY, property -> new ParagraphDecorateAction(this.editor, property, d -> d.getAlignment() == TextAlignment.JUSTIFY, (builder, a) -> builder.alignment(a != false ? TextAlignment.JUSTIFY : TextAlignment.LEFT).build())), new Separator(Orientation.VERTICAL), this.createSpinner("Spacing", p -> new ParagraphDecorateAction(this.editor, p, v -> (int)v.getSpacing(), (builder, a) -> builder.spacing((double)a.intValue()).build())), new Separator(Orientation.VERTICAL), this.createSpinner("Top", p -> new ParagraphDecorateAction(this.editor, p, v -> (int)v.getTopInset(), (builder, a) -> builder.topInset((double)a.intValue()).build())), this.createSpinner("Right", p -> new ParagraphDecorateAction(this.editor, p, v -> (int)v.getRightInset(), (builder, a) -> builder.rightInset((double)a.intValue()).build())), this.createSpinner("Bottom", p -> new ParagraphDecorateAction(this.editor, p, v -> (int)v.getBottomInset(), (builder, a) -> builder.bottomInset((double)a.intValue()).build())), this.createSpinner("Left", p -> new ParagraphDecorateAction(this.editor, p, v -> (int)v.getLeftInset(), (builder, a) -> builder.leftInset((double)a.intValue()).build())), new Separator(Orientation.VERTICAL), this.createToggleButton((Ikon)LineAwesomeSolid.LIST_OL, property -> new ParagraphDecorateAction(this.editor, property, d -> d.getGraphicType() == ParagraphDecoration.GraphicType.NUMBERED_LIST, (builder, a) -> builder.graphicType(a != false ? ParagraphDecoration.GraphicType.NUMBERED_LIST : ParagraphDecoration.GraphicType.NONE).build())), this.createToggleButton((Ikon)LineAwesomeSolid.LIST_UL, property -> new ParagraphDecorateAction(this.editor, property, d -> d.getGraphicType() == ParagraphDecoration.GraphicType.BULLETED_LIST, (builder, a) -> builder.graphicType(a != false ? ParagraphDecoration.GraphicType.BULLETED_LIST : ParagraphDecoration.GraphicType.NONE).build())), this.createSpinner("Indent", p -> new ParagraphDecorateAction(this.editor, p, ParagraphDecoration::getIndentationLevel, (builder, a) -> builder.indentationLevel(a.intValue()).build())), new Separator(Orientation.VERTICAL)});
        HBox statusBar = new HBox(10.0);
        statusBar.getStyleClass().add((Object)"status-bar");
        statusBar.setAlignment(Pos.CENTER_RIGHT);
        statusBar.getChildren().setAll((Object[])new Node[]{this.textLengthLabel});
        this.setCenter((Node)this.editor);
        this.setTop((Node)new VBox(new Node[]{toolbar, fontsToolbar, paragraphToolbar}));
        this.setBottom((Node)statusBar);
        this.getStylesheets().add((Object)RichTextEditor.class.getResource("richtexteditor.css").toExternalForm());
        this.editor.requestFocus();
    }

    public RichTextArea getEditor() {
        return this.editor;
    }

    private Button actionButton(Ikon ikon, Action action) {
        Button button = new Button();
        FontIcon icon = new FontIcon(ikon);
        icon.setIconSize(20);
        button.setGraphic((Node)icon);
        button.disableProperty().bind((ObservableValue)action.disabledProperty());
        button.setOnAction(arg_0 -> ((Action)action).execute(arg_0));
        return button;
    }

    private ToggleButton createToggleButton(Ikon ikon, Function<ObjectProperty<Boolean>, DecorateAction<Boolean>> function) {
        ToggleButton toggleButton = new ToggleButton();
        FontIcon icon = new FontIcon(ikon);
        icon.setIconSize(20);
        toggleButton.setGraphic((Node)icon);
        function.apply((ObjectProperty<Boolean>)toggleButton.selectedProperty().asObject());
        return toggleButton;
    }

    private HBox createSpinner(String text, Function<ObjectProperty<Integer>, DecorateAction<Integer>> function) {
        Spinner spinner = new Spinner();
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 20);
        spinner.setValueFactory((SpinnerValueFactory)valueFactory);
        spinner.setPrefWidth(60.0);
        spinner.setEditable(false);
        function.apply((ObjectProperty<Integer>)valueFactory.valueProperty());
        HBox spinnerBox = new HBox(5.0, new Node[]{new Label(text), spinner});
        spinnerBox.setAlignment(Pos.CENTER);
        return spinnerBox;
    }

    private Button actionImage(Ikon ikon) {
        Button button = new Button();
        FontIcon icon = new FontIcon(ikon);
        icon.setIconSize(20);
        button.setGraphic((Node)icon);
        button.setOnAction(e -> {
            ImageDialog dlg = new ImageDialog(this.getScene().getWindow());
            dlg.showAndWait().ifPresent(btnType -> {
                if (btnType == ButtonType.OK && dlg.getSelectedResource() != null) {
                    Action action = this.editor.getActionFactory().decorate(new Decoration[]{new ResourceImageDecoration(dlg.getSelectedResource().getURL())});
                    action.execute(e);
                }
            });
        });
        return button;
    }

    private Button actionHyperlink(Ikon ikon) {
        Button button = new Button();
        FontIcon icon = new FontIcon(ikon);
        icon.setIconSize(20);
        button.setGraphic((Node)icon);
        button.setOnAction(e -> {
            Dialog<String> hyperlinkDialog = this.createHyperlinkDialog();
            Optional result = hyperlinkDialog.showAndWait();
            result.ifPresent(textURL -> this.editor.getActionFactory().decorate(new Decoration[]{TextDecoration.builder().url(textURL).build()}).execute(e));
        });
        return button;
    }

    private Dialog<String> createHyperlinkDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Hyperlink");
        ButtonType textButtonType = new ButtonType("Create", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().add((Object)textButtonType);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 20.0, 10.0, 10.0));
        TextField url = new TextField();
        url.setPromptText("URL");
        grid.add((Node)new Label("URL:"), 0, 1);
        grid.add((Node)url, 1, 1);
        Node loginButton = dialog.getDialogPane().lookupButton(textButtonType);
        loginButton.setDisable(true);
        loginButton.disableProperty().bind((ObservableValue)url.textProperty().isEmpty());
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == textButtonType) {
                return url.getText();
            }
            return null;
        });
        dialog.setOnShown(e -> Platform.runLater(() -> ((TextField)url).requestFocus()));
        return dialog;
    }

    private Button actionTable(Ikon ikon, Function<TableDecoration, Action> actionFunction) {
        Button button = new Button();
        FontIcon icon = new FontIcon(ikon);
        icon.setIconSize(20);
        button.setGraphic((Node)icon);
        button.disableProperty().bind((ObservableValue)actionFunction.apply(null).disabledProperty());
        button.setOnAction(e -> {
            Dialog<TableDecoration> tableDialog = this.insertTableDialog();
            Optional result = tableDialog.showAndWait();
            result.ifPresent(td -> ((Action)actionFunction.apply((TableDecoration)td)).execute(e));
        });
        return button;
    }

    private Dialog<TableDecoration> insertTableDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Insert table");
        ButtonType textButtonType = new ButtonType("Create", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().add((Object)textButtonType);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 20.0, 10.0, 10.0));
        TextField rows = new TextField();
        rows.setPromptText("Rows ");
        grid.add((Node)new Label("Rows:"), 0, 1);
        grid.add((Node)rows, 1, 1);
        TextField cols = new TextField();
        cols.setPromptText("Columns ");
        grid.add((Node)new Label("Columns:"), 0, 2);
        grid.add((Node)cols, 1, 2);
        Node tableButton = dialog.getDialogPane().lookupButton(textButtonType);
        tableButton.setDisable(true);
        tableButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (rows.getText().isEmpty() || cols.getText().isEmpty()) {
                return true;
            }
            try {
                Integer.parseInt(rows.getText());
                Integer.parseInt(cols.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{rows.textProperty(), cols.textProperty()}));
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == textButtonType) {
                int r = Integer.parseInt(rows.getText());
                int c = Integer.parseInt(cols.getText());
                return new TableDecoration(r, c);
            }
            return null;
        });
        dialog.setOnShown(e -> Platform.runLater(() -> ((TextField)rows).requestFocus()));
        return dialog;
    }

    private MenuItem actionMenuItem(String text, Ikon ikon, Action action) {
        FontIcon icon = new FontIcon(ikon);
        icon.setIconSize(16);
        MenuItem menuItem = new MenuItem(text, (Node)icon);
        menuItem.disableProperty().bind((ObservableValue)action.disabledProperty());
        menuItem.setOnAction(arg_0 -> ((Action)action).execute(arg_0));
        return menuItem;
    }

    private static enum Presets {
        DEFAULT("Default", 12, FontWeight.NORMAL, TextAlignment.LEFT),
        HEADER1("Header 1", 32, FontWeight.BOLD, TextAlignment.CENTER),
        HEADER2("Header 2", 24, FontWeight.BOLD, TextAlignment.LEFT),
        HEADER3("Header 3", 19, FontWeight.BOLD, TextAlignment.LEFT);

        private final String name;
        private final int fontSize;
        private final FontWeight weight;
        private final TextAlignment textAlignment;

        private Presets(String name, int fontSize, FontWeight weight, TextAlignment textAlignment) {
            this.name = name;
            this.fontSize = fontSize;
            this.weight = weight;
            this.textAlignment = textAlignment;
        }

        public String getName() {
            return this.name;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public FontWeight getWeight() {
            return this.weight;
        }

        public TextAlignment getTextAlignment() {
            return this.textAlignment;
        }
    }
}

