/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.cells;

import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.fx.controls.NumericField;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class EditableVarValueTableCell<S>
extends TableCell<S, IVarValue> {
    protected NumericField numberField;
    protected final MeasuringUnit valueMU;
    protected final MeasuringUnit displayMU;
    protected final MeasuringUnitFormat displayMUFormat;
    protected final SupplementValueStrategy supplementValueStrategy;
    protected final TreeMap<Instant, SupplementValue> originalSupplementValues = new TreeMap();
    protected final VirtualRaster raster;
    private boolean escapePressed = false;
    private TablePosition<S, ?> editingCell = null;
    private final List<String> defaultClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());

    public EditableVarValueTableCell(MeasuringUnit valueMU, MeasuringUnit displayMU, MeasuringUnitFormat displayMUFormat, SupplementValueStrategy supplementValueStrategy, SupplementValue[] originalSupplementValues, VirtualRaster raster) {
        this.valueMU = valueMU;
        this.displayMU = displayMU;
        this.displayMUFormat = displayMUFormat != null ? displayMUFormat : MeasuringUnitFormats.TABLE;
        this.supplementValueStrategy = supplementValueStrategy;
        if (originalSupplementValues != null) {
            SupplementValue[] supplementValueArray = originalSupplementValues;
            int n = originalSupplementValues.length;
            int n2 = 0;
            while (n2 < n) {
                SupplementValue sv = supplementValueArray[n2];
                this.originalSupplementValues.put(Instant.ofEpochMilli(sv.getEndTimestamp()), sv);
                ++n2;
            }
        }
        this.raster = raster;
    }

    protected NumericField getNumberField() {
        if (this.numberField == null) {
            this.numberField = this.createNumberField();
            this.numberField.focusedProperty().addListener((o, ov, nv) -> {
                if (ov.booleanValue() && !nv.booleanValue()) {
                    SupplementValue newItemVal = this.createSupplementValue((IVarValue)this.getItem(), this.numberField.getValue());
                    this.commitEdit((IVarValue)newItemVal);
                }
            });
        }
        return this.numberField;
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            this.escapePressed = false;
            NumericField numberField = this.getNumberField();
            double val = ((IVarValue)this.getItem()).getValue();
            if (Double.isNaN(val)) {
                numberField.setValue(null);
            } else {
                numberField.setValue((Number)this.displayMU.convert(val, this.valueMU));
            }
            this.setTextFill((Paint)Color.BLACK);
            this.setText(null);
            this.setGraphic((Node)numberField);
            numberField.selectAll();
            numberField.requestFocus();
            TableView table = this.getTableView();
            if (table != null) {
                this.editingCell = table.getEditingCell();
            }
        }
    }

    public void commitEdit(IVarValue newValue) {
        if (!this.isEditing()) {
            this.escapePressed = true;
            return;
        }
        TableView table = this.getTableView();
        TablePosition<S, ?> cell = null;
        if (table != null && (cell = table.getEditingCell()) == null && this.editingCell != null) {
            cell = this.editingCell;
            this.editingCell = null;
            table.edit(cell.getRow(), cell.getTableColumn());
        }
        if (cell != null) {
            this.escapePressed = true;
            super.commitEdit((Object)newValue);
        }
    }

    public void cancelEdit() {
        if (!this.escapePressed) {
            Double itemDVal;
            this.escapePressed = true;
            NumericField nf = this.getNumberField();
            nf.commitValue();
            Number value = nf.getValue();
            IVarValue itemVal = (IVarValue)this.getItem();
            SupplementValue newItemVal = this.createSupplementValue(itemVal, value);
            Double d = itemDVal = Double.isNaN(itemVal.getValue()) ? null : Double.valueOf(itemVal.getValue());
            if (value == null && itemDVal != null || value != null && itemDVal == null || value != null && !value.equals(itemDVal)) {
                this.commitEdit((IVarValue)newItemVal);
            }
        }
        super.cancelEdit();
        this.formatTextCell((IVarValue)this.getItem());
        this.setGraphic(null);
    }

    private void formatTextCell(IVarValue varValue) {
        boolean boldFont = false;
        if (!Double.isNaN(varValue.getValue())) {
            double displayValue = this.displayMU.convert(varValue.getValue(), this.valueMU);
            this.setText(this.displayMU.getValueFormat(this.displayMUFormat).format(displayValue));
        } else {
            this.setText(null);
            this.setTooltip(null);
        }
        this.setStyle(boldFont ? "-fx-font-weight: bold;" : null);
    }

    public void updateItem(IVarValue item, boolean empty) {
        super.updateItem((Object)item, empty);
        LinkedList<String> classes = new LinkedList<String>();
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            NumericField nf = this.getNumberField();
            nf.setValue((Number)item.getValue());
            this.setGraphic((Node)nf);
        } else {
            if (item != null) {
                classes.add("var-value");
                classes.add(this.canEdit() ? "editable" : "readonly");
                if (!item.isValid()) {
                    classes.add("invalid");
                }
                if (item instanceof SupplementValue) {
                    classes.add("supplement");
                }
                this.formatTextCell(item);
            } else {
                this.setText(null);
            }
            this.setGraphic(null);
        }
        this.setStyleClass(classes.toArray(new String[0]));
    }

    private void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }

    protected NumericField createNumberField() {
        NumericField numberField = new NumericField(Double.class, this.displayMU.getValueFormat(MeasuringUnitFormats.INPUT));
        numberField.setOnAction(event -> {
            if (event.getTarget() instanceof Button) {
                return;
            }
            try {
                Number value = numberField.getValue();
                SupplementValue newItemVal = this.createSupplementValue((IVarValue)this.getItem(), value);
                this.commitEdit((IVarValue)newItemVal);
            }
            catch (Exception exception) {
                this.escapePressed = true;
                this.cancelEdit();
            }
        });
        numberField.setOnKeyPressed(t -> {
            this.escapePressed = t.getCode() == KeyCode.ESCAPE;
        });
        numberField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        return numberField;
    }

    protected SupplementValue createSupplementValue(IVarValue prevValue, Number displayValue) {
        Instant valueTsEnd = this.raster.getRasterEnd(Instant.ofEpochMilli(prevValue.getEndTimestamp()));
        Instant valueTsBegin = this.raster.getRasterBegin(valueTsEnd).minusNanos(1L);
        if (displayValue == null) {
            return new SupplementValue(valueTsBegin.toEpochMilli(), valueTsEnd.toEpochMilli(), Double.NaN, Instant.now().toEpochMilli(), 0);
        }
        double value = this.valueMU.convert(displayValue.doubleValue(), this.displayMU);
        if (this.supplementValueStrategy == SupplementValueStrategy.Rasterized) {
            return new SupplementValue(valueTsBegin.toEpochMilli(), valueTsEnd.toEpochMilli(), value, Instant.now().toEpochMilli(), 0);
        }
        return new SupplementValue(valueTsBegin.toEpochMilli(), valueTsBegin.toEpochMilli(), value, Instant.now().toEpochMilli(), 0);
    }

    private boolean canEdit() {
        return this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable() && this.supplementValueStrategy != null;
    }
}

