/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.cells;

import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import javafx.scene.control.TableCell;

public class LocalDateTimeTableCell<S>
extends TableCell<S, Instant> {
    private final boolean withUTC;

    public LocalDateTimeTableCell() {
        this(true);
    }

    public LocalDateTimeTableCell(boolean withUTC) {
        this.withUTC = withUTC;
    }

    protected void updateItem(Instant item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setGraphic(null);
        if (empty || item == null) {
            this.setText(null);
        } else {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(item, ZoneOffset.systemDefault());
            if (this.withUTC) {
                LocalDateTime utcDateTime = LocalDateTime.ofInstant(item, ZoneOffset.UTC);
                this.setText(String.format("%s (%s UTC)", TimeFormatType.DateTimeHMs.format((TemporalAccessor)localDateTime), TimeFormatType.TimeHMs.format((TemporalAccessor)utcDateTime)));
            } else {
                this.setText(TimeFormatType.DateTimeHMs.format((TemporalAccessor)localDateTime));
            }
        }
    }
}

