/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.cells;

import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;

public abstract class VarTableEditorCell<S, E extends Control>
extends TableCell<S, VarTableCellData> {
    protected E editor;
    protected boolean escapePressed = false;
    protected final MeasuringUnit valueMU;
    protected final MeasuringUnit displayMU;
    protected final MeasuringUnitFormat displayMUFormat;
    protected TablePosition<S, ?> editingCell = null;
    protected final List<String> defaultClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());

    public VarTableEditorCell(MeasuringUnit valueUnit, MeasuringUnit displayUnit, MeasuringUnitFormat displayMUFormat, String ... defaultClasses) {
        this.defaultClasses.addAll(Arrays.asList(defaultClasses));
        this.valueMU = valueUnit;
        this.displayMU = displayUnit;
        this.displayMUFormat = displayMUFormat != null ? displayMUFormat : MeasuringUnitFormats.TABLE;
    }

    public void commitEdit(VarTableCellData newValue) {
        if (!this.isEditing()) {
            this.escapePressed = true;
            return;
        }
        TableView table = this.getTableView();
        TablePosition<S, ?> cell = null;
        if (table != null && (cell = table.getEditingCell()) == null && this.editingCell != null) {
            cell = this.editingCell;
            this.editingCell = null;
            table.edit(cell.getRow(), cell.getTableColumn());
        }
        if (cell != null) {
            this.escapePressed = true;
            super.commitEdit((Object)newValue);
        }
    }

    protected void formatTextCell(IVarValue varValue) {
        boolean boldFont = false;
        if (varValue != null && !Double.isNaN(varValue.getValue())) {
            double displayValue = this.displayMU.convert(varValue.getValue(), this.valueMU);
            this.setText(this.displayMU.getValueFormat(this.displayMUFormat).format(displayValue));
        } else {
            this.setText(null);
            this.setTooltip(null);
        }
        this.setStyle(boldFont ? "-fx-font-weight: bold;" : null);
    }

    protected E getEditor() {
        if (this.editor == null) {
            this.editor = this.createEditor();
        }
        return this.editor;
    }

    protected abstract E createEditor();

    protected IVarValue createIVarValue(Number displayValue) {
        if (displayValue == null) {
            return new VarValue(0L, Double.NaN, 0.0, ValueSource.NaN);
        }
        double value = this.valueMU.convert(displayValue.doubleValue(), this.displayMU);
        return new SupplementValue(0L, 0L, value, Instant.now().toEpochMilli(), 0);
    }

    protected void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }

    protected boolean isEditableItem() {
        return this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable() && this.getItem() != null && !((VarTableCellData)this.getItem()).isSummary() && ((VarTableCellData)this.getItem()).getInstance() != null && ((VarTableCellData)this.getItem()).getInstance().getSupplementValueStrategy() != null;
    }

    protected boolean isLockedItem() {
        return ((VarTableCellData)this.getItem()).isLockedCell();
    }

    protected boolean canEdit() {
        return this.isEditableItem() && !this.isLockedItem();
    }
}

