/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.cells;

import de.elpro.ewms.core.fx.cells.VarTableEditorCell;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.time.TimeIntervalStringValue;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ui.fx.controls.NumericField;
import java.util.LinkedList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VarValueTableCell<S>
extends VarTableEditorCell<S, NumericField> {
    protected boolean escapePressed = false;

    public VarValueTableCell(MeasuringUnit valueUnit, MeasuringUnit displayUnit, MeasuringUnitFormat displayMUFormat, String ... defaultClasses) {
        super(valueUnit, displayUnit, displayMUFormat, defaultClasses);
    }

    public void startEdit() {
        if (!this.canEdit()) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            double val;
            this.escapePressed = false;
            NumericField numberField = this.getEditor();
            IVarValue editableValue = ((VarTableCellData)this.getItem()).getVarValue();
            double d = val = editableValue != null ? editableValue.getValue() : Double.NaN;
            if (Double.isNaN(val)) {
                numberField.setValue(null);
            } else {
                numberField.setValue((Number)this.displayMU.convert(val, this.valueMU));
            }
            this.setTextFill((Paint)Color.BLACK);
            this.setText(null);
            this.setGraphic((Node)numberField);
            numberField.selectAll();
            numberField.requestFocus();
            TableView table = this.getTableView();
            if (table != null) {
                this.editingCell = table.getEditingCell();
            }
        }
    }

    public void cancelEdit() {
        if (!this.escapePressed) {
            this.escapePressed = true;
            NumericField nf = this.getEditor();
            IVarValue prevItemVal = ((VarTableCellData)this.getItem()).getVarValue();
            Double prevVal = prevItemVal != null ? (Double.isNaN(prevItemVal.getValue()) ? null : Double.valueOf(prevItemVal.getValue())) : null;
            Number newVal = nf.getValue();
            if (newVal == null && prevVal != null || newVal != null && prevVal == null || newVal != null && !newVal.equals(prevVal)) {
                IVarValue newItemVal = this.createIVarValue(newVal);
                this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
            }
        }
        super.cancelEdit();
        this.formatTextCell(((VarTableCellData)this.getItem()).getVarValue());
        this.setGraphic(null);
    }

    @Override
    protected void formatTextCell(IVarValue varValue) {
        boolean boldFont = false;
        if (varValue != null && !Double.isNaN(varValue.getValue())) {
            double displayValue = this.displayMU.convert(varValue.getValue(), this.valueMU);
            this.setText(this.displayMU.getValueFormat(this.displayMUFormat).format(displayValue));
        } else {
            this.setText(null);
            this.setTooltip(null);
        }
        this.setStyle(boldFont ? "-fx-font-weight: bold;" : null);
    }

    public void updateItem(VarTableCellData item, boolean empty) {
        super.updateItem((Object)item, empty);
        LinkedList<String> classes = new LinkedList<String>();
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
            classes.add("empty");
        } else if (this.isEditing()) {
            this.setText(null);
            NumericField editor = this.getEditor();
            editor.setValue((Number)item.getVarValue().getValue());
            this.setGraphic((Node)editor);
        } else {
            if (item != null && ((VarTableCellData)this.getItem()).isSummary()) {
                classes.add("summary");
            }
            if (item != null && item.getObject() != null) {
                Object object = item.getObject();
                if (object instanceof IVarValue) {
                    classes.add("var-value");
                    IVarValue val = (IVarValue)object;
                    if (!val.isValid()) {
                        classes.add("invalid");
                    }
                    if (val instanceof SupplementValue) {
                        classes.add("supplement");
                    }
                    this.formatTextCell(val);
                } else if (object instanceof Aggregation) {
                    this.setText(object.toString());
                    classes.add("aggregation");
                } else if (object instanceof Number) {
                    this.setText(this.displayMUFormat.getDefaultDecimalFormat().format(item.getDisplayDoubleValue()));
                    classes.add("number");
                } else if (object instanceof TimeIntervalStringValue) {
                    TimeIntervalStringValue timeIntervalStringValue = (TimeIntervalStringValue)object;
                    this.setText((String)timeIntervalStringValue.getValue());
                    classes.add("text");
                } else {
                    this.setText(object.toString());
                    classes.add("text");
                }
                classes.addAll(item.getCellStyleClasses());
            } else {
                classes.add("empty");
                this.setText(null);
            }
            classes.add(this.isEditableItem() ? (this.isLockedItem() ? "locked" : "editable") : "readonly");
            this.setGraphic(null);
        }
        this.setStyleClass(classes.toArray(new String[0]));
    }

    @Override
    protected NumericField getEditor() {
        if (this.editor == null) {
            this.editor = this.createEditor();
        }
        return (NumericField)this.editor;
    }

    @Override
    protected NumericField createEditor() {
        NumericField numberField = new NumericField(Double.class, this.displayMU.getValueFormat(this.displayMUFormat));
        numberField.setShowAllFractionDigits(true);
        numberField.setOnAction(event -> {
            if (event.getTarget() instanceof Button) {
                return;
            }
            try {
                Number value = numberField.getValue();
                IVarValue newItemVal = this.createIVarValue(value);
                this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
            }
            catch (Exception exception) {
                this.escapePressed = true;
                this.cancelEdit();
            }
            this.requestFocus();
        });
        numberField.setOnKeyPressed(t -> {
            this.escapePressed = t.getCode() == KeyCode.ESCAPE;
        });
        numberField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        numberField.focusedProperty().addListener((o, ov, nv) -> {
            if (ov.booleanValue() && !nv.booleanValue()) {
                IVarValue prevItemVal = ((VarTableCellData)this.getItem()).getVarValue();
                Double prevVal = prevItemVal != null ? (Double.isNaN(prevItemVal.getValue()) ? null : Double.valueOf(prevItemVal.getValue())) : null;
                Number newVal = numberField.getValue();
                if (newVal == null && prevVal != null || newVal != null && prevVal == null || newVal != null && !newVal.equals(prevVal)) {
                    IVarValue newItemVal = this.createIVarValue(newVal);
                    this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
                } else {
                    this.commitEdit((VarTableCellData)this.getItem());
                }
            }
        });
        return numberField;
    }
}

