/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.cells;

import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.VarTableRow;
import de.elpro.ewms.core.time.TimeIntervalStringValue;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.cells.InstantTableCell;
import de.elpro.ui.fx.utils.TransitionUtils;
import de.elpro.ui.utils.TextUtils;
import java.time.Instant;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import javafx.util.Duration;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.lineawesome.LineAwesomeSolid;

public class VarValueTableEditableTextCell
extends TableCell<VarTableRow, VarTableCellData> {
    private TextEntry textEntry;

    protected void updateItem(VarTableCellData item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setText(null);
        if (item == null || item.isSummary()) {
            this.setGraphic(null);
        } else {
            TextEntry textEntry = this.getTextEntry();
            textEntry.setTimeIntervalStringValues(item.getTimeIntervalStringValues());
            textEntry.setEditable(this.isEditable());
            this.setGraphic((Node)textEntry);
        }
    }

    protected TextEntry getTextEntry() {
        if (this.textEntry == null) {
            this.textEntry = new TextEntry();
        }
        return this.textEntry;
    }

    private static class EditDialog
    extends Dialog<ButtonType> {
        private final TextArea editArea = new TextArea();

        private EditDialog(Window owner, TimeIntervalStringValue[] values) {
            this.initOwner(owner);
            this.setResizable(true);
            this.getDialogPane().setPrefSize(800.0, 600.0);
            StringBuilder text = new StringBuilder();
            TimeIntervalStringValue[] timeIntervalStringValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                TimeIntervalStringValue v = timeIntervalStringValueArray[n2];
                if (v.getValue() != null) {
                    if (text.isEmpty()) {
                        text.append((String)v.getValue());
                    } else {
                        text.append("\r\n" + (String)v.getValue());
                    }
                }
                ++n2;
            }
            String startText = text.toString();
            this.editArea.setText(startText);
            this.getDialogPane().setContent((Node)this.editArea);
            this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
            Button applyBtn = (Button)this.getDialogPane().lookupButton(ButtonType.APPLY);
            applyBtn.disableProperty().bind((ObservableValue)Bindings.equal((String)startText, (ObservableStringValue)this.editArea.textProperty()));
        }

        public String getText() {
            String text = this.editArea.getText();
            if (text == null || text.isBlank()) {
                return null;
            }
            return text.trim();
        }
    }

    private static class SourceValuesDialog
    extends Dialog<ButtonType> {
        private SourceValuesDialog(Window owner, TimeIntervalStringValue[] values) {
            this.initOwner(owner);
            this.setResizable(true);
            this.getDialogPane().setPrefSize(800.0, 600.0);
            TableView view = new TableView(FXCollections.observableArrayList((Object[])values));
            TableColumn fromColumn = new TableColumn("From");
            fromColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)Instant.ofEpochMilli(((TimeIntervalStringValue)cf.getValue()).getFromTs())));
            fromColumn.setCellFactory(cf -> new InstantTableCell(TimeFormatType.DateTimeHMs.getFormatter()));
            TableColumn toColumn = new TableColumn("To");
            toColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)Instant.ofEpochMilli(((TimeIntervalStringValue)cf.getValue()).getToTs())));
            toColumn.setCellFactory(cf -> new InstantTableCell(TimeFormatType.DateTimeHMs.getFormatter()));
            TableColumn textColumn = new TableColumn("Text");
            textColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper((String)((TimeIntervalStringValue)cf.getValue()).getValue()));
            textColumn.setMinWidth(400.0);
            view.getColumns().addAll((Object[])new TableColumn[]{fromColumn, toColumn, textColumn});
            this.getDialogPane().setContent((Node)view);
            this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        }
    }

    private class TextEntry
    extends BorderPane {
        private final Hyperlink text = new Hyperlink();
        private final HBox textBox = new HBox(new Node[]{this.text});
        private final Button editButton;
        private final HBox buttons;
        private FadeTransition fadeOutTrans;

        public TextEntry() {
            FontIcon editIcon = new FontIcon((Ikon)LineAwesomeSolid.EDIT);
            editIcon.setIconSize(16);
            this.text.setTextFill((Paint)Color.BLACK);
            this.editButton = new Button(null, (Node)editIcon);
            this.buttons = new HBox(5.0, new Node[]{this.editButton});
            this.buttons.setOpacity(0.0);
            this.fadeOutTrans = TransitionUtils.getFadeTransition((Node)this.buttons, (double)1.0, (double)1.0, (int)0, (int)1);
            this.textBox.setAlignment(Pos.CENTER_LEFT);
            this.setCenter((Node)this.textBox);
            this.setRight((Node)this.buttons);
            this.setOnMouseEntered(e -> {
                if (this.fadeOutTrans != null) {
                    this.fadeOutTrans.stop();
                }
                this.buttons.setOpacity(1.0);
            });
            this.setOnMouseExited(e -> {
                this.fadeOutTrans = TextEntry.getFadeTransition((Node)this.buttons, this.buttons.getOpacity(), 0.0, 200);
                this.fadeOutTrans.play();
            });
            this.editButton.setOnAction(e -> {
                EditDialog dlg = new EditDialog(this.getScene().getWindow(), ((VarTableCellData)VarValueTableEditableTextCell.this.getItem()).getTimeIntervalStringValues());
                dlg.showAndWait().ifPresent(btn -> {
                    if (btn == ButtonType.APPLY) {
                        VarValueTableEditableTextCell.this.getTableView().edit(VarValueTableEditableTextCell.this.getTableRow().getIndex(), VarValueTableEditableTextCell.this.getTableColumn());
                        TimeIntervalStringValue newValue = new TimeIntervalStringValue(((VarTableRow)VarValueTableEditableTextCell.this.getTableRow().getItem()).getIntervalBegin().toEpochMilli(), ((VarTableRow)VarValueTableEditableTextCell.this.getTableRow().getItem()).getIntervalEnd().toEpochMilli(), dlg.getText());
                        VarValueTableEditableTextCell.this.commitEdit(new VarTableCellData(((VarTableCellData)VarValueTableEditableTextCell.this.getItem()).getInstance(), newValue));
                    }
                });
            });
            this.text.setOnAction(e -> {
                this.text.setVisited(false);
                new SourceValuesDialog(this.getScene().getWindow(), ((VarTableCellData)VarValueTableEditableTextCell.this.getItem()).getTimeIntervalStringValues()).show();
            });
        }

        public void setEditable(boolean editable) {
            this.setRight((Node)(editable ? this.buttons : null));
        }

        public void setTimeIntervalStringValues(TimeIntervalStringValue[] values) {
            if (values == null || values.length == 0) {
                this.text.setText(null);
                this.setCenter(null);
            } else {
                StringBuilder text = new StringBuilder();
                TimeIntervalStringValue[] timeIntervalStringValueArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    TimeIntervalStringValue v = timeIntervalStringValueArray[n2];
                    if (v.getValue() != null) {
                        String textPart = TextUtils.getFirstLine((String)((String)v.getValue()), (int)Integer.MAX_VALUE);
                        if (!textPart.equals(v.getValue())) {
                            textPart = String.valueOf(textPart) + " \u2026";
                        }
                        if (text.isEmpty()) {
                            text.append("\"" + textPart + "\"");
                        } else {
                            text.append(", \"" + textPart + "\"");
                        }
                    }
                    ++n2;
                }
                this.text.setText(text.toString());
                this.setCenter((Node)this.textBox);
            }
        }

        public static FadeTransition getFadeTransition(Node node, double fromValue, double toValue, int duration) {
            FadeTransition ft = new FadeTransition(Duration.millis((double)duration), node);
            ft.setFromValue(fromValue);
            ft.setToValue(toValue);
            return ft;
        }
    }
}

