/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.cells;

import de.elpro.ewms.core.variable.value.IVarValue;
import java.text.DecimalFormat;
import javafx.scene.control.TreeTableCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VarValueTreeTableCell<S>
extends TreeTableCell<S, IVarValue> {
    private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("###,###,###,##0.000");
    private static final DecimalFormat QUALITY_FORMAT = new DecimalFormat("0.0");

    protected void updateItem(IVarValue item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            String text;
            if (item.isValid()) {
                text = String.format("%s (%s)", VALUE_FORMAT.format(item.getValue()), QUALITY_FORMAT.format(item.getQuality()));
                this.setTextFill((Paint)Color.BLACK);
            } else {
                String valueText;
                if (Double.isNaN(item.getValue())) {
                    valueText = "NaN";
                } else if (item.getValue() == Double.NEGATIVE_INFINITY) {
                    valueText = "-\u221e";
                } else if (item.getValue() == Double.POSITIVE_INFINITY) {
                    valueText = "+\u221e";
                    this.setTextFill((Paint)Color.RED);
                } else {
                    valueText = VALUE_FORMAT.format(item.getValue());
                }
                text = String.format("%s (%s, %s)", valueText, QUALITY_FORMAT.format(item.getQuality()), item.getPlausibility().name());
                this.setTextFill((Paint)Color.RED);
            }
            this.setText(text);
        }
    }
}

