/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.DurationCurveType;
import de.elpro.ewms.core.charts.IVarSeries;
import de.elpro.ewms.core.charts.PlotType;
import de.elpro.ewms.core.charts.RendererType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.viewprefs.AxisViewPrefsDAO;
import de.elpro.ewms.core.client.charts.viewprefs.Chart2DViewPrefsDAO;
import de.elpro.ewms.core.client.charts.viewprefs.SeriesViewPrefsDAO;
import de.elpro.ewms.core.client.notes.NoteDAO;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.rawvalues.RawValuesViewDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.time.TimeRangeFilterPreferenceDAO;
import de.elpro.ewms.core.client.variable.ValuesBoundsDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.AdjustDefaultViewPrefsCallback;
import de.elpro.ewms.core.fx.charts.ChartPrefsDialog;
import de.elpro.ewms.core.fx.charts.ChartViewBase;
import de.elpro.ewms.core.fx.charts.DrawSeriesListener;
import de.elpro.ewms.core.fx.charts.IChartViewAddon;
import de.elpro.ewms.core.fx.charts.LoadCustomSeriesDataCallback;
import de.elpro.ewms.core.fx.charts.addons.Chart2DCharacteristicAddon;
import de.elpro.ewms.core.fx.charts.addons.Chart2DSnapshotAddon;
import de.elpro.ewms.core.fx.charts.skins.BarChartViewSkin;
import de.elpro.ewms.core.fx.charts.skins.Chart2DDrawData;
import de.elpro.ewms.core.fx.charts.skins.Chart2DViewSkinBase;
import de.elpro.ewms.core.fx.charts.skins.ChartViewSkinBase;
import de.elpro.ewms.core.fx.charts.skins.PieChartViewSkin;
import de.elpro.ewms.core.fx.charts.skins.XYChartViewSkin;
import de.elpro.ewms.core.fx.dialogs.CreateRawValuesViewDialog;
import de.elpro.ewms.core.fx.dialogs.CreateVariableInstanceSnapshotDialog;
import de.elpro.ewms.core.fx.dialogs.SelectOrEditVariableInstanceSnapshotDialog;
import de.elpro.ewms.core.fx.model.DataSelection;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.model.ILoadDataCallback;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.VarValuesColumn;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.CustomViewTimeRangeFilter;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TimeRangeFilterPreference;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.UsageDomains;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.jfree.data.SeriesPoint;
import de.elpro.jfree.data.SeriesPointList;
import de.elpro.resources.Icons;
import de.elpro.resources.Resources;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.function.BooleanFunction;
import de.elpro.ui.fx.controls.CheckBoxDialog;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.ThreadSynchronize;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUtils;

public class Chart2DView
extends ChartViewBase
implements IExportable {
    @Inject
    private ThreadSynchronize sync;
    @Inject
    private MApplication app;
    private Chart2D config;
    private Chart2DViewPrefs viewPrefs = null;
    private ILoadDataCallback onLoadData;
    private final Table<VarSeries2D, StructureObject, LoadCustomSeriesDataCallback> onLoadCustomSeriesDataCallbacks = HashBasedTable.create();
    private AdjustDefaultViewPrefsCallback adjustDefaultViewPrefsCallback;
    private DrawSeriesListener onDrawSeries;
    private MeasuringUnit xAxisDefaultMU = null;
    private final Table<VarSeries2D, VariableInstance, VariableInstance> xAxisSeriesInstances = HashBasedTable.create();
    private final Table<VarSeries2D, VariableInstance, VariableInstance> clusteringInstances = HashBasedTable.create();
    private final Map<YAxis, MeasuringUnit> yAxisDefaultMUs = new LinkedHashMap<YAxis, MeasuringUnit>();
    private final Map<VarSeries2D, VariableInstance[]> yAxisSeriesInstances = new LinkedHashMap<VarSeries2D, VariableInstance[]>();
    private volatile boolean hideInvalidValues = true;
    private boolean useStructureObjectColorsForObject = true;
    private final Set<IChartViewAddon<?>> addons = new LinkedHashSet();
    private ObservableBooleanValue hasChanges = new SimpleBooleanProperty(false);
    private Chart2DDrawData drawData;
    private Comparator<VariableInstance> instanceComparator;
    private BooleanFunction<Series2DViewPrefs> seriesVisibilityFunction;

    @Inject
    public Chart2DView(StructureObject structureObject, Scene scene, @Optional ITimeRangeFilter timeRangeFilter, @Optional VirtualRaster fixedRaster) throws IllegalConfigException {
        super(structureObject, scene.getWindow(), timeRangeFilter, fixedRaster);
    }

    @PostConstruct
    public void postConstruct(Chart2D chartDefinition, IEclipseContext chartContext, @Optional @Named(value="instance.comparator") @Named(value="instance.comparator") Comparator<VariableInstance> instanceComparator) throws IllegalConfigException {
        this.config = chartDefinition;
        this.instanceComparator = instanceComparator;
        IEclipseContext addonContext = chartContext.createChild();
        addonContext.set(Chart2DView.class, (Object)this);
        this.installAddon((IChartViewAddon)ContextInjectionFactory.make(Chart2DCharacteristicAddon.class, (IEclipseContext)addonContext));
        this.installAddon((IChartViewAddon)ContextInjectionFactory.make(Chart2DSnapshotAddon.class, (IEclipseContext)addonContext));
        this.loadStaticModel();
        this.skinProperty().addListener((o, ov, nv) -> {
            if (ov == null && nv instanceof ChartViewSkinBase) {
                Chart2DViewSkinBase chartViewSkin = (Chart2DViewSkinBase)((Object)nv);
                try {
                    chartViewSkin.updateChartConfig();
                    this.initContextMenu(chartViewSkin);
                    this.reloadData();
                    chartViewSkin.setCrosshairValueChangedListener((instant, xValue, yValue) -> {
                        Instant oldTimestamp;
                        IDataSelection oldSelection = this.getDataSelection();
                        Instant instant2 = oldTimestamp = oldSelection != null ? oldSelection.getEndTimestamp() : null;
                        if (oldTimestamp == null && instant == null) {
                            return;
                        }
                        if (oldTimestamp != null && oldTimestamp.equals(instant)) {
                            return;
                        }
                        if (instant != null && instant.equals(oldTimestamp)) {
                            return;
                        }
                        this.setDataSelection(new DataSelection(instant, new SeriesPoint(Double.valueOf(xValue), Double.valueOf(yValue))));
                    });
                }
                catch (IllegalConfigException exc) {
                    ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                    dlg.initOwner(this.getScene().getWindow());
                    dlg.show();
                }
            }
        });
        this.parentProperty().addListener((o, ov, nv) -> {
            if (ov != null && nv == null) {
                this.dispose();
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        if (this.config.getPlotType() == PlotType.XYPlot) {
            return new XYChartViewSkin(this);
        }
        if (this.config.getPlotType() == PlotType.BarPlot) {
            return new BarChartViewSkin(this);
        }
        return new PieChartViewSkin(this);
    }

    public <T extends IChartViewAddon<?>> T getAddon(Class<T> clazz) {
        for (IChartViewAddon<?> addon : this.addons) {
            if (!addon.getClass().equals(clazz)) continue;
            return (T)addon;
        }
        return null;
    }

    public Set<IChartViewAddon<?>> getAddons() {
        return this.addons;
    }

    protected void installAddon(IChartViewAddon<?> addon) {
        this.addons.add(addon);
        this.hasChanges = Bindings.or((ObservableBooleanValue)this.hasChanges, (ObservableBooleanValue)addon.hasChangedProperty());
    }

    public String getTitle() {
        String title = this.config.getLocalTitle();
        if (title != null) {
            title = title.replaceAll("\\{object\\}", this.getStructureObject().toString());
        }
        return title;
    }

    public Chart2D getConfig() {
        return this.config;
    }

    public Chart2DDrawData getChartDrawData() {
        return this.drawData;
    }

    public Chart2DViewPrefs getViewPrefs() {
        return this.viewPrefs;
    }

    public boolean isUseStructureObjectColorsForObject() {
        return this.useStructureObjectColorsForObject;
    }

    public void setUseStructureObjectColorsForObject(boolean useStructureObjectColors) {
        this.useStructureObjectColorsForObject = useStructureObjectColors;
    }

    public BooleanFunction<Series2DViewPrefs> getSeriesVisibilityFunction() {
        return this.seriesVisibilityFunction;
    }

    public void setSeriesVisibilityFunction(BooleanFunction<Series2DViewPrefs> seriesVisibilityFunction) {
        this.seriesVisibilityFunction = seriesVisibilityFunction;
    }

    @Override
    public String getReportLabel() {
        return this.toString();
    }

    @Override
    public Object getReportObject() {
        if (this.getSkin() instanceof Chart2DViewSkinBase) {
            return ((Chart2DViewSkinBase)this.getSkin()).getExportableElement();
        }
        return null;
    }

    public void applyConfig(Chart2D chartDefinition) throws IllegalConfigException {
        this.config = chartDefinition;
        this.loadStaticModel();
        if (this.getSkin() instanceof ChartViewSkinBase) {
            ((Chart2DViewSkinBase)this.getSkin()).updateChartConfig();
        }
    }

    private void loadStaticModel() throws IllegalConfigException {
        this.config.normilize();
        StructureObject structureObject = this.getStructureObject();
        Transaction trx = Transactions.begin();
        try {
            this.xAxisDefaultMU = null;
            this.xAxisSeriesInstances.clear();
            this.clusteringInstances.clear();
            this.yAxisDefaultMUs.clear();
            this.yAxisSeriesInstances.clear();
            this.addons.forEach(a -> a.loadStaticModel(trx, this.config, structureObject));
            if (this.config.getXAxisType() == XAxisType.Variable) {
                this.xAxisDefaultMU = this.config.getXAxisResultMU();
            }
            for (YAxis yAxis : this.config.getYAxes()) {
                if (yAxis.getSeriesGroups().isEmpty() && yAxis.getSeries().isEmpty() && (this.config.getCharacteristic2DSeries() == null || !this.config.getCharacteristic2DSeries().getYAxis().equals((Object)yAxis))) continue;
                MeasuringUnit displayUnit = yAxis.getDefaultMeasuringUnit();
                for (SeriesGroup seriesGroup : yAxis.getSeriesGroups()) {
                    for (VarSeries2D varSeries : seriesGroup.getSeries()) {
                        varSeries.setSeriesGroup(seriesGroup);
                        if (varSeries.isCustomData()) {
                            this.yAxisSeriesInstances.put(varSeries, new VariableInstance[0]);
                            continue;
                        }
                        Variable var = VariableDAO.get((Transaction)trx, (int)varSeries.getVariable().getId());
                        displayUnit = var.getMeasuringUnit();
                        if (var.getValuesBounds() != null) {
                            var.setValuesBounds(ValuesBoundsDAO.get((Transaction)trx, (int)var.getValuesBounds().getId()));
                        }
                        Object[] instances = varSeries.getVariableInstance() != null ? new VariableInstance[]{VariableInstanceDAO.get((Transaction)trx, (int)varSeries.getVariableInstance().getId())} : VariableDAO.findInstances((Transaction)trx, (Variable)varSeries.getVariable(), (StructureObject)structureObject, (SearchPolicy)varSeries.getSearchPolicy());
                        VariableInstanceDAO.loadStructureObjects((Transaction)trx, (VariableInstance[])instances);
                        if (this.instanceComparator == null) {
                            Arrays.sort(instances);
                        } else {
                            Arrays.sort(instances, this.instanceComparator);
                        }
                        Object[] objectArray = instances;
                        int n = instances.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object instance = objectArray[n2];
                            if (instance.getValuesBounds() != null) {
                                instance.setValuesBounds(ValuesBoundsDAO.get((Transaction)trx, (int)instance.getValuesBounds().getId()));
                            }
                            instance.setVariable(var);
                            ++n2;
                        }
                        if (this.config.getXAxisType() == XAxisType.Variable) {
                            ArrayList<Object> foundInstances = new ArrayList<Object>();
                            foundInstances.addAll(Arrays.asList(instances));
                            Object[] objectArray2 = instances;
                            int n3 = instances.length;
                            n = 0;
                            while (n < n3) {
                                VariableInstance xAxisInstance;
                                Object instance = objectArray2[n];
                                VariableInstance[] candidateInstances = VariableDAO.findInstances((Transaction)trx, (Variable)this.config.getXAxisVariable(), (StructureObject)instance.getStructureObject(), (SearchPolicy)SearchPolicy.ThisOrParent);
                                if (candidateInstances.length != 1) {
                                    candidateInstances = VariableDAO.findInstances((Transaction)trx, (Variable)this.config.getXAxisVariable(), (StructureObject)structureObject, (SearchPolicy)SearchPolicy.ThisOrParent);
                                }
                                if (candidateInstances.length == 1) {
                                    xAxisInstance = candidateInstances[0];
                                    xAxisInstance.setVariable(this.config.getXAxisVariable());
                                    this.xAxisSeriesInstances.put((Object)varSeries, instance, (Object)xAxisInstance);
                                } else {
                                    foundInstances.remove(instance);
                                }
                                if (this.config.getClusteringVariable() != null) {
                                    candidateInstances = VariableDAO.findInstances((Transaction)trx, (Variable)this.config.getClusteringVariable(), (StructureObject)instance.getStructureObject(), (SearchPolicy)SearchPolicy.ThisOrParent);
                                    if (candidateInstances.length != 1) {
                                        candidateInstances = VariableDAO.findInstances((Transaction)trx, (Variable)this.config.getClusteringVariable(), (StructureObject)structureObject, (SearchPolicy)SearchPolicy.ThisOrParent);
                                    }
                                    if (candidateInstances.length == 1) {
                                        xAxisInstance = candidateInstances[0];
                                        xAxisInstance.setVariable(this.config.getXAxisVariable());
                                        this.clusteringInstances.put((Object)varSeries, instance, (Object)xAxisInstance);
                                    }
                                }
                                ++n;
                            }
                            instances = foundInstances.toArray(new VariableInstance[0]);
                        }
                        this.yAxisSeriesInstances.put(varSeries, (VariableInstance[])instances);
                    }
                }
                if (displayUnit == null && yAxis.equals((Object)this.config.getCharacteristic2DSeries().getYAxis())) {
                    displayUnit = this.config.getCharacteristic2DSeries().getCharacteristic().getOutputMeasuringUnit();
                }
                if (yAxis.getDefaultMeasuringUnit() != null) {
                    displayUnit = yAxis.getDefaultMeasuringUnit();
                } else if (displayUnit == null && yAxis.getPhysicalUnit().getMeasuringUnit(UsageDomains.REPORT) != null) {
                    displayUnit = yAxis.getPhysicalUnit().getMeasuringUnit(UsageDomains.REPORT);
                }
                this.yAxisDefaultMUs.put(yAxis, displayUnit);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private Chart2DViewPrefs loadViewPrefs(Chart2D chartDefinition, StructureObject structureObject) throws IllegalConfigException {
        return this.loadViewPrefs(chartDefinition, structureObject, this.getTimeRangeFilter());
    }

    /*
     * WARNING - void declaration
     */
    private Chart2DViewPrefs loadViewPrefs(Chart2D chartDefinition, StructureObject structureObject, ITimeRangeFilter timeRangePrefs) throws IllegalConfigException {
        Transaction trx = Transactions.begin();
        try {
            Chart2DViewPrefs prefs = Chart2DViewPrefsDAO.get((Transaction)trx, (Chart2D)chartDefinition, (StructureObject)structureObject);
            if (prefs == null) {
                prefs = new Chart2DViewPrefs(chartDefinition, structureObject);
            } else {
                prefs.setChart(chartDefinition);
                prefs.setStructureObject(structureObject);
            }
            HashMap<YAxis, AxisViewPrefs> savedYAxisPrefs = new HashMap<YAxis, AxisViewPrefs>();
            for (AxisViewPrefs axisViewPrefs : prefs.getAxesViewPrefs()) {
                AxisViewPrefs axisViewPrefs2 = AxisViewPrefsDAO.get((Transaction)trx, (int)axisViewPrefs.getId());
                savedYAxisPrefs.put(axisViewPrefs2.getYAxis(), axisViewPrefs2);
            }
            prefs.getAxesViewPrefs().clear();
            if (chartDefinition.getXAxisType() == XAxisType.Variable) {
                void var7_12;
                AxisViewPrefs axisViewPrefs = (AxisViewPrefs)savedYAxisPrefs.get(null);
                if (axisViewPrefs == null) {
                    AxisViewPrefs axisViewPrefs3 = new AxisViewPrefs(prefs, this.xAxisDefaultMU);
                } else if (chartDefinition.getXAxisPU() != axisViewPrefs.getMeasuringUnit().getPhysicalUnit()) {
                    axisViewPrefs.setMeasuringUnit(chartDefinition.getXAxisResultMU());
                }
                var7_12.setChartViewPrefs(prefs);
                prefs.getAxesViewPrefs().add(var7_12);
            }
            for (Map.Entry entry : this.yAxisDefaultMUs.entrySet()) {
                AxisViewPrefs axisViewPrefs = (AxisViewPrefs)savedYAxisPrefs.get(entry.getKey());
                if (axisViewPrefs == null) {
                    axisViewPrefs = new AxisViewPrefs(prefs, (YAxis)entry.getKey(), (MeasuringUnit)entry.getValue());
                } else if (((MeasuringUnit)entry.getValue()).getPhysicalUnit() != axisViewPrefs.getMeasuringUnit().getPhysicalUnit()) {
                    axisViewPrefs.setMeasuringUnit((MeasuringUnit)entry.getValue());
                }
                axisViewPrefs.setChartViewPrefs(prefs);
                axisViewPrefs.setYAxis((YAxis)entry.getKey());
                prefs.getAxesViewPrefs().add(axisViewPrefs);
            }
            prefs.getSeriesViewPrefs().clear();
            if (chartDefinition.getXAxisType() != XAxisType.Variable || timeRangePrefs.getType() != TimeRangeFilterType.GlobalView_Timeline) {
                for (Map.Entry entry : this.yAxisSeriesInstances.entrySet()) {
                    VariableInstance[] instances;
                    VarSeries2D varSeries = (VarSeries2D)entry.getKey();
                    VariableInstance[] variableInstanceArray = instances = (VariableInstance[])entry.getValue();
                    int n = instances.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableInstance instance = variableInstanceArray[n2];
                        Series2DViewPrefs seriesViewPrefs = SeriesViewPrefsDAO.getOrDefault((Transaction)trx, (Chart2DViewPrefs)prefs, (VarSeries2D)varSeries, (VariableInstance)instance, null);
                        if (seriesViewPrefs.getColor() == null && (instances.length > 1 || seriesViewPrefs.getColor() == null)) {
                            if ((this.useStructureObjectColorsForObject || !structureObject.equals((Object)instance.getStructureObject())) && instance.getStructureObject().getDefaultColor() != null) {
                                seriesViewPrefs.setColor(instance.getStructureObject().getDefaultColor());
                            } else {
                                seriesViewPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, instance.getVariable(), instance.getStructureObject(), null));
                            }
                        }
                        prefs.getSeriesViewPrefs().add(seriesViewPrefs);
                        ++n2;
                    }
                }
            } else {
                for (TimelinePhase timelinePhase : timeRangePrefs.getPhases().keySet()) {
                    for (Map.Entry<VarSeries2D, VariableInstance[]> seriesInstance : this.yAxisSeriesInstances.entrySet()) {
                        VariableInstance[] instances;
                        VarSeries2D varSeries = seriesInstance.getKey();
                        VariableInstance[] variableInstanceArray = instances = seriesInstance.getValue();
                        int n = instances.length;
                        int n3 = 0;
                        while (n3 < n) {
                            VariableInstance instance = variableInstanceArray[n3];
                            Series2DViewPrefs seriesViewPrefs = SeriesViewPrefsDAO.getOrDefault((Transaction)trx, (Chart2DViewPrefs)prefs, (VarSeries2D)varSeries, (VariableInstance)instance, (TimelinePhase)timelinePhase);
                            if (seriesViewPrefs.getColor() == null && (instances.length > 1 || seriesViewPrefs.getColor() == null)) {
                                if (timeRangePrefs.getType() == TimeRangeFilterType.GlobalView_Timeline && timelinePhase.getType() != null && timelinePhase.getType().getChartColor() != null) {
                                    seriesViewPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, instance.getVariable(), instance.getStructureObject(), timelinePhase));
                                } else {
                                    seriesViewPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, instance.getVariable(), instance.getStructureObject(), null));
                                }
                            }
                            prefs.getSeriesViewPrefs().add(seriesViewPrefs);
                            ++n3;
                        }
                    }
                }
            }
            Collections.sort(prefs.getSeriesViewPrefs(), new Comparator<Series2DViewPrefs>(){

                @Override
                public int compare(Series2DViewPrefs o1, Series2DViewPrefs o2) {
                    if (o1.getVisualOrderPosition() == o2.getVisualOrderPosition()) {
                        return 0;
                    }
                    if (o1.getVisualOrderPosition() == null) {
                        return -1;
                    }
                    if (o2.getVisualOrderPosition() == null) {
                        return 1;
                    }
                    return Integer.compare(o1.getVisualOrderPosition(), o2.getVisualOrderPosition());
                }
            });
            if (prefs.getTimeRangeFilterType() == null) {
                prefs.setTimeRangeFilterType(timeRangePrefs.getType());
                prefs.setCustomViewIndex(timeRangePrefs.getCustomViewIndex());
            }
            Chart2DViewPrefs chart2DViewPrefs = prefs;
            return chart2DViewPrefs;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    public VariableInstance[] getStaticModelXAxisVariableInstances() {
        return (VariableInstance[])this.xAxisSeriesInstances.values().toArray(VariableInstance[]::new);
    }

    public VariableInstance[] getStaticModelYAxisVariableInstances() {
        LinkedHashSet instances = new LinkedHashSet();
        this.yAxisSeriesInstances.values().stream().forEach(is -> {
            boolean bl = instances.addAll(Arrays.asList(is));
        });
        return (VariableInstance[])instances.toArray(VariableInstance[]::new);
    }

    public VariableInstance[] getStaticModelYAxisVariableInstances(VarSeries2D series) {
        return this.yAxisSeriesInstances.get(series);
    }

    public VariableInstance getStaticModelXAxisVariableInstance(VarSeries2D series, VariableInstance yAxisInstance) {
        return (VariableInstance)this.xAxisSeriesInstances.get((Object)series, (Object)yAxisInstance);
    }

    private void fullfillViewPrefs(Chart2DViewPrefs chartViewPrefs, ITimeRangeFilter timeRangePrefs) throws IllegalConfigException {
        Chart2DViewPrefs prefs = chartViewPrefs;
        if (this.config.getXAxisType() == XAxisType.Variable && prefs.getAxesViewPrefs().stream().noneMatch(axisPrefs -> axisPrefs.getYAxis() == null)) {
            prefs.getAxesViewPrefs().add(new AxisViewPrefs(prefs, this.xAxisDefaultMU));
        }
        for (Map.Entry<YAxis, MeasuringUnit> entry : this.yAxisDefaultMUs.entrySet()) {
            YAxis yAxis = entry.getKey();
            if (!prefs.getAxesViewPrefs().stream().noneMatch(axisPrefs -> yAxis.equals((Object)axisPrefs.getYAxis()))) continue;
            prefs.getAxesViewPrefs().add(new AxisViewPrefs(prefs, entry.getKey(), entry.getValue()));
        }
        if (this.config.getXAxisType() != XAxisType.Variable || timeRangePrefs.getType() != TimeRangeFilterType.GlobalView_Timeline) {
            for (Map.Entry<Object, Object> entry : this.yAxisSeriesInstances.entrySet()) {
                VariableInstance[] instances;
                VarSeries2D varSeries = (VarSeries2D)entry.getKey();
                if (varSeries.isCustomData() && prefs.getSeriesViewPrefs().stream().noneMatch(seriesPrefs -> seriesPrefs.getSeries().equals((Object)varSeries))) {
                    for (StructureObject o : this.getOnLoadCustomSeriesDataObjects(varSeries)) {
                        Series2DViewPrefs customSeriesPrefs = new Series2DViewPrefs(prefs, varSeries, null, null);
                        customSeriesPrefs.setCustomDataStructureObject(o);
                        if (varSeries.getDefaultColor() == null && this.useStructureObjectColorsForObject && o.getDefaultColor() != null) {
                            customSeriesPrefs.setColor(o.getDefaultColor());
                        } else {
                            customSeriesPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, null, o, null));
                        }
                        prefs.getSeriesViewPrefs().add(customSeriesPrefs);
                    }
                    continue;
                }
                VariableInstance[] variableInstanceArray = instances = (VariableInstance[])entry.getValue();
                int n = instances.length;
                int customSeriesPrefs = 0;
                while (customSeriesPrefs < n) {
                    VariableInstance instance = variableInstanceArray[customSeriesPrefs];
                    if (prefs.getSeriesViewPrefs().stream().noneMatch(seriesPrefs -> seriesPrefs.getSeries().equals((Object)varSeries) && seriesPrefs.getVariableInstance().equals((Object)instance) && seriesPrefs.getTimelinePhase() == null)) {
                        Series2DViewPrefs seriesViewPrefs = new Series2DViewPrefs(prefs, varSeries, instance, null);
                        if (instances.length > 1 || seriesViewPrefs.getColor() == null) {
                            if (this.useStructureObjectColorsForObject && instance.getStructureObject().getDefaultColor() != null) {
                                seriesViewPrefs.setColor(instance.getStructureObject().getDefaultColor());
                            } else {
                                seriesViewPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, instance.getVariable(), instance.getStructureObject(), null));
                            }
                        }
                        prefs.getSeriesViewPrefs().add(seriesViewPrefs);
                    }
                    ++customSeriesPrefs;
                }
            }
        } else {
            for (TimelinePhase timelinePhase : timeRangePrefs.getPhases().keySet()) {
                for (Map.Entry<VarSeries2D, VariableInstance[]> seriesInstance : this.yAxisSeriesInstances.entrySet()) {
                    VariableInstance[] instances;
                    VarSeries2D varSeries = seriesInstance.getKey();
                    if (varSeries.isCustomData() && prefs.getSeriesViewPrefs().stream().noneMatch(seriesPrefs -> seriesPrefs.getSeries().equals((Object)varSeries))) {
                        for (StructureObject o : this.getOnLoadCustomSeriesDataObjects(varSeries)) {
                            Series2DViewPrefs customSeriesPrefs = new Series2DViewPrefs(prefs, varSeries, null, null);
                            customSeriesPrefs.setCustomDataStructureObject(o);
                            prefs.getSeriesViewPrefs().add(customSeriesPrefs);
                        }
                        continue;
                    }
                    VariableInstance[] variableInstanceArray = instances = seriesInstance.getValue();
                    int n = instances.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableInstance instance = variableInstanceArray[n2];
                        if (prefs.getSeriesViewPrefs().stream().noneMatch(seriesPrefs -> seriesPrefs.getSeries().equals((Object)varSeries) && seriesPrefs.getVariableInstance().equals((Object)instance) && seriesPrefs.getTimelinePhase() == phase)) {
                            Series2DViewPrefs seriesViewPrefs = new Series2DViewPrefs(prefs, varSeries, instance, null);
                            if (instances.length > 1 || seriesViewPrefs.getColor() == null) {
                                if (timeRangePrefs.getType() == TimeRangeFilterType.GlobalView_Timeline) {
                                    seriesViewPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, instance.getVariable(), instance.getStructureObject(), timelinePhase));
                                } else {
                                    seriesViewPrefs.setColor(this.getSeriesColorGenerator().generateColor((IVarSeries)varSeries, instance.getVariable(), instance.getStructureObject(), null));
                                }
                            }
                            prefs.getSeriesViewPrefs().add(seriesViewPrefs);
                        }
                        ++n2;
                    }
                }
            }
        }
        Collections.sort(prefs.getSeriesViewPrefs(), UIModelElement.COMPARATOR);
        if (this.adjustDefaultViewPrefsCallback != null) {
            this.adjustDefaultViewPrefsCallback.adjustViewPrefs(prefs);
        }
    }

    private IVarValuesCollection loadInstanceValues(VariableInstance instance, ITimeRangeFilter timeRangeFilter, TimeRange customTimeRange, ComplexRaster complexRaster, boolean rasterizeTimestamps) {
        if (this.config.getPlotType() == PlotType.XYPlot || this.config.getPlotType() == PlotType.BarPlot) {
            if (timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView) {
                return VariableInstanceDAO.getVarValues((RawValuesViewType)RawValuesViewType.RealtimeView, null, (int)instance.getId(), (ComplexRaster)complexRaster);
            }
            IVarValuesCollection values = customTimeRange != null ? VariableInstanceDAO.getVarValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)instance.getId(), (Instant)customTimeRange.getFrom(), (Instant)customTimeRange.getTo(), (ComplexRaster)complexRaster) : VariableInstanceDAO.getVarValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)instance.getId(), (ComplexRaster)complexRaster);
            if (rasterizeTimestamps) {
                Throwable throwable = null;
                Object var8_9 = null;
                try (IVarValuesCollection rasterizedValues = new IVarValuesCollection();){
                    for (IVarValue value : values) {
                        rasterizedValues.add(value.copy(complexRaster.getRasterEnd(Instant.ofEpochMilli(value.getEndTimestamp())).toEpochMilli()));
                    }
                    return rasterizedValues;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return values;
        }
        if (customTimeRange == TimeRange.REALTIME) {
            return IVarValuesCollection.create((IVarValue[])new IVarValue[]{VariableInstanceDAO.getCurrentValue((VariableInstance)instance)});
        }
        if (customTimeRange != null) {
            return VariableInstanceDAO.getVarValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)instance.getId(), (Instant)customTimeRange.getFrom(), (Instant)customTimeRange.getTo(), (ComplexRaster)ComplexRaster.OVERALL);
        }
        return VariableInstanceDAO.getVarValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)instance.getId(), (ComplexRaster)ComplexRaster.OVERALL);
    }

    protected Chart2DDrawData loadDrawData(Chart2DViewPrefs chartViewPrefs, ITimeRangeFilter timeRangeFilter) {
        HashBasedTable xAxisValuesCache = HashBasedTable.create();
        HashBasedTable clusteringCache = HashBasedTable.create();
        LinkedHashMap<VariableInstance, VarValuesColumn> instanceColumns = new LinkedHashMap<VariableInstance, VarValuesColumn>();
        HashMap<VariableInstance, IVarValuesCollection> tableValuesCache = new HashMap<VariableInstance, IVarValuesCollection>();
        ComplexRaster complexRaster = this.getFixedRaster() != null ? ComplexRaster.of((VirtualRaster)this.getFixedRaster()) : chartViewPrefs.getComplexRaster();
        Chart2DDrawData chartDrawData = new Chart2DDrawData(complexRaster, timeRangeFilter.getFrom(), timeRangeFilter.getTo());
        TimeRange defaultTimeRange = timeRangeFilter.getTimeRange(null);
        for (Series2DViewPrefs series2DViewPrefs : chartViewPrefs.getSeriesViewPrefs()) {
            if (!series2DViewPrefs.isVisible() || this.seriesVisibilityFunction != null && !this.seriesVisibilityFunction.apply((Object)series2DViewPrefs)) continue;
            AxisViewPrefs xAxisViewPrefs = chartViewPrefs.getXAxisViewPrefs();
            AxisViewPrefs yAxisViewPrefs = chartViewPrefs.getYAxisViewPrefs(series2DViewPrefs.getSeries().getYAxis());
            MeasuringUnit xAxisDisplayMU = xAxisViewPrefs != null ? xAxisViewPrefs.getMeasuringUnit() : null;
            MeasuringUnit yAxisDisplayMU = yAxisViewPrefs.getMeasuringUnit();
            if (series2DViewPrefs.getSeries().isCustomData()) {
                LoadCustomSeriesDataCallback listener = this.getOnLoadCustomSeriesDataCallback(series2DViewPrefs.getSeries(), series2DViewPrefs.getCustomDataStructureObject());
                if (listener == null) continue;
                List<SeriesPoint> points = listener.loadData(series2DViewPrefs.getSeries(), series2DViewPrefs.getCustomDataStructureObject(), xAxisDisplayMU, yAxisDisplayMU, timeRangeFilter);
                chartDrawData.addSeriesData(series2DViewPrefs, points);
                continue;
            }
            MeasuringUnit xAxisVarMU = null;
            MeasuringUnit yAxisVarMU = series2DViewPrefs.getVariableInstance().getVariable().getMeasuringUnit();
            IVarValuesCollection xAxisValues = null;
            TimeRange effectiveTimeRange = series2DViewPrefs.getTimelinePhase() == null ? defaultTimeRange : timeRangeFilter.getTimeRange(series2DViewPrefs.getTimelinePhase());
            VariableInstance xAxisVariableInstance = (VariableInstance)this.xAxisSeriesInstances.get((Object)series2DViewPrefs.getSeries(), (Object)series2DViewPrefs.getVariableInstance());
            if (xAxisVariableInstance != null) {
                xAxisVarMU = xAxisVariableInstance.getVariable().getMeasuringUnit();
                xAxisValues = (IVarValuesCollection)xAxisValuesCache.get((Object)effectiveTimeRange, (Object)xAxisVariableInstance);
                if (xAxisValues == null) {
                    xAxisValues = this.loadInstanceValues(xAxisVariableInstance, timeRangeFilter, effectiveTimeRange, complexRaster, false);
                    if (!tableValuesCache.containsKey(xAxisVariableInstance)) {
                        instanceColumns.put(xAxisVariableInstance, new VarValuesColumn(xAxisVariableInstance, xAxisDisplayMU, chartViewPrefs.getXAxisViewPrefs().getLocalTitle(), null, complexRaster, timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView));
                        tableValuesCache.put(xAxisVariableInstance, xAxisValues);
                    }
                    xAxisValuesCache.put((Object)effectiveTimeRange, (Object)xAxisVariableInstance, (Object)xAxisValues);
                }
            }
            IVarValuesCollection clusteringValues = null;
            VariableInstance clusteringInstance = (VariableInstance)this.clusteringInstances.get((Object)series2DViewPrefs.getSeries(), (Object)series2DViewPrefs.getVariableInstance());
            if (clusteringInstance != null && (clusteringValues = (IVarValuesCollection)clusteringCache.get((Object)effectiveTimeRange, (Object)clusteringInstance)) == null) {
                clusteringValues = this.loadInstanceValues(clusteringInstance, timeRangeFilter, effectiveTimeRange, complexRaster, false);
                clusteringCache.put((Object)effectiveTimeRange, (Object)xAxisVariableInstance, (Object)xAxisValues);
            }
            boolean rasterizeTimestamps = series2DViewPrefs.getSeries().getSeriesGroup().getType() == RendererType.Area || series2DViewPrefs.getSeries().getSeriesGroup().getType() == RendererType.StackedArea;
            IVarValuesCollection yAxisValues = this.loadInstanceValues(series2DViewPrefs.getVariableInstance(), timeRangeFilter, effectiveTimeRange, complexRaster, rasterizeTimestamps);
            if (chartViewPrefs.getChart().getXAxisType() != XAxisType.Variable && series2DViewPrefs.getSeries().isDurationCurve()) {
                DurationCurveType durationCurveType = series2DViewPrefs.getSeries().getDurationCurveType();
                IVarValue[] yAxisValuesArray = yAxisValues.toArray();
                long currentTimestamp = complexRaster.getRasterEnd(Instant.ofEpochMilli(yAxisValuesArray[0].getEndTimestamp())).toEpochMilli();
                Arrays.sort(yAxisValuesArray, (v1, v2) -> {
                    switch (durationCurveType) {
                        case Increment: {
                            double v1d = v1.isValid() ? v1.getValue() : Double.POSITIVE_INFINITY;
                            double v2d = v2.isValid() ? v2.getValue() : Double.POSITIVE_INFINITY;
                            return Double.compare(v1d, v2d);
                        }
                        case Decrement: {
                            double v1d = v1.isValid() ? v1.getValue() : Double.NEGATIVE_INFINITY;
                            double v2d = v2.isValid() ? v2.getValue() : Double.NEGATIVE_INFINITY;
                            return Double.compare(v2d, v1d);
                        }
                    }
                    return 0;
                });
                int i = 0;
                while (i < yAxisValuesArray.length) {
                    yAxisValuesArray[i] = yAxisValuesArray[i].copy(currentTimestamp);
                    currentTimestamp = complexRaster.getRasterEnd(Instant.ofEpochMilli(currentTimestamp + 1L)).toEpochMilli();
                    ++i;
                }
                yAxisValues = IVarValuesCollection.create((IVarValue[])yAxisValuesArray);
            }
            if (!tableValuesCache.containsKey(series2DViewPrefs.getVariableInstance())) {
                String label = chartViewPrefs.getStructureObject().equals((Object)series2DViewPrefs.getVariableInstance().getStructureObject()) ? series2DViewPrefs.getSeries().getResultTitle() : (series2DViewPrefs.getSeries().getLocalTitle() != null ? String.format("%s\r\n<%s>", series2DViewPrefs.getSeries().getLocalTitle(), series2DViewPrefs.getVariableInstance().getStructureObject()) : series2DViewPrefs.getVariableInstance().getStructureObject().toString());
                instanceColumns.put(series2DViewPrefs.getVariableInstance(), new VarValuesColumn(series2DViewPrefs.getVariableInstance(), yAxisViewPrefs.getMeasuringUnit(), label, series2DViewPrefs.getGraphic(), complexRaster, timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView));
                tableValuesCache.put(series2DViewPrefs.getVariableInstance(), yAxisValues);
            }
            SeriesPointList points = Chart2DView.toSeriesPoints(xAxisValues, xAxisVarMU, xAxisDisplayMU, xAxisViewPrefs != null ? xAxisViewPrefs.isAbsolute() : false, yAxisValues, yAxisVarMU, yAxisDisplayMU, yAxisViewPrefs.isAbsolute(), null, clusteringValues, this.hideInvalidValues);
            chartDrawData.addSeriesData(series2DViewPrefs, (List<SeriesPoint>)points);
        }
        for (Map.Entry entry : instanceColumns.entrySet()) {
            VarValuesColumn column = (VarValuesColumn)entry.getValue();
            IVarValuesCollection vals = (IVarValuesCollection)tableValuesCache.get(entry.getKey());
            column.setValues(vals);
        }
        this.setVarValuesColumns(instanceColumns.values());
        if (chartViewPrefs.getNotesSearchPolicy() != null && defaultTimeRange != null) {
            Transaction transaction = Transactions.begin();
            try {
                RawValuesViewType viewType = timeRangeFilter.getType().toRawValueViewType();
                Instant from = viewType == RawValuesViewType.GlobalView ? timeRangeFilter.getFrom() : null;
                Instant to = viewType == RawValuesViewType.GlobalView ? timeRangeFilter.getTo() : null;
                Note[] notes = NoteDAO.findByStructureObject((Transaction)transaction, (RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (StructureObject)this.getStructureObject(), (Instant)from, (Instant)to, (SearchPolicy)chartViewPrefs.getNotesSearchPolicy(), (NoteType)chartViewPrefs.getNotesFilter());
                StructureObject[] notesObject = StructureObjectDAO.get((Transaction)transaction, (int[])Arrays.stream(notes).mapToInt(n -> n.getStructureObject().getId()).toArray());
                int i = 0;
                while (i < notes.length) {
                    notes[i].setStructureObject(notesObject[i]);
                    ++i;
                }
                chartDrawData.setNotes(notes);
            }
            finally {
                Transactions.close((Transaction)transaction);
            }
        }
        this.addons.forEach(a -> chartDrawData.putAddonDrawData((IChartViewAddon<?>)a, a.loadDrawData(chartViewPrefs, timeRangeFilter)));
        return chartDrawData;
    }

    public static SeriesPointList toSeriesPoints(IVarValuesCollection xAxisValues, MeasuringUnit xAxisVarMU, MeasuringUnit xAxisDisplayMU, boolean xAxisAbsouluteVals, IVarValuesCollection yAxisValues, MeasuringUnit yAxisVarMU, MeasuringUnit yAxisDisplayMU, boolean yAxisAbsouluteVals, TimeRange timeRangeFilter, IVarValuesCollection clusteringValues, boolean hideInvalidValues) {
        Double minXAxisValue = null;
        boolean gapInserted = false;
        SeriesPointList points = new SeriesPointList(yAxisValues.size());
        Iterator xAxisValuesIterator = xAxisValues != null ? xAxisValues.iterator() : null;
        Iterator clusteringValuesIterator = clusteringValues != null ? clusteringValues.iterator() : null;
        for (IVarValue yVarValue : yAxisValues) {
            Double clusteringDVal;
            boolean showXValue;
            boolean showYValue;
            long timestamp = yVarValue.getEndTimestamp();
            if (timeRangeFilter != null && !timeRangeFilter.in(timestamp)) continue;
            Double yDVal = null;
            boolean bl = showYValue = hideInvalidValues ? yVarValue.isValid() : Double.isFinite(yVarValue.getValue());
            if (showYValue) {
                yDVal = yAxisDisplayMU.convert(yVarValue.getValue(), yAxisVarMU);
                if (yAxisAbsouluteVals) {
                    yDVal = Math.abs(yDVal);
                }
            }
            if (xAxisValuesIterator != null && !xAxisValuesIterator.hasNext()) break;
            IVarValue xVarValue = xAxisValues != null ? (IVarValue)xAxisValuesIterator.next() : null;
            Double xDVal = null;
            boolean bl2 = xVarValue != null && (hideInvalidValues ? xVarValue.isValid() : Double.isFinite(xVarValue.getValue())) ? true : (showXValue = false);
            if (showXValue) {
                xDVal = xAxisDisplayMU.convert(xVarValue.getValue(), xAxisVarMU);
                if (xAxisAbsouluteVals) {
                    xDVal = Math.abs(xDVal);
                }
            }
            Double d = clusteringDVal = clusteringValues != null ? Double.valueOf(((IVarValue)clusteringValuesIterator.next()).getValue()) : null;
            if (xDVal != null && Double.MIN_VALUE == xDVal) {
                xDVal = 0.0;
            }
            if (yDVal != null && Double.MIN_VALUE == yDVal) {
                yDVal = 0.0;
            }
            if (xAxisValues == null) {
                points.add(Long.valueOf(timestamp), xDVal, yDVal, null);
                continue;
            }
            if (xDVal != null) {
                points.add(Long.valueOf(timestamp), xDVal, yDVal, clusteringDVal);
                minXAxisValue = minXAxisValue != null ? Math.min(minXAxisValue, xDVal) : xDVal;
                gapInserted = false;
                continue;
            }
            if (minXAxisValue == null || gapInserted) continue;
            points.add(Long.valueOf(timestamp), minXAxisValue, null, null);
            gapInserted = true;
        }
        return points;
    }

    @Override
    public Future<?> reloadData() {
        return this.reloadData(true);
    }

    public Future<?> reloadData(boolean withProgressIndicator) {
        if (this.getTimeRangeFilter() != null) {
            return this.loadData(this.getTimeRangeFilter(), withProgressIndicator);
        }
        return null;
    }

    @Override
    public Future<?> loadData(ITimeRangeFilter timeRangeFilter) {
        return this.loadData(timeRangeFilter, true);
    }

    public Future<?> loadData(ITimeRangeFilter timeRangeFilter, boolean withProgressIndicator) {
        if (this.getTimeRangeFilter() != null && this.getTimeRangeFilter().getPhases() != null || timeRangeFilter != null && timeRangeFilter.getPhases() != null) {
            this.viewPrefs = null;
        }
        this.updateTimeRangeFilter(timeRangeFilter);
        try {
            return this.loadData(this.viewPrefs, null, withProgressIndicator);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public Future<?> loadData(final Chart2DViewPrefs chartViewPrefs, final Runnable prefsPersister, boolean withProgressIndicator) {
        final ITimeRangeFilter timeRangeFilter = this.getTimeRangeFilter();
        if (timeRangeFilter == null) {
            return null;
        }
        if (this.hasChanges()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initOwner(this.getScene().getWindow());
            alert.setContentText(Messages.chart_ChartView_resetChangesAlert);
            if (ButtonType.OK == alert.showAndWait().get()) {
                this.addons.forEach(a -> a.resetChanges());
            } else {
                return null;
            }
        }
        try {
            FXUtils.runAndWait(() -> {
                Chart2DView chart2DView = this;
                synchronized (chart2DView) {
                    this.stateProperty().set((Object)UIObjectState.Loading);
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        CallableTask<Chart2DDrawData> task = new CallableTask<Chart2DDrawData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Chart2DDrawData call() throws Exception {
                Chart2DView chart2DView = Chart2DView.this;
                synchronized (chart2DView) {
                    if (Chart2DView.this.getOnLoadData() != null) {
                        Chart2DView.this.getOnLoadData().loadData(Chart2DView.this.getTimeRangeFilter());
                    }
                    if (chartViewPrefs != null) {
                        Chart2DView.this.viewPrefs = chartViewPrefs;
                    } else if (Chart2DView.this.config.getId() != null && !Chart2DView.this.config.hasCustomDataSeries()) {
                        Chart2DView.this.viewPrefs = Chart2DView.this.loadViewPrefs(Chart2DView.this.config, Chart2DView.this.getStructureObject(), timeRangeFilter);
                    } else if (Chart2DView.this.viewPrefs == null) {
                        Chart2DView.this.viewPrefs = new Chart2DViewPrefs(Chart2DView.this.config, Chart2DView.this.getStructureObject());
                        Chart2DView.this.viewPrefs.setTimeRangeFilterType(timeRangeFilter.getType());
                        Chart2DView.this.viewPrefs.setCustomViewIndex(timeRangeFilter.getCustomViewIndex());
                    }
                    Chart2DView.this.fullfillViewPrefs(Chart2DView.this.viewPrefs, timeRangeFilter);
                    Chart2DView.this.updateViewPrefsRaster((IViewPrefs)Chart2DView.this.viewPrefs);
                    if (prefsPersister != null) {
                        try {
                            prefsPersister.run();
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                    return Chart2DView.this.loadDrawData(Chart2DView.this.viewPrefs, Chart2DView.this.getTimeRangeFilter());
                }
            }
        };
        Chart2DViewSkinBase skin = (Chart2DViewSkinBase)this.getSkin();
        Future f = TaskUtils.executeUITask((ProgressIndicatorPane)(withProgressIndicator ? skin.getProgressIndicatorPane() : null), (CallableTask)task).consumeResult((status, result) -> {
            if (status == Worker.State.SUCCEEDED && result != null) {
                Platform.runLater(() -> {
                    Chart2DView chart2DView = this;
                    synchronized (chart2DView) {
                        try {
                            this.setState(UIObjectState.Ready);
                            this.drawData = result;
                            skin.clearSelection();
                            this.draw();
                        }
                        catch (Exception exc) {
                            ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                            dlg.initOwner(this.getWindow());
                            dlg.setHeaderText(Messages.charts_JFreeChartView_error_drawing_data);
                            dlg.show();
                        }
                    }
                });
            } else {
                Chart2DView chart2DView = this;
                synchronized (chart2DView) {
                    this.setState(UIObjectState.Error);
                }
            }
        });
        return f;
    }

    public void draw() {
        Chart2DViewSkinBase skin = (Chart2DViewSkinBase)this.getSkin();
        skin.draw(this.drawData);
        if (this.getOnDrawSeries() != null && this.getReportObject() instanceof JFreeChart) {
            this.getOnDrawSeries().drawSeries((JFreeChart)this.getReportObject(), this.viewPrefs.getXAxisViewPrefs(), this.viewPrefs.getYAxesViewPrefs().toArray(new AxisViewPrefs[0]));
        }
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    public void saveChanges(Transaction trx) throws DAOOperationException {
        for (IChartViewAddon<?> addon : this.addons) {
            addon.saveChanges(trx);
        }
    }

    public void resetChanges() {
        this.addons.forEach(a -> a.resetChanges());
    }

    public ILoadDataCallback getOnLoadData() {
        return this.onLoadData;
    }

    public void setOnLoadData(ILoadDataCallback onLoadData) {
        this.onLoadData = onLoadData;
    }

    public AdjustDefaultViewPrefsCallback getAdjustDefaultViewPrefsCallback() {
        return this.adjustDefaultViewPrefsCallback;
    }

    public void setAdjustDefaultViewPrefsCallback(AdjustDefaultViewPrefsCallback adjustDefaultViewPrefsCallback) {
        this.adjustDefaultViewPrefsCallback = adjustDefaultViewPrefsCallback;
    }

    public LoadCustomSeriesDataCallback getOnLoadCustomSeriesDataCallback(VarSeries2D series, StructureObject structureObject) {
        return (LoadCustomSeriesDataCallback)this.onLoadCustomSeriesDataCallbacks.get((Object)series, (Object)structureObject);
    }

    public Collection<StructureObject> getOnLoadCustomSeriesDataObjects(VarSeries2D series) {
        return this.onLoadCustomSeriesDataCallbacks.row((Object)series).keySet();
    }

    public void setOnLoadCustomSeriesData(VarSeries2D series, LoadCustomSeriesDataCallback onLoadCustomSeriesDataCallback, StructureObject ... forObjects) {
        StructureObject[] structureObjectArray = forObjects;
        int n = forObjects.length;
        int n2 = 0;
        while (n2 < n) {
            StructureObject o = structureObjectArray[n2];
            this.onLoadCustomSeriesDataCallbacks.put((Object)series, (Object)o, (Object)onLoadCustomSeriesDataCallback);
            ++n2;
        }
    }

    public void removeOnLoadCustomSeriesDataCallback(VarSeries2D series) {
        LinkedList objects = new LinkedList(this.onLoadCustomSeriesDataCallbacks.row((Object)series).keySet());
        for (StructureObject o : objects) {
            this.onLoadCustomSeriesDataCallbacks.remove((Object)series, (Object)o);
        }
    }

    public DrawSeriesListener getOnDrawSeries() {
        return this.onDrawSeries;
    }

    public void setOnDrawSeries(DrawSeriesListener onDrawSeries) {
        this.onDrawSeries = onDrawSeries;
    }

    @Override
    public void selectData(Instant atTimestamp, Object o) {
        if (this.config.getXAxisType() != XAxisType.Variable) {
            ((Chart2DViewSkinBase)this.getSkin()).setCrosshairPosition(atTimestamp.toEpochMilli(), null);
        } else {
            if (this.drawData == null) {
                return;
            }
            for (Series2DViewPrefs prefs : this.drawData.getSeriesViewPrefs()) {
                List<SeriesPoint> points = this.drawData.getSeriesPoints(prefs);
                for (SeriesPoint point : points) {
                    if (point.getTimestamp().longValue() != atTimestamp.toEpochMilli()) continue;
                    ((Chart2DViewSkinBase)this.getSkin()).setCrosshairPosition(point.getXValue(), point.getYValue());
                    return;
                }
            }
        }
    }

    public Map<VarSeries2D, VariableInstance[]> getSeriesInstances() {
        return Collections.unmodifiableMap(this.yAxisSeriesInstances);
    }

    protected void initContextMenu(ChartViewSkinBase skin) {
        LinkedList<SeparatorMenuItem> predefinedItems = new LinkedList<SeparatorMenuItem>();
        if (this.getContextMenu() != null && !this.getContextMenu().getItems().isEmpty()) {
            predefinedItems.addAll((Collection<SeparatorMenuItem>)this.getContextMenu().getItems());
            this.getContextMenu().getItems().clear();
        }
        ContextMenu contextMenu = null;
        Region viewContent = skin.getViewContent();
        MenuItem exportMenuItem = null;
        if (viewContent instanceof ChartViewer) {
            contextMenu = ((ChartViewer)viewContent).getContextMenu();
            if (contextMenu.getItems().size() == 1) {
                exportMenuItem = (MenuItem)contextMenu.getItems().get(0);
                exportMenuItem.setText(Messages.charts_JFreeChartView_menu_item_export);
            }
            if (!contextMenu.getItems().isEmpty()) {
                if (!predefinedItems.isEmpty()) {
                    predefinedItems.add(new SeparatorMenuItem());
                }
                predefinedItems.addAll((Collection<SeparatorMenuItem>)contextMenu.getItems());
                contextMenu.getItems().clear();
            }
        }
        if (contextMenu == null && (contextMenu = this.getContextMenu()) == null) {
            contextMenu = new ContextMenu();
            this.setContextMenu(contextMenu);
        }
        this.addAdjustViewMenuItems(contextMenu);
        SeparatorMenuItem adjustMenuItemSeparator = new SeparatorMenuItem();
        adjustMenuItemSeparator.setId("chart.menuitem.adjustmenuitemseparator");
        contextMenu.getItems().add((Object)adjustMenuItemSeparator);
        this.addViewMenuItems(contextMenu);
        if (!predefinedItems.isEmpty()) {
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
            contextMenu.getItems().addAll(predefinedItems);
            MenuItem drawSVG = new MenuItem("SVG...");
            drawSVG.setId("chart.menuitem.drawsvg");
            drawSVG.setOnAction(e -> {
                SVGGraphics2D g2 = new SVGGraphics2D(900, 500);
                Rectangle r = new Rectangle(0, 0, 900, 500);
                ((JFreeChart)this.getReportObject()).draw((Graphics2D)g2, (Rectangle2D)r);
                try {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setInitialFileName(this.getTitle());
                    fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("SVG", new String[]{"*.svg"})});
                    File f = fileChooser.showSaveDialog(this.getScene().getWindow());
                    if (f != null) {
                        SVGUtils.writeToSVG((File)f, (String)g2.getSVGElement());
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
            if (exportMenuItem instanceof Menu) {
                ((Menu)exportMenuItem).getItems().add((Object)drawSVG);
            } else {
                contextMenu.getItems().add((Object)drawSVG);
            }
        }
        for (IChartViewAddon<?> addon : this.addons) {
            addon.installMenuItems(contextMenu);
        }
    }

    protected void addAdjustViewMenuItems(ContextMenu contextMenu) {
        MenuItem restoreInitialZoomItem;
        MenuItem unzoomItem;
        MenuItem adjustItem = new MenuItem(Messages.charts_JFreeChartView_Adjust);
        adjustItem.setId("chart.menuitem.adjust");
        adjustItem.setOnAction(e -> {
            try {
                Chart2DViewPrefs prefs = this.config.getId() != null && !this.config.hasCustomDataSeries() ? this.loadViewPrefs(this.config, this.getStructureObject()) : this.viewPrefs;
                this.updateViewPrefsRaster((IViewPrefs)prefs);
                Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.getTimeRangeFilter().getType().toRawValueViewType(), (Integer)this.getTimeRangeFilter().getCustomViewIndex());
                ChartPrefsDialog dialog = new ChartPrefsDialog(this.getWindow(), prefs, this.yAxisSeriesInstances, this.getTimeRangeFilter().getType(), this.getTimeRangeFilter().getCustomViewIndex(), minRaster, this.getFixedRaster() != null);
                dialog.showAndWait().ifPresent(bt -> {
                    if (bt == ButtonType.OK) {
                        this.loadData(prefs, () -> {
                            if (this.config.getId() != null && !this.config.hasCustomDataSeries()) {
                                dialog.persist();
                            }
                        }, true);
                    }
                });
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        MenuItem refreshItem = new MenuItem(Messages.charts_JFreeChartView_Refresh, (Node)new ImageView(Icons.REFRESH_ITEM_URL.toString()));
        refreshItem.setId("chart.menuitem.refresh");
        refreshItem.setOnAction(e -> {
            Future<?> future = this.reloadData();
        });
        CheckMenuItem hideInvalidValuesItem = new CheckMenuItem(Messages.charts_JFreeChartView_Hide_Invalid_Values);
        hideInvalidValuesItem.setId("chart.menuitem.hideinvalidvalues");
        hideInvalidValuesItem.setSelected(this.hideInvalidValues);
        hideInvalidValuesItem.setOnAction(e -> {
            this.hideInvalidValues = hideInvalidValuesItem.isSelected();
            this.reloadData();
        });
        MenuItem clearViewPreferencesItem = new MenuItem(Messages.charts_JFreeChartView_Clear_Preferences);
        clearViewPreferencesItem.setId("chart.menuitem.clearpreferences");
        clearViewPreferencesItem.setOnAction(e -> {
            CheckBoxDialog dialog = new CheckBoxDialog(false);
            dialog.initOwner(this.getScene().getWindow());
            dialog.setContentText(Messages.charts_JFreeChartView_Clear_preferences_at_similar_charts);
            dialog.showAndWait().ifPresent(result -> {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        if (result.booleanValue()) {
                            Chart2DViewPrefsDAO.delete((Transaction)trx, (Chart2D)this.config);
                        } else {
                            Chart2DViewPrefsDAO.delete((Transaction)trx, (Chart2D)this.config, (StructureObject)this.getStructureObject());
                        }
                        Transactions.commitSync((Transaction)trx);
                        this.viewPrefs = null;
                        this.reloadData();
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.setContentText(Messages.charts_JFreeChartView_ErrorClearingViewPerspective);
                        dlg.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            });
        });
        if (this.getSkin() instanceof XYChartViewSkin) {
            XYChartViewSkin xyChartViewSkin = (XYChartViewSkin)this.getSkin();
            unzoomItem = new MenuItem(Messages.charts_JFreeChartView_Unzoom);
            unzoomItem.setId("chart.menuitem.unzoom");
            unzoomItem.setOnAction(e -> xyChartViewSkin.unzoom());
            unzoomItem.setGraphic((Node)new ImageView(Resources.getResourceUrl((String)"/icons/16x16/", (String)"application/undo.png").toString()));
            restoreInitialZoomItem = new MenuItem(Messages.charts_JFreeChartView_ResetZoom);
            restoreInitialZoomItem.setId("chart.menuitem.restoreinitialzoom");
            restoreInitialZoomItem.setOnAction(e -> xyChartViewSkin.resetZoom());
            contextMenu.setOnShowing(e -> {
                boolean canUnzoom = xyChartViewSkin.canUnzoom();
                unzoomItem.setDisable(!canUnzoom);
                restoreInitialZoomItem.setDisable(!canUnzoom);
            });
        } else {
            restoreInitialZoomItem = null;
            unzoomItem = null;
        }
        contextMenu.getItems().add((Object)adjustItem);
        contextMenu.getItems().add((Object)refreshItem);
        contextMenu.getItems().add((Object)hideInvalidValuesItem);
        if (this.config.getId() != null) {
            contextMenu.getItems().add((Object)clearViewPreferencesItem);
        }
        if (unzoomItem != null && restoreInitialZoomItem != null) {
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
            contextMenu.getItems().add((Object)unzoomItem);
            contextMenu.getItems().add((Object)restoreInitialZoomItem);
        }
    }

    protected void addViewMenuItems(ContextMenu contextMenu) {
        if (this.getConfig().getXAxisType() == XAxisType.Time && this.getSkin() instanceof XYChartViewSkin) {
            MenuItem extractCustomView = new MenuItem(Messages.charts_ChartView_createcustomdataview);
            extractCustomView.setId("chart.menuitem.createcustomview");
            extractCustomView.setOnAction(e -> {
                XYChartViewSkin xyChartViewSkin = (XYChartViewSkin)this.getSkin();
                Pair<Double, Double> bounds = xyChartViewSkin.getXAxisBounds();
                LocalDateTime from = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Double)bounds.getKey()).longValue()), ZoneId.systemDefault());
                LocalDateTime to = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Double)bounds.getValue()).longValue()), ZoneId.systemDefault());
                CreateRawValuesViewDialog dlg = new CreateRawValuesViewDialog(this.getWindow(), this.sync, from, to, Raster.Second_1);
                dlg.showAndWait().ifPresent(customViewIndex -> {
                    if (customViewIndex != null) {
                        RawValuesViewDescriptor valuesView = RawValuesViewDAO.getView((RawValuesViewType)RawValuesViewType.CustomView, (Integer)customViewIndex);
                        this.app.getContext().set(ITimeRangeFilter.class, (Object)new CustomViewTimeRangeFilter(customViewIndex.intValue(), valuesView.getTimeRangeBegin(), valuesView.getTimeRangeEnd()));
                        xyChartViewSkin.resetZoom();
                        Transaction trx = Transactions.begin();
                        try {
                            try {
                                TimeRangeFilterPreference prefs = TimeRangeFilterPreferenceDAO.getUserPreferences((Transaction)trx);
                                prefs.setType(TimeRangeFilterType.CustomView);
                                prefs.setCustomViewIndex(customViewIndex);
                                TimeRangeFilterPreferenceDAO.saveOrUpdate((Transaction)trx, (TimeRangeFilterPreference)prefs);
                                Transactions.commitSync((Transaction)trx);
                            }
                            catch (DAOOperationException dAOOperationException) {
                                Transactions.rollback((Transaction)trx);
                                Transactions.close((Transaction)trx);
                            }
                        }
                        finally {
                            Transactions.close((Transaction)trx);
                        }
                    }
                });
            });
            contextMenu.getItems().add((Object)extractCustomView);
        }
    }

    private void addSnapshotsMenuItem(ContextMenu contextMenu) {
        Menu snapshotsItem = new Menu("Snapshots");
        snapshotsItem.setId("chart.menuitem.createsnapshot");
        contextMenu.getItems().add((Object)snapshotsItem);
        MenuItem createSnapshotItem = new MenuItem("Create Snapshot");
        createSnapshotItem.setId("chart.menuitem.createsnapshot");
        createSnapshotItem.setOnAction(e -> {
            RawValuesViewType viewType = this.getTimeRangeFilter().getType().toRawValueViewType();
            Integer viewIndex = this.getTimeRangeFilter().getCustomViewIndex();
            Instant fromTs = this.getTimeRangeFilter().getFrom();
            Instant toTs = this.getTimeRangeFilter().getTo();
            Raster baseRaster = this.getViewPrefs().getRaster();
            if (this.getViewPrefs().getVirtualRaster() != null) {
                baseRaster = Raster.Hour;
            }
            LocalDateTime from = fromTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            LocalDateTime to = toTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            VariableInstance[] obligatoryInstances = (VariableInstance[])this.xAxisSeriesInstances.values().toArray(VariableInstance[]::new);
            LinkedHashSet optionalInstances = new LinkedHashSet();
            this.yAxisSeriesInstances.values().stream().forEach(is -> {
                boolean bl = optionalInstances.addAll(Arrays.asList(is));
            });
            CreateVariableInstanceSnapshotDialog dlg = new CreateVariableInstanceSnapshotDialog(this.getWindow(), this.sync, viewType, viewIndex, from, to, null, null, baseRaster, obligatoryInstances, (VariableInstance[])optionalInstances.toArray(VariableInstance[]::new));
            dlg.showAndWait().ifPresent(id -> {});
        });
        snapshotsItem.getItems().add((Object)createSnapshotItem);
        MenuItem selectOrDeleteSnapshotItem = new MenuItem("Select Snapshot");
        createSnapshotItem.setId("chart.menuitem.selectordeleteshapshot");
        selectOrDeleteSnapshotItem.setOnAction(e -> {
            Instant fromTs = this.getTimeRangeFilter().getFrom();
            Instant toTs = this.getTimeRangeFilter().getTo();
            LocalDateTime from = fromTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            LocalDateTime to = toTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            SelectOrEditVariableInstanceSnapshotDialog dlg = new SelectOrEditVariableInstanceSnapshotDialog(this.getWindow(), this.sync, null, from, to);
            dlg.showAndWait();
        });
        snapshotsItem.getItems().add((Object)selectOrDeleteSnapshotItem);
    }

    public String toString() {
        if (this.config.getLocalTitle() == null) {
            return this.getStructureObject().toString();
        }
        if (this.config.getLocalTitle().contains("{object}")) {
            return this.config.getLocalTitle().replaceAll("\\{object\\}", this.getStructureObject().toString());
        }
        return String.format("%s (%s)", this.config.getLocalTitle(), this.getStructureObject());
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public static Chart2DView create(Chart2D config, IEclipseContext chartContext) {
        return Chart2DView.create(config, null, null, null, null, chartContext);
    }

    public static Chart2DView create(Chart2D config, StructureObject structureObject, IEclipseContext chartContext) {
        return Chart2DView.create(config, structureObject, null, null, null, chartContext);
    }

    public static Chart2DView create(Chart2D config, StructureObject structureObject, ITimeRangeFilter timeRangeFilter, IEclipseContext chartContext) {
        return Chart2DView.create(config, structureObject, timeRangeFilter, null, null, chartContext);
    }

    public static Chart2DView create(Chart2D config, StructureObject structureObject, ITimeRangeFilter timeRangeFilter, VirtualRaster fixedRaster, Comparator<VariableInstance> instanceComparator, IEclipseContext chartContext) {
        chartContext.set(Chart2D.class, (Object)config);
        if (structureObject != null) {
            chartContext.set(StructureObject.class, (Object)structureObject);
        }
        if (fixedRaster != null) {
            chartContext.set(VirtualRaster.class, (Object)fixedRaster);
        }
        if (timeRangeFilter != null) {
            chartContext.set(ITimeRangeFilter.class, (Object)timeRangeFilter);
        }
        if (instanceComparator != null) {
            chartContext.set("instance.comparator", instanceComparator);
        }
        Chart2DView chart2DView = (Chart2DView)ContextInjectionFactory.make(Chart2DView.class, (IEclipseContext)chartContext);
        return chart2DView;
    }
}

