/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.Chart3DViewPrefs;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.viewprefs.Chart3DViewPrefsDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart3DPrefsHelper;
import de.elpro.ewms.core.fx.internal.ComplexRasterDescriptor;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.cells.editable.DoubleFieldTableCell;
import de.elpro.ui.fx.cells.editable.DynamicComboBoxTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.model.UIModelElement;
import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class Chart3DPrefsDialog
extends Dialog<ButtonType> {
    private final Chart3DViewPrefs chartViewPrefs;
    private final SimpleBooleanProperty copyPreferencesProperty = new SimpleBooleanProperty(false);
    private final TimeRangeFilterType timeRangeFilterType;
    private final Integer customViewIndex;
    private final Raster minRaster;
    private StringConverter<ShapeType> shapeTypeConverter = new StringConverter<ShapeType>(){

        public String toString(ShapeType object) {
            if (object == null || object == ShapeType.None) {
                return null;
            }
            return object.toString();
        }

        public ShapeType fromString(String string) {
            return null;
        }
    };

    public Chart3DPrefsDialog(Window window, Chart3DViewPrefs chartViewPrefs, TimeRangeFilterType timeRangeFilterType, Integer customViewIndex, Raster minRaster, boolean fixedRaster) {
        this.chartViewPrefs = chartViewPrefs;
        this.timeRangeFilterType = timeRangeFilterType;
        this.customViewIndex = customViewIndex;
        this.minRaster = minRaster;
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner(window);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        BorderPane pane = new BorderPane();
        if (!fixedRaster) {
            pane.setTop(this.createRasterSettingsUI());
        }
        pane.setCenter(this.createAxesSettingsUI());
        CheckBox copyPrefsCb = new CheckBox(Messages.charts_ChartPrefsDialog_Copy_preferences_to_similar_charts);
        copyPrefsCb.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.copyPreferencesProperty.bind((ObservableValue)copyPrefsCb.selectedProperty());
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        VBox contentBox = new VBox(10.0, new Node[]{pane});
        contentBox.getChildren().add((Object)copyPrefsCb);
        this.getDialogPane().setContent((Node)contentBox);
        this.setResultConverter(bt -> bt);
        this.setTitle(Messages.charts_ChartPrefsDialog_Chart_Preferences);
        this.getDialogPane().setPrefWidth(800.0);
        this.setResizable(true);
    }

    protected Node createRasterSettingsUI() {
        ObservableList<ComplexRasterDescriptor> rasters = ComplexRasterDescriptor.createDescriptors(this.minRaster);
        ComboBox rasterCb = new ComboBox(rasters);
        rasterCb.setValue((Object)new ComplexRasterDescriptor(this.chartViewPrefs.getComplexRaster() != null ? this.chartViewPrefs.getComplexRaster() : ComplexRaster.of((Raster)this.minRaster)));
        rasterCb.valueProperty().addListener(il -> {
            ComplexRaster cr = ((ComplexRasterDescriptor)rasterCb.getValue()).getComplexRaster();
            if (cr == null || cr.ordinal() <= this.minRaster.ordinal()) {
                this.chartViewPrefs.setRaster(this.minRaster);
                this.chartViewPrefs.setVirtualRaster(null);
            } else {
                this.chartViewPrefs.setRaster(cr.getRaster());
                this.chartViewPrefs.setVirtualRaster(cr.getVirtualRaster());
            }
        });
        Label label = new Label(Messages.charts_ChartPrefsDialog_Raster1);
        label.setPadding(new Insets(5.0));
        HBox box = new HBox(10.0, new Node[]{label, rasterCb});
        box.setPadding(new Insets(10.0));
        return box;
    }

    protected Node createAxesSettingsUI() {
        TableView tableView = new TableView();
        tableView.setEditable(true);
        TableColumn titleColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Axis);
        titleColumn.setGraphic((Node)new ImageView(YAxis.DEFAULT_ICON.toString()));
        titleColumn.setCellFactory(cf -> new UIModelTableCell());
        titleColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((Chart3DAxisWrapper)cf.getValue())));
        titleColumn.setMinWidth(200.0);
        TableColumn measuringUnitColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Unit);
        measuringUnitColumn.setCellFactory(cf -> new DynamicComboBoxTableCell(mu -> mu.getPhysicalUnit().getMeasuringUnits()));
        measuringUnitColumn.setCellValueFactory(cf -> ((Chart3DAxisWrapper)cf.getValue()).measuringUnit);
        TableColumn lowerRange = new TableColumn(Messages.charts_ChartPrefsDialog_l_lim);
        lowerRange.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.DEFAULT_DOUBLE));
        lowerRange.setCellValueFactory(cf -> ((Chart3DAxisWrapper)cf.getValue()).lowerRange);
        lowerRange.setMinWidth(100.0);
        TableColumn upperRange = new TableColumn(Messages.charts_ChartPrefsDialog_u_lim);
        upperRange.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.DEFAULT_DOUBLE));
        upperRange.setCellValueFactory(cf -> ((Chart3DAxisWrapper)cf.getValue()).upperRange);
        upperRange.setMinWidth(100.0);
        tableView.getColumns().addAll((Object[])new TableColumn[]{titleColumn, measuringUnitColumn, lowerRange, upperRange});
        ArrayList<Chart3DAxisWrapper> axes = new ArrayList<Chart3DAxisWrapper>();
        axes.add(new Chart3DAxisWrapper('X', this.chartViewPrefs.getChart().getXAxisLocalName(), this.chartViewPrefs.getChart().getXAxisColor(), (ObjectProperty<MeasuringUnit>)this.chartViewPrefs.xAxisMeasuringUnitProperty(), (ObjectProperty<Double>)this.chartViewPrefs.xAxisLowerRangeProperty(), (ObjectProperty<Double>)this.chartViewPrefs.xAxisUpperRangeProperty()));
        axes.add(new Chart3DAxisWrapper('Y', this.chartViewPrefs.getChart().getYAxisLocalName(), this.chartViewPrefs.getChart().getYAxisColor(), (ObjectProperty<MeasuringUnit>)this.chartViewPrefs.yAxisMeasuringUnitProperty(), (ObjectProperty<Double>)this.chartViewPrefs.yAxisLowerRangeProperty(), (ObjectProperty<Double>)this.chartViewPrefs.yAxisUpperRangeProperty()));
        axes.add(new Chart3DAxisWrapper('Z', this.chartViewPrefs.getChart().getZAxisLocalName(), this.chartViewPrefs.getChart().getZAxisColor(), (ObjectProperty<MeasuringUnit>)this.chartViewPrefs.zAxisMeasuringUnitProperty(), (ObjectProperty<Double>)this.chartViewPrefs.zAxisLowerRangeProperty(), (ObjectProperty<Double>)this.chartViewPrefs.zAxisUpperRangeProperty()));
        if (this.chartViewPrefs.getChart().getWAxisType() == Chart3DWAxisType.Variable) {
            axes.add(new Chart3DAxisWrapper('W', this.chartViewPrefs.getChart().getWAxisLocalName(), Color.BLACK, (ObjectProperty<MeasuringUnit>)this.chartViewPrefs.wAxisMeasuringUnitProperty(), (ObjectProperty<Double>)this.chartViewPrefs.wAxisLowerRangeProperty(), (ObjectProperty<Double>)this.chartViewPrefs.wAxisUpperRangeProperty()));
        }
        tableView.getItems().setAll(axes);
        tableView.setMinHeight(100.0);
        tableView.setPrefHeight(150.0);
        VBox box = new VBox(new Node[]{tableView});
        box.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        return box;
    }

    public void persist() {
        Transaction trx = Transactions.begin();
        try {
            try {
                this.chartViewPrefs.setTimeRangeFilterType(this.timeRangeFilterType);
                this.chartViewPrefs.setCustomViewIndex(this.customViewIndex);
                Chart3DPrefsHelper.persist(trx, this.chartViewPrefs);
                if (this.copyPreferencesProperty.get()) {
                    StructureObject[] structureObjectArray = StructureClassDAO.getAllObjects((Transaction)trx, (StructureClass)this.chartViewPrefs.getChart().getDataStructureClass());
                    int n = structureObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructureObject object = structureObjectArray[n2];
                        if (!object.equals((Object)this.chartViewPrefs.getStructureObject())) {
                            Chart3DViewPrefs clonedPrefs = this.copyPreferences(trx, this.chartViewPrefs, object);
                            Chart3DPrefsHelper.persist(trx, clonedPrefs);
                        }
                        ++n2;
                    }
                }
                Transactions.commitSync((Transaction)trx);
            }
            catch (DAOOperationException e) {
                e.printStackTrace();
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private Chart3DViewPrefs copyPreferences(Transaction trx, Chart3DViewPrefs sourcePrefs, StructureObject object) throws DAOOperationException {
        Chart3DViewPrefs prefs = Chart3DViewPrefsDAO.get((Transaction)trx, (Chart3D)sourcePrefs.getChart(), (StructureObject)object);
        prefs = prefs != null ? new Chart3DViewPrefs(prefs.getId().intValue(), sourcePrefs.getChart(), object) : new Chart3DViewPrefs(sourcePrefs.getChart(), object);
        prefs.setAutoupdate(sourcePrefs.isAutoupdate());
        prefs.setTimeRangeFilterType(sourcePrefs.getTimeRangeFilterType());
        prefs.setCustomViewIndex(sourcePrefs.getCustomViewIndex());
        prefs.setRaster(sourcePrefs.getRaster());
        prefs.setVirtualRaster(sourcePrefs.getVirtualRaster());
        prefs.setXAxisMeasuringUnit(sourcePrefs.getXAxisMeasuringUnit());
        prefs.setXAxisLowerRange(sourcePrefs.getXAxisLowerRange());
        prefs.setXAxisUpperRange(sourcePrefs.getXAxisUpperRange());
        prefs.setYAxisMeasuringUnit(sourcePrefs.getYAxisMeasuringUnit());
        prefs.setYAxisLowerRange(sourcePrefs.getYAxisLowerRange());
        prefs.setYAxisUpperRange(sourcePrefs.getYAxisUpperRange());
        prefs.setZAxisMeasuringUnit(sourcePrefs.getZAxisMeasuringUnit());
        prefs.setZAxisLowerRange(sourcePrefs.getZAxisLowerRange());
        prefs.setZAxisUpperRange(sourcePrefs.getZAxisUpperRange());
        return prefs;
    }

    public static class Chart3DAxisWrapper
    implements UIModelElement {
        private final char axisType;
        private final String name;
        private final Color axisColor;
        private final ObjectProperty<MeasuringUnit> measuringUnit;
        private final ObjectProperty<Double> lowerRange;
        private final ObjectProperty<Double> upperRange;

        public Chart3DAxisWrapper(char axisType, String name, Color axisColor, ObjectProperty<MeasuringUnit> measuringUnit, ObjectProperty<Double> lowerRange, ObjectProperty<Double> upperRange) {
            this.axisType = axisType;
            this.name = name;
            this.axisColor = axisColor;
            this.measuringUnit = measuringUnit;
            this.lowerRange = lowerRange;
            this.upperRange = upperRange;
        }

        public String toString() {
            return this.name;
        }

        public Node getGraphic() {
            Label label = new Label(Character.toString(this.axisType));
            String colorStr = this.axisColor != null ? this.axisColor.toString().replaceAll("0x", "#") : "black";
            label.setStyle(String.format("-fx-text-fill: %s; -fx-font-weight: bold;", colorStr));
            return label;
        }
    }
}

