/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import de.elpro.ewms.core.ai.AINetworkModel;
import de.elpro.ewms.core.ai.AINetworkParams;
import de.elpro.ewms.core.ai.AIProvider;
import de.elpro.ewms.core.ai.AIProviders;
import de.elpro.ewms.core.ai.TrainingListener;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DFunction;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctions;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.charts.Characteristic3DSeries;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.FunctionSeries3D;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.charts.viewprefs.Chart3DViewPrefs;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DInstanceDAO;
import de.elpro.ewms.core.client.charts.viewprefs.Chart3DViewPrefsDAO;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.utils.StructureUtils;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart3DPrefsDialog;
import de.elpro.ewms.core.fx.charts.ChartViewBase;
import de.elpro.ewms.core.fx.charts.CompareCharacteristic3DChart;
import de.elpro.ewms.core.fx.charts.CompareCharacteristic3DDialog;
import de.elpro.ewms.core.fx.charts.LearnCurveDialog;
import de.elpro.ewms.core.fx.charts.addons.CharacteristicCurveBeginTimestampDialog;
import de.elpro.ewms.core.fx.charts.skins.Chart3DDrawData;
import de.elpro.ewms.core.fx.charts.skins.Chart3DViewSkinBase;
import de.elpro.ewms.core.fx.charts.skins.XYZChart3DViewSkin;
import de.elpro.ewms.core.fx.model.DataSelection;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.VarValuesColumn;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.structure.StructureTreeSearchException;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.FormulaCalculator;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.value.FastIVarValuesArrayIterable;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.resources.Icons;
import de.elpro.resources.Resources;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.series.AreaSurfaceEditMode;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZFunctionSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.controls.CheckBoxDialog;
import de.elpro.ui.fx.e4.FXPartService;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;

public class Chart3DView
extends ChartViewBase {
    @Inject
    private FXPartService partService;
    private final Chart3D config;
    private Chart3DViewPrefs viewPrefs;
    private final Multimap<VarSeries3D, StructureObject> varSeriesObjects = TreeMultimap.create();
    private final Table<VarSeries3D, StructureObject, VariableInstance> xAxisInstances = HashBasedTable.create();
    private final Table<VarSeries3D, StructureObject, VariableInstance> yAxisInstances = HashBasedTable.create();
    private final Table<VarSeries3D, StructureObject, VariableInstance> zAxisInstances = HashBasedTable.create();
    private final Table<VarSeries3D, StructureObject, VariableInstance> wAxisInstances = HashBasedTable.create();
    private final Multimap<FunctionSeries3D, StructureObject> functionSeriesObjects = TreeMultimap.create();
    private List<XYZAreaSeries> functionSeriesKI = new ArrayList<XYZAreaSeries>();
    private XYZKIAreaSeries kiSeries;
    private volatile boolean isLearning = false;
    private final SimpleStringProperty infoLabelText = new SimpleStringProperty();
    private Map.Entry<Instant, Characteristic3DFunction> selectedFunctionEntry;
    private Characteristic3DInstance characteristic3DInstance = null;
    private final ObservableList<Characteristic3DFunctionChange> characteristicFunctionChanges = FXCollections.observableArrayList();
    private final BooleanProperty show2DView = new SimpleBooleanProperty(false);
    private final BooleanProperty swapZWAxes = new SimpleBooleanProperty(false);
    private final ObservableBooleanValue hasChanges = Bindings.isNotEmpty(this.characteristicFunctionChanges);
    private Chart3DDrawData drawData;
    private MenuItem menuItemStartStopCurve;
    private MenuItem menuItemDismissCurve;
    private final AIProvider aiProvider;

    public Chart3DView(Chart3D config, StructureObject structureObject, Scene scene, ITimeRangeFilter timeRangeFilter) {
        this(config, structureObject, scene, timeRangeFilter, null);
    }

    @Inject
    public Chart3DView(Chart3D config, StructureObject structureObject, Scene scene, @Optional ITimeRangeFilter timeRangeFilter, @Optional VirtualRaster fixedRaster) {
        super(structureObject, scene.getWindow(), timeRangeFilter, fixedRaster);
        this.config = config;
        this.aiProvider = AIProviders.getFirst();
        this.setSwapZWAxes(config.isSwapZWAxes());
        this.parentProperty().addListener((o, ov, nv) -> {
            if (ov != null && nv == null) {
                this.dispose();
            }
        });
        this.skinProperty().addListener((o, ov, nv) -> {
            if (ov == null && nv != null) {
                Chart3DViewSkinBase chartViewSkin = (Chart3DViewSkinBase)((Object)nv);
                this.initContextMenu(chartViewSkin);
                chartViewSkin.getSelectedItems().addListener(il -> {
                    IDataSelection lastSelection = this.getDataSelection();
                    Instant lastTimestamp = null;
                    for (XYZItem item : chartViewSkin.getSelectedItems()) {
                        if (lastTimestamp == null) {
                            lastTimestamp = item.getTimetamp();
                            continue;
                        }
                        Instant instant = lastTimestamp = item.getTimetamp().isAfter(lastTimestamp) ? item.getTimetamp() : lastTimestamp;
                    }
                    if (lastSelection != null && lastSelection.getEndTimestamp().equals(lastTimestamp)) {
                        return;
                    }
                    if (lastTimestamp != null) {
                        this.setDataSelection(new DataSelection(lastTimestamp, Collections.unmodifiableList(chartViewSkin.getSelectedItems())));
                    } else {
                        this.setDataSelection(null);
                    }
                });
                this.reloadData();
            }
        });
    }

    public Chart3D getConfig() {
        return this.config;
    }

    public Chart3DViewPrefs getViewPrefs() {
        return this.viewPrefs;
    }

    public Characteristic3DInstance getCharacteristic3dInstance() {
        return this.characteristic3DInstance;
    }

    private void loadStaticModel(Chart3D config, StructureObject structureObject) throws IllegalConfigException {
        Transaction trx = Transactions.begin();
        try {
            StructureObject dataObject;
            int n;
            int n2;
            StructureObject[] structureObjectArray;
            this.varSeriesObjects.clear();
            this.xAxisInstances.clear();
            this.yAxisInstances.clear();
            this.zAxisInstances.clear();
            this.wAxisInstances.clear();
            StructureObject[] dataObjects = StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)structureObject, (StructureClass)config.getDataStructureClass(), (SearchPolicy)SearchPolicy.Auto);
            for (VarSeries3D series : config.getVarSeries()) {
                structureObjectArray = dataObjects;
                n2 = dataObjects.length;
                n = 0;
                while (n < n2) {
                    block15: {
                        VariableInstance wAxisInstance;
                        VariableInstance zAxisInstance;
                        VariableInstance yAxisInstance;
                        VariableInstance xAxisInstance;
                        block22: {
                            block20: {
                                VariableInstance[] candidates;
                                block21: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block14: {
                                                        block13: {
                                                            dataObject = structureObjectArray[n];
                                                            if (series.getXAxisVariableInstance() == null) break block13;
                                                            xAxisInstance = series.getXAxisVariableInstance();
                                                            break block14;
                                                        }
                                                        candidates = VariableDAO.findInstances((Transaction)trx, (Variable)series.getXAxisVariable(), (StructureObject)dataObject);
                                                        if (candidates.length != 1) break block15;
                                                        xAxisInstance = candidates[0];
                                                    }
                                                    if (series.getYAxisVariableInstance() == null) break block16;
                                                    yAxisInstance = series.getYAxisVariableInstance();
                                                    break block17;
                                                }
                                                candidates = VariableDAO.findInstances((Transaction)trx, (Variable)series.getYAxisVariable(), (StructureObject)dataObject);
                                                if (candidates.length != 1) break block15;
                                                yAxisInstance = candidates[0];
                                            }
                                            if (series.getZAxisVariableInstance() == null) break block18;
                                            zAxisInstance = series.getZAxisVariableInstance();
                                            break block19;
                                        }
                                        candidates = VariableDAO.findInstances((Transaction)trx, (Variable)series.getZAxisVariable(), (StructureObject)dataObject);
                                        if (candidates.length != 1) break block15;
                                        zAxisInstance = candidates[0];
                                    }
                                    if (config.getWAxisType() != Chart3DWAxisType.Variable || series.getWAxisVariable() == null) break block20;
                                    if (series.getWAxisVariableInstance() == null) break block21;
                                    wAxisInstance = series.getWAxisVariableInstance();
                                    break block22;
                                }
                                candidates = VariableDAO.findInstances((Transaction)trx, (Variable)series.getWAxisVariable(), (StructureObject)dataObject);
                                if (candidates.length != 1) break block15;
                                wAxisInstance = candidates[0];
                                break block22;
                            }
                            wAxisInstance = null;
                        }
                        xAxisInstance.setVariable(series.getXAxisVariable());
                        yAxisInstance.setVariable(series.getYAxisVariable());
                        zAxisInstance.setVariable(series.getZAxisVariable());
                        if (wAxisInstance != null) {
                            wAxisInstance.setVariable(series.getWAxisVariable());
                        }
                        this.varSeriesObjects.put((Object)series, (Object)dataObject);
                        this.xAxisInstances.put((Object)series, (Object)dataObject, (Object)xAxisInstance);
                        this.yAxisInstances.put((Object)series, (Object)dataObject, (Object)yAxisInstance);
                        this.zAxisInstances.put((Object)series, (Object)dataObject, (Object)zAxisInstance);
                        if (wAxisInstance != null) {
                            this.wAxisInstances.put((Object)series, (Object)dataObject, (Object)wAxisInstance);
                        }
                    }
                    ++n;
                }
            }
            for (VarSeries3D series : config.getFunctionSeries()) {
                structureObjectArray = dataObjects;
                n2 = dataObjects.length;
                n = 0;
                while (n < n2) {
                    dataObject = structureObjectArray[n];
                    this.functionSeriesObjects.put((Object)series, (Object)dataObject);
                    ++n;
                }
            }
            Characteristic3DSeries c3dS = config.getCharacteristic3DSeries();
            if (c3dS != null) {
                Characteristic3D c3d = Characteristic3DDAO.get((Transaction)trx, (int)c3dS.getCharacteristic().getId());
                c3dS.setCharacteristic(c3d);
                Characteristic3DInstance c3di = Characteristic3DInstanceDAO.get((Transaction)trx, (Characteristic3D)c3d, (StructureObject)structureObject);
                if (c3di != null) {
                    c3di.setCharacteristic(c3d);
                }
                this.characteristic3DInstance = c3di;
                if (this.selectedFunctionEntry == null) {
                    this.selectedFunctionEntry = this.characteristic3DInstance.getFunctions().lastEntry();
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private Chart3DViewPrefs loadViewPrefs(Chart3D chartDefinition, StructureObject structureObject) throws IllegalConfigException {
        return this.loadViewPrefs(chartDefinition, structureObject, this.getTimeRangeFilter());
    }

    private Chart3DViewPrefs loadViewPrefs(Chart3D config, StructureObject structureObject, ITimeRangeFilter timeRangePrefs) throws IllegalConfigException {
        Transaction trx = Transactions.begin();
        try {
            Chart3DViewPrefs prefs = Chart3DViewPrefsDAO.get((Transaction)trx, (Chart3D)config, (StructureObject)structureObject);
            if (prefs == null) {
                prefs = new Chart3DViewPrefs(config, structureObject);
                prefs.setTimeRangeFilterType(timeRangePrefs.getType());
                prefs.setCustomViewIndex(timeRangePrefs.getCustomViewIndex());
            } else {
                prefs.setChart(config);
                prefs.setStructureObject(structureObject);
            }
            if (prefs.getXAxisMeasuringUnit() == null || prefs.getXAxisMeasuringUnit().getPhysicalUnit() != config.getXAxisPhysicalUnit()) {
                prefs.setXAxisMeasuringUnit(config.getXAxisResultMeasuringUnit());
            }
            if (prefs.getYAxisMeasuringUnit() == null || prefs.getYAxisMeasuringUnit().getPhysicalUnit() != config.getYAxisPhysicalUnit()) {
                prefs.setYAxisMeasuringUnit(config.getYAxisResultMeasuringUnit());
            }
            if (prefs.getZAxisMeasuringUnit() == null || prefs.getZAxisMeasuringUnit().getPhysicalUnit() != config.getZAxisPhysicalUnit()) {
                prefs.setZAxisMeasuringUnit(config.getZAxisResultMeasuringUnit());
            }
            if (config.getWAxisType() == Chart3DWAxisType.Variable && (prefs.getWAxisMeasuringUnit() == null || prefs.getWAxisMeasuringUnit().getPhysicalUnit() != config.getWAxisPhysicalUnit())) {
                prefs.setWAxisMeasuringUnit(config.getWAxisResultMeasuringUnit());
            }
            if (prefs.getTimeRangeFilterType() == null) {
                prefs.setTimeRangeFilterType(timeRangePrefs.getType());
            }
            Chart3DViewPrefs chart3DViewPrefs = prefs;
            return chart3DViewPrefs;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    public StringProperty infoLabelTextProperty() {
        return this.infoLabelText;
    }

    public String getInfoLabelText() {
        return (String)this.infoLabelTextProperty().get();
    }

    public void setInfoLabelText(String text) {
        this.infoLabelTextProperty().set((Object)text);
    }

    protected Skin<?> createDefaultSkin() {
        return new XYZChart3DViewSkin(this);
    }

    @Override
    public Future<?> reloadData() {
        return this.loadData(this.getTimeRangeFilter());
    }

    @Override
    public Future<?> loadData(ITimeRangeFilter timeRangeFilter) {
        return this.loadData(timeRangeFilter, true);
    }

    public Future<?> loadData(ITimeRangeFilter timeRangeFilter, boolean withProgressIndicator) {
        this.updateTimeRangeFilter(timeRangeFilter);
        try {
            return this.loadData(this.viewPrefs, null, withProgressIndicator);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public Future<?> loadData(final Chart3DViewPrefs chartViewPrefs, final Runnable prefsPersister, boolean withProgressIndicator) {
        Chart3DViewSkinBase skin = (Chart3DViewSkinBase)this.getSkin();
        final UIObjectState state = this.getState();
        if (this.hasChanges()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initOwner(this.getScene().getWindow());
            alert.setContentText(Messages.chart_ChartView_resetChangesAlert);
            if (ButtonType.OK == alert.showAndWait().get()) {
                this.clearCharacteristicFunctionChanges();
            } else {
                return null;
            }
        }
        try {
            FXUtils.runAndWait(() -> {
                Chart3DView chart3DView = this;
                synchronized (chart3DView) {
                    this.stateProperty().set((Object)UIObjectState.Loading);
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        CallableTask<Chart3DDrawData> task = new CallableTask<Chart3DDrawData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Chart3DDrawData call() throws Exception {
                Chart3DView chart3DView = Chart3DView.this;
                synchronized (chart3DView) {
                    if (state == UIObjectState.New) {
                        Chart3DView.this.loadStaticModel(Chart3DView.this.config, Chart3DView.this.getStructureObject());
                    }
                    Chart3DView.this.setState(UIObjectState.Loading);
                    Chart3DView.this.viewPrefs = chartViewPrefs != null ? chartViewPrefs : Chart3DView.this.loadViewPrefs(Chart3DView.this.config, Chart3DView.this.getStructureObject());
                    ITimeRangeFilter timeRangeFilter = Chart3DView.this.getTimeRangeFilter();
                    if (prefsPersister != null) {
                        try {
                            prefsPersister.run();
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                    Chart3DView.this.updateViewPrefsRaster((IViewPrefs)Chart3DView.this.viewPrefs);
                    return Chart3DView.this.loadDrawData(timeRangeFilter);
                }
            }
        };
        Future f = TaskUtils.executeUITask((ProgressIndicatorPane)skin.getProgressIndicatorPane(), (CallableTask)task).consumeResult((status, result) -> {
            if (status == Worker.State.SUCCEEDED && result != null) {
                Platform.runLater(() -> {
                    Chart3DView chart3DView = this;
                    synchronized (chart3DView) {
                        try {
                            this.drawData = result;
                            skin.updateChartConfig();
                            skin.draw((Chart3DDrawData)result);
                            ((XYZChart3DViewSkin)skin).getXYZChart().getSeriesList().addAll(this.functionSeriesKI);
                            this.stateProperty().set((Object)UIObjectState.Ready);
                        }
                        catch (Exception exc) {
                            ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                            dlg.initOwner(this.getWindow());
                            dlg.setHeaderText(Messages.charts_JFreeChartView_error_drawing_data);
                            dlg.show();
                        }
                    }
                });
            } else {
                Chart3DView chart3DView = this;
                synchronized (chart3DView) {
                    this.stateProperty().set((Object)UIObjectState.Error);
                }
            }
        });
        return f;
    }

    protected Chart3DDrawData loadDrawData(ITimeRangeFilter timeRangeFilter) {
        LinkedHashMap<VariableInstance, VarValuesColumn> instanceColumns = new LinkedHashMap<VariableInstance, VarValuesColumn>();
        ComplexRaster complexRaster = this.getFixedRaster() != null ? ComplexRaster.of((VirtualRaster)this.getFixedRaster()) : (this.viewPrefs.getComplexRaster() == null ? (this.config.getDefaultRaster() != null ? ComplexRaster.of((VirtualRaster)this.config.getDefaultRaster()) : ComplexRaster.of((Raster)ServerDAO.getRawValuesViewRaster((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex()))) : this.viewPrefs.getComplexRaster());
        Chart3DDrawData chartDrawData = new Chart3DDrawData(complexRaster, timeRangeFilter.getFrom(), timeRangeFilter.getTo());
        for (Map.Entry seriesObject : this.varSeriesObjects.entries()) {
            VarSeries3D series = (VarSeries3D)seriesObject.getKey();
            StructureObject dataObject = (StructureObject)seriesObject.getValue();
            VariableInstance xAxisInstance = (VariableInstance)this.xAxisInstances.get((Object)series, (Object)dataObject);
            VariableInstance yAxisInstance = (VariableInstance)this.yAxisInstances.get((Object)series, (Object)dataObject);
            VariableInstance zAxisInstance = (VariableInstance)this.zAxisInstances.get((Object)series, (Object)dataObject);
            VariableInstance wAxisInstance = (VariableInstance)this.wAxisInstances.get((Object)series, (Object)dataObject);
            IVarValuesCollection xValues = this.loadInstanceValues(xAxisInstance, timeRangeFilter, complexRaster);
            IVarValuesCollection yValues = this.loadInstanceValues(yAxisInstance, timeRangeFilter, complexRaster);
            IVarValuesCollection zValues = this.loadInstanceValues(zAxisInstance, timeRangeFilter, complexRaster);
            IVarValuesCollection wValues = wAxisInstance != null ? this.loadInstanceValues(wAxisInstance, timeRangeFilter, complexRaster) : null;
            ArrayList<XYZItem> points = new ArrayList<XYZItem>(xValues.size());
            MeasuringUnit xAxisValuesMU = xAxisInstance.getVariable().getMeasuringUnit();
            MeasuringUnit yAxisValuesMU = yAxisInstance.getVariable().getMeasuringUnit();
            MeasuringUnit zAxisValuesMU = zAxisInstance.getVariable().getMeasuringUnit();
            MeasuringUnit wAxisValuesMU = wValues != null ? wAxisInstance.getVariable().getMeasuringUnit() : null;
            MeasuringUnit xAxisDisplayMU = this.viewPrefs.getXAxisResultMeasuringUnit();
            MeasuringUnit yAxisDisplayMU = this.viewPrefs.getYAxisResultMeasuringUnit();
            MeasuringUnit zAxisDisplayMU = this.viewPrefs.getZAxisResultMeasuringUnit();
            MeasuringUnit wAxisDisplayMU = wValues != null ? this.viewPrefs.getWAxisResultMeasuringUnit() : null;
            FastIVarValuesArrayIterable arrayIterable = wValues != null ? new FastIVarValuesArrayIterable(new IVarValuesCollection[]{xValues, yValues, zValues, wValues}) : new FastIVarValuesArrayIterable(new IVarValuesCollection[]{xValues, yValues, zValues});
            for (IVarValue[] xyzwValues : arrayIterable) {
                IVarValue xValue = xyzwValues[0];
                IVarValue yValue = xyzwValues[1];
                IVarValue zValue = xyzwValues[2];
                if (!xValue.isValid() || !yValue.isValid() || !zValue.isValid()) continue;
                double wValue = Double.NaN;
                try {
                    switch (this.config.getWAxisType()) {
                        case Time: {
                            wValue = Math.max(Math.max(xValue.getEndTimestamp(), yValue.getEndTimestamp()), zValue.getEndTimestamp());
                            break;
                        }
                        case Variable: {
                            if (wValues != null) {
                                wValue = xyzwValues[3].isValid() ? xyzwValues[3].getValue() : Double.NaN;
                                wValue = wAxisDisplayMU.convert(wValue, wAxisValuesMU);
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
                long timestamp = Math.max(xValue.getEndTimestamp(), Math.max(yValue.getEndTimestamp(), zValue.getEndTimestamp()));
                points.add(new XYZItem(Instant.ofEpochMilli(timestamp), xAxisDisplayMU.convert(xValue.getValue(), xAxisValuesMU), yAxisDisplayMU.convert(yValue.getValue(), yAxisValuesMU), zAxisDisplayMU.convert(zValue.getValue(), zAxisValuesMU), wValue));
            }
            instanceColumns.put(xAxisInstance, new VarValuesColumn(xAxisInstance, xAxisDisplayMU, String.format("%s\r\n%s", series.getLocalTitle(), this.config.getXAxisLocalName()), new Chart3DPrefsDialog.Chart3DAxisWrapper('X', null, this.config.getXAxisColor(), null, null, null).getGraphic(), complexRaster, timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView, xValues));
            instanceColumns.put(yAxisInstance, new VarValuesColumn(yAxisInstance, yAxisDisplayMU, String.format("%s\r\n%s", series.getLocalTitle(), this.config.getYAxisLocalName()), new Chart3DPrefsDialog.Chart3DAxisWrapper('Y', null, this.config.getYAxisColor(), null, null, null).getGraphic(), complexRaster, timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView, yValues));
            instanceColumns.put(zAxisInstance, new VarValuesColumn(zAxisInstance, zAxisDisplayMU, String.format("%s\r\n%s", series.getLocalTitle(), this.config.getZAxisLocalName()), new Chart3DPrefsDialog.Chart3DAxisWrapper('Z', null, this.config.getZAxisColor(), null, null, null).getGraphic(), complexRaster, timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView, zValues));
            if (wAxisInstance != null) {
                instanceColumns.put(wAxisInstance, new VarValuesColumn(wAxisInstance, wAxisDisplayMU, String.format("%s\r\n%s", series.getLocalTitle(), this.config.getWAxisLocalName()), new Chart3DPrefsDialog.Chart3DAxisWrapper('W', null, Color.BLACK, null, null, null).getGraphic(), complexRaster, timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView, wValues));
            }
            chartDrawData.addVarSeriesData(series, dataObject, points);
        }
        Transaction trx = Transactions.begin();
        try {
            for (Map.Entry seriesObject : this.functionSeriesObjects.entries()) {
                FunctionSeries3D series = (FunctionSeries3D)seriesObject.getKey();
                StructureObject dataObject = StructureObjectDAO.get((Transaction)trx, (int)((StructureObject)seriesObject.getValue()).getId());
                XYZFunctionSeries.ZFunction zFunc = null;
                XYZFunctionSeries.WFunction wFunc = null;
                PropertyValue zFunctionPV = dataObject.getPropertyValue(series.getZFunctionProperty());
                if (zFunctionPV != null && zFunctionPV.getValue() != null && !zFunctionPV.getValue().isEmpty()) {
                    try {
                        FormulaNode zFormula = StructureUtils.resolveDependencies((StructureObject)this.getStructureObject(), (FormulaNode)ScriptParser.parseFormula((String)zFunctionPV.getValue()));
                        String xParam = series.getXAxisParameter() != null && !series.getXAxisParameter().isEmpty() ? series.getXAxisParameter().trim() : null;
                        MeasuringUnit xAxisMu = xParam != null ? series.getXAxisMU() : null;
                        String yParam = series.getYAxisParameter() != null && !series.getYAxisParameter().isEmpty() ? series.getYAxisParameter().trim() : null;
                        String zParam = series.getZAxisParameter() != null && !series.getZAxisParameter().isEmpty() ? series.getZAxisParameter().trim() : null;
                        MeasuringUnit yAxisMu = yParam != null ? series.getYAxisMU() : null;
                        MeasuringUnit zAxisMu = series.getZAxisMU();
                        MeasuringUnit wAxisMu = series.getWAxisMU();
                        zFunc = (x, y) -> {
                            try {
                                Double result;
                                HashMap<String, Double> args = new HashMap<String, Double>();
                                if (xParam != null) {
                                    args.put(xParam, xAxisMu.convert(x, this.viewPrefs.getXAxisMeasuringUnit()));
                                }
                                if (yParam != null) {
                                    args.put(yParam, yAxisMu.convert(y, this.viewPrefs.getYAxisMeasuringUnit()));
                                }
                                return (result = FormulaCalculator.calculate((FormulaNode)zFormula, args)) != null && Double.isFinite(result) ? yAxisMu.convert(result.doubleValue(), this.viewPrefs.getYAxisMeasuringUnit()) : Double.NaN;
                            }
                            catch (Exception exception) {
                                return Double.NaN;
                            }
                        };
                        PropertyValue wFunctionPV = dataObject.getPropertyValue(series.getWFunctionProperty());
                        if (wFunctionPV != null && wFunctionPV.getValue() != null && !wFunctionPV.getValue().isEmpty()) {
                            FormulaNode wFormula = StructureUtils.resolveDependencies((StructureObject)this.getStructureObject(), (FormulaNode)ScriptParser.parseFormula((String)wFunctionPV.getValue()));
                            wFunc = (x, y, z) -> {
                                try {
                                    Double result;
                                    HashMap<String, Double> args = new HashMap<String, Double>();
                                    if (xParam != null) {
                                        args.put(xParam, xAxisMu.convert(x, this.viewPrefs.getXAxisMeasuringUnit()));
                                    }
                                    if (yParam != null) {
                                        args.put(yParam, yAxisMu.convert(y, this.viewPrefs.getYAxisMeasuringUnit()));
                                    }
                                    if (zParam != null) {
                                        args.put(zParam, zAxisMu.convert(z, this.viewPrefs.getZAxisMeasuringUnit()));
                                    }
                                    return (result = FormulaCalculator.calculate((FormulaNode)wFormula, args)) != null && Double.isFinite(result) ? wAxisMu.convert(result.doubleValue(), this.viewPrefs.getWAxisMeasuringUnit()) : Double.NaN;
                                }
                                catch (Exception exception) {
                                    return Double.NaN;
                                }
                            };
                        }
                    }
                    catch (StructureTreeSearchException e1) {
                        e1.printStackTrace();
                    }
                }
                if (zFunc == null) continue;
                chartDrawData.addFunctionSeriesCalc(series, dataObject, (Pair<XYZFunctionSeries.ZFunction, XYZFunctionSeries.WFunction>)new Pair(zFunc, wFunc));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.setVarValuesColumns(instanceColumns.values());
        this.loadCharacteristics3dData(chartDrawData);
        return chartDrawData;
    }

    protected void loadCharacteristics3dData(Chart3DDrawData chartDrawData) {
        if (this.characteristic3DInstance != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Transaction trx = Transactions.begin();){
                this.characteristic3DInstance = Characteristic3DInstanceDAO.get((Transaction)trx, (int)this.characteristic3DInstance.getId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (this.selectedFunctionEntry == null) {
                this.selectedFunctionEntry = this.characteristic3DInstance.getFunctions().lastEntry();
            }
        }
        if (this.selectedFunctionEntry != null) {
            chartDrawData.setCharacteristic3dFunctionEntry(this.selectedFunctionEntry);
            return;
        }
    }

    protected void initContextMenu(Chart3DViewSkinBase skin) {
        LinkedList predefinedItems = new LinkedList();
        if (this.getContextMenu() != null && !this.getContextMenu().getItems().isEmpty()) {
            predefinedItems.addAll(this.getContextMenu().getItems());
            this.getContextMenu().getItems().clear();
        }
        XYZChart3D xyzChart = (XYZChart3D)skin.getViewContent();
        ContextMenu contextMenu = xyzChart.getContextMenu();
        MenuItem adjustItem = new MenuItem(Messages.charts_JFreeChartView_Adjust);
        adjustItem.setId("chart.menuitem.adjust");
        adjustItem.setOnAction(e -> {
            try {
                Chart3DViewPrefs prefs = this.config.getId() != null ? this.loadViewPrefs(this.config, this.getStructureObject()) : this.viewPrefs;
                this.updateViewPrefsRaster((IViewPrefs)prefs);
                Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.getTimeRangeFilter().getType().toRawValueViewType(), (Integer)this.getTimeRangeFilter().getCustomViewIndex());
                Chart3DPrefsDialog dialog = new Chart3DPrefsDialog(this.getWindow(), prefs, this.getTimeRangeFilter().getType(), this.getTimeRangeFilter().getCustomViewIndex(), minRaster, this.getFixedRaster() != null);
                dialog.showAndWait().ifPresent(bt -> {
                    if (bt == ButtonType.OK) {
                        this.loadData(prefs, () -> {
                            if (this.config.getId() != null) {
                                dialog.persist();
                            }
                        }, true);
                    }
                });
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        MenuItem refreshItem = new MenuItem(Messages.charts_JFreeChartView_Refresh, (Node)new ImageView(Icons.REFRESH_ITEM_URL.toString()));
        refreshItem.setId("chart.menuitem.refresh");
        refreshItem.setOnAction(e -> {
            Future<?> future = this.reloadData();
        });
        MenuItem clearViewPreferencesItem = new MenuItem(Messages.charts_JFreeChartView_Clear_Preferences);
        clearViewPreferencesItem.setId("chart.menuitem.clearpreferences");
        clearViewPreferencesItem.setOnAction(e -> {
            CheckBoxDialog dialog = new CheckBoxDialog(false);
            dialog.initOwner(this.getScene().getWindow());
            dialog.setContentText(Messages.charts_JFreeChartView_Clear_preferences_at_similar_charts);
            dialog.showAndWait().ifPresent(result -> {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        if (result.booleanValue()) {
                            Chart3DViewPrefsDAO.delete((Transaction)trx, (Chart3D)this.config);
                        } else {
                            Chart3DViewPrefsDAO.delete((Transaction)trx, (Chart3D)this.config, (StructureObject)this.getStructureObject());
                        }
                        Transactions.commitSync((Transaction)trx);
                        this.viewPrefs = null;
                        this.reloadData();
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.setContentText(Messages.charts_JFreeChartView_ErrorClearingViewPerspective);
                        dlg.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            });
        });
        CheckMenuItem show2DViewItem = new CheckMenuItem(Messages.charts_Chart3DView_show2DViewMenuItem);
        show2DViewItem.selectedProperty().bindBidirectional((Property)this.show2DView);
        contextMenu.getItems().addAll((Object[])new MenuItem[]{adjustItem, refreshItem, show2DViewItem, clearViewPreferencesItem});
        CheckMenuItem invertYAxisItem = new CheckMenuItem(Messages.charts_Chart3DView_invertYAxis);
        invertYAxisItem.selectedProperty().bindBidirectional((Property)this.config.yAxisInvertedProperty());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), invertYAxisItem});
        if (this.config.getWAxisType() == Chart3DWAxisType.Variable) {
            CheckMenuItem swapZWAxesItem = new CheckMenuItem(Messages.charts_Chart3DView_swapZWAxes);
            swapZWAxesItem.selectedProperty().bindBidirectional((Property)this.swapZWAxesProperty());
            contextMenu.getItems().add((Object)swapZWAxesItem);
        }
        if (this.getConfig().getCharacteristic3DSeries() != null) {
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.initContextMenuCharacteristics(skin);
        }
        if (!predefinedItems.isEmpty()) {
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
            contextMenu.getItems().addAll(predefinedItems);
        }
    }

    private void initContextMenuCharacteristics(Chart3DViewSkinBase skin) {
        XYZChart3D xyzChart = (XYZChart3D)skin.getViewContent();
        ContextMenu contextMenu = xyzChart.getContextMenu();
        Menu characteristicMenu = new Menu(this.getConfig().getCharacteristic3DSeries().getResultTitle(), (Node)new ImageView(Characteristic3D.DEFAULT_ICON.toString()));
        characteristicMenu.getItems().add((Object)new MenuItem("<empty>"));
        characteristicMenu.setOnShowing(e -> {
            characteristicMenu.getItems().clear();
            Boolean someFunctionIsSelected = false;
            TreeSet<Instant> beginTimestamps = new TreeSet<Instant>(this.getCharacteristic3dInstance().getFunctionsBeginTimestamps());
            for (Instant beginTs : beginTimestamps) {
                Instant nextBeginTs = beginTimestamps.ceiling(beginTs.plusNanos(1L));
                String text = nextBeginTs != null ? String.format(Messages.chart_addons_Characteristic2DAddon_curvetimerange, TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(beginTs, ZoneId.systemDefault())), TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(nextBeginTs, ZoneId.systemDefault()))) : String.format(Messages.chart_addons_Characteristic2DAddon_curvefrom, TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(beginTs, ZoneId.systemDefault())));
                CheckMenuItem item = new CheckMenuItem(text, (Node)new ImageView(Characteristic2DInstance.ENABLED_ICON.toString()));
                if (beginTs.equals(this.selectedFunctionEntry.getKey())) {
                    item.setSelected(true);
                    someFunctionIsSelected = true;
                } else {
                    item.setOnAction(event -> {
                        this.selectedFunctionEntry = this.getCharacteristic3dInstance().getFunctions().floorEntry((Object)beginTs);
                        this.reloadData();
                    });
                }
                characteristicMenu.getItems().add((Object)item);
            }
            if (someFunctionIsSelected.booleanValue()) {
                characteristicMenu.getItems().add((Object)new SeparatorMenuItem());
                if (this.getCharacteristic3dInstance().getFunctionsBeginTimestamps().size() > 1) {
                    MenuItem compareMenuItem = new MenuItem(Messages.charts_Chart3DView_compareCharacteristics);
                    compareMenuItem.setOnAction(e1 -> this.handleCompareCharacteristics());
                    characteristicMenu.getItems().add((Object)compareMenuItem);
                }
                characteristicMenu.getItems().add((Object)new SeparatorMenuItem());
                Instant characteristicReferenceTimestamp = this.selectedFunctionEntry.getKey();
                MenuItem changeTimestampItem = new MenuItem(Messages.chart_addons_Characteristic2DAddon_changebegin);
                characteristicMenu.getItems().add((Object)changeTimestampItem);
                changeTimestampItem.setOnAction(event -> {
                    Instant selectedTs = this.getUserSelectedInstantFromDialog(characteristicReferenceTimestamp);
                    if (selectedTs != null) {
                        Characteristic3DFunction selectedFunction = this.selectedFunctionEntry.getValue();
                        this.addCharacteristicCurveChange(new Characteristic3DFunctionChange(characteristicReferenceTimestamp, selectedTs, selectedFunction));
                        this.getCharacteristic3dInstance().removeFunction(characteristicReferenceTimestamp);
                        Characteristic3DFunctions functions = this.characteristic3DInstance.getFunctions();
                        for (Map.Entry item : functions.entrySet()) {
                            if (item.getKey() != selectedTs) continue;
                            this.selectedFunctionEntry = item;
                            break;
                        }
                    }
                });
                MenuItem removeItem = new MenuItem(Messages.chart_addons_Characteristic2DAddon_removecurve);
                characteristicMenu.getItems().add((Object)removeItem);
                removeItem.setOnAction(event -> {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.initOwner(this.getScene().getWindow());
                    alert.setContentText(Messages.chart_addons_Characteristic2DAddon_removeAlertText);
                    if (alert.showAndWait().get() == ButtonType.OK) {
                        this.addCharacteristicCurveChange(new Characteristic3DFunctionChange(characteristicReferenceTimestamp, null, null));
                        this.getCharacteristic3dInstance().removeFunction(characteristicReferenceTimestamp);
                        Instant nextTimestamp = this.getCharacteristic3dInstance().getFunctionsBeginTimestamps().stream().filter(ts -> ts.isAfter(characteristicReferenceTimestamp)).findFirst().orElse(null);
                        Characteristic3DFunctions functions = this.characteristic3DInstance.getFunctions();
                        this.selectedFunctionEntry = null;
                        for (Map.Entry item : functions.entrySet()) {
                            if (item.getKey() != nextTimestamp) continue;
                            this.selectedFunctionEntry = item;
                            break;
                        }
                        if (this.selectedFunctionEntry == null) {
                            this.selectedFunctionEntry = this.getCharacteristic3dInstance().getFunctions().lastEntry();
                        }
                        this.drawData.setCharacteristic3dFunctionEntry(this.selectedFunctionEntry);
                        skin.draw(this.drawData);
                    }
                });
            }
            if (characteristicMenu.getItems().size() == 0) {
                characteristicMenu.getItems().add((Object)new MenuItem("<empty>"));
            }
        });
        contextMenu.getItems().add((Object)characteristicMenu);
        ImageView playIcon = new ImageView(Resources.getResourceUrl((String)"/icons/16x16/", (String)"application/brain.svg").toString());
        ImageView stopIcon = new ImageView(Resources.getResourceUrl((String)"/icons/svg/", (String)"ewms/stop.svg").toString());
        ImageView cancelIcon = new ImageView(Resources.getResourceUrl((String)"/icons/16x16/", (String)"application/cancel.png").toString());
        if (this.aiProvider != null) {
            this.menuItemDismissCurve = new MenuItem(Messages.charts_Chart3DView_dismissCharacteristic, (Node)cancelIcon);
            this.menuItemStartStopCurve = new MenuItem(Messages.charts_Chart3DView_learn_characteristic, (Node)playIcon);
            this.menuItemDismissCurve.setVisible(false);
            this.menuItemStartStopCurve.setOnAction(arg_0 -> this.lambda$20(skin, (Node)stopIcon, (Node)playIcon, arg_0));
            this.menuItemDismissCurve.setOnAction(e -> {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.initOwner(this.getScene().getWindow());
                alert.setContentText(Messages.chart_addons_Characteristic2DAddon_removeAlertText);
                if (alert.showAndWait().get() == ButtonType.OK) {
                    this.removeCurrentCurveLearningVisualisation();
                    this.clearCharacteristicFunctionChanges(true);
                }
            });
            contextMenu.getItems().addAll((Object[])new MenuItem[]{this.menuItemStartStopCurve, this.menuItemDismissCurve});
        }
    }

    private boolean learnCurveStart(Chart3DViewSkinBase skin) {
        double maxW;
        double minW;
        XYZChart3D xyzChart = (XYZChart3D)skin.getViewContent();
        LinkedList<XYZItemSeries> itemSeries = new LinkedList<XYZItemSeries>();
        for (XYZSeries series : xyzChart.getSeriesList()) {
            if (!(series instanceof XYZItemSeries)) continue;
            itemSeries.add((XYZItemSeries)series);
        }
        if (itemSeries.isEmpty()) {
            return false;
        }
        LearnCurveDialog dialog = new LearnCurveDialog(this.getScene(), itemSeries);
        XYZItemSeries firstSeries = dialog.showAndWait().orElse(null);
        if (firstSeries == null) {
            return false;
        }
        int numHiddenNodes = dialog.getNumHiddenNodes();
        int numHiddenLayers = dialog.getNumHiddenLayers();
        int xAxisResolution = dialog.getXAxisResolution();
        int yAxisResolution = dialog.getYAxisResolution();
        double learningRate = dialog.getLearingRate();
        ArrayList originalSeries = new ArrayList(xyzChart.getSeriesList());
        originalSeries.removeAll(this.functionSeriesKI);
        if (dialog.isRemovePreviousFunctions()) {
            this.removeFunctionCalculationRendering(skin);
        }
        MeasuringUnit xAxisDrawMU = this.getViewPrefs().getXAxisResultMeasuringUnit();
        MeasuringUnit yAxisDrawMU = this.getViewPrefs().getYAxisResultMeasuringUnit();
        MeasuringUnit zAxisDrawMU = this.getViewPrefs().getZAxisResultMeasuringUnit();
        MeasuringUnit wAxisDrawMU = this.getViewPrefs().getWAxisResultMeasuringUnit();
        Characteristic3D characteristic = this.getConfig().getCharacteristic3DSeries().getCharacteristic();
        MeasuringUnit inputXAxisMU = characteristic.getInputXAxisMeasuringUnit();
        MeasuringUnit inputYAxisMU = characteristic.getInputYAxisMeasuringUnit();
        MeasuringUnit outputZAxisMU = characteristic.getOutputZAxisMeasuringUnit();
        MeasuringUnit outputWAxisMU = characteristic.getOutputWAxisMeasuringUnit();
        double minXDraw = xyzChart.getDataViewRange().getMinX();
        double maxXDraw = xyzChart.getDataViewRange().getMaxX();
        double minX = inputXAxisMU.convert(minXDraw, xAxisDrawMU);
        double maxX = inputXAxisMU.convert(maxXDraw, xAxisDrawMU);
        double minYDraw = xyzChart.getDataViewRange().getMinY();
        double maxYDraw = xyzChart.getDataViewRange().getMaxY();
        double minY = inputYAxisMU.convert(minYDraw, yAxisDrawMU);
        double maxY = inputYAxisMU.convert(maxYDraw, yAxisDrawMU);
        double minZDraw = xyzChart.getDataViewRange().getMinZ();
        double maxZDraw = xyzChart.getDataViewRange().getMaxZ();
        double minZ = outputZAxisMU.convert(minZDraw, zAxisDrawMU);
        double maxZ = outputZAxisMU.convert(maxZDraw, zAxisDrawMU);
        double minWDraw = xyzChart.getDataViewRange().getMinW();
        double maxWDraw = xyzChart.getDataViewRange().getMaxW();
        if (outputWAxisMU != null) {
            minW = outputWAxisMU.convert(minWDraw, wAxisDrawMU);
            maxW = outputWAxisMU.convert(maxWDraw, wAxisDrawMU);
        } else {
            maxW = Double.NaN;
            minW = Double.NaN;
        }
        List innerItems = firstSeries.getItems().stream().filter(i -> xyzChart.getDataViewRange().contains(i)).collect(Collectors.toList());
        int size = innerItems.size();
        boolean hasW = outputWAxisMU != null;
        double[] xs = new double[size];
        double[] ys = new double[size];
        double[] zs = new double[size];
        double[] ws = hasW ? new double[size] : null;
        int i2 = 0;
        for (XYZItem item : innerItems) {
            if (!Double.isFinite(item.getX()) || !Double.isFinite(item.getY()) || !Double.isFinite(item.getZ()) || hasW && !Double.isFinite(item.getW())) continue;
            double itemX = inputXAxisMU.convert(item.getX(), xAxisDrawMU);
            double itemY = inputYAxisMU.convert(item.getY(), yAxisDrawMU);
            double itemZ = outputZAxisMU.convert(item.getZ(), zAxisDrawMU);
            xs[i2] = ((itemX - minX) / (maxX - minX) - 0.5) * 2.0;
            ys[i2] = ((itemY - minY) / (maxY - minY) - 0.5) * 2.0;
            zs[i2] = ((itemZ - minZ) / (maxZ - minZ) - 0.5) * 2.0;
            if (hasW) {
                double itemW = outputWAxisMU.convert(item.getW(), wAxisDrawMU);
                ws[i2] = ((itemW - minW) / (maxW - minW) - 0.5) * 2.0;
            }
            ++i2;
        }
        double[][] inputs = new double[][]{Arrays.copyOf(xs, i2), Arrays.copyOf(ys, i2)};
        double[][] outputs = new double[hasW ? 2 : 1][];
        outputs[0] = Arrays.copyOf(zs, i2);
        if (hasW) {
            outputs[1] = Arrays.copyOf(ws, i2);
        }
        this.isLearning = true;
        new Thread(() -> {
            AINetworkParams aiNetworkParams = new AINetworkParams(inputs, outputs, numHiddenNodes, numHiddenLayers, learningRate);
            AINetworkModel model = this.aiProvider.createModel(aiNetworkParams);
            model.init();
            TrainingListener tl = (tlmodel, iteration, epoch) -> {
                double score = tlmodel.getScore();
                String infoText = String.format(Messages.charts_Chart3DView_ai_stats, iteration, NumberFormats.getOptimalFormat((double)score).format(score));
                Platform.runLater(() -> this.setInfoLabelText(infoText));
            };
            model.setTrainingListener(new TrainingListener[]{tl});
            this.kiSeries = null;
            Color kiSeriesColor = Color.GRAY;
            Characteristic3DFunction characteristicFunction = new Characteristic3DFunction(inputXAxisMU, inputYAxisMU, outputZAxisMU, outputWAxisMU, minX, maxX, minY, maxY, xAxisResolution, yAxisResolution, null);
            int nEpochs = 300000;
            long ts = System.nanoTime();
            int epoch2 = 0;
            while (epoch2 < nEpochs) {
                if (!this.isLearning) break;
                model.fit();
                long duration = (System.nanoTime() - ts) / 1000000L;
                if (epoch2 == 1 || duration > 500L) {
                    if (this.kiSeries == null) {
                        String title = String.format("%s (%s)", Messages.charts_Chart3DView_ai, firstSeries.getName());
                        this.kiSeries = new XYZKIAreaSeries(title, this.getViewPrefs(), characteristicFunction);
                        this.kiSeries.setBaseColor(kiSeriesColor);
                        this.functionSeriesKI.add(this.kiSeries);
                        ArrayList<XYZAreaSeries> allSeries = new ArrayList<XYZAreaSeries>(originalSeries);
                        allSeries.addAll(this.functionSeriesKI);
                        try {
                            FXUtils.runAndWait(() -> {
                                xyzChart.getSeriesList().setAll((Collection)allSeries);
                                this.onEpochEvent();
                            });
                        }
                        catch (InterruptedException | ExecutionException e1) {
                            e1.printStackTrace();
                        }
                    }
                    Chart3DView.updateCharacteristic3D(characteristicFunction, model, minZ, maxZ, minW, maxW);
                    try {
                        FXUtils.runAndWait(() -> this.kiSeries.update());
                    }
                    catch (InterruptedException | ExecutionException e1) {
                        e1.printStackTrace();
                    }
                    ts = System.nanoTime();
                }
                ++epoch2;
            }
        }).start();
        return true;
    }

    private void handleLearnCurveStop(Chart3DViewSkinBase skin) {
        this.isLearning = false;
        this.menuItemStartStopCurve.setVisible(false);
        for (XYZAreaSeries functionSeries : this.functionSeriesKI) {
            XYZKIAreaSeries kiSeries = (XYZKIAreaSeries)functionSeries;
            Characteristic3DFunction c3dF = kiSeries.getCharacteristic();
            this.addCharacteristicCurveChange(new Characteristic3DFunctionChange(null, null, c3dF));
        }
    }

    private void handleCompareCharacteristics() {
        Instant selectedBeginTs = this.selectedFunctionEntry.getKey();
        TreeSet<Instant> beginTimestamps = new TreeSet<Instant>(this.getCharacteristic3dInstance().getFunctionsBeginTimestamps());
        LinkedList<CompareCharacteristic3DDialog.C3DFunctionEntry> selectEntrys = new LinkedList<CompareCharacteristic3DDialog.C3DFunctionEntry>();
        for (Instant fromTs : beginTimestamps) {
            if (selectedBeginTs.equals(fromTs)) continue;
            Instant toTs = beginTimestamps.ceiling(fromTs.plusNanos(1L));
            selectEntrys.add(new CompareCharacteristic3DDialog.C3DFunctionEntry(fromTs, toTs));
        }
        CompareCharacteristic3DDialog dlg = new CompareCharacteristic3DDialog(this.getScene(), selectEntrys);
        dlg.showAndWait().ifPresent(btn -> {
            if (btn == ButtonType.OK) {
                Instant masterTs = selectedBeginTs;
                Instant slaveTs = dlg.getSelectedEntry().getFrom();
                XYZChart3DViewSkin skin = (XYZChart3DViewSkin)this.getSkin();
                XYZChart3D chart3d = skin.getXYZChart();
                CompareCharacteristic3DChart chart = new CompareCharacteristic3DChart(this.getConfig().getCharacteristic3DSeries().getResultTitle(), chart3d.getAxes(), masterTs, this.selectedFunctionEntry.getValue(), slaveTs, this.getCharacteristic3dInstance().getFunction(slaveTs), this.getViewPrefs().getXAxisResultMeasuringUnit(), this.getViewPrefs().getYAxisResultMeasuringUnit(), this.getViewPrefs().getZAxisResultMeasuringUnit(), this.getViewPrefs().getWAxisResultMeasuringUnit(), dlg.isRelativeComparsion(), dlg.isCompareWAxisValues());
                this.partService.showPart(false, (Node)chart);
            }
        });
    }

    private void drawFunctionEntry(Transaction trx, Instant newTs) {
        Chart3DViewSkinBase skin = (Chart3DViewSkinBase)this.getSkin();
        this.selectedFunctionEntry = this.characteristic3DInstance.getFunctions().floorEntry((Object)newTs);
        this.drawData.setCharacteristic3dFunctionEntry(this.selectedFunctionEntry);
        skin.draw(this.drawData);
    }

    private void removeCurrentCurveLearningVisualisation() {
        Chart3DViewSkinBase skin = (Chart3DViewSkinBase)this.getSkin();
        this.removeFunctionCalculationRendering(skin);
        this.menuItemDismissCurve.setVisible(false);
        this.menuItemStartStopCurve.setVisible(true);
    }

    private void removeFunctionCalculationRendering(Chart3DViewSkinBase skin) {
        try {
            FXUtils.runAndWait(() -> {
                Chart3DView chart3DView = this;
                synchronized (chart3DView) {
                    XYZChart3D xyzChart = (XYZChart3D)skin.getViewContent();
                    ArrayList originalSeries = new ArrayList(xyzChart.getSeriesList());
                    originalSeries.removeAll(this.functionSeriesKI);
                    this.functionSeriesKI.clear();
                    xyzChart.getSeriesList().setAll(originalSeries);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void onEpochEvent() {
        this.menuItemStartStopCurve.setVisible(true);
    }

    private static void updateCharacteristic3D(Characteristic3DFunction characteristic, AINetworkModel model, double minZ, double maxZ, double minW, double maxW) {
        boolean hasW = characteristic.getWAxisMU() != null;
        double minX = characteristic.getMinX();
        double maxX = characteristic.getMaxX();
        double minY = characteristic.getMinY();
        double maxY = characteristic.getMaxY();
        double[] xs = characteristic.getXValues();
        double[] ys = characteristic.getYValues();
        double[] xsp = new double[xs.length * ys.length];
        double[] ysp = new double[xs.length * ys.length];
        int p = 0;
        int x = 0;
        while (x < xs.length) {
            int y = 0;
            while (y < ys.length) {
                xsp[p] = ((xs[x] - minX) / (maxX - minX) - 0.5) * 2.0;
                ysp[p] = ((ys[y] - minY) / (maxY - minY) - 0.5) * 2.0;
                ++p;
                ++y;
            }
            ++x;
        }
        double[][] input = new double[][]{xsp, ysp};
        double[][] output = model.getOutput((double[][])input);
        double[][] zValues = new double[xs.length][ys.length];
        double[][] wValues = hasW ? new double[xs.length][ys.length] : null;
        p = 0;
        int x2 = 0;
        while (x2 < xs.length) {
            int y = 0;
            while (y < ys.length) {
                zValues[x2][y] = (output[0][p] / 2.0 + 0.5) * (maxZ - minZ) + minZ;
                if (hasW) {
                    wValues[x2][y] = (output[1][p] / 2.0 + 0.5) * (maxW - minW) + minW;
                }
                ++p;
                ++y;
            }
            ++x2;
        }
        characteristic.setZValues(zValues);
        if (hasW) {
            characteristic.setWValues(wValues);
        }
    }

    private Instant getUserSelectedInstantFromDialog() {
        return this.getUserSelectedInstantFromDialog(Instant.now());
    }

    private Instant getUserSelectedInstantFromDialog(Instant preselectedTimestamp) {
        try {
            return (Instant)FXUtils.runAndWait(() -> {
                Set forbiddenTimestamps = this.getCharacteristic3dInstance().getFunctionsBeginTimestamps();
                CharacteristicCurveBeginTimestampDialog timestampDialog = new CharacteristicCurveBeginTimestampDialog(this.getScene().getWindow(), forbiddenTimestamps, preselectedTimestamp, this.getTimeRangeFilter());
                if (timestampDialog.showAndWait().get() == ButtonType.OK) {
                    return timestampDialog.getBegin();
                }
                return null;
            });
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void linkNewFunctionToInstanceWithGivenTs(Instant newTs) throws DAOOperationException {
        for (Characteristic3DFunctionChange change : this.characteristicFunctionChanges) {
            if (!change.isWithoutTimes()) continue;
            change.setNewBegin(newTs);
            Instant roundedTs = Instant.ofEpochMilli(newTs.toEpochMilli());
            this.characteristic3DInstance.putFunction(roundedTs, change.getFunction());
            return;
        }
    }

    private Instant ifAvailableAddNewGeneratedCurveToChanges() throws DAOOperationException {
        long unsetNewTsCount = this.characteristicFunctionChanges.stream().filter(c -> c.isWithoutTimes()).count();
        if (unsetNewTsCount == 0L) {
            return null;
        }
        if (unsetNewTsCount > 1L) {
            String message = Messages.charts_Chart3DView_moreThanOneCharacteristicError;
            throw new DAOOperationException(new OperationResult(ResultType.UnexprectedError, message));
        }
        Instant chosenTimestamp = null;
        try {
            chosenTimestamp = this.getUserSelectedInstantFromDialog();
        }
        catch (Exception e) {
            throw new DAOOperationException(new OperationResult(ResultType.UnexprectedError, e.getMessage()));
        }
        if (chosenTimestamp == null) {
            String message = Messages.charts_Chart3DView_noEndTSError;
            throw new DAOOperationException(new OperationResult(ResultType.ExpectedError, message));
        }
        this.linkNewFunctionToInstanceWithGivenTs(chosenTimestamp);
        return chosenTimestamp;
    }

    public void currentCharacteristicCurveChanged() {
        if (this.selectedFunctionEntry != null) {
            this.addCharacteristicCurveChange(new Characteristic3DFunctionChange(null, this.selectedFunctionEntry.getKey(), this.selectedFunctionEntry.getValue()));
        } else {
            for (XYZAreaSeries functionSeries : this.functionSeriesKI) {
                XYZKIAreaSeries kiSeries = (XYZKIAreaSeries)functionSeries;
                Characteristic3DFunction c3dF = kiSeries.getCharacteristic();
                this.addCharacteristicCurveChange(new Characteristic3DFunctionChange(null, null, c3dF));
            }
        }
    }

    public void addCharacteristicCurveChange(Characteristic3DFunctionChange change) {
        int i = 0;
        while (i < this.characteristicFunctionChanges.size()) {
            Characteristic3DFunctionChange oldChange = (Characteristic3DFunctionChange)this.characteristicFunctionChanges.get(i);
            if (change.getOldBegin() == null && change.getNewBegin() == null && oldChange.getOldBegin() == null && oldChange.getNewBegin() == null && change.getFunction() != null) {
                this.characteristicFunctionChanges.set(i, (Object)change);
                return;
            }
            if (oldChange.getNewBegin() != null && oldChange.getNewBegin().equals(change.getNewBegin())) {
                this.characteristicFunctionChanges.set(i, (Object)change);
                if (change.getFunction() != null) {
                    this.characteristic3DInstance.putFunction(change.getNewBegin(), change.getFunction());
                } else {
                    this.characteristic3DInstance.removeFunction(oldChange.getNewBegin());
                }
                return;
            }
            ++i;
        }
        this.characteristicFunctionChanges.add((Object)change);
        if (change.getNewBegin() == null) {
            return;
        }
        if (change.getFunction() != null) {
            this.characteristic3DInstance.putFunction(change.getNewBegin(), change.getFunction());
        } else {
            this.characteristic3DInstance.removeFunction(change.getOldBegin());
        }
    }

    public final BooleanProperty show2DViewProperty() {
        return this.show2DView;
    }

    public final boolean isShow2DView() {
        return this.show2DViewProperty().get();
    }

    public final void setShow2DView(boolean show2DView) {
        this.show2DViewProperty().set(show2DView);
    }

    public final BooleanProperty swapZWAxesProperty() {
        return this.swapZWAxes;
    }

    public final boolean isSwapZWAxes() {
        return this.swapZWAxesProperty().get();
    }

    public final void setSwapZWAxes(boolean swapZWAxes) {
        this.swapZWAxesProperty().set(swapZWAxes);
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    public void saveChanges(Transaction trx) throws DAOOperationException {
        if (this.characteristic3DInstance != null && !this.characteristicFunctionChanges.isEmpty()) {
            Instant newTs = this.ifAvailableAddNewGeneratedCurveToChanges();
            Characteristic3DInstanceDAO.applyCurveValuesChanges((Transaction)trx, (Characteristic3DInstance)this.characteristic3DInstance, (Characteristic3DFunctionChange[])((Characteristic3DFunctionChange[])this.characteristicFunctionChanges.toArray((Object[])new Characteristic3DFunctionChange[0])));
            if (newTs != null) {
                try {
                    FXUtils.runAndWait(() -> {
                        Chart3DView chart3DView = this;
                        synchronized (chart3DView) {
                            this.removeCurrentCurveLearningVisualisation();
                            this.drawFunctionEntry(trx, newTs);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void clearCharacteristicFunctionChanges() {
        this.clearCharacteristicFunctionChanges(false);
    }

    public void clearCharacteristicFunctionChanges(Boolean removeOnlyThoseWithoutTimes) {
        if (!removeOnlyThoseWithoutTimes.booleanValue()) {
            this.characteristicFunctionChanges.clear();
            return;
        }
        ArrayList<Characteristic3DFunctionChange> changesWithoutTimes = new ArrayList<Characteristic3DFunctionChange>();
        for (Characteristic3DFunctionChange change : this.characteristicFunctionChanges) {
            if (!change.isWithoutTimes()) continue;
            changesWithoutTimes.add(change);
        }
        for (Characteristic3DFunctionChange change : changesWithoutTimes) {
            this.characteristicFunctionChanges.remove((Object)change);
        }
    }

    private IVarValuesCollection loadInstanceValues(VariableInstance instance, ITimeRangeFilter timeRangeFilter, ComplexRaster complexRaster) {
        return VariableInstanceDAO.getVarValues((VariableInstance)instance, (ITimeRangeFilter)timeRangeFilter, (ComplexRaster)complexRaster);
    }

    @Override
    public void selectData(Instant atTimestamp, Object o) {
        if (this.getViewPrefs() == null) {
            return;
        }
        ComplexRaster raster = this.getViewPrefs().getComplexRaster();
        Instant to = raster.getRasterEnd(atTimestamp);
        Instant from = raster.getRasterBegin(to);
        ((Chart3DViewSkinBase)this.getSkin()).selectItems(from, to);
    }

    public String toString() {
        if (this.config.getLocalTitle() == null) {
            return this.getStructureObject().toString();
        }
        if (this.config.getLocalTitle().contains("{object}")) {
            return this.config.getLocalTitle().replaceAll("\\{object\\}", this.getStructureObject().toString());
        }
        return String.format("%s (%s)", this.config.getLocalTitle(), this.getStructureObject());
    }

    public static Chart3DView create(IEclipseContext chartContext) {
        Chart3DView chart3DView = (Chart3DView)ContextInjectionFactory.make(Chart3DView.class, (IEclipseContext)chartContext);
        return chart3DView;
    }

    private /* synthetic */ void lambda$20(Chart3DViewSkinBase chart3DViewSkinBase, Node node, Node node2, ActionEvent e) {
        boolean bl = this.isLearning = !this.isLearning;
        if (this.isLearning) {
            if (!this.learnCurveStart(chart3DViewSkinBase)) {
                this.isLearning = false;
                return;
            }
            this.menuItemStartStopCurve.setVisible(false);
        } else {
            this.handleLearnCurveStop(chart3DViewSkinBase);
        }
        this.menuItemDismissCurve.setVisible(!this.isLearning);
        this.menuItemStartStopCurve.setText(this.isLearning ? Messages.charts_Chart3DView_stoplearn_characteristic : Messages.charts_Chart3DView_learn_characteristic);
        this.menuItemStartStopCurve.setGraphic(this.isLearning ? node : node2);
    }

    public static class XYZKIAreaSeries
    extends XYZAreaSeries {
        private final Characteristic3DFunction characteristic;
        private final MeasuringUnit xAxisDisplayMU;
        private final MeasuringUnit yAxisDisplayMU;
        private final MeasuringUnit zAxisDisplayMU;
        private final MeasuringUnit wAxisDisplayMU;

        public XYZKIAreaSeries(String name, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU, Characteristic3DFunction characteristic) {
            super(name);
            this.setOpacityFactor(0.7);
            this.characteristic = characteristic;
            this.xAxisDisplayMU = xAxisMU;
            this.yAxisDisplayMU = yAxisMU;
            this.zAxisDisplayMU = zAxisMU;
            this.wAxisDisplayMU = wAxisMU;
        }

        public XYZKIAreaSeries(String name, Chart3DViewPrefs viewPrefs, Characteristic3DFunction characteristic) {
            this(name, viewPrefs.getXAxisResultMeasuringUnit(), viewPrefs.getYAxisResultMeasuringUnit(), viewPrefs.getZAxisResultMeasuringUnit(), viewPrefs.getWAxisResultMeasuringUnit(), characteristic);
        }

        public double[][][] getZW(double[] xs, double[] ys) {
            boolean hasW = this.hasW();
            double[][][] result = new double[xs.length][ys.length][hasW ? 2 : 1];
            int x = 0;
            while (x < xs.length) {
                int y = 0;
                while (y < ys.length) {
                    result[x][y][0] = this.characteristic.getZValue(this.xAxisDisplayMU, xs[x], this.yAxisDisplayMU, ys[y], this.zAxisDisplayMU);
                    if (hasW) {
                        result[x][y][1] = this.characteristic.getWValue(this.xAxisDisplayMU, xs[x], this.yAxisDisplayMU, ys[y], this.wAxisDisplayMU);
                    }
                    ++y;
                }
                ++x;
            }
            return result;
        }

        public boolean hasW() {
            return this.characteristic.getWAxisMU() != null;
        }

        public Characteristic3DFunction getCharacteristic() {
            return this.characteristic;
        }

        public XYAreaBounds getXYAreaBounds() {
            return this.characteristic.getXYBounds(this.xAxisDisplayMU, this.yAxisDisplayMU);
        }

        public void setXYAreaBounds(XYAreaBounds polygon) {
            this.characteristic.setXYBounds(polygon, this.xAxisDisplayMU, this.yAxisDisplayMU);
        }

        public XYZDataViewRange getDataViewRange() {
            double minX = this.characteristic.getMinValidX(this.xAxisDisplayMU);
            double maxX = this.characteristic.getMaxValidX(this.xAxisDisplayMU);
            double minY = this.characteristic.getMinValidY(this.yAxisDisplayMU);
            double maxY = this.characteristic.getMaxValidY(this.yAxisDisplayMU);
            double minZ = this.characteristic.getMinValidZ(this.zAxisDisplayMU);
            double maxZ = this.characteristic.getMaxValidZ(this.zAxisDisplayMU);
            double minW = Double.NaN;
            double maxW = Double.NaN;
            if (this.hasW()) {
                minW = this.characteristic.getMinValidW(this.wAxisDisplayMU);
                maxW = this.characteristic.getMaxValidW(this.wAxisDisplayMU);
            }
            return new XYZDataViewRange(minX, maxX, minY, maxY, minZ, maxZ, minW, maxW);
        }

        public void modifySurface(AreaSurfaceEditMode editMode, Point2D initialPoint, Point2D editPoint, double xRadius, double yRadius, double zAmplitude, double wAmplitude) {
            this.characteristic.modifyZWValues(editMode, initialPoint, editPoint, xRadius, yRadius, zAmplitude, wAmplitude, this.xAxisDisplayMU, this.yAxisDisplayMU, this.zAxisDisplayMU, this.wAxisDisplayMU);
        }
    }
}

