/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.viewprefs.Chart2DViewPrefsDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.ChartPrefsHelper;
import de.elpro.ewms.core.fx.internal.ComplexRasterDescriptor;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.cells.editable.DoubleFieldTableCell;
import de.elpro.ui.fx.cells.editable.DynamicComboBoxTableCell;
import de.elpro.ui.fx.cells.editable.IntegerFieldTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.cells.uimodel.dnd.DnDUIModelTableCell;
import de.elpro.ui.fx.controls.IntermediateCheckBox;
import de.elpro.ui.fx.dialogs.ColorPickerDialog;
import de.elpro.ui.fx.utils.FXUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class ChartPrefsDialog
extends Dialog<ButtonType> {
    private final Chart2DViewPrefs chartViewPrefs;
    private final ObservableList<Series2DViewPrefs> seriesViewPreferences = FXCollections.observableArrayList();
    private final ObservableList<AxisViewPrefs> axisViewPreferences = FXCollections.observableArrayList();
    private final SimpleBooleanProperty copyPreferencesProperty = new SimpleBooleanProperty(false);
    private final ArrayList<Series2DViewPrefs> seriesViewHistory = new ArrayList();
    private final Raster minRaster;
    private final TimeRangeFilterType timeRangeFilterType;
    private final Integer custoViewIndex;
    private final SimpleObjectProperty<Boolean> rowsEnabled = new SimpleObjectProperty();
    private StringConverter<LineType> lineTypeConverter = new StringConverter<LineType>(){

        public String toString(LineType object) {
            if (object == null || object == LineType.None) {
                return null;
            }
            return object.toString();
        }

        public LineType fromString(String string) {
            return null;
        }
    };
    private StringConverter<ShapeType> shapeTypeConverter = new StringConverter<ShapeType>(){

        public String toString(ShapeType object) {
            if (object == null || object == ShapeType.None) {
                return null;
            }
            return object.toString();
        }

        public ShapeType fromString(String string) {
            return null;
        }
    };

    public ChartPrefsDialog(Window window, Chart2DViewPrefs chartViewPrefs, Map<VarSeries2D, VariableInstance[]> seriesInstances, TimeRangeFilterType timeRangeFilterType, Integer customViewIndex, Raster minRaster, boolean fixedRaster) {
        this.chartViewPrefs = chartViewPrefs;
        this.timeRangeFilterType = timeRangeFilterType;
        this.custoViewIndex = customViewIndex;
        this.minRaster = minRaster;
        this.seriesViewPreferences.addAll((Collection)chartViewPrefs.getSeriesViewPrefs());
        this.seriesViewHistory.addAll((Collection<Series2DViewPrefs>)this.seriesViewPreferences);
        for (AxisViewPrefs cvp : chartViewPrefs.getAxesViewPrefs()) {
            if (cvp.getYAxis() != null || chartViewPrefs.getChart().getXAxisType() != XAxisType.Variable) continue;
            this.axisViewPreferences.add((Object)cvp);
            break;
        }
        for (AxisViewPrefs cvp : chartViewPrefs.getAxesViewPrefs()) {
            if (cvp.getYAxis() == null) continue;
            this.axisViewPreferences.add((Object)cvp);
        }
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner(window);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        BorderPane pane = new BorderPane();
        if (!fixedRaster) {
            pane.setTop(this.createRasterSettingsUI());
        }
        pane.setCenter(this.createSeriesSettingsUI());
        pane.setBottom(this.createAxesSettingsUI());
        CheckBox copyPrefsCb = new CheckBox(Messages.charts_ChartPrefsDialog_Copy_preferences_to_similar_charts);
        copyPrefsCb.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.copyPreferencesProperty.bind((ObservableValue)copyPrefsCb.selectedProperty());
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        VBox contentBox = new VBox(10.0, new Node[]{pane});
        if (chartViewPrefs.getChart().getXAxisType() == XAxisType.Time) {
            contentBox.getChildren().addAll((Object[])new Node[]{this.createNotesSettingsUI(), new Separator(Orientation.HORIZONTAL)});
        }
        contentBox.getChildren().add((Object)copyPrefsCb);
        this.getDialogPane().setContent((Node)contentBox);
        this.setResultConverter(bt -> {
            if (bt == ButtonType.OK) {
                int i = 0;
                for (Series2DViewPrefs seriesViewPrefs : this.seriesViewPreferences) {
                    seriesViewPrefs.setVisualOrderPosition(Integer.valueOf(i++));
                }
                chartViewPrefs.getSeriesViewPrefs().clear();
                chartViewPrefs.getSeriesViewPrefs().addAll(this.seriesViewPreferences);
            }
            return bt;
        });
        this.setTitle(Messages.charts_ChartPrefsDialog_Chart_Preferences);
        this.getDialogPane().setPrefWidth(800.0);
        this.setResizable(true);
    }

    protected Node createNotesSettingsUI() {
        GridPane notesPrefs = new GridPane();
        notesPrefs.setHgap(10.0);
        notesPrefs.setVgap(5.0);
        LinkedList<SearchPolicyDescr> searchPolicies = new LinkedList<SearchPolicyDescr>();
        searchPolicies.add(new SearchPolicyDescr(null));
        SearchPolicyDescr selected = null;
        SearchPolicy[] searchPolicyArray = SearchPolicy.values();
        int n = searchPolicyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchPolicy searchPolicy = searchPolicyArray[n2];
            SearchPolicyDescr searchPolicyDescr = new SearchPolicyDescr(searchPolicy);
            if (searchPolicy == this.chartViewPrefs.getNotesSearchPolicy()) {
                selected = searchPolicyDescr;
            }
            searchPolicies.add(searchPolicyDescr);
            ++n2;
        }
        ComboBox notesSearchPolicyCb = new ComboBox(FXCollections.observableArrayList(searchPolicies));
        notesSearchPolicyCb.setValue(selected);
        notesSearchPolicyCb.valueProperty().addListener((o, ov, nv) -> this.chartViewPrefs.setNotesSearchPolicy(nv.searchPolicy));
        ComboBox notesFilterCb = new ComboBox(FXCollections.observableArrayList((Object[])NoteType.values()));
        notesFilterCb.setButtonCell((ListCell)new UIModelListCell());
        notesFilterCb.setCellFactory(cf -> new UIModelListCell());
        notesFilterCb.valueProperty().bindBidirectional((Property)this.chartViewPrefs.notesFilterProperty());
        Label notesSearchPolicyLabel = new Label(Messages.charts_ChartPrefsDialog_NotesSearchPolicy);
        Label notesFilterLabel = new Label(Messages.charts_ChartPrefsDialog_NotesFilter);
        notesPrefs.addRow(0, new Node[]{notesSearchPolicyLabel, notesSearchPolicyCb, notesFilterLabel, notesFilterCb});
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setMinWidth(150.0);
        ColumnConstraints c2 = new ColumnConstraints();
        ColumnConstraints c3 = new ColumnConstraints();
        c3.setMinWidth(100.0);
        ColumnConstraints c4 = new ColumnConstraints();
        notesPrefs.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c1, c2, c3, c4});
        notesPrefs.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        return notesPrefs;
    }

    protected Node createRasterSettingsUI() {
        ObservableList<ComplexRasterDescriptor> rasters = ComplexRasterDescriptor.createDescriptors(this.minRaster);
        ComboBox rasterCb = new ComboBox(rasters);
        rasterCb.setValue((Object)new ComplexRasterDescriptor(this.chartViewPrefs.getComplexRaster() != null ? this.chartViewPrefs.getComplexRaster() : ComplexRaster.of((Raster)this.minRaster)));
        rasterCb.valueProperty().addListener(il -> {
            ComplexRaster cr = ((ComplexRasterDescriptor)rasterCb.getValue()).getComplexRaster();
            if (cr == null || cr.ordinal() <= this.minRaster.ordinal()) {
                this.chartViewPrefs.setRaster(this.minRaster);
                this.chartViewPrefs.setVirtualRaster(null);
            } else {
                this.chartViewPrefs.setRaster(cr.getRaster());
                this.chartViewPrefs.setVirtualRaster(cr.getVirtualRaster());
            }
        });
        Label label = new Label(Messages.charts_ChartPrefsDialog_Raster1);
        label.setPadding(new Insets(5.0));
        HBox box = new HBox(10.0, new Node[]{label, rasterCb});
        box.setPadding(new Insets(10.0));
        return box;
    }

    protected Node createSeriesSettingsUI() {
        TableView tableView = new TableView(this.seriesViewPreferences);
        tableView.setEditable(true);
        tableView.setMaxHeight(Double.MAX_VALUE);
        tableView.setMaxWidth(Double.MAX_VALUE);
        IntermediateCheckBox rowsEnabledCB = new IntermediateCheckBox();
        rowsEnabledCB.compositeValueProperty().bindBidirectional(this.rowsEnabled);
        this.rowsEnabled.addListener((o, ov, nv) -> {
            if (nv == null) {
                return;
            }
            if (nv.booleanValue()) {
                this.seriesViewPreferences.forEach(row -> row.setVisible(true));
            }
            if (!nv.booleanValue()) {
                this.seriesViewPreferences.forEach(row -> row.setVisible(false));
            }
        });
        InvalidationListener updateRowsSelection = o -> {
            int count = 0;
            for (Series2DViewPrefs row : this.seriesViewPreferences) {
                if (!row.isVisible()) continue;
                ++count;
            }
            if (count == 0) {
                this.rowsEnabled.set((Object)false);
            } else if (count == this.seriesViewPreferences.size()) {
                this.rowsEnabled.set((Object)true);
            } else {
                this.rowsEnabled.set(null);
            }
        };
        updateRowsSelection.invalidated(null);
        this.seriesViewPreferences.forEach(row -> row.isVisibleProperty().addListener(updateRowsSelection));
        TableColumn visibleColumn = new TableColumn();
        visibleColumn.setGraphic((Node)rowsEnabledCB);
        visibleColumn.setCellFactory(cf -> new CheckBoxTableCell());
        visibleColumn.setCellValueFactory(cf -> ((Series2DViewPrefs)cf.getValue()).isVisibleProperty());
        TableColumn seriesColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Var_Series);
        seriesColumn.setGraphic((Node)new ImageView(VarSeries2D.DEFAULT_ICON.toString()));
        seriesColumn.setCellFactory(cf -> new DnDUIModelTableCell());
        seriesColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((Series2DViewPrefs)cf.getValue())));
        seriesColumn.setPrefWidth(200.0);
        TableColumn objectColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Object);
        objectColumn.setCellValueFactory(cf -> {
            if (((Series2DViewPrefs)cf.getValue()).getVariableInstance() != null) {
                return new ReadOnlyObjectWrapper((Object)((Series2DViewPrefs)cf.getValue()).getVariableInstance().getStructureObject());
            }
            return new ReadOnlyObjectWrapper((Object)((Series2DViewPrefs)cf.getValue()).getCustomDataStructureObject());
        });
        TableColumn lineTypeColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Line);
        lineTypeColumn.setCellFactory(cf -> new ComboBoxTableCell(this.lineTypeConverter, (Object[])LineType.values()));
        lineTypeColumn.setCellValueFactory(cf -> ((Series2DViewPrefs)cf.getValue()).lineTypeProperty());
        lineTypeColumn.setPrefWidth(100.0);
        TableColumn shapeTypeColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Shape);
        shapeTypeColumn.setCellFactory(cf -> new ComboBoxTableCell(this.shapeTypeConverter, (Object[])ShapeType.values()));
        shapeTypeColumn.setCellValueFactory(cf -> ((Series2DViewPrefs)cf.getValue()).shapeTypeProperty());
        shapeTypeColumn.setPrefWidth(100.0);
        TableColumn lineWidthColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Line_Width);
        lineWidthColumn.setCellFactory(cf -> new IntegerFieldTableCell(NumberFormats.INTEGER, true));
        lineWidthColumn.setCellValueFactory(cf -> ((Series2DViewPrefs)cf.getValue()).lineWidthProperty());
        TableColumn shapeSizeColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Shape_Size);
        shapeSizeColumn.setCellFactory(cf -> new IntegerFieldTableCell(NumberFormats.INTEGER, true));
        shapeSizeColumn.setCellValueFactory(cf -> ((Series2DViewPrefs)cf.getValue()).shapeSizeProperty());
        TableColumn showValuesBoundsColumn = new TableColumn(Messages.charts_ChartPrefsDialog_ShowValuesBounds);
        showValuesBoundsColumn.setCellFactory(cf -> new CheckBoxTableCell());
        showValuesBoundsColumn.setCellValueFactory(cf -> ((Series2DViewPrefs)cf.getValue()).showValuesBoundsProperty());
        tableView.getColumns().addAll((Object[])new TableColumn[]{visibleColumn, seriesColumn, objectColumn, lineTypeColumn, shapeTypeColumn, lineWidthColumn, shapeSizeColumn, showValuesBoundsColumn});
        FXUtils.addOnMouseDoubleClickListener((TableView)tableView, Series2DViewPrefs.class, scp -> {
            ColorPickerDialog colorDialog = new ColorPickerDialog(this.getOwner(), scp.getColor());
            colorDialog.showAndWait().ifPresent(c -> scp.setColor(c));
        });
        return tableView;
    }

    protected Node createAxesSettingsUI() {
        TableView tableView = new TableView(this.axisViewPreferences);
        tableView.setEditable(true);
        TableColumn titleColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Axis);
        titleColumn.setGraphic((Node)new ImageView(YAxis.DEFAULT_ICON.toString()));
        titleColumn.setCellFactory(cf -> new UIModelTableCell());
        titleColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((AxisViewPrefs)cf.getValue())));
        titleColumn.setMinWidth(200.0);
        TableColumn measuringUnitColumn = new TableColumn(Messages.charts_ChartPrefsDialog_Unit);
        measuringUnitColumn.setCellFactory(cf -> new DynamicComboBoxTableCell(mu -> mu.getPhysicalUnit().getMeasuringUnits()));
        measuringUnitColumn.setCellValueFactory(cf -> ((AxisViewPrefs)cf.getValue()).measuringUnitProperty());
        TableColumn isAbsoluteColumn = new TableColumn(Messages.charts_ChartPrefsDialog_v);
        isAbsoluteColumn.setCellFactory(cf -> new CheckBoxTableCell());
        isAbsoluteColumn.setCellValueFactory(cf -> ((AxisViewPrefs)cf.getValue()).isAbsoluteProperty());
        TableColumn lowerRange = new TableColumn(Messages.charts_ChartPrefsDialog_l_lim);
        lowerRange.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.DEFAULT_DOUBLE));
        lowerRange.setCellValueFactory(cf -> ((AxisViewPrefs)cf.getValue()).lowerRangeProperty());
        lowerRange.setMinWidth(100.0);
        TableColumn upperRange = new TableColumn(Messages.charts_ChartPrefsDialog_u_lim);
        upperRange.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.DEFAULT_DOUBLE));
        upperRange.setCellValueFactory(cf -> ((AxisViewPrefs)cf.getValue()).upperRangeProperty());
        upperRange.setMinWidth(100.0);
        tableView.getColumns().addAll((Object[])new TableColumn[]{titleColumn, measuringUnitColumn, isAbsoluteColumn, lowerRange, upperRange});
        tableView.setMinHeight(100.0);
        tableView.setPrefHeight(150.0);
        VBox box = new VBox(new Node[]{tableView});
        box.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        return box;
    }

    public void persist() {
        Transaction trx = Transactions.begin();
        try {
            try {
                this.chartViewPrefs.setTimeRangeFilterType(this.timeRangeFilterType);
                this.chartViewPrefs.setCustomViewIndex(this.custoViewIndex);
                ChartPrefsHelper.persist(trx, this.chartViewPrefs);
                if (this.copyPreferencesProperty.get()) {
                    StructureClass thisClass = this.chartViewPrefs.getStructureObject().getStructureClass();
                    for (StructureClass chartClass : this.chartViewPrefs.getChart().getStructureClasses()) {
                        if (!StructureClassDAO.isSubclass((Transaction)trx, (StructureClass)chartClass, (StructureClass)thisClass)) continue;
                        StructureObject[] structureObjectArray = StructureClassDAO.getAllObjects((Transaction)trx, (int)chartClass.getId());
                        int n = structureObjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StructureObject object = structureObjectArray[n2];
                            if (!object.equals((Object)this.chartViewPrefs.getStructureObject())) {
                                Chart2DViewPrefs clonedPrefs = this.copyPreferences(trx, this.chartViewPrefs, object);
                                ChartPrefsHelper.persist(trx, clonedPrefs);
                            }
                            ++n2;
                        }
                    }
                }
                Transactions.commitSync((Transaction)trx);
            }
            catch (DAOOperationException e) {
                e.printStackTrace();
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private Chart2DViewPrefs copyPreferences(Transaction trx, Chart2DViewPrefs sourcePrefs, StructureObject object) throws DAOOperationException {
        Chart2DViewPrefs prefs = Chart2DViewPrefsDAO.get((Transaction)trx, (Chart2D)sourcePrefs.getChart(), (StructureObject)object);
        prefs = prefs != null ? new Chart2DViewPrefs(prefs.getId().intValue(), sourcePrefs.getChart(), object) : new Chart2DViewPrefs(sourcePrefs.getChart(), object);
        prefs.setTitle(sourcePrefs.getTitle());
        prefs.setAutoupdate(sourcePrefs.isAutoupdate());
        prefs.setTimeRangeFilterType(sourcePrefs.getTimeRangeFilterType());
        prefs.setCustomViewIndex(sourcePrefs.getCustomViewIndex());
        prefs.setRaster(sourcePrefs.getRaster());
        prefs.setVirtualRaster(sourcePrefs.getVirtualRaster());
        prefs.setNotesFilter(sourcePrefs.getNotesFilter());
        prefs.setNotesSearchPolicy(sourcePrefs.getNotesSearchPolicy());
        for (AxisViewPrefs yAxisPrefs : sourcePrefs.getAxesViewPrefs()) {
            prefs.getAxesViewPrefs().add(yAxisPrefs.clone(prefs));
        }
        for (Series2DViewPrefs seriesViewPrefs : sourcePrefs.getSeriesViewPrefs()) {
            SearchPolicy searchPolicy = seriesViewPrefs.getSeries().getSearchPolicy();
            VariableInstance[] instancesForObject = VariableDAO.findInstances((Transaction)trx, (Variable)seriesViewPrefs.getVariableInstance().getVariable(), (StructureObject)object, (SearchPolicy)searchPolicy);
            if (instancesForObject.length != 1) continue;
            prefs.getSeriesViewPrefs().add(seriesViewPrefs.clone(prefs, instancesForObject[0]));
        }
        return prefs;
    }

    private static class SearchPolicyDescr {
        final SearchPolicy searchPolicy;

        public SearchPolicyDescr(SearchPolicy searchPolicy) {
            this.searchPolicy = searchPolicy;
        }

        public String toString() {
            if (this.searchPolicy == null) {
                return null;
            }
            return this.searchPolicy.toString();
        }
    }
}

