/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ewms.core.charts.IVarSeries;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.fx.charts.SeriesColorGenerator;
import de.elpro.ewms.core.fx.model.IDataComposition;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.VarValuesColumn;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.stage.Window;

public abstract class ChartViewBase
extends Control
implements IDataComposition {
    private final SimpleObjectProperty<UIObjectState> state = new SimpleObjectProperty((Object)UIObjectState.New);
    private final SimpleObjectProperty<IDataSelection> dataSelection = new SimpleObjectProperty();
    private Collection<VarValuesColumn> varValuesColumns = null;
    private final StructureObject structureObject;
    private final Window window;
    private final VirtualRaster fixedRaster;
    private SeriesColorGenerator seriesColorGenerator = new DefaultSeriesColorGenerator();
    private ITimeRangeFilter timeRangeFilter = null;
    private boolean showFullSeriesNames = false;

    public ChartViewBase(StructureObject structureObject, Window window, ITimeRangeFilter timeRangeFilter, VirtualRaster fixedRaster) {
        this.structureObject = structureObject;
        this.window = window;
        this.fixedRaster = fixedRaster;
        this.timeRangeFilter = timeRangeFilter;
    }

    public final StructureObject getStructureObject() {
        return this.structureObject;
    }

    protected final Window getWindow() {
        return this.window;
    }

    public final VirtualRaster getFixedRaster() {
        return this.fixedRaster;
    }

    public final ITimeRangeFilter getTimeRangeFilter() {
        return this.timeRangeFilter;
    }

    protected final void updateTimeRangeFilter(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
    }

    public boolean isShowFullSeriesNames() {
        return this.showFullSeriesNames;
    }

    public void setShowFullSeriesNames(boolean showObjectNames) {
        this.showFullSeriesNames = showObjectNames;
    }

    @Override
    public final UIObjectState getState() {
        return (UIObjectState)((Object)this.state.get());
    }

    public final void setState(UIObjectState state) {
        this.stateProperty().set((Object)state);
    }

    @Override
    public final SimpleObjectProperty<UIObjectState> stateProperty() {
        return this.state;
    }

    @Override
    public final ReadOnlyProperty<IDataSelection> dataSelectionProperty() {
        return this.dataSelection;
    }

    public Collection<VarValuesColumn> getVarValuesColumns() {
        return this.varValuesColumns;
    }

    public void setVarValuesColumns(Collection<VarValuesColumn> varValuesColumns) {
        this.varValuesColumns = Collections.unmodifiableCollection(varValuesColumns);
    }

    public final IDataSelection getDataSelection() {
        return (IDataSelection)this.dataSelectionProperty().getValue();
    }

    protected final void setDataSelection(IDataSelection dataSelection) {
        this.dataSelection.set((Object)dataSelection);
    }

    public SeriesColorGenerator getSeriesColorGenerator() {
        return this.seriesColorGenerator;
    }

    public void setSeriesColorGenerator(SeriesColorGenerator seriesColorGenerator) {
        this.seriesColorGenerator = seriesColorGenerator;
    }

    protected void updateViewPrefsRaster(IViewPrefs viewPrefs) {
        if (!viewPrefs.getTimeRangeFilterType().toRawValueViewType().equals((Object)this.timeRangeFilter.getType().toRawValueViewType()) || viewPrefs.getTimeRangeFilterType().toRawValueViewType() == RawValuesViewType.CustomView && (viewPrefs.getCustomViewIndex() != null || this.timeRangeFilter.getCustomViewIndex() != null) && !viewPrefs.getCustomViewIndex().equals(this.timeRangeFilter.getCustomViewIndex())) {
            viewPrefs.setTimeRangeFilterType(this.timeRangeFilter.getType());
            viewPrefs.setCustomViewIndex(this.timeRangeFilter.getCustomViewIndex());
            viewPrefs.setRaster(null);
            viewPrefs.setVirtualRaster(null);
        }
        viewPrefs.setTimeRangeFilterType(this.timeRangeFilter.getType());
        viewPrefs.setCustomViewIndex(this.timeRangeFilter.getCustomViewIndex());
        if (viewPrefs.getComplexRaster() == null) {
            viewPrefs.setRaster(ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.timeRangeFilter.getType().toRawValueViewType(), (Integer)this.timeRangeFilter.getCustomViewIndex()));
        } else if (viewPrefs.getComplexRaster().getRaster() != null) {
            Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.timeRangeFilter.getType().toRawValueViewType(), (Integer)this.timeRangeFilter.getCustomViewIndex());
            if (viewPrefs.getComplexRaster().getRaster().toMilli() < minRaster.toMilli()) {
                viewPrefs.setRaster(minRaster);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.getSkin() != null) {
            this.getSkin().dispose();
        }
        this.varValuesColumns = null;
    }

    private static class DefaultSeriesColorGenerator
    implements SeriesColorGenerator {
        private DefaultSeriesColorGenerator() {
        }

        @Override
        public Color generateColor(IVarSeries series, Variable variable, StructureObject structureObject, TimelinePhase timelinePhase) {
            if (series.getDefaultColor() != null) {
                return series.getDefaultColor();
            }
            return DefaultSeriesColorGenerator.deriveColor(series, variable, structureObject, timelinePhase);
        }

        protected static Color deriveColor(IVarSeries series, Variable variable, StructureObject structureObject, TimelinePhase timelinePhase) {
            double b;
            double g;
            double r;
            StructureObject object = structureObject;
            Color color = object.getDefaultColor();
            if (color != null) {
                r = color.getRed();
                g = color.getGreen();
                b = color.getBlue();
            } else {
                double hashCode = Math.abs((double)object.hashCode());
                r = (hashCode / 3.0 + hashCode / 17.0) / 7.76;
                r -= Math.floor(r);
                g = (hashCode / 11.0 + hashCode / 7.0) / 5.34;
                g -= Math.floor(g);
                b = (hashCode / Math.PI + hashCode / 5.0) / 3.168;
                if (r + g + (b -= Math.floor(b)) > 2.1) {
                    if (r > 0.3) {
                        r -= 0.3;
                    }
                    if (g > 0.3) {
                        g -= 0.3;
                    }
                    if (b > 0.3) {
                        b -= 0.3;
                    }
                }
            }
            double seriesHashCode = series.getId() != null ? (double)series.hashCode() : (double)(object.toString().hashCode() + series.toString().hashCode());
            r = (r + Math.abs(Math.sin(seriesHashCode / 13.6803)) * 0.7) / 2.0;
            g = (g + Math.abs(Math.cos(seriesHashCode / 7.3952)) * 0.7) / 2.0;
            b = (b + Math.abs(Math.sin(seriesHashCode / 17.13489)) * 0.7) / 2.0;
            if (timelinePhase != null) {
                double timelineHashCode = timelinePhase.hashCode();
                r = (r * 0.7 + Math.abs(Math.sin(timelineHashCode / 7.52))) / 1.7;
                g = (g * 0.7 + Math.abs(Math.cos(timelineHashCode / 17.693))) / 1.7;
                b = (b * 0.7 + Math.abs(Math.sin(timelineHashCode / 13.128))) / 1.7;
            }
            return Color.color((double)r, (double)g, (double)b);
        }
    }
}

