/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ewms.core.characteristic.Characteristic3DFunction;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.charts.xyz.XYZChart2D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.series.AreaSurfaceEditMode;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.model.UILabeledElement;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;

public class CompareCharacteristic3DChart
extends BorderPane
implements UILabeledElement {
    private final String characteristicName;
    private final Instant masterFunctionTimestamp;
    private final Instant slaveFunctionTimestamp;

    public CompareCharacteristic3DChart(String characteristicName, XYZAxes axes, Instant masterFunctionTimestamp, Characteristic3DFunction masterFunction, Instant slaveFunctionTimestamp, Characteristic3DFunction slaveFunction, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU, boolean relativeComparsion, boolean compareWAxisValues) {
        this.characteristicName = characteristicName;
        this.masterFunctionTimestamp = masterFunctionTimestamp;
        this.slaveFunctionTimestamp = slaveFunctionTimestamp;
        XYZChart2D chart2d = new XYZChart2D(new XYZAxes(axes.getXAxis(), axes.getYAxis(), axes.getZAxis(), compareWAxisValues ? axes.getWAxis() : null));
        chart2d.setDeriveItemColorFromZAxis(false);
        chart2d.setZAxisColorPolicy(ItemColorPolicy.SeriesBaseColor);
        chart2d.setWAxisColorPolicy(ItemColorPolicy.WRedToGreen);
        chart2d.setShowWIsolines(compareWAxisValues && wAxisMU != null);
        AreaSeries areaSeries = new AreaSeries("", masterFunction, slaveFunction, xAxisMU, yAxisMU, zAxisMU, wAxisMU, relativeComparsion, compareWAxisValues);
        chart2d.getSeriesList().add((Object)areaSeries);
        areaSeries.setBaseColor(Color.BLACK);
        double[] xs = masterFunction.getXValues(xAxisMU);
        double[] ys = masterFunction.getYValues(yAxisMU);
        double[][][] zws = areaSeries.getZW(xs, ys);
        double minX = xs[0];
        double maxX = xs[xs.length - 1];
        double minY = ys[0];
        double maxY = ys[ys.length - 1];
        double minZ = Double.NaN;
        double maxZ = Double.NaN;
        double minW = Double.NaN;
        double maxW = Double.NaN;
        int xi = 0;
        while (xi < xs.length) {
            int yi = 0;
            while (yi < ys.length) {
                double w;
                double z = zws[xi][yi][0];
                double d = w = compareWAxisValues && wAxisMU != null ? zws[xi][yi][1] : Double.NaN;
                if (Double.isFinite(z)) {
                    if (!Double.isFinite(minZ)) {
                        minZ = maxZ = z;
                    } else {
                        minZ = Math.min(minZ, z);
                        maxZ = Math.max(maxZ, z);
                    }
                }
                if (compareWAxisValues && Double.isFinite(w)) {
                    if (!Double.isFinite(minW)) {
                        minW = maxW = w;
                    } else {
                        minW = Math.min(minW, w);
                        maxW = Math.max(maxW, w);
                    }
                }
                ++yi;
            }
            ++xi;
        }
        chart2d.setDefaultViewRange(new XYZDataViewRange(minX, maxX, minY, maxY, minZ, maxZ, minW, maxW));
        this.setCenter((Node)chart2d);
    }

    public String toString() {
        return String.format("%s: %s -> %s", this.characteristicName, TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(this.masterFunctionTimestamp, ZoneId.systemDefault())), TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(this.slaveFunctionTimestamp, ZoneId.systemDefault())));
    }

    private static class AreaSeries
    extends XYZAreaSeries {
        private final Characteristic3DFunction masterFunction;
        private final Characteristic3DFunction slaveFunction;
        private final MeasuringUnit xAxisMU;
        private final MeasuringUnit yAxisMU;
        private final MeasuringUnit zAxisMU;
        private final MeasuringUnit wAxisMU;
        private final boolean relativeComparsion;
        private final boolean compareWAxisValues;

        public AreaSeries(String name, Characteristic3DFunction masterFunction, Characteristic3DFunction slaveFunction, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU, boolean relativeComparsion, boolean compareWAxisValues) {
            super(name);
            this.masterFunction = masterFunction;
            this.slaveFunction = slaveFunction;
            this.xAxisMU = xAxisMU;
            this.yAxisMU = yAxisMU;
            this.zAxisMU = zAxisMU;
            this.wAxisMU = wAxisMU;
            this.relativeComparsion = relativeComparsion;
            this.compareWAxisValues = compareWAxisValues;
        }

        public double[][][] getZW(double[] xs, double[] ys) {
            double[][][] result = new double[xs.length][][];
            int xi = 0;
            while (xi < xs.length) {
                result[xi] = new double[ys.length][];
                int yi = 0;
                while (yi < ys.length) {
                    double[] zw = new double[this.compareWAxisValues && this.wAxisMU != null ? 2 : 1];
                    double masterZ = this.masterFunction.getZValue(this.xAxisMU, xs[xi], this.yAxisMU, ys[yi], this.zAxisMU);
                    double slaveZ = this.slaveFunction.getZValue(this.xAxisMU, xs[xi], this.yAxisMU, ys[yi], this.zAxisMU);
                    double d = zw[0] = this.relativeComparsion ? 100.0 * (slaveZ - masterZ) / masterZ : slaveZ - masterZ;
                    if (this.compareWAxisValues && this.wAxisMU != null) {
                        double masterW = this.masterFunction.getWValue(this.xAxisMU, xs[xi], this.yAxisMU, ys[yi], this.wAxisMU);
                        double slaveW = this.slaveFunction.getWValue(this.xAxisMU, xs[xi], this.yAxisMU, ys[yi], this.wAxisMU);
                        zw[1] = this.relativeComparsion ? 100.0 * (slaveW - masterW) / masterW : slaveW - masterW;
                    }
                    result[xi][yi] = zw;
                    ++yi;
                }
                ++xi;
            }
            return result;
        }

        public boolean hasW() {
            return this.wAxisMU != null;
        }

        public XYAreaBounds getXYAreaBounds() {
            return null;
        }

        public void setXYAreaBounds(XYAreaBounds xyBounds) {
        }

        public void modifySurface(AreaSurfaceEditMode editMode, Point2D initialPoint, Point2D editPoint, double xRadius, double yRadius, double zAmplitude, double wAmplitude) {
        }
    }
}

