/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class CompareCharacteristic3DDialog
extends Dialog<ButtonType> {
    private final ListView<C3DFunctionEntry> listView;
    private final CheckBox relativeCb = new CheckBox("Relative Comparsion");
    private final CheckBox compareWCb = new CheckBox("Compare W-Axis Values");

    public CompareCharacteristic3DDialog(Scene scene, List<C3DFunctionEntry> comapreFunctions) {
        this.initOwner(scene.getWindow());
        this.listView = new ListView(FXCollections.observableArrayList(comapreFunctions));
        this.listView.setCellFactory(cf -> new C3DListCell());
        BorderPane bp = new BorderPane(this.listView);
        VBox cbBox = new VBox(10.0, new Node[]{this.relativeCb, this.compareWCb});
        cbBox.setPadding(new Insets(10.0));
        bp.setTop((Node)cbBox);
        this.getDialogPane().setContent((Node)bp);
        this.getDialogPane().setPrefHeight(400.0);
        this.getDialogPane().setPrefWidth(600.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)this.listView.getSelectionModel().selectedItemProperty()));
    }

    public boolean isRelativeComparsion() {
        return this.relativeCb.isSelected();
    }

    public boolean isCompareWAxisValues() {
        return this.compareWCb.isSelected();
    }

    public C3DFunctionEntry getSelectedEntry() {
        return (C3DFunctionEntry)this.listView.getSelectionModel().getSelectedItem();
    }

    public static class C3DFunctionEntry {
        private final Instant from;
        private final Instant to;

        public C3DFunctionEntry(Instant from, Instant to) {
            this.from = from;
            this.to = to;
        }

        public Instant getFrom() {
            return this.from;
        }
    }

    private class C3DListCell
    extends ListCell<C3DFunctionEntry> {
        private C3DListCell() {
        }

        protected void updateItem(C3DFunctionEntry item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.textProperty().unbind();
                this.setText(null);
            } else {
                LocalDateTime from = LocalDateTime.ofInstant(item.from, ZoneId.systemDefault());
                LocalDateTime to = item.to != null ? LocalDateTime.ofInstant(item.to, ZoneId.systemDefault()) : null;
                String text = to != null ? String.format(Messages.chart_addons_Characteristic2DAddon_curvetimerange, TimeFormatType.DateTimeHM.format((TemporalAccessor)from), TimeFormatType.DateTimeHM.format((TemporalAccessor)to)) : String.format(Messages.chart_addons_Characteristic2DAddon_curvefrom, TimeFormatType.DateTimeHM.format((TemporalAccessor)from));
                this.setGraphic((Node)new ImageView(Characteristic2DInstance.ENABLED_ICON.toString()));
                this.setText(text);
            }
        }
    }
}

