/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.LinkedList;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;

public class DefaultJFreeChartTheme
extends StandardChartTheme {
    private static final long serialVersionUID = -1634137686994828329L;
    private static final String FONT_NAME = javafx.scene.text.Font.getDefault().getName();
    private static final Font REGULAR_FONT = new Font(FONT_NAME, 0, 11);
    private static final Font LARGE_FONT;
    private static final Font EXTRA_LARGE_FONT;
    private static final DefaultJFreeChartTheme INSTANCE;
    private boolean rangeAxisLineVisible = true;

    static {
        EXTRA_LARGE_FONT = LARGE_FONT = new Font(FONT_NAME, 0, 13);
        INSTANCE = new DefaultJFreeChartTheme("EOS");
    }

    public DefaultJFreeChartTheme(String name) {
        super(name);
        this.setTitlePaint(Color.decode("#004e86"));
        this.setExtraLargeFont(EXTRA_LARGE_FONT);
        this.setLargeFont(LARGE_FONT);
        this.setRegularFont(REGULAR_FONT);
        this.setRangeGridlinePaint(Color.decode("#C0C0C0"));
        this.setPlotBackgroundPaint(Color.white);
        this.setChartBackgroundPaint(Color.white);
        this.setGridBandPaint(Color.red);
        this.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.setBarPainter((BarPainter)new StandardBarPainter());
        this.setRangeAxisLineVisible(false);
    }

    public static DefaultJFreeChartTheme getChartTheme() {
        return INSTANCE;
    }

    public boolean isRangeAxisLineVisible() {
        return this.rangeAxisLineVisible;
    }

    public void setRangeAxisLineVisible(boolean rangeAxisLineVisible) {
        this.rangeAxisLineVisible = rangeAxisLineVisible;
    }

    public void apply(JFreeChart chart) {
        super.apply(chart);
        DefaultJFreeChartTheme.customApply(chart);
        DefaultJFreeChartTheme.applyAnnotationStyle(chart);
    }

    public void applyToRangeAxis(ValueAxis axis) {
        super.applyToValueAxis(axis);
        axis.setAxisLineVisible(this.isRangeAxisLineVisible());
    }

    private static void customApply(JFreeChart chart) {
        if (chart.getTitle() != null) {
            chart.getTitle().setPadding(new RectangleInsets(5.0, 0.0, 0.0, 0.0));
        }
        if (chart.getLegend() != null) {
            chart.getLegend().setBorder(0.5, 0.5, 0.5, 0.5);
            chart.getLegend().setMargin(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            chart.getLegend().setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            chart.getLegend().setItemLabelPadding(new RectangleInsets(5.0, 3.0, 5.0, 10.0));
        }
        RectangleInsets axisOffset = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        if (chart.getPlot() instanceof XYPlot) {
            XYPlot xyPlot = chart.getXYPlot();
            xyPlot.setAxisOffset(axisOffset);
        } else if (chart.getPlot() instanceof CategoryPlot) {
            CategoryPlot catPlot = chart.getCategoryPlot();
            catPlot.setAxisOffset(axisOffset);
        }
        chart.getPlot().setOutlineVisible(false);
    }

    private static void applyAnnotationStyle(JFreeChart chart) {
        Plot plot = chart.getPlot();
        if (plot instanceof XYPlot) {
            chart.setSubtitles(new LinkedList());
            LegendTitle lt = new LegendTitle((LegendItemSource)plot);
            lt.setItemFont(REGULAR_FONT);
            lt.setItemLabelPadding(new RectangleInsets(5.0, 0.0, 5.0, 5.0));
            lt.setLegendItemGraphicPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            lt.setBackgroundPaint((Paint)new Color(0.994f, 0.994f, 0.994f, 0.5f));
            lt.setFrame((BlockFrame)new BlockBorder((Paint)Color.decode("#F0F0F0")));
            lt.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            lt.setPosition(RectangleEdge.TOP);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.01, 0.99, (Title)lt, RectangleAnchor.TOP_LEFT);
            ta.setMaxWidth(0.5);
            ((XYPlot)plot).addAnnotation((XYAnnotation)ta);
        } else if (plot instanceof CategoryPlot || plot instanceof PiePlot || plot instanceof RingPlot) {
            chart.getLegend().setItemLabelPadding(new RectangleInsets(5.0, 0.0, 5.0, 5.0));
            chart.getLegend().setLegendItemGraphicPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            chart.getLegend().setPosition(RectangleEdge.TOP);
            chart.getLegend().setFrame((BlockFrame)new BlockBorder((Paint)Color.WHITE));
        }
    }
}

