/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.DoublePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;

public class LearnCurveDialog
extends Dialog<XYZItemSeries> {
    private ObjectProperty<XYZItemSeries> trainSeries = new SimpleObjectProperty();
    private ObjectProperty<Integer> numHiddenNodes = new SimpleObjectProperty((Object)200);
    private ObjectProperty<Integer> numHiddenLayers = new SimpleObjectProperty((Object)10);
    private BooleanProperty removePreviousFunctions = new SimpleBooleanProperty(true);
    private final IntegerProperty xAxisResolution = new SimpleIntegerProperty(100);
    private final IntegerProperty yAxisResolution = new SimpleIntegerProperty(100);
    private final DoubleProperty learningRate = new SimpleDoubleProperty(0.0045);
    private final int minGridSize = 5;

    public LearnCurveDialog(Scene scene, List<XYZItemSeries> allSeries) {
        this.initOwner(scene.getWindow());
        this.trainSeries.set((Object)allSeries.get(0));
        PropertySheet sheet = new PropertySheet();
        Label descriptionLabel = new Label("Please enter the deep learning parameters\n\n");
        BorderPane pane = new BorderPane((Node)sheet);
        pane.setTop((Node)descriptionLabel);
        ChoicePropertyItem trainSeriesItem = new ChoicePropertyItem("Train Series", this.trainSeries, allSeries);
        trainSeriesItem.setNullable(false);
        IntegerPropertyItem numHiddenNodesItem = new IntegerPropertyItem("Num. hidden Nodes", this.numHiddenNodes);
        numHiddenNodesItem.setPositiveOnly(true);
        numHiddenNodesItem.setValidator(Validators.createNotEmptyValidator());
        IntegerPropertyItem numHiddenLayersItem = new IntegerPropertyItem("Num. hidden Layers", this.numHiddenLayers);
        numHiddenLayersItem.setPositiveOnly(true);
        numHiddenLayersItem.setValidator(Validators.createNotEmptyValidator());
        BooleanPropertyItem removePrevFuncItem = new BooleanPropertyItem("Remove Old Functions", (ReadOnlyProperty)this.removePreviousFunctions);
        IntegerPropertyItem xAxisResolutionItem = new IntegerPropertyItem("X Axis resolution", (ObservableValue)this.xAxisResolution);
        IntegerPropertyItem yAxisResolutionItem = new IntegerPropertyItem("Y Axis resolution", (ObservableValue)this.yAxisResolution);
        DoublePropertyItem learningRateItem = new DoublePropertyItem(null, "Learning rate", (ObservableValue)this.learningRate, "0.0000");
        Validator min5Validator = Validators.createValidator((o, oldValue, newValue) -> newValue >= 5, (String)"Please enter a number higher than or equal to 5");
        Validator lrValidator = Validators.createValidator((o, oldValue, newValue) -> newValue > 0.0 && newValue <= 0.01, (String)"Please enter a number between 0.0 and 0.01 ");
        xAxisResolutionItem.setValidator(min5Validator);
        yAxisResolutionItem.setValidator(min5Validator);
        learningRateItem.setValidator(lrValidator);
        sheet.setSearchBoxVisible(false);
        sheet.setModeSwitcherVisible(false);
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{trainSeriesItem, numHiddenNodesItem, numHiddenLayersItem, removePrevFuncItem, xAxisResolutionItem, yAxisResolutionItem, learningRateItem});
        this.getDialogPane().setContent((Node)pane);
        this.getDialogPane().setPrefHeight(400.0);
        this.getDialogPane().setPrefWidth(600.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        ObservableBooleanValue hasErrors = PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems());
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)hasErrors);
        this.setResultConverter(btn -> {
            if (btn == ButtonType.OK) {
                return (XYZItemSeries)this.trainSeries.get();
            }
            return null;
        });
    }

    public XYZItemSeries getTrainSeries() {
        return (XYZItemSeries)this.trainSeries.get();
    }

    public int getNumHiddenNodes() {
        return Math.max(10, (Integer)this.numHiddenNodes.get());
    }

    public int getNumHiddenLayers() {
        return Math.max(1, (Integer)this.numHiddenLayers.get());
    }

    public int getXAxisResolution() {
        return Math.max(5, this.xAxisResolution.get());
    }

    public int getYAxisResolution() {
        return Math.max(5, this.yAxisResolution.get());
    }

    public boolean isRemovePreviousFunctions() {
        return this.removePreviousFunctions.get();
    }

    public double getLearingRate() {
        return this.learningRate.get();
    }
}

