/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts;

import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.charts.SankeyNodeType;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.UsageDomains;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.charts.sankey.SankeyFXChart;
import de.elpro.ui.fx.charts.sankey.SankeyFXLink;
import de.elpro.ui.fx.charts.sankey.SankeyFXNode;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;

public class SankeyChartView
extends Control {
    private final SankeyChart chartDefinition;
    private final StructureObject structureObject;
    private ITimeRangeFilter timeRangeFilter;
    private final BorderPane sankeyChartContainer = new BorderPane();
    private ProgressIndicatorPane progressIndicator;

    public SankeyChartView(SankeyChart chartDefinition, StructureObject structureObject, ITimeRangeFilter timeRangePrefs) {
        this.chartDefinition = chartDefinition;
        this.structureObject = structureObject;
        this.timeRangeFilter = timeRangePrefs;
    }

    private IVarValue loadValue(VariableInstance instance) {
        if (this.timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView) {
            return VariableInstanceDAO.getCurrentValue((VariableInstance)instance);
        }
        IVarValuesCollection values = VariableInstanceDAO.getVarValues((RawValuesViewType)this.timeRangeFilter.getType().toRawValueViewType(), (Integer)this.timeRangeFilter.getCustomViewIndex(), (VariableInstance)instance, (Instant)this.timeRangeFilter.getFrom(), (Instant)this.timeRangeFilter.getTo(), (ComplexRaster)ComplexRaster.OVERALL);
        return values.getFirst();
    }

    protected Skin<?> createDefaultSkin() {
        try {
            DefaultSkin skin = new DefaultSkin(this);
            this.reloadData();
            return skin;
        }
        catch (IllegalConfigException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reloadData() {
        CallableTask<SankeyFXChart> task = new CallableTask<SankeyFXChart>(){

            public SankeyFXChart call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    ObservableSet fxNodes = FXCollections.observableSet((Object[])new SankeyFXNode[0]);
                    ObservableSet fxLinks = FXCollections.observableSet((Object[])new SankeyFXLink[0]);
                    for (SankeyNode rootNode : SankeyChartView.this.chartDefinition.getRootNodes()) {
                        SankeyChartView.this.buildNodesRecursive(trx, rootNode, SankeyChartView.this.structureObject, null, (Collection<SankeyFXNode>)fxNodes, (Collection<SankeyFXLink>)fxLinks);
                    }
                    SankeyFXChart sankeyFXChart = new SankeyFXChart(fxNodes, fxLinks);
                    return sankeyFXChart;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult((status, chart) -> {
            if (chart != null) {
                Platform.runLater(() -> this.sankeyChartContainer.setCenter((Node)chart));
            }
        });
    }

    private void buildNodesRecursive(Transaction trx, final SankeyNode node, StructureObject object, SankeyFXNode sourceNode, Collection<SankeyFXNode> fxNodes, Collection<SankeyFXLink> fxLinks) {
        SearchPolicy searchPolicy = switch (node.getType()) {
            case SankeyNodeType.Recursive -> sourceNode == null ? SearchPolicy.This : SearchPolicy.TopChildren;
            case SankeyNodeType.DirectChild -> SearchPolicy.This;
            case SankeyNodeType.ObjectVariable -> SearchPolicy.This;
            default -> SearchPolicy.TopChildren;
        };
        LinkedList<VariableInstance> instances = new LinkedList<VariableInstance>();
        if (node.getType() != SankeyNodeType.DirectChild) {
            instances.addAll(Arrays.asList(VariableDAO.findInstances((Transaction)trx, (Variable)node.getVariable(), (StructureObject)object, (SearchPolicy)searchPolicy)));
        } else {
            for (StructureObject directChild : object.getChildren()) {
                instances.addAll(Arrays.asList(VariableDAO.findInstances((Transaction)trx, (Variable)node.getVariable(), (StructureObject)directChild, (SearchPolicy)SearchPolicy.This)));
            }
        }
        final MeasuringUnit displayUnit = this.chartDefinition.getDefaultMeasuringUnit() != null ? this.chartDefinition.getDefaultMeasuringUnit() : this.chartDefinition.getPhysicalUnit().getMeasuringUnit(UsageDomains.DEFAULT);
        for (VariableInstance subInstance : instances) {
            StructureObject subObject = StructureObjectDAO.get((Transaction)trx, (int)subInstance.getStructureObject().getId());
            if (!StructureClassDAO.isSubclass((Transaction)trx, (StructureClass)node.getStructureClass(), (StructureClass)subObject.getStructureClass())) continue;
            subInstance.setStructureObject(subObject);
            IVarValue iVal = this.loadValue(subInstance);
            if (!iVal.isValid() || iVal.getValue() <= 0.0) continue;
            String title = node.getLocalTitle();
            String label = title != null && !title.isEmpty() ? title.replaceAll("\\{object\\}", subObject.toString()) : subObject.toString();
            StringConverter<Double> valueFormatter = new StringConverter<Double>(){

                public String toString(Double object) {
                    return displayUnit.formatValue(object.doubleValue(), node.getVariable().getMeasuringUnit());
                }

                public Double fromString(String string) {
                    return null;
                }
            };
            SankeyFXNode targetNode = new SankeyFXNode(subObject.getGraphic(), label, (StringConverter)valueFormatter);
            targetNode.setValue(Double.valueOf(iVal.getValue()));
            if (node.getType() == SankeyNodeType.ObjectVariable) {
                targetNode.setShowGraphic(false);
            }
            fxNodes.add(targetNode);
            targetNode.setFixedHorizontalPosition(Integer.valueOf(sourceNode != null ? sourceNode.getHorizontalPosition() + 1 : 0));
            if (subObject.getDefaultColor() != null) {
                Color defaultColor = subObject.getDefaultColor();
                targetNode.setFill((Paint)defaultColor);
            } else {
                Color randomColor = new Color(Math.random(), Math.random(), Math.random(), 1.0);
                targetNode.setFill((Paint)randomColor);
            }
            if (sourceNode != null) {
                SimpleDoubleProperty valueProperty = new SimpleDoubleProperty(iVal.getValue());
                SankeyFXLink link = new SankeyFXLink(sourceNode, targetNode, (DoubleProperty)valueProperty, (StringConverter)valueFormatter);
                fxLinks.add(link);
            }
            if (node.getType() == SankeyNodeType.Recursive) {
                this.buildNodesRecursive(trx, node, subObject, targetNode, fxNodes, fxLinks);
            }
            for (SankeyNode subNode : node.getChildren()) {
                this.buildNodesRecursive(trx, subNode, subObject, targetNode, fxNodes, fxLinks);
            }
        }
    }

    public void loadData(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        this.reloadData();
    }

    private class DefaultSkin
    extends SkinBase<SankeyChartView> {
        protected DefaultSkin(SankeyChartView control) throws IllegalConfigException {
            super((Control)control);
            StackPane ic = new StackPane(new Node[]{new InfiniteCanvas(), SankeyChartView.this.sankeyChartContainer});
            ic.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, null)}));
            ic.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.LIGHTGREY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
            BorderPane container = new BorderPane((Node)new StackPane(new Node[]{ic}){
                {
                    this.setPadding(new Insets(6.0));
                    BackgroundFill fill = new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY);
                    this.setBackground(new Background(new BackgroundFill[]{fill}));
                }
            });
            String title = SankeyChartView.this.chartDefinition.getLocalTitle();
            if (title != null) {
                title = title.replaceAll("\\{object\\}", SankeyChartView.this.structureObject.toString());
                Label label = new Label(title);
                label.getStyleClass().add((Object)"chart-title");
                label.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.BOLD, (double)18.0));
                StackPane.setAlignment((Node)label, (Pos)Pos.CENTER);
                container.setTop((Node)new StackPane(new Node[]{label}){
                    {
                        this.setPadding(new Insets(5.0));
                    }
                });
            }
            SankeyChartView.this.progressIndicator = new ProgressIndicatorPane((Node)container);
            this.getChildren().add((Object)SankeyChartView.this.progressIndicator);
        }
    }
}

