/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.addons;

import de.elpro.ewms.core.characteristic.Characteristic2DFunction;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.cells.editable.DoubleFieldTableCell;
import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.stage.Window;

public class Characteristic2DAdjustCurveDialog
extends Dialog<ButtonType> {
    private final ObservableList<Point> points = FXCollections.observableArrayList();

    public Characteristic2DAdjustCurveDialog(Window window, Characteristic2DFunction function, String xAxisTitle, AxisViewPrefs xAxisPrefs, String yAxisTitle, AxisViewPrefs yAxisPrefs) {
        this.initOwner(window);
        MeasuringUnit inputDisplayMU = xAxisPrefs.getMeasuringUnit();
        MeasuringUnit outputDisplayMU = yAxisPrefs.getMeasuringUnit();
        TableColumn xHeaderColumn = new TableColumn(xAxisTitle);
        TableColumn xColumn = new TableColumn(xAxisPrefs.getMeasuringUnit().getDisplayUnitText());
        xColumn.setPrefWidth(150.0);
        xHeaderColumn.getColumns().add((Object)xColumn);
        xColumn.setCellValueFactory(cf -> ((Point)cf.getValue()).input);
        xColumn.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.F0_000));
        TableColumn yHeaderColumn = new TableColumn(yAxisTitle);
        TableColumn yColumn = new TableColumn(yAxisPrefs.getMeasuringUnit().getDisplayUnitText());
        yColumn.setPrefWidth(150.0);
        yHeaderColumn.getColumns().add((Object)yColumn);
        yColumn.setCellValueFactory(cf -> ((Point)cf.getValue()).output);
        yColumn.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.F0_000));
        this.points.addAll((Object[])((Point[])function.getPoints().stream().map(p -> new Point(inputDisplayMU.convert(p.getInput(), function.getInputMU()), outputDisplayMU.convert(p.getOutput(), function.getOutputMU()))).toArray(Point[]::new)));
        TableView tableView = new TableView(this.points);
        tableView.setEditable(true);
        tableView.getColumns().addAll((Object[])new TableColumn[]{xHeaderColumn, yHeaderColumn});
        this.getDialogPane().setContent((Node)tableView);
        this.getDialogPane().setPrefWidth(500.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.APPLY).setDisable(true);
        tableView.editingCellProperty().addListener((o, ov, nv) -> {
            if (ov != null && nv == null) {
                ArrayList list = new ArrayList(this.points.filtered(p -> p.input.get() != null && p.output.get() != null));
                list.sort((p1, p2) -> Double.compare((Double)p1.input.get(), (Double)p2.input.get()));
                this.points.setAll(list);
                function.clear();
                for (Point point : this.points) {
                    MeasuringUnitValue inputMV = new MeasuringUnitValue(xAxisPrefs.getMeasuringUnit(), ((Double)point.input.get()).doubleValue());
                    MeasuringUnitValue outputMV = new MeasuringUnitValue(yAxisPrefs.getMeasuringUnit(), ((Double)point.output.get()).doubleValue());
                    function.addPoint(inputMV, outputMV);
                }
                function.commitChanges();
                this.getDialogPane().lookupButton(ButtonType.APPLY).setDisable(false);
            }
        });
        this.setResizable(true);
    }

    private static class Point {
        private final ObjectProperty<Double> input = new SimpleObjectProperty();
        private final ObjectProperty<Double> output = new SimpleObjectProperty();

        public Point(Double input, Double output) {
            this.input.set((Object)input);
            this.output.set((Object)output);
        }
    }
}

