/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.addons;

import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ui.fx.controls.DateTimePicker;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;

public class CharacteristicCurveBeginTimestampDialog
extends Alert {
    private final SimpleObjectProperty<Instant> begin = new SimpleObjectProperty();
    private final DateTimePicker changeFromPicker = new DateTimePicker();

    public CharacteristicCurveBeginTimestampDialog(Window window, Set<Instant> disalowedTimestamps, Instant preselectedTimestamp, ITimeRangeFilter timeRangeFilter) {
        super(Alert.AlertType.CONFIRMATION);
        this.initOwner(window);
        this.begin.addListener(il -> this.getDialogPane().lookupButton(ButtonType.OK).setDisable(disalowedTimestamps.contains(this.getBegin())));
        Instant from = preselectedTimestamp.isBefore(timeRangeFilter.getFrom()) ? preselectedTimestamp : timeRangeFilter.getFrom();
        Instant to = preselectedTimestamp.isAfter(timeRangeFilter.getTo()) ? preselectedTimestamp : timeRangeFilter.getTo();
        LocalDate rangeFrom = VirtualZone.INSTANCE.getOffsetDateTime(VirtualRaster.Day.getRasterBegin(from.plusNanos(1L)).minusNanos(1L)).toLocalDate();
        LocalDate rangeTo = VirtualZone.INSTANCE.getOffsetDateTime(VirtualRaster.Day.getRasterEnd(to)).toLocalDate();
        LocalDate preselected = VirtualZone.INSTANCE.getOffsetDateTime(preselectedTimestamp).toLocalDate();
        GridPane pane = new GridPane();
        pane.setVgap(5.0);
        pane.setHgap(10.0);
        Slider slider = new Slider(0.0, (double)Math.max(0L, Duration.between(rangeFrom.atStartOfDay(), rangeTo.atStartOfDay()).toDays()), 0.0);
        slider.setMajorTickUnit(Math.max(1.0, slider.getMax() / 50.0));
        slider.setMinorTickCount(0);
        slider.setSnapToTicks(slider.getMax() <= 50.0);
        slider.setShowTickMarks(true);
        slider.setValue((double)Duration.between(rangeFrom.atStartOfDay(), preselected.atStartOfDay()).toDays());
        slider.valueProperty().addListener((o, ov, nv) -> {
            long nextValue;
            long prevValue = Math.round(ov.doubleValue());
            if (prevValue != (nextValue = Math.round(nv.doubleValue()))) {
                this.sliderMoved(rangeFrom.plusDays(nextValue));
            }
        });
        HBox labelBox = new HBox(new Node[]{this.changeFromPicker});
        labelBox.setAlignment(Pos.CENTER);
        VBox changeFromPane = new VBox(5.0, new Node[]{slider, labelBox});
        GridPane.setHgrow((Node)changeFromPane, (Priority)Priority.ALWAYS);
        pane.addRow(1, new Node[]{new Label(Messages.chart_addons_CharacteristicCurveBeginTimestampDialog_curvebegin), changeFromPane});
        pane.add((Node)new Separator(Orientation.HORIZONTAL), 0, 3, 2, 1);
        this.changeFromPicker.dateTimeValueProperty().addListener((o, ov, nv) -> {
            ZonedDateTime zdt = ZonedDateTime.of(nv, ZoneId.systemDefault());
            this.begin.set((Object)zdt.toInstant());
        });
        this.changeFromPicker.setDateTimeValue(ZonedDateTime.ofInstant(preselectedTimestamp, ZoneId.systemDefault()).toLocalDateTime());
        this.getDialogPane().setContent((Node)pane);
        this.setTitle(Messages.chart_addons_CharacteristicCurveBeginTimestampDialog_titletext);
        this.setHeaderText(Messages.chart_addons_CharacteristicCurveBeginTimestampDialog_headertext);
    }

    private void sliderMoved(LocalDate newDate) {
        this.changeFromPicker.setValue((Object)newDate);
    }

    public Instant getBegin() {
        return (Instant)this.begin.get();
    }
}

