/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.addons;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DFunction;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic2DInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.IChartViewAddon;
import de.elpro.ewms.core.fx.charts.addons.Characteristic2DAdjustCurveDialog;
import de.elpro.ewms.core.fx.charts.addons.Characteristic2DDrawData;
import de.elpro.ewms.core.fx.charts.addons.CharacteristicCurveBeginTimestampDialog;
import de.elpro.ewms.core.fx.charts.skins.Characteristic2DAddonSkin;
import de.elpro.ewms.core.fx.charts.skins.Chart2DDrawData;
import de.elpro.ewms.core.fx.charts.skins.XYChartViewSkin;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.ImageView;
import javax.inject.Inject;

public class Chart2DCharacteristicAddon
implements IChartViewAddon<Characteristic2DDrawData> {
    private final Chart2DView chartView;
    private final ObservableList<Characteristic2DFunctionChange> characteristicCurveChanges = FXCollections.observableArrayList();
    private final ObservableBooleanValue hasChanges = Bindings.isNotEmpty(this.characteristicCurveChanges);
    private Characteristic2DInstance characteristic2dInstance = null;
    private Instant characteristicReferenceTimestamp = null;
    private ITimeRangeFilter lastTimeRangePrefs = null;

    @Inject
    public Chart2DCharacteristicAddon(Chart2DView chartView) {
        this.chartView = chartView;
    }

    public Characteristic2DInstance getCharacteristic2dInstance() {
        return this.characteristic2dInstance;
    }

    public Collection<Characteristic2DFunctionChange> getCharacteristicCurveChanges() {
        return this.characteristicCurveChanges;
    }

    public void addCharacteristicCurveChange(Characteristic2DFunctionChange change) {
        int i = 0;
        while (i < this.characteristicCurveChanges.size()) {
            Characteristic2DFunctionChange oldChange = (Characteristic2DFunctionChange)this.characteristicCurveChanges.get(i);
            if (oldChange.getNewBegin() != null && oldChange.getNewBegin().equals(change.getNewBegin())) {
                this.characteristicCurveChanges.set(i, (Object)change);
                if (!change.getFunction().isEmpty()) {
                    this.characteristic2dInstance.putFunction(change.getNewBegin(), change.getFunction());
                } else {
                    this.characteristic2dInstance.removeFunction(oldChange.getNewBegin());
                }
                return;
            }
            ++i;
        }
        this.characteristicCurveChanges.add((Object)change);
        if (!change.getFunction().isEmpty()) {
            this.characteristic2dInstance.putFunction(change.getNewBegin(), change.getFunction());
        } else {
            this.characteristic2dInstance.removeFunction(change.getOldBegin());
        }
    }

    @Override
    public void installMenuItems(ContextMenu contextMenu) {
        Menu characteristicMenu;
        if (this.getCharacteristic2dInstance() != null) {
            Characteristic2D characteristic2D = this.getCharacteristic2dInstance().getCharacteristic();
            characteristicMenu = new Menu(this.chartView.getConfig().getCharacteristic2DSeries().getResultTitle(), (Node)new ImageView(Characteristic2D.DEFAULT_ICON.toString()));
            characteristicMenu.getItems().add((Object)new MenuItem("<empty>"));
            characteristicMenu.setOnShowing(e -> {
                characteristicMenu.getItems().clear();
                Instant selectedCharacteristicTimestamp = null;
                TreeSet<Instant> beginTimestamps = new TreeSet<Instant>(this.getCharacteristic2dInstance().getFunctionsBeginTimestamps());
                for (Instant beginTs : beginTimestamps) {
                    Instant nextBeginTs = beginTimestamps.ceiling(beginTs.plusNanos(1L));
                    String text = nextBeginTs != null ? String.format(Messages.chart_addons_Characteristic2DAddon_curvetimerange, TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(beginTs, ZoneId.systemDefault())), TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(nextBeginTs, ZoneId.systemDefault()))) : String.format(Messages.chart_addons_Characteristic2DAddon_curvefrom, TimeFormatType.DateTimeHM.format((TemporalAccessor)LocalDateTime.ofInstant(beginTs, ZoneId.systemDefault())));
                    CheckMenuItem item = new CheckMenuItem(text, (Node)new ImageView(Characteristic2DInstance.ENABLED_ICON.toString()));
                    if (beginTs.equals(this.characteristicReferenceTimestamp)) {
                        item.setSelected(true);
                        selectedCharacteristicTimestamp = this.characteristicReferenceTimestamp;
                    } else {
                        item.setOnAction(event -> {
                            this.characteristicReferenceTimestamp = beginTs;
                            this.chartView.reloadData();
                        });
                    }
                    characteristicMenu.getItems().add((Object)item);
                }
                MenuItem adjustPoints = new MenuItem(Messages.chart_addons_Characteristic2DAddon_adjustPoints);
                characteristicMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), adjustPoints});
                adjustPoints.setOnAction(event -> {
                    Characteristic2DFunction function = this.getCharacteristic2dInstance().getFunction(this.characteristicReferenceTimestamp);
                    if (function == null) {
                        function = new Characteristic2DFunction(characteristic2D.getInputMeasuringUnit(), characteristic2D.getOutputMeasuringUnit(), this.characteristic2dInstance.getResultInputValuesBounds(), this.characteristic2dInstance.getResultOutputValuesBounds());
                    }
                    Characteristic2DFunction functionCopy = function.copy();
                    AxisViewPrefs xAxisPrefs = this.chartView.getViewPrefs().getXAxisViewPrefs();
                    AxisViewPrefs yAxisPrefs = this.chartView.getViewPrefs().getYAxisViewPrefs(this.chartView.getConfig().getCharacteristic2DSeries().getYAxis());
                    String xAxisTitle = this.chartView.getConfig().getLocalXAxisTitle();
                    String yAxisTitle = this.chartView.getConfig().getYAxes().stream().filter(y -> y.equals((Object)this.chartView.getConfig().getCharacteristic2DSeries().getYAxis())).findAny().get().getLocalTitle();
                    Characteristic2DAdjustCurveDialog dialog = new Characteristic2DAdjustCurveDialog(this.chartView.getScene().getWindow(), functionCopy, xAxisTitle, xAxisPrefs, yAxisTitle, yAxisPrefs);
                    if (dialog.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.APPLY) {
                        Chart2DDrawData drawData = this.chartView.getChartDrawData();
                        Characteristic2DDrawData c2ddd = new Characteristic2DDrawData();
                        c2ddd.setCharacteristic2DFunction(this.characteristicReferenceTimestamp, functionCopy);
                        drawData.putAddonDrawData(this, c2ddd);
                        this.addCharacteristicCurveChange(new Characteristic2DFunctionChange(this.characteristicReferenceTimestamp, this.characteristicReferenceTimestamp, functionCopy));
                        this.chartView.draw();
                    }
                });
                MenuItem newPoints = new MenuItem(Messages.chart_addons_Characteristic2DAddon_newcurve);
                characteristicMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), newPoints});
                newPoints.setOnAction(event -> {
                    CharacteristicCurveBeginTimestampDialog referenceTimestampDialog = new CharacteristicCurveBeginTimestampDialog(this.chartView.getScene().getWindow(), this.getCharacteristic2dInstance().getFunctionsBeginTimestamps(), this.lastTimeRangePrefs.getTo(), this.lastTimeRangePrefs);
                    if (referenceTimestampDialog.showAndWait().get() == ButtonType.OK) {
                        this.characteristicReferenceTimestamp = referenceTimestampDialog.getBegin();
                        Chart2DDrawData drawData = this.chartView.getChartDrawData();
                        Characteristic2DDrawData c2ddd = new Characteristic2DDrawData();
                        c2ddd.setCharacteristic2DFunction(this.characteristicReferenceTimestamp, new Characteristic2DFunction(characteristic2D.getInputMeasuringUnit(), characteristic2D.getOutputMeasuringUnit(), this.characteristic2dInstance.getResultInputValuesBounds(), this.characteristic2dInstance.getResultOutputValuesBounds()));
                        drawData.putAddonDrawData(this, c2ddd);
                        this.chartView.draw();
                    }
                });
                if (selectedCharacteristicTimestamp != null) {
                    MenuItem changeTimestampItem = new MenuItem(Messages.chart_addons_Characteristic2DAddon_changebegin);
                    characteristicMenu.getItems().add((Object)changeTimestampItem);
                    changeTimestampItem.setOnAction(event -> {
                        CharacteristicCurveBeginTimestampDialog referenceTimestampDialog = new CharacteristicCurveBeginTimestampDialog(this.chartView.getScene().getWindow(), this.getCharacteristic2dInstance().getFunctionsBeginTimestamps(), this.characteristicReferenceTimestamp, this.lastTimeRangePrefs);
                        if (referenceTimestampDialog.showAndWait().get() == ButtonType.OK) {
                            Characteristic2DFunction function = this.getCharacteristic2dInstance().getFunction(this.characteristicReferenceTimestamp);
                            this.addCharacteristicCurveChange(new Characteristic2DFunctionChange(this.characteristicReferenceTimestamp, referenceTimestampDialog.getBegin(), function));
                            this.getCharacteristic2dInstance().removeFunction(this.characteristicReferenceTimestamp);
                            this.characteristicReferenceTimestamp = referenceTimestampDialog.getBegin();
                            Chart2DDrawData drawData = this.chartView.getChartDrawData();
                            Characteristic2DDrawData c2ddd = new Characteristic2DDrawData();
                            c2ddd.setCharacteristic2DFunction(this.characteristicReferenceTimestamp, function);
                            drawData.putAddonDrawData(this, c2ddd);
                            this.chartView.draw();
                        }
                    });
                    MenuItem removeItem = new MenuItem(Messages.chart_addons_Characteristic2DAddon_removecurve);
                    characteristicMenu.getItems().add((Object)removeItem);
                    removeItem.setOnAction(event -> {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.initOwner(this.chartView.getScene().getWindow());
                        alert.setContentText(Messages.chart_addons_Characteristic2DAddon_removeAlertText);
                        if (alert.showAndWait().get() == ButtonType.OK) {
                            this.addCharacteristicCurveChange(new Characteristic2DFunctionChange(this.characteristicReferenceTimestamp, null, new Characteristic2DFunction(characteristic2D.getInputMeasuringUnit(), characteristic2D.getOutputMeasuringUnit(), this.characteristic2dInstance.getResultInputValuesBounds(), this.characteristic2dInstance.getResultOutputValuesBounds())));
                            this.getCharacteristic2dInstance().removeFunction(this.characteristicReferenceTimestamp);
                            Instant nextTimestamp = this.getCharacteristic2dInstance().getFunctionsBeginTimestamps().stream().filter(ts -> ts.isAfter(this.characteristicReferenceTimestamp)).findFirst().orElse(null);
                            this.characteristicReferenceTimestamp = nextTimestamp != null ? nextTimestamp : this.lastTimeRangePrefs.getTo();
                            Chart2DDrawData drawData = this.chartView.getChartDrawData();
                            Characteristic2DDrawData c2ddd = new Characteristic2DDrawData();
                            c2ddd.setCharacteristic2DFunction(this.characteristicReferenceTimestamp, nextTimestamp != null ? this.getCharacteristic2dInstance().getFunction(nextTimestamp) : new Characteristic2DFunction(characteristic2D.getInputMeasuringUnit(), characteristic2D.getOutputMeasuringUnit(), this.characteristic2dInstance.getResultInputValuesBounds(), this.characteristic2dInstance.getResultOutputValuesBounds()));
                            drawData.putAddonDrawData(this, c2ddd);
                            this.chartView.draw();
                        }
                    });
                }
            });
        } else {
            characteristicMenu = null;
        }
        if (characteristicMenu != null) {
            Optional<MenuItem> clearPreferencesItem = contextMenu.getItems().stream().filter(i -> i.getId().equals("chart.menuitem.clearpreferences")).findAny();
            clearPreferencesItem.ifPresent(cpi -> {
                int index = contextMenu.getItems().indexOf(cpi);
                contextMenu.getItems().add(index + 1, (Object)new SeparatorMenuItem());
                contextMenu.getItems().add(index + 2, (Object)characteristicMenu);
            });
        }
    }

    @Override
    public void loadStaticModel(Transaction trx, Chart2D config, StructureObject structureObject) {
        if (config.getCharacteristic2DSeries() != null) {
            this.characteristic2dInstance = Characteristic2DInstanceDAO.get((Transaction)trx, (Characteristic2D)config.getCharacteristic2DSeries().getCharacteristic(), (StructureObject)structureObject);
            if (this.characteristic2dInstance != null) {
                this.characteristic2dInstance.setCharacteristic(config.getCharacteristic2DSeries().getCharacteristic());
            }
        }
    }

    @Override
    public Characteristic2DDrawData loadDrawData(Chart2DViewPrefs chartViewPrefs, ITimeRangeFilter timeRangeFilter) {
        Characteristic2DDrawData dd = new Characteristic2DDrawData();
        if (this.characteristic2dInstance != null) {
            if (this.characteristicReferenceTimestamp == null) {
                this.characteristicReferenceTimestamp = timeRangeFilter.getTo();
            }
            Transaction trx = Transactions.begin();
            try {
                this.characteristic2dInstance = Characteristic2DInstanceDAO.get((Transaction)trx, (int)this.characteristic2dInstance.getId());
                this.characteristic2dInstance.setCharacteristic(Characteristic2DDAO.get((Transaction)trx, (int)this.characteristic2dInstance.getCharacteristic().getId()));
                Instant originalTimestamp = this.characteristic2dInstance.getCurrentFunctionTimestamp(this.characteristicReferenceTimestamp);
                if (originalTimestamp != null) {
                    dd.setCharacteristic2DFunction(originalTimestamp, this.characteristic2dInstance.getFunction(originalTimestamp));
                    this.characteristicReferenceTimestamp = originalTimestamp;
                } else {
                    Characteristic2D characteristic2D = this.characteristic2dInstance.getCharacteristic();
                    dd.setCharacteristic2DFunction(this.characteristicReferenceTimestamp, new Characteristic2DFunction(characteristic2D.getInputMeasuringUnit(), characteristic2D.getOutputMeasuringUnit(), this.characteristic2dInstance.getResultInputValuesBounds(), this.characteristic2dInstance.getResultOutputValuesBounds()));
                }
                this.lastTimeRangePrefs = timeRangeFilter;
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
        return dd;
    }

    @Override
    public ObservableBooleanValue hasChangedProperty() {
        return this.hasChanges;
    }

    @Override
    public void saveChanges(Transaction trx) throws DAOOperationException {
        if (this.characteristic2dInstance != null && !this.characteristicCurveChanges.isEmpty()) {
            Characteristic2DInstanceDAO.applyCurveValuesChanges((Transaction)trx, (Characteristic2DInstance)this.characteristic2dInstance, (Characteristic2DFunctionChange[])((Characteristic2DFunctionChange[])this.characteristicCurveChanges.toArray((Object[])new Characteristic2DFunctionChange[0])));
        }
    }

    @Override
    public void resetChanges() {
        this.characteristicCurveChanges.clear();
    }

    public Characteristic2DAddonSkin createSkin(XYChartViewSkin chartViewSkin) {
        return new Characteristic2DAddonSkin(this, chartViewSkin);
    }
}

