/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.addons;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.snapshot.VariableInstanceSnapshotGroupDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.IChartViewAddon;
import de.elpro.ewms.core.fx.charts.IChartViewAddonSkin;
import de.elpro.ewms.core.fx.charts.LoadCustomSeriesDataCallback;
import de.elpro.ewms.core.fx.charts.skins.XYChartViewSkin;
import de.elpro.ewms.core.fx.dialogs.CreateVariableInstanceSnapshotDialog;
import de.elpro.ewms.core.fx.dialogs.SelectOrEditVariableInstanceSnapshotDialog;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.snapshot.VariableInstanceSnapshotGroup;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.jfree.data.SeriesPoint;
import de.elpro.jfree.data.SeriesPointList;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;

public class Chart2DSnapshotAddon
implements IChartViewAddon<Void> {
    private final Chart2DView chartView;
    private final Window window;
    private final Set<VarSeries2D> snapshotSeries = new HashSet<VarSeries2D>();
    @Inject
    private ThreadSynchronize sync;

    @Inject
    public Chart2DSnapshotAddon(Chart2DView chartView, Scene scene) {
        this.chartView = chartView;
        this.window = scene.getWindow();
    }

    @Override
    public ObservableBooleanValue hasChangedProperty() {
        return new ReadOnlyBooleanWrapper(false);
    }

    @Override
    public void saveChanges(Transaction trx) throws DAOOperationException {
    }

    @Override
    public void resetChanges() {
    }

    @Override
    public void loadStaticModel(Transaction trx, Chart2D chartDefinition, StructureObject structureObject) {
    }

    @Override
    public Void loadDrawData(Chart2DViewPrefs chartViewPrefs, ITimeRangeFilter timeRangeFilter) {
        return null;
    }

    @Override
    public void installMenuItems(ContextMenu contextMenu) {
        Menu snapshotsItem = new Menu(Messages.charts_addon_Chart2DSnapshotAddon_snapshots);
        snapshotsItem.setId("chart.menuitem.createsnapshot");
        Integer insertIndex = 0;
        for (MenuItem item : contextMenu.getItems()) {
            insertIndex = insertIndex + 1;
            if ("chart.menuitem.adjustmenuitemseparator".equals(item.getId())) break;
        }
        contextMenu.getItems().add(insertIndex.intValue(), (Object)snapshotsItem);
        MenuItem createSnapshotItem = new MenuItem(Messages.charts_addon_Chart2DSnapshotAddon_createSnapshot);
        createSnapshotItem.setId("chart.menuitem.createsnapshot");
        createSnapshotItem.setOnAction(e -> {
            RawValuesViewType viewType = this.chartView.getTimeRangeFilter().getType().toRawValueViewType();
            Integer viewIndex = this.chartView.getTimeRangeFilter().getCustomViewIndex();
            Instant fromTs = this.chartView.getTimeRangeFilter().getFrom();
            Instant toTs = this.chartView.getTimeRangeFilter().getTo();
            Raster baseRaster = this.chartView.getViewPrefs().getRaster();
            if (this.chartView.getViewPrefs().getVirtualRaster() != null) {
                baseRaster = Raster.Hour;
            }
            LocalDateTime from = fromTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            LocalDateTime to = toTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            CreateVariableInstanceSnapshotDialog dlg = new CreateVariableInstanceSnapshotDialog(this.window, this.sync, viewType, viewIndex, from, to, null, null, baseRaster, this.chartView.getStaticModelXAxisVariableInstances(), this.chartView.getStaticModelYAxisVariableInstances());
            dlg.showAndWait();
        });
        snapshotsItem.getItems().add((Object)createSnapshotItem);
        MenuItem selectOrDeleteSnapshotItem = new MenuItem(Messages.charts_addon_Chart2DSnapshotAddon_selectSnapshot);
        createSnapshotItem.setId("chart.menuitem.selectordeleteshapshot");
        selectOrDeleteSnapshotItem.setOnAction(e -> {
            Instant toTs;
            LocalDateTime to;
            Instant fromTs = this.chartView.getTimeRangeFilter().getFrom();
            LocalDateTime from = fromTs != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(fromTs.toEpochMilli()), ZoneId.systemDefault()) : null;
            SelectOrEditVariableInstanceSnapshotDialog dlg = new SelectOrEditVariableInstanceSnapshotDialog(this.window, this.sync, null, from, to = (toTs = this.chartView.getTimeRangeFilter().getTo()) != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(toTs.toEpochMilli()), ZoneId.systemDefault()) : null);
            if (dlg.showAndWait().get() == ButtonType.OK) {
                try {
                    List<VariableInstanceSnapshotGroup> groups = dlg.getSelectedGroups();
                    if (groups.size() == 1) {
                        this.addSnapshotGroupSeries(groups.get(0));
                    } else {
                        this.removePreviousSelection();
                    }
                    this.chartView.applyConfig(this.chartView.getConfig());
                    this.chartView.reloadData();
                }
                catch (Exception exc) {
                    ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                    excDlg.initOwner(this.window);
                    excDlg.show();
                }
            }
        });
        snapshotsItem.getItems().add((Object)selectOrDeleteSnapshotItem);
    }

    private void removePreviousSelection() {
        Chart2D config = this.chartView.getConfig();
        for (YAxis yAxis : config.getYAxes()) {
            yAxis.getSeries().removeAll(this.snapshotSeries);
            for (SeriesGroup sg : yAxis.getSeriesGroups()) {
                sg.getSeries().removeAll(this.snapshotSeries);
            }
        }
        this.chartView.getViewPrefs().getSeriesViewPrefs().removeIf(svp -> this.snapshotSeries.contains(svp.getSeries()));
        config.normilize();
        this.snapshotSeries.clear();
    }

    private void addSnapshotGroupSeries(VariableInstanceSnapshotGroup snapshotGroup) throws Exception {
        this.removePreviousSelection();
        Chart2D config = this.chartView.getConfig();
        HashSet<VariableInstance> groupInstances = new HashSet<VariableInstance>(Arrays.asList(VariableInstanceSnapshotGroupDAO.getVariableInstances((VariableInstanceSnapshotGroup)snapshotGroup)));
        Transaction trx = Transactions.begin();
        Map variables = VariableDAO.getAsMap((Transaction)trx, (int[])groupInstances.stream().mapToInt(i -> i.getVariable().getId()).distinct().toArray());
        try {
            for (YAxis yAxis : config.getYAxes()) {
                for (SeriesGroup sg : yAxis.getSeriesGroups()) {
                    LinkedList<VarSeries2D> snapshotGroupSeriesList = new LinkedList<VarSeries2D>();
                    for (VarSeries2D series : sg.getSeries()) {
                        VariableInstance[] yAxisInstances;
                        VariableInstance[] variableInstanceArray = yAxisInstances = this.chartView.getStaticModelYAxisVariableInstances(series);
                        int n = yAxisInstances.length;
                        int n2 = 0;
                        while (n2 < n) {
                            VariableInstance xAxisInstance;
                            VariableInstance yAxisInstance = variableInstanceArray[n2];
                            if (groupInstances.contains(yAxisInstance) && ((xAxisInstance = this.chartView.getStaticModelXAxisVariableInstance(series, yAxisInstance)) == null || groupInstances.contains(xAxisInstance))) {
                                String snapshotGroupTitle;
                                MeasuringUnit xAxisVarMU = xAxisInstance != null ? ((Variable)variables.get(xAxisInstance.getVariable().getId())).getMeasuringUnit() : null;
                                MeasuringUnit yAxisVarMU = ((Variable)variables.get(yAxisInstance.getVariable().getId())).getMeasuringUnit();
                                String seriesTitle = series.getLocalTitle();
                                if (seriesTitle == null || seriesTitle.isBlank()) {
                                    seriesTitle = series.getResultTitle();
                                }
                                if ((snapshotGroupTitle = snapshotGroup.getLocalName()) == null || snapshotGroupTitle.isBlank()) {
                                    snapshotGroupTitle = TimeFormatType.DateTimeHMs.format((TemporalAccessor)LocalDateTime.ofInstant(snapshotGroup.getTimestamp(), ZoneId.systemDefault()));
                                }
                                String title = String.format("%s (%s)", seriesTitle, snapshotGroupTitle);
                                VarSeries2D snapshotGroupSeries = new VarSeries2D(title, true, series.getDefaultColor(), series.getLineType(), series.getLineWidth(), series.getShapeType(), series.getShapeSize());
                                IVarValuesCollection xAxisVarValues = xAxisInstance != null ? VariableInstanceSnapshotGroupDAO.getSnapshotVarValues((Transaction)trx, (VariableInstanceSnapshotGroup)snapshotGroup, (VariableInstance)xAxisInstance) : null;
                                IVarValuesCollection yAxisVarValues = VariableInstanceSnapshotGroupDAO.getSnapshotVarValues((Transaction)trx, (VariableInstanceSnapshotGroup)snapshotGroup, (VariableInstance)yAxisInstance);
                                LoadSnapshotSeriesDataCallback lssdc = new LoadSnapshotSeriesDataCallback(xAxisVarValues, xAxisVarMU, yAxisVarValues, yAxisVarMU);
                                this.chartView.setOnLoadCustomSeriesData(snapshotGroupSeries, lssdc, yAxisInstance.getStructureObject());
                                snapshotGroupSeriesList.add(snapshotGroupSeries);
                            }
                            ++n2;
                        }
                    }
                    sg.getSeries().addAll(snapshotGroupSeriesList);
                    yAxis.getSeries().addAll(snapshotGroupSeriesList);
                    this.snapshotSeries.addAll(snapshotGroupSeriesList);
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Override
    public IChartViewAddonSkin<Void> createSkin(XYChartViewSkin skin) {
        return null;
    }

    private static final class LoadSnapshotSeriesDataCallback
    implements LoadCustomSeriesDataCallback {
        private final IVarValuesCollection xAxisVarValues;
        private final MeasuringUnit xAxisVarMU;
        private final IVarValuesCollection yAxisVarValues;
        private final MeasuringUnit yAxisVarMU;

        public LoadSnapshotSeriesDataCallback(IVarValuesCollection xAxisVarValues, MeasuringUnit xAxisVarMU, IVarValuesCollection yAxisVarValues, MeasuringUnit yAxisVarMU) {
            this.xAxisVarValues = xAxisVarValues;
            this.xAxisVarMU = xAxisVarMU;
            this.yAxisVarValues = yAxisVarValues;
            this.yAxisVarMU = yAxisVarMU;
        }

        @Override
        public List<SeriesPoint> loadData(VarSeries2D customSeries, StructureObject structureObject, MeasuringUnit xAxisDisplayMU, MeasuringUnit yAxisDisplayMU, ITimeRangeFilter timeRangeFilter) {
            TimeRange timeRange = timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView ? null : timeRangeFilter.getTimeRange(null);
            SeriesPointList spList = Chart2DView.toSeriesPoints(this.xAxisVarValues, this.xAxisVarMU, xAxisDisplayMU, false, this.yAxisVarValues, this.yAxisVarMU, yAxisDisplayMU, false, timeRange, null, false);
            return spList;
        }
    }
}

