/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.YAxisLocation;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.CrosshairValueChangedListener;
import de.elpro.ewms.core.fx.charts.DefaultJFreeChartTheme;
import de.elpro.ewms.core.fx.charts.skins.Chart2DDrawData;
import de.elpro.ewms.core.fx.charts.skins.Chart2DViewSkinBase;
import de.elpro.ewms.core.fx.jfree.IOptionalItemColorRenderer;
import de.elpro.ewms.core.fx.jfree.LayeredBarRenderer;
import de.elpro.ewms.core.fx.jfree.LevelRenderer;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.jfree.chart.axis.UnzoomableNumberAxis;
import de.elpro.jfree.data.SeriesPoint;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.util.Pair;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChartViewSkin
extends Chart2DViewSkinBase {
    private final CategoryPlot plot;
    private final JFreeChart chart;
    private final ChartViewer chartViewer;
    private final ProgressIndicatorPane progressIndicator;
    private final CategoryAxis xAxis;
    private final Map<YAxis, UnzoomableNumberAxis> yAxesToNumberAxisMap = new HashMap<YAxis, UnzoomableNumberAxis>();
    private final Map<SeriesGroup, CategoryDataset> datasets = new HashMap<SeriesGroup, CategoryDataset>();
    private final Map<SeriesGroup, Integer> datasetIndexes = new HashMap<SeriesGroup, Integer>();
    private final Map<SeriesGroup, CategoryItemRenderer> renderers = new HashMap<SeriesGroup, CategoryItemRenderer>();

    public BarChartViewSkin(Chart2DView control) {
        super(control);
        XAxisType xAxisType = control.getConfig().getXAxisType();
        String xAxisTitle = control.getConfig().getLocalXAxisTitle();
        this.xAxis = new CategoryAxis(xAxisTitle);
        this.plot = new CategoryPlot();
        this.chart = new JFreeChart(control.getTitle(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        DefaultJFreeChartTheme.getChartTheme().apply(this.chart);
        this.plot.setDomainCrosshairVisible(true);
        if (xAxisType == XAxisType.Variable) {
            this.plot.setRangeCrosshairVisible(true);
            this.plot.setRangePannable(true);
        }
        this.chartViewer = new ChartViewer(this.chart);
        this.progressIndicator = new ProgressIndicatorPane((Node)this.chartViewer);
        this.getChildren().add((Object)this.progressIndicator);
    }

    @Override
    public void updateChartConfig() throws IllegalConfigException {
        this.initAxes(((Chart2DView)this.getSkinnable()).getConfig().getYAxes());
    }

    @Override
    public ProgressIndicatorPane getProgressIndicatorPane() {
        return this.progressIndicator;
    }

    @Override
    public Region getViewContent() {
        return this.chartViewer;
    }

    @Override
    public Object getExportableElement() {
        return this.chart;
    }

    @Override
    public void clearSelection() {
    }

    @Override
    public void setCrosshairValueChangedListener(CrosshairValueChangedListener listener) {
    }

    @Override
    public void setCrosshairPosition(double xVal, Double yVal) {
    }

    public void initAxes(Collection<YAxis> yAxes) throws IllegalConfigException {
        int yAxisIndex = 0;
        int datasetIndex = 0;
        if (yAxes.isEmpty()) {
            throw new IllegalConfigException("No Y-Axes defined");
        }
        double[] widthes = new double[(int)yAxes.stream().filter(a -> !a.getSeries().isEmpty() && !a.getSeriesGroups().isEmpty()).count()];
        int i = widthes.length - 1;
        while (i >= 0) {
            widthes[i] = 1.0 * Math.pow(0.8, widthes.length - 1 - i);
            --i;
        }
        int index = 0;
        for (YAxis yAxis : yAxes) {
            if (yAxis.getSeriesGroups().isEmpty() && yAxis.getSeries().isEmpty()) continue;
            UnzoomableNumberAxis valueAxis = new UnzoomableNumberAxis(yAxis.getLocalTitle());
            DefaultJFreeChartTheme.getChartTheme().applyToRangeAxis((ValueAxis)valueAxis);
            this.plot.setRangeAxis(yAxisIndex, (ValueAxis)valueAxis);
            this.plot.setRangeAxisLocation(yAxisIndex, yAxis.getAxisLocation() == YAxisLocation.Left ? AxisLocation.BOTTOM_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
            if (yAxis.getAxisLocation() == YAxisLocation.Right) {
                valueAxis.setLabelAngle(Math.PI);
            }
            if (yAxis.getColor() != null) {
                Color awtColor = FXUtils.getAwtColor((Paint)yAxis.getColor());
                valueAxis.setLabelPaint((java.awt.Paint)awtColor);
                valueAxis.setTickLabelPaint((java.awt.Paint)awtColor);
            }
            this.yAxesToNumberAxisMap.put(yAxis, valueAxis);
            for (SeriesGroup seriesGroup : yAxis.getSeriesGroups()) {
                Object renderer;
                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                switch (seriesGroup.getType()) {
                    case Bar: {
                        renderer = new MultiaxedBarRender();
                        ((BarRenderer)renderer).setItemMargin(0.1);
                        ((BarRenderer)renderer).setMaximumBarWidth(widthes[index++]);
                        break;
                    }
                    case OverlayedBar: {
                        renderer = new LayeredBarRenderer();
                        break;
                    }
                    case StackedBar: {
                        renderer = new StackedBarRenderer();
                        break;
                    }
                    case LevelBar: {
                        renderer = new LevelRenderer();
                        break;
                    }
                    default: {
                        renderer = new MultiaxedBarRender();
                    }
                }
                if (renderer instanceof BarRenderer) {
                    ((BarRenderer)renderer).setDrawBarOutline(false);
                    ((BarRenderer)renderer).setShadowVisible(false);
                    ((BarRenderer)renderer).setBarPainter((BarPainter)new StandardBarPainter());
                }
                renderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)new BarItemLabelGenerator());
                renderer.setDefaultItemLabelsVisible(false);
                renderer.setDefaultToolTipGenerator(new CategoryToolTipGenerator(){

                    public String generateToolTip(CategoryDataset dataset, int row, int column) {
                        Comparable rowKey = dataset.getRowKey(row);
                        Comparable columnKey = dataset.getColumnKey(column);
                        String rowText = rowKey.toString().replaceAll("\r\n", " ");
                        String s = String.format("%s (%s): %f\r\n", rowText, columnKey, dataset.getValue(row, column));
                        return s;
                    }
                });
                this.datasets.put(seriesGroup, (CategoryDataset)dataset);
                this.datasetIndexes.put(seriesGroup, datasetIndex);
                this.renderers.put(seriesGroup, (CategoryItemRenderer)renderer);
                this.plot.setRenderer(datasetIndex, (CategoryItemRenderer)renderer);
                this.plot.setDataset(datasetIndex, (CategoryDataset)dataset);
                this.plot.mapDatasetToRangeAxis(datasetIndex, yAxisIndex);
                ++datasetIndex;
            }
            ++yAxisIndex;
        }
        this.plot.setDomainAxis(this.xAxis);
    }

    public JFreeChart getJFreeChart() {
        return this.chart;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void applyAxisPrefs(AxisViewPrefs prefs) {
        ValueAxis axis = (ValueAxis)this.yAxesToNumberAxisMap.get(prefs.getYAxis());
        axis.setLabel(prefs.getFullTitle());
        if (prefs.getLowerRange() != null && prefs.getUpperRange() != null && prefs.getLowerRange() < prefs.getUpperRange()) {
            axis.setAutoRange(false);
            if (axis instanceof UnzoomableNumberAxis) {
                ((UnzoomableNumberAxis)axis).setOriginalLowerBound(Double.valueOf(prefs.getLowerRange()));
                ((UnzoomableNumberAxis)axis).setOriginalUpperBound(Double.valueOf(prefs.getUpperRange()));
            } else {
                axis.setLowerBound(prefs.getLowerRange().doubleValue());
                axis.setUpperBound(prefs.getUpperRange().doubleValue());
            }
        } else {
            if (axis instanceof UnzoomableNumberAxis) {
                ((UnzoomableNumberAxis)axis).setOriginalLowerBound(null);
                ((UnzoomableNumberAxis)axis).setOriginalUpperBound(null);
            }
            axis.setAutoRange(true);
            if (axis instanceof UnzoomableNumberAxis) {
                ((UnzoomableNumberAxis)axis).setAutoRangeIncludesZero(false);
            }
        }
    }

    public ContextMenu getContextMenu() {
        return this.chartViewer.getContextMenu();
    }

    protected void removeAllSeries() {
        for (CategoryDataset dataset : this.datasets.values()) {
            ((DefaultCategoryDataset)dataset).clear();
        }
    }

    @Override
    public void draw(Chart2DDrawData chartDrawData) {
        ComplexRaster complexRaster = chartDrawData.getRaster();
        boolean saved = this.plot.isNotify();
        this.plot.setNotify(false);
        this.plot.setDomainCrosshairColumnKey(null, false);
        this.plot.setDomainCrosshairRowKey(null, false);
        this.removeAllSeries();
        AxisViewPrefs xAxisPrefs = ((Chart2DView)this.getSkinnable()).getViewPrefs().getXAxisViewPrefs();
        XAxisType xAxisType = ((Chart2DView)this.getSkinnable()).getConfig().getXAxisType();
        List yAxesPrefs = ((Chart2DView)this.getSkinnable()).getViewPrefs().getYAxesViewPrefs();
        if (complexRaster != ComplexRaster.OVERALL) {
            HashMap<SeriesGroup, LinkedList<Pair>> newSeries = new HashMap<SeriesGroup, LinkedList<Pair>>();
            HashSet<YAxis> visibleYAxes = new HashSet<YAxis>();
            for (Series2DViewPrefs series2DViewPrefs : chartDrawData.getSeriesViewPrefs()) {
                VarSeries2D varSeries = series2DViewPrefs.getSeries();
                SeriesGroup seriesGroup = varSeries.getSeriesGroup();
                YAxis yAxis = varSeries.getYAxis();
                visibleYAxes.add(yAxis);
                String seriesTitle = this.createSeriesTitle(series2DViewPrefs);
                Object seriesList = (LinkedList<Pair>)newSeries.get(seriesGroup);
                if (seriesList == null) {
                    seriesList = new LinkedList<Pair>();
                    newSeries.put(seriesGroup, (LinkedList<Pair>)seriesList);
                }
                seriesList.add(new Pair((Object)seriesTitle, chartDrawData.getSeriesPoints(series2DViewPrefs)));
                this.setupSeriesStyle(this.datasetIndexes.get(seriesGroup), seriesList.size() - 1, series2DViewPrefs);
            }
            if (xAxisPrefs != null && xAxisType == XAxisType.Variable) {
                this.applyAxisPrefs(xAxisPrefs);
            }
            for (AxisViewPrefs axisViewPrefs : yAxesPrefs) {
                this.applyAxisPrefs(axisViewPrefs);
            }
            for (Map.Entry entry : this.yAxesToNumberAxisMap.entrySet()) {
                ((UnzoomableNumberAxis)entry.getValue()).setVisible(visibleYAxes.contains(entry.getKey()));
            }
            for (Map.Entry entry : newSeries.entrySet()) {
                SeriesGroup seriesGroup = (SeriesGroup)entry.getKey();
                DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
                Integer datasetIndex = this.datasetIndexes.get(seriesGroup);
                for (Pair seriesPoints : (List)entry.getValue()) {
                    String seriesName = (String)seriesPoints.getKey();
                    for (SeriesPoint seriesPoint : (List)seriesPoints.getValue()) {
                        Instant rasterBegin = complexRaster.getRasterBegin(Instant.ofEpochMilli(seriesPoint.getTimestamp()));
                        OffsetDateTime localTime = VirtualZone.INSTANCE.getOffsetDateTime(rasterBegin);
                        String label = complexRaster.getVirtualRaster() != null ? complexRaster.getVirtualRaster().getDefaultFormatType().format((TemporalAccessor)localTime) : TimeFormatType.DateTimeHMs.format((TemporalAccessor)localTime);
                        newDataset.addValue(seriesPoint.getYValue() != null ? seriesPoint.getYValue() : 0.0, (Comparable)((Object)seriesName), (Comparable)((Object)label));
                    }
                }
                this.datasets.put(seriesGroup, (CategoryDataset)newDataset);
                this.plot.setDataset(datasetIndex.intValue(), (CategoryDataset)newDataset);
            }
        } else {
            HashMap newSeries = new HashMap();
            HashSet<YAxis> visibleYAxes = new HashSet<YAxis>();
            for (Series2DViewPrefs series2DViewPrefs : chartDrawData.getSeriesViewPrefs()) {
                SeriesPoint seriesPoint = chartDrawData.getSeriesPoints(series2DViewPrefs).get(0);
                VarSeries2D varSeries = series2DViewPrefs.getSeries();
                SeriesGroup seriesGroup = varSeries.getSeriesGroup();
                YAxis yAxis = varSeries.getYAxis();
                visibleYAxes.add(yAxis);
                LinkedList<Pair> seriesList = (LinkedList<Pair>)newSeries.get(seriesGroup);
                if (seriesList == null) {
                    seriesList = new LinkedList<Pair>();
                    newSeries.put(seriesGroup, seriesList);
                }
                StructureObject prefsObject = series2DViewPrefs.getVariableInstance() != null ? series2DViewPrefs.getVariableInstance().getStructureObject() : series2DViewPrefs.getCustomDataStructureObject();
                seriesList.add(new Pair((Object)new Pair((Object)varSeries, (Object)prefsObject), (Object)seriesPoint));
                CategoryItemRenderer renderer = this.renderers.get(seriesGroup);
                if (!(renderer instanceof IOptionalItemColorRenderer) || series2DViewPrefs.getColor() == null) continue;
                int column = seriesGroup.getSeries().indexOf(varSeries);
                int row = (int)seriesList.stream().filter(e -> ((VarSeries2D)((Pair)e.getKey()).getKey()).equals((Object)varSeries)).count() - 1;
                ((IOptionalItemColorRenderer)renderer).setItemPaint(column, row, series2DViewPrefs.getAwtColor());
            }
            for (Map.Entry entry : this.datasetIndexes.entrySet()) {
                CategoryItemRenderer renderer = this.renderers.get(entry.getKey());
                int index = 0;
                for (VarSeries2D series : ((SeriesGroup)entry.getKey()).getSeries()) {
                    if (series.getDefaultColor() == null) continue;
                    renderer.setSeriesPaint(index++, (java.awt.Paint)FXUtils.getAwtColor((Paint)series.getDefaultColor()));
                }
            }
            if (xAxisPrefs != null && xAxisType == XAxisType.Variable) {
                this.applyAxisPrefs(xAxisPrefs);
            }
            for (AxisViewPrefs axisViewPrefs : yAxesPrefs) {
                this.applyAxisPrefs(axisViewPrefs);
            }
            for (Map.Entry entry : this.yAxesToNumberAxisMap.entrySet()) {
                ((UnzoomableNumberAxis)entry.getValue()).setVisible(visibleYAxes.contains(entry.getKey()));
            }
            for (Map.Entry entry : newSeries.entrySet()) {
                SeriesGroup seriesGroup = (SeriesGroup)entry.getKey();
                DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
                Integer datasetIndex = this.datasetIndexes.get(seriesGroup);
                for (Pair seriesPoints : (List)entry.getValue()) {
                    VarSeries2D varSeries = (VarSeries2D)((Pair)seriesPoints.getKey()).getKey();
                    StructureObject object = (StructureObject)((Pair)seriesPoints.getKey()).getValue();
                    SeriesPoint seriesPoint = (SeriesPoint)seriesPoints.getValue();
                    newDataset.addValue(seriesPoint.getYValue() != null ? seriesPoint.getYValue() : 0.0, (Comparable)((Object)varSeries.getResultTitle()), (Comparable)((Object)object.getLocalName()));
                }
                this.datasets.put(seriesGroup, (CategoryDataset)newDataset);
                this.plot.setDataset(datasetIndex.intValue(), (CategoryDataset)newDataset);
            }
        }
        this.plot.setNotify(saved);
    }

    private void setupSeriesStyle(int rendererIndex, int index, Series2DViewPrefs style) {
        if (style.getColor() != null) {
            CategoryItemRenderer renderer = this.plot.getRenderer(rendererIndex);
            javafx.scene.paint.Color color = style.getColor().deriveColor(1.0, 1.0, Math.pow(0.85, rendererIndex), 1.0);
            renderer.setSeriesPaint(index, (java.awt.Paint)FXUtils.getAwtColor((Paint)color), false);
        }
    }

    protected class BarItemLabelGenerator
    extends StandardCategoryItemLabelGenerator {
        private static final long serialVersionUID = -7127207798437038319L;

        public String generateLabel(CategoryDataset dataset, int row, int column) {
            Number value = dataset.getValue(row, column);
            return value != null ? NumberFormats.getOptimalShortFormat((double)value.doubleValue()).format(value.doubleValue()) : null;
        }
    }

    public static class MultiaxedBarRender
    extends BarRenderer {
        private static final long serialVersionUID = 5005151257676509122L;

        protected void calculateBarWidth(CategoryPlot plot, Rectangle2D dataArea, int rendererIndex, CategoryItemRendererState state) {
            CategoryAxis domainAxis = this.getDomainAxis(plot, rendererIndex);
            CategoryDataset dataset = plot.getDataset(rendererIndex);
            if (dataset != null) {
                int columns = dataset.getColumnCount();
                int rows = state.getVisibleSeriesCount() >= 0 ? state.getVisibleSeriesCount() : dataset.getRowCount();
                double space = 0.0;
                PlotOrientation orientation = plot.getOrientation();
                if (orientation == PlotOrientation.HORIZONTAL) {
                    space = dataArea.getHeight();
                } else if (orientation == PlotOrientation.VERTICAL) {
                    space = dataArea.getWidth();
                }
                double maxWidth = space * this.getMaximumBarWidth();
                double categoryMargin = 0.0;
                double currentItemMargin = 0.0;
                if (columns > 1) {
                    categoryMargin = domainAxis.getCategoryMargin();
                }
                if (rows > 1) {
                    currentItemMargin = this.getItemMargin();
                }
                double used = maxWidth * (1.0 - domainAxis.getLowerMargin() - domainAxis.getUpperMargin() - categoryMargin - currentItemMargin);
                if (rows * columns > 0) {
                    state.setBarWidth(Math.min(used / (double)(rows * columns), maxWidth));
                } else {
                    state.setBarWidth(Math.min(used, maxWidth));
                }
            }
        }
    }
}

