/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DFunction;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.charts.Characteristic2DSeries;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.IChartViewAddonSkin;
import de.elpro.ewms.core.fx.charts.addons.Characteristic2DDrawData;
import de.elpro.ewms.core.fx.charts.addons.Chart2DCharacteristicAddon;
import de.elpro.ewms.core.fx.charts.skins.CharacteristicView;
import de.elpro.ewms.core.fx.charts.skins.Chart2DDrawData;
import de.elpro.ewms.core.fx.charts.skins.XYChartTooltipGenerator;
import de.elpro.ewms.core.fx.charts.skins.XYChartViewSkin;
import de.elpro.ewms.core.fx.charts.skins.XYTimeSeries;
import de.elpro.ewms.core.fx.jfree.EfficientXYLineAndOptionalShapeRenderer;
import de.elpro.jfree.chart.axis.UnzoomableNumberAxis;
import de.elpro.jfree.chart.plot.UnzoomableXYPlot;
import de.elpro.ui.fx.utils.FXUtils;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Collection;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Characteristic2DAddonSkin
implements IChartViewAddonSkin<Characteristic2DDrawData> {
    private final Chart2DCharacteristicAddon addon;
    private final XYChartViewSkin chartViewSkin;
    private final Chart2DView chartView;
    private final ChartViewer chartViewer;
    private final UnzoomableXYPlot plot;
    private Characteristic2DSeries characteristic2DSeries;
    private CharacteristicView characteristicView;
    private EfficientXYLineAndOptionalShapeRenderer characteristicRenderer;
    private XYSeriesCollection characteristicDataset;
    private Integer characteristicDatasetIndex = null;

    public Characteristic2DAddonSkin(Chart2DCharacteristicAddon addon, XYChartViewSkin chartViewSkin) {
        this.addon = addon;
        this.chartViewSkin = chartViewSkin;
        this.chartView = (Chart2DView)chartViewSkin.getSkinnable();
        this.chartViewer = chartViewSkin.getViewContent();
        this.plot = chartViewSkin.getPlot();
    }

    @Override
    public int initAxes(int datasetCount, Collection<YAxis> yAxes) {
        Chart2D config = this.chartView.getConfig();
        if (config.getCharacteristic2DSeries() == null) {
            return datasetCount;
        }
        for (YAxis yAxis : yAxes) {
            if (!yAxis.equals((Object)config.getCharacteristic2DSeries().getYAxis())) continue;
            UnzoomableNumberAxis valueAxis = this.chartViewSkin.getOrCreateNumberAxis(yAxis);
            this.characteristicDataset = new XYSeriesCollection();
            this.characteristicRenderer = new EfficientXYLineAndOptionalShapeRenderer();
            this.characteristicRenderer.setUseFillPaint(true);
            this.characteristicRenderer.setDefaultToolTipGenerator(new XYChartTooltipGenerator(yAxis, this.chartView));
            this.characteristicDatasetIndex = datasetCount;
            this.chartViewSkin.addDatasetToNumberAxis(datasetCount++, (XYDataset)this.characteristicDataset, valueAxis, (XYItemRenderer)this.characteristicRenderer);
        }
        return datasetCount;
    }

    @Override
    public void draw(Chart2DDrawData chartDrawData) {
        if (this.chartView == null) {
            return;
        }
        if (this.characteristicView != null) {
            this.chartViewer.getCanvas().removeMouseHandler(this.characteristicView.getMouseHandler());
            this.chartViewer.getCanvas().clearLiveHandler();
            this.chartViewer.setOnKeyPressed(null);
        } else {
            this.chartViewer.getCanvas().addEventFilter(MouseEvent.ANY, e -> this.chartViewer.getCanvas().requestFocus());
        }
        Characteristic2DInstance characteristic2dInstance = this.addon.getCharacteristic2dInstance();
        if (characteristic2dInstance == null) {
            return;
        }
        Chart2D config = this.chartView.getConfig();
        if (config.getCharacteristic2DSeries() == null || config.getXAxisType() != XAxisType.Variable) {
            return;
        }
        this.characteristic2DSeries = config.getCharacteristic2DSeries();
        UnzoomableNumberAxis rangeAxis = this.chartViewSkin.getOrCreateNumberAxis(this.characteristic2DSeries.getYAxis());
        if (rangeAxis == null) {
            return;
        }
        rangeAxis.setVisible(true);
        Characteristic2D characteristic2d = this.characteristic2DSeries.getCharacteristic();
        Characteristic2DDrawData c2ddd = chartDrawData.getAddonDrawData(this.addon);
        Characteristic2DFunction curve = c2ddd != null && c2ddd.getCharacteristic2DFunction() != null ? c2ddd.getCharacteristic2DFunction() : new Characteristic2DFunction(characteristic2d.getInputMeasuringUnit(), characteristic2d.getOutputMeasuringUnit(), characteristic2dInstance.getResultInputValuesBounds(), characteristic2dInstance.getResultOutputValuesBounds());
        Runnable applyChangesCallback = () -> {
            curve.commitChanges();
            this.addon.addCharacteristicCurveChange(new Characteristic2DFunctionChange(c2ddd.getCharacteristicCurveTimestamp(), c2ddd.getCharacteristicCurveTimestamp(), curve));
        };
        this.characteristicView = new CharacteristicView(curve, (XYPlot)this.plot, this.characteristicRenderer, (ValueAxis)rangeAxis, this.chartViewer, this.chartView, () -> this.chartViewSkin.updateAxisBounds(), applyChangesCallback);
        this.chartViewer.getCanvas().addMouseHandler(this.characteristicView.getMouseHandler());
        this.chartViewer.getCanvas().removeAuxiliaryMouseHandler(this.chartViewer.getCanvas().getMouseHandler("anchor"));
        this.chartViewer.getCanvas().setOnKeyReleased(this.characteristicView.getKeyHandler());
        XYTimeSeries series = this.characteristicView.getClickSeries();
        this.characteristicDataset = new XYSeriesCollection();
        EfficientXYLineAndOptionalShapeRenderer lineAndShapeRenderer = this.characteristicRenderer;
        Stroke stroke = LineType.Solid.createStroke(2.0f);
        Color characteristicColor = this.characteristic2DSeries.getDefaultColor() != null ? FXUtils.getAwtColor((Paint)this.characteristic2DSeries.getDefaultColor()) : Color.RED;
        lineAndShapeRenderer.setSeriesPaint(0, characteristicColor);
        lineAndShapeRenderer.setSeriesLinesVisible(0, true);
        lineAndShapeRenderer.setSeriesStroke(0, stroke);
        lineAndShapeRenderer.setSeriesFillPaint(0, Color.WHITE);
        this.characteristicDataset.addSeries((XYSeries)series);
        this.plot.setDataset(this.characteristicDatasetIndex.intValue(), (XYDataset)this.characteristicDataset);
    }

    @Override
    public void removeAllSeries() {
        if (this.characteristicDataset != null) {
            this.characteristicDataset.removeAllSeries();
        }
    }
}

