/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.characteristic.Characteristic2DFunction;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.skins.XYTimeSeries;
import de.elpro.ewms.core.fx.jfree.EfficientXYLineAndOptionalShapeRenderer;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.time.Instant;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.fx.ChartCanvas;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.fx.interaction.MouseHandlerFX;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;

public class CharacteristicView {
    private final XYTimeSeries clickSeries;
    private final XYPlot plot;
    private final ChartViewer chartViewer;
    private final Chart2DView chartView;
    private final Characteristic2DFunction function;
    private final ValueAxis domainAxis;
    private final ValueAxis rangeAxis;
    private final EfficientXYLineAndOptionalShapeRenderer renderer;
    private Characteristic2DFunction.FunctionPoint currentPoint;
    private final Runnable updateRangesCallback;
    private final Runnable applyChangesCallback;
    private boolean pointDraged = false;
    private EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if ((event.getCode() == KeyCode.DELETE || event.getCode() == KeyCode.BACK_SPACE) && CharacteristicView.this.currentPoint != null) {
                CharacteristicView.this.function.removePoint(CharacteristicView.this.currentPoint);
                double input = CharacteristicView.this.currentPoint.getInput();
                CharacteristicView.this.currentPoint = CharacteristicView.this.function.getFloorPoint(input);
                if (CharacteristicView.this.currentPoint == null) {
                    CharacteristicView.this.currentPoint = CharacteristicView.this.function.getCeilingPoint(input);
                }
                CharacteristicView.this.applyChangesCallback.run();
                CharacteristicView.this.clickSeries.setNotify(false);
                CharacteristicView.this.updateSeriesPoints();
                CharacteristicView.this.clickSeries.setNotify(true);
            }
        }
    };
    private final MouseHandlerFX mouseHandler = new MouseHandlerFX(){

        public String getID() {
            return "EOS.Characteristic";
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean hasMatchingModifiers(MouseEvent e) {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1) {
                MeasuringUnitValue yEpsilon;
                MeasuringUnitValue xEpsilon;
                MeasuringUnitValue outputValue;
                ClickData clickData = CharacteristicView.this.getClickData(e);
                MeasuringUnitValue inputValue = new MeasuringUnitValue(CharacteristicView.this.getXAxisViewPrefs().getMeasuringUnit(), clickData.getChartX());
                if (CharacteristicView.this.function.findPoint(inputValue, outputValue = new MeasuringUnitValue(CharacteristicView.this.getYAxisViewPrefs().getMeasuringUnit(), clickData.getChartY()), xEpsilon = new MeasuringUnitValue(CharacteristicView.this.getXAxisViewPrefs().getMeasuringUnit(), clickData.getXEpsilon()), yEpsilon = new MeasuringUnitValue(CharacteristicView.this.getYAxisViewPrefs().getMeasuringUnit(), clickData.getYEpsilon())) != null) {
                    return true;
                }
                if (CharacteristicView.this.function.canInsertPoint(inputValue, outputValue, xEpsilon, yEpsilon)) {
                    return true;
                }
            }
            return false;
        }

        public void handleScroll(ChartCanvas canvas, ScrollEvent e) {
        }

        public void handleMouseReleased(ChartCanvas canvas, MouseEvent e) {
            if (CharacteristicView.this.currentPoint != null) {
                boolean updateRanges = CharacteristicView.this.pointDraged;
                if (updateRanges && CharacteristicView.this.function.size() > 1) {
                    double x = CharacteristicView.this.currentPoint.getInput();
                    double y = CharacteristicView.this.currentPoint.getOutput();
                    double minX = Double.POSITIVE_INFINITY;
                    double minY = Double.POSITIVE_INFINITY;
                    double maxX = Double.NEGATIVE_INFINITY;
                    double maxY = Double.NEGATIVE_INFINITY;
                    for (Characteristic2DFunction.FunctionPoint point : CharacteristicView.this.function.getPoints()) {
                        if (point.equals((Object)CharacteristicView.this.currentPoint)) continue;
                        minX = Math.min(minX, point.getInput());
                        maxX = Math.max(maxX, point.getInput());
                        minY = Math.min(minY, point.getOutput());
                        maxY = Math.max(maxY, point.getOutput());
                    }
                    updateRanges = !new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY).contains(x, y);
                }
                CharacteristicView.this.applyChangesCallback.run();
                if (updateRanges) {
                    CharacteristicView.this.updateRangesCallback.run();
                }
            }
            CharacteristicView.this.pointDraged = false;
            canvas.clearLiveHandler();
        }

        public void handleMousePressed(ChartCanvas canvas, MouseEvent e) {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1) {
                ClickData clickData = CharacteristicView.this.getClickData(e);
                MeasuringUnitValue inputValue = new MeasuringUnitValue(CharacteristicView.this.getXAxisViewPrefs().getMeasuringUnit(), clickData.getChartX());
                MeasuringUnitValue outputValue = new MeasuringUnitValue(CharacteristicView.this.getYAxisViewPrefs().getMeasuringUnit(), clickData.getChartY());
                MeasuringUnitValue xEpsilon = new MeasuringUnitValue(CharacteristicView.this.getXAxisViewPrefs().getMeasuringUnit(), clickData.getXEpsilon());
                MeasuringUnitValue yEpsilon = new MeasuringUnitValue(CharacteristicView.this.getYAxisViewPrefs().getMeasuringUnit(), clickData.getYEpsilon());
                CharacteristicView.this.currentPoint = CharacteristicView.this.function.findPoint(inputValue, outputValue, xEpsilon, yEpsilon);
                if (CharacteristicView.this.currentPoint == null) {
                    CharacteristicView.this.currentPoint = CharacteristicView.this.function.addPoint(inputValue, outputValue);
                }
                CharacteristicView.this.plot.setNotify(false);
                CharacteristicView.this.updateSeriesPoints();
                CharacteristicView.this.plot.setNotify(true);
            }
        }

        public void handleMouseMoved(ChartCanvas canvas, MouseEvent e) {
        }

        public void handleMouseDragged(ChartCanvas canvas, MouseEvent e) {
            if (CharacteristicView.this.currentPoint != null) {
                ClickData clickData = CharacteristicView.this.getClickData(e);
                MeasuringUnitValue inputValue = new MeasuringUnitValue(CharacteristicView.this.getXAxisViewPrefs().getMeasuringUnit(), clickData.getChartX());
                MeasuringUnitValue outputValue = new MeasuringUnitValue(CharacteristicView.this.getYAxisViewPrefs().getMeasuringUnit(), clickData.getChartY());
                CharacteristicView.this.currentPoint = CharacteristicView.this.function.movePoint(CharacteristicView.this.currentPoint, inputValue, outputValue);
                CharacteristicView.this.pointDraged = true;
                CharacteristicView.this.plot.setNotify(false);
                CharacteristicView.this.updateSeriesPoints();
                CharacteristicView.this.plot.setNotify(true);
            }
        }

        public void handleMouseClicked(ChartCanvas canvas, MouseEvent e) {
        }
    };

    public CharacteristicView(Characteristic2DFunction curve, XYPlot plot, EfficientXYLineAndOptionalShapeRenderer renderer, ValueAxis rangeAxis, ChartViewer chartViewer, Chart2DView chartView, Runnable udpateRangesCallback, Runnable applyChangesCallback) {
        this.clickSeries = new XYTimeSeries((Comparable<?>)((Object)chartView.getConfig().getCharacteristic2DSeries().getResultTitle()), false);
        this.plot = plot;
        this.chartViewer = chartViewer;
        this.function = curve;
        this.chartView = chartView;
        this.domainAxis = plot.getDomainAxis();
        this.rangeAxis = rangeAxis;
        this.updateRangesCallback = udpateRangesCallback;
        this.applyChangesCallback = applyChangesCallback;
        this.renderer = renderer;
        this.updateSeriesPoints();
    }

    public XYTimeSeries getClickSeries() {
        return this.clickSeries;
    }

    public MouseHandlerFX getMouseHandler() {
        return this.mouseHandler;
    }

    public EventHandler<KeyEvent> getKeyHandler() {
        return this.keyHandler;
    }

    private AxisViewPrefs getXAxisViewPrefs() {
        return this.chartView.getViewPrefs().getXAxisViewPrefs();
    }

    private AxisViewPrefs getYAxisViewPrefs() {
        return this.chartView.getViewPrefs().getYAxesViewPrefs().stream().filter(yap -> yap.getYAxis().equals((Object)this.chartView.getConfig().getCharacteristic2DSeries().getYAxis())).findAny().get();
    }

    private void updateSeriesPoints() {
        this.clickSeries.clear();
        this.renderer.clearSeriesItemPaints(false);
        this.renderer.clearSeriesItemShapes(false);
        int i = 0;
        for (Characteristic2DFunction.FunctionPoint point : this.function.getPoints()) {
            double chartInput = this.getXAxisViewPrefs().getMeasuringUnit().convert(point.getInput(), this.function.getInputMU());
            double chartOutput = this.getYAxisViewPrefs().getMeasuringUnit().convert(point.getOutput(), this.function.getOutputMU());
            this.clickSeries.add(chartInput, chartOutput, Instant.now(), null);
            if (point.equals((Object)this.currentPoint)) {
                this.renderer.setItemFillPaint(0, i, Color.BLACK);
            }
            ++i;
        }
    }

    private ClickData getClickData(MouseEvent e) {
        double x = e.getX();
        double y = e.getY();
        ChartRenderingInfo info = this.chartViewer.getCanvas().getRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        RectangleEdge domainAxisEdge = this.plot.getDomainAxisEdge();
        Integer rangeAxisIndex = this.plot.getRangeAxisIndex(this.rangeAxis);
        RectangleEdge rangeAxisEdge = this.plot.getRangeAxisEdge(rangeAxisIndex.intValue());
        double chartX = this.domainAxis.java2DToValue(x, dataArea, domainAxisEdge);
        double chartY = this.rangeAxis.java2DToValue(y, dataArea, rangeAxisEdge);
        double xEpsilon = this.domainAxis.getRange().getLength() * 0.01;
        double yEpsilon = this.rangeAxis.getRange().getLength() * 0.01;
        return new ClickData(chartX, chartY, xEpsilon, yEpsilon);
    }

    private static class ClickData {
        private final double chartX;
        private final double chartY;
        private final double xEpsilon;
        private final double yEpsilon;

        public ClickData(double chartX, double chartY, double xEpsilon, double yEpsilon) {
            this.chartX = chartX;
            this.chartY = chartY;
            this.xEpsilon = xEpsilon;
            this.yEpsilon = yEpsilon;
        }

        public double getChartX() {
            return this.chartX;
        }

        public double getChartY() {
            return this.chartY;
        }

        public double getXEpsilon() {
            return this.xEpsilon;
        }

        public double getYEpsilon() {
            return this.yEpsilon;
        }
    }
}

