/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import de.elpro.ewms.core.characteristic.Characteristic3DFunction;
import de.elpro.ewms.core.charts.FunctionSeries3D;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ui.fx.charts.xyz.series.XYZFunctionSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;

public class Chart3DDrawData {
    private final Instant from;
    private final Instant to;
    private final ComplexRaster raster;
    private final Table<VarSeries3D, StructureObject, List<XYZItem>> varSeriesPoints = TreeBasedTable.create();
    private final Table<FunctionSeries3D, StructureObject, Pair<XYZFunctionSeries.ZFunction, XYZFunctionSeries.WFunction>> functionSeriesCalc = TreeBasedTable.create();
    private Map.Entry<Instant, Characteristic3DFunction> characteristic3dFunctionEntry = null;

    public Chart3DDrawData(ComplexRaster raster, Instant from, Instant to) {
        this.raster = raster;
        this.from = from;
        this.to = to;
    }

    public Instant getFrom() {
        return this.from;
    }

    public Instant getTo() {
        return this.to;
    }

    public ComplexRaster getRaster() {
        return this.raster;
    }

    public void addVarSeriesData(VarSeries3D series, StructureObject structureObject, List<XYZItem> points) {
        this.varSeriesPoints.put((Object)series, (Object)structureObject, points);
    }

    public void addFunctionSeriesCalc(FunctionSeries3D series, StructureObject structureObject, Pair<XYZFunctionSeries.ZFunction, XYZFunctionSeries.WFunction> calc) {
        this.functionSeriesCalc.put((Object)series, (Object)structureObject, calc);
    }

    public Collection<StructureObject> getStructureObjects(VarSeries3D series) {
        return this.varSeriesPoints.row((Object)series).keySet();
    }

    public Collection<StructureObject> getStructureObjects(FunctionSeries3D series) {
        return this.functionSeriesCalc.row((Object)series).keySet();
    }

    public List<XYZItem> getVarSeriesPoints(VarSeries3D series, StructureObject structureObject) {
        return Collections.unmodifiableList((List)this.varSeriesPoints.get((Object)series, (Object)structureObject));
    }

    public Pair<XYZFunctionSeries.ZFunction, XYZFunctionSeries.WFunction> getFunctionSeriesCalc(FunctionSeries3D series, StructureObject structureObject) {
        return (Pair)this.functionSeriesCalc.get((Object)series, (Object)structureObject);
    }

    public Map.Entry<Instant, Characteristic3DFunction> getCharacteristic3dFunctionEntry() {
        return this.characteristic3dFunctionEntry;
    }

    public void setCharacteristic3dFunctionEntry(Map.Entry<Instant, Characteristic3DFunction> entry) {
        this.characteristic3dFunctionEntry = entry;
    }
}

