/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.charts.ChartViewBase;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Region;

public abstract class ChartViewSkinBase<C extends ChartViewBase>
extends SkinBase<C> {
    protected ChartViewSkinBase(C control) {
        super(control);
    }

    public abstract ProgressIndicatorPane getProgressIndicatorPane();

    public abstract Object getExportableElement();

    public abstract Region getViewContent();

    public abstract void updateChartConfig() throws IllegalConfigException;

    public String createSeriesTitle(Series2DViewPrefs seriesViewPrefs) {
        String seriesTitle = seriesViewPrefs.toString();
        if (seriesViewPrefs.getVariableInstance() == null) {
            StructureObject customDataObject = seriesViewPrefs.getCustomDataStructureObject();
            if (customDataObject.equals((Object)seriesViewPrefs.getChartViewPrefs().getStructureObject())) {
                return seriesTitle;
            }
            return String.valueOf(seriesTitle) + String.format("\r\n<%s>", customDataObject);
        }
        if (!seriesViewPrefs.getVariableInstance().getStructureObject().equals((Object)seriesViewPrefs.getChartViewPrefs().getStructureObject()) || ((ChartViewBase)this.getSkinnable()).isShowFullSeriesNames()) {
            seriesTitle = seriesTitle != null && !seriesTitle.isEmpty() ? String.valueOf(seriesTitle) + String.format("\r\n<%s>", seriesViewPrefs.getVariableInstance().getStructureObject()) : seriesViewPrefs.getVariableInstance().getStructureObject().toString();
        }
        if (seriesTitle == null) {
            seriesTitle = "";
        }
        return seriesTitle;
    }

    public void dispose() {
        this.getChildren().clear();
        super.dispose();
    }
}

