/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.charts.PlotType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.CrosshairValueChangedListener;
import de.elpro.ewms.core.fx.charts.DefaultJFreeChartTheme;
import de.elpro.ewms.core.fx.charts.skins.Chart2DDrawData;
import de.elpro.ewms.core.fx.charts.skins.Chart2DViewSkinBase;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.jfree.data.SeriesPoint;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChartViewSkin
extends Chart2DViewSkinBase {
    private final GridPane pane = new GridPane();
    private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane((Node)this.pane);
    private final Map<SeriesGroup, DefaultPieDataset> datasets = new LinkedHashMap<SeriesGroup, DefaultPieDataset>();
    private final Map<SeriesGroup, JFreeChart> charts = new LinkedHashMap<SeriesGroup, JFreeChart>();
    private final Map<JFreeChart, ChartViewer> chartViewers = new LinkedHashMap<JFreeChart, ChartViewer>();

    public PieChartViewSkin(Chart2DView control) {
        super(control);
        this.getChildren().add((Object)this.pane);
    }

    @Override
    public void updateChartConfig() throws IllegalConfigException {
    }

    @Override
    public ProgressIndicatorPane getProgressIndicatorPane() {
        return this.progressIndicator;
    }

    @Override
    public Object getExportableElement() {
        Iterator<JFreeChart> iterator = this.charts.values().iterator();
        if (iterator.hasNext()) {
            JFreeChart chart = iterator.next();
            return chart;
        }
        return null;
    }

    @Override
    public Region getViewContent() {
        return this.pane;
    }

    @Override
    public void clearSelection() {
    }

    @Override
    public void setCrosshairValueChangedListener(CrosshairValueChangedListener listener) {
    }

    @Override
    public void setCrosshairPosition(double xVal, Double yVal) {
    }

    @Override
    public void draw(Chart2DDrawData data) {
        this.pane.getChildren().clear();
        this.datasets.clear();
        this.charts.clear();
        this.chartViewers.clear();
        if (this.getSkinnable() == null) {
            return;
        }
        PlotType plotType = ((Chart2DView)this.getSkinnable()).getConfig().getPlotType();
        List yAxesPrefs = ((Chart2DView)this.getSkinnable()).getViewPrefs().getYAxesViewPrefs();
        for (Series2DViewPrefs seriesViewPrefs : data.getSeriesViewPrefs()) {
            PiePlot plot;
            SeriesPoint value = data.getSeriesPoints(seriesViewPrefs).get(0);
            if (value.getYValue() == null) continue;
            VarSeries2D varSeries = seriesViewPrefs.getSeries();
            SeriesGroup seriesGroup = varSeries.getSeriesGroup();
            DefaultPieDataset dataset = this.datasets.get(seriesGroup);
            if (dataset == null) {
                MeasuringUnit measuringUnit = null;
                for (AxisViewPrefs yAxisViewPref : yAxesPrefs) {
                    if (!yAxisViewPref.getYAxis().equals((Object)seriesGroup.getYAxis())) continue;
                    measuringUnit = yAxisViewPref.getMeasuringUnit();
                    break;
                }
                DecimalFormat valueFormat = varSeries.getValueMeasuringUnitFormat() != null ? varSeries.getValueMeasuringUnitFormat().getDefaultDecimalFormat() : measuringUnit.getValueFormat(MeasuringUnitFormats.SIMPLE);
                dataset = new DefaultPieDataset();
                this.datasets.put(seriesGroup, dataset);
                StandardPieSectionLabelGenerator gen = new StandardPieSectionLabelGenerator("{0}: {1} ({2})", (NumberFormat)valueFormat, (NumberFormat)new DecimalFormat("0%"));
                if (plotType == PlotType.PiePlot) {
                    plot = new PiePlot((PieDataset)dataset);
                } else {
                    RingPlot ringPlot = new RingPlot((PieDataset)dataset);
                    ringPlot.setShadowPaint(null);
                    ringPlot.setSectionDepth(0.25);
                    plot = ringPlot;
                }
                plot.setLabelGenerator((PieSectionLabelGenerator)gen);
                String title = seriesGroup.getYAxis().getLocalTitle();
                if (title == null) {
                    title = seriesGroup.getLocalName();
                }
                title = title.replaceAll("\\{object\\}", ((Chart2DView)this.getSkinnable()).getStructureObject().toString());
                if (measuringUnit != null) {
                    title = String.valueOf(title) + String.format(" [%s]", measuringUnit.getDisplayUnitText(DisplayUnitFormat.SIMPLE));
                }
                JFreeChart jFreeChart = new JFreeChart(title, (Plot)plot);
                jFreeChart.getLegend().setPosition(RectangleEdge.TOP);
                DefaultJFreeChartTheme.getChartTheme().apply(jFreeChart);
                this.charts.put(seriesGroup, jFreeChart);
                ChartViewer chartViewer = new ChartViewer(jFreeChart);
                this.chartViewers.put(jFreeChart, chartViewer);
            } else {
                plot = (PiePlot)this.charts.get(seriesGroup).getPlot();
            }
            String seriesTitle = seriesViewPrefs.toString();
            if (!seriesViewPrefs.getVariableInstance().getStructureObject().equals((Object)seriesViewPrefs.getChartViewPrefs().getStructureObject()) || ((Chart2DView)this.getSkinnable()).isShowFullSeriesNames()) {
                if (!((Chart2DView)this.getSkinnable()).isShowFullSeriesNames()) {
                    seriesTitle = seriesViewPrefs.getSeries().getLocalTitle();
                }
                seriesTitle = seriesTitle != null && !seriesTitle.isEmpty() ? String.valueOf(seriesTitle) + String.format("\r\n<%s>", seriesViewPrefs.getVariableInstance().getStructureObject()) : seriesViewPrefs.getVariableInstance().getStructureObject().toString();
            }
            if (seriesTitle == null) {
                seriesTitle = "";
            }
            dataset.setValue((Comparable)((Object)seriesTitle), (Number)value.getYValue());
            if (!(plot instanceof PiePlot)) continue;
            PiePlot piePlot = plot;
            Color paint = seriesViewPrefs.getAwtColor();
            if (paint == null) continue;
            piePlot.setSectionPaint((Comparable)((Object)seriesTitle), (Paint)paint);
        }
        int columns = this.charts.size() >= 6 ? 3 : (this.charts.size() >= 2 ? 2 : 1);
        int row = 0;
        int column = 0;
        for (ChartViewer chartViewer : this.chartViewers.values()) {
            GridPane.setHgrow((Node)chartViewer, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)chartViewer, (Priority)Priority.ALWAYS);
            chartViewer.getContextMenu().getItems().clear();
            this.pane.add((Node)chartViewer, column++, row);
            if (column != columns) continue;
            ++row;
            column = 0;
        }
    }
}

