/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.skins.XYTimeSeries;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.units.time.Time;
import de.elpro.jfree.data.time.FixedLengthTimeSeriesCollection;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

class XYChartTooltipGenerator
implements XYToolTipGenerator {
    private final YAxis yAxis;
    private final Chart2DView chartView;

    public XYChartTooltipGenerator(YAxis yAxis, Chart2DView chartView) {
        this.yAxis = yAxis;
        this.chartView = chartView;
    }

    private MeasuringUnit getXAxisMU() {
        if (this.chartView.getConfig().getXAxisType() == XAxisType.Duration) {
            return Time.DAY;
        }
        return this.chartView.getViewPrefs().getAxesViewPrefs().stream().filter(avp -> avp.getYAxis() == null).findFirst().get().getMeasuringUnit();
    }

    private MeasuringUnit getYAxisMU() {
        if (this.chartView.getViewPrefs() == null) {
            return null;
        }
        for (AxisViewPrefs pref : this.chartView.getViewPrefs().getAxesViewPrefs()) {
            if (!this.yAxis.equals((Object)pref.getYAxis())) continue;
            return pref.getMeasuringUnit();
        }
        return null;
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        Instant timestamp;
        double yValue = dataset.getYValue(series, item);
        double xValue = dataset.getXValue(series, item);
        if (dataset instanceof XYSeriesCollection && ((XYSeriesCollection)dataset).getSeries(series) instanceof XYTimeSeries) {
            XYTimeSeries xyTimeSeries = (XYTimeSeries)((XYSeriesCollection)dataset).getSeries(series);
            timestamp = xyTimeSeries.getItemTimestamp(item);
        } else {
            timestamp = Instant.ofEpochMilli((long)xValue);
        }
        String yAxisTitle = dataset.getSeriesKey(series).toString().replaceAll("\r", " ").replaceAll("\n", "");
        MeasuringUnit yAxisMU = this.getYAxisMU();
        if (yAxisMU == null) {
            return null;
        }
        String s = String.format("%s: %s", yAxisTitle, yAxisMU.formatValue(yValue, MeasuringUnitFormats.getOptimalFormat((double)yValue), true));
        if (this.chartView.getConfig().getXAxisType() != XAxisType.Time) {
            String xAxisTitle = this.chartView.getConfig().getLocalXAxisTitle();
            MeasuringUnit xAxisMU = this.getXAxisMU();
            String xValueStr = xAxisMU.formatValue(xValue, MeasuringUnitFormats.getOptimalFormat((double)xValue), true);
            s = xAxisTitle == null || xAxisTitle.isEmpty() ? String.valueOf(s) + String.format(", %s", xValueStr) : String.valueOf(s) + String.format("\r\n%s: %s", xAxisTitle, xValueStr);
        }
        if (timestamp != null) {
            LocalDateTime localTime = LocalDateTime.ofInstant(timestamp, ZoneOffset.systemDefault());
            TimeFormatType timeFormatType = localTime.getNano() == 0 ? TimeFormatType.DateTimeHMs : TimeFormatType.DateTimeHMsMs;
            s = String.valueOf(s) + "\r\n" + String.format(Messages.chart_renderers_XYChartRenderer_Timestamp, timeFormatType.format((TemporalAccessor)localTime));
        }
        return s;
    }

    private Series getSeries(XYDataset dataset, int series) {
        if (dataset instanceof FixedLengthTimeSeriesCollection) {
            return ((FixedLengthTimeSeriesCollection)dataset).getSeries(series);
        }
        if (dataset instanceof XYSeriesCollection) {
            return ((XYSeriesCollection)dataset).getSeries(series);
        }
        return null;
    }
}

