/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.YAxisLocation;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.ChartUtils;
import de.elpro.ewms.core.fx.charts.CrosshairValueChangedListener;
import de.elpro.ewms.core.fx.charts.DefaultJFreeChartTheme;
import de.elpro.ewms.core.fx.charts.IChartViewAddon;
import de.elpro.ewms.core.fx.charts.IChartViewAddonSkin;
import de.elpro.ewms.core.fx.charts.skins.Chart2DDrawData;
import de.elpro.ewms.core.fx.charts.skins.Chart2DViewSkinBase;
import de.elpro.ewms.core.fx.charts.skins.XYChartTooltipGenerator;
import de.elpro.ewms.core.fx.charts.skins.XYTimeSeries;
import de.elpro.ewms.core.fx.jfree.EfficientStackedXYAreaRenderer;
import de.elpro.ewms.core.fx.jfree.EfficientXYAreaRenderer;
import de.elpro.ewms.core.fx.jfree.EfficientXYLineAndOptionalShapeRenderer;
import de.elpro.ewms.core.fx.jfree.EfficientXYLineAndShapeRenderer;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.time.Time;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.jfree.chart.axis.UnzoomableNumberAxis;
import de.elpro.jfree.chart.plot.UnzoomableXYPlot;
import de.elpro.jfree.data.SeriesPoint;
import de.elpro.jfree.data.SeriesPointList;
import de.elpro.jfree.data.time.FixedLengthTimeSeries;
import de.elpro.jfree.data.time.FixedLengthTimeSeriesCollection;
import de.elpro.jfree.data.time.FixedLengthTimeTableXYDataset;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import javafx.scene.Node;
import javafx.util.Pair;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.fx.interaction.ChartMouseEventFX;
import org.jfree.chart.fx.interaction.ChartMouseListenerFX;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.LengthAdjustmentType;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYChartViewSkin
extends Chart2DViewSkinBase {
    private final UnzoomableXYPlot plot;
    private final JFreeChart chart;
    private final ChartViewer chartViewer;
    private final ProgressIndicatorPane progressIndicator;
    private CrosshairValueChangedListener crosshairValueChangedListener;
    private ValueAxis xAxis;
    private final BiMap<YAxis, UnzoomableNumberAxis> yAxesToNumberAxisMap = HashBiMap.create();
    private final Map<SeriesGroup, XYDataset> seriesGroupDatasets = new HashMap<SeriesGroup, XYDataset>();
    private final Map<SeriesGroup, Integer> seriesGroupIndexes = new HashMap<SeriesGroup, Integer>();
    private final BiMap<SeriesGroup, XYItemRenderer> seriesGroupRenderers = HashBiMap.create();
    private final Map<ValueAxis, AxisViewPrefs> axisViewPreferences = new HashMap<ValueAxis, AxisViewPrefs>();
    private final Map<IChartViewAddon<?>, IChartViewAddonSkin<?>> addonSkins = new LinkedHashMap();
    private double mouseSelectionClusterValue = Double.NaN;

    public XYChartViewSkin(Chart2DView chartView) {
        super(chartView);
        Chart2D config = chartView.getConfig();
        XAxisType xAxisType = config.getXAxisType();
        String xAxisTitle = config.getLocalXAxisTitle();
        this.xAxis = null;
        if (xAxisType == XAxisType.Time) {
            DateAxis dateAxis = new DateAxis(xAxisTitle);
            dateAxis.setStandardTickUnits(ChartUtils.createStandardDateTickUnits(TimeZone.getDefault(), Locale.getDefault()));
            this.xAxis = dateAxis;
        } else if (xAxisType == XAxisType.Duration) {
            MeasuringUnit xAxisMU = config.getXAxisResultMU();
            if (xAxisMU == null) {
                xAxisMU = Time.DAY;
            }
            String timeMU = xAxisMU.getDisplayUnitText();
            String durationTitle = xAxisTitle != null ? String.format("%s [%s]", xAxisTitle, timeMU) : String.format("[%s]", timeMU);
            this.xAxis = new UnzoomableNumberAxis(durationTitle);
            ((UnzoomableNumberAxis)this.xAxis).setAutoRangeIncludesZero(false);
        } else {
            this.xAxis = new UnzoomableNumberAxis(xAxisTitle);
        }
        this.xAxis.setLowerMargin(0.02);
        this.xAxis.setUpperMargin(0.02);
        this.plot = new UnzoomableXYPlot(null, this.xAxis, null, null);
        this.chart = new JFreeChart(((Chart2DView)this.getSkinnable()).getTitle(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        DefaultJFreeChartTheme.getChartTheme().apply(this.chart);
        this.plot.setDomainPannable(true);
        this.plot.setRangePannable(true);
        this.initCrosshair();
        this.chartViewer = new ChartViewer(this.chart);
        this.chartViewer.addChartMouseListener((ChartMouseListenerFX)new ClickedIndexMouseListeneFX());
        this.progressIndicator = new ProgressIndicatorPane((Node)this.chartViewer);
        this.getChildren().add((Object)this.progressIndicator);
        for (IChartViewAddon<?> addon : chartView.getAddons()) {
            IChartViewAddonSkin<?> addonSkin = addon.createSkin(this);
            if (addonSkin == null) continue;
            this.addonSkins.put(addon, addonSkin);
        }
    }

    private void initCrosshair() {
        Color color = new Color(50, 126, 203, 150);
        this.plot.setDomainCrosshairStroke(LineType.ShortDash.createStroke(1.0f));
        this.plot.setRangeCrosshairStroke(LineType.ShortDash.createStroke(1.0f));
        this.plot.setDomainCrosshairPaint((Paint)color);
        this.plot.setRangeCrosshairPaint((Paint)color);
        this.plot.setDomainCrosshairVisible(true);
        if (((Chart2DView)this.getSkinnable()).getConfig().getXAxisType() == XAxisType.Variable) {
            this.plot.setRangeCrosshairVisible(true);
        }
        this.chart.addChangeListener(e -> {
            if (this.crosshairValueChangedListener != null) {
                double xVal = this.plot.getDomainCrosshairValue();
                double yVal = this.plot.getRangeCrosshairValue();
                if (((Chart2DView)this.getSkinnable()).getConfig().getXAxisType() != XAxisType.Variable) {
                    Instant ts = Instant.ofEpochMilli((long)xVal);
                    this.crosshairValueChangedListener.valueChanged(ts, xVal, yVal);
                } else {
                    this.crosshairValueChangedListener.valueChanged(null, xVal, yVal);
                }
            }
        });
    }

    @Override
    public void updateChartConfig() throws IllegalConfigException {
        this.initAxes(((Chart2DView)this.getSkinnable()).getConfig().getYAxes());
    }

    public ChartViewer getViewContent() {
        return this.chartViewer;
    }

    public UnzoomableXYPlot getPlot() {
        return this.plot;
    }

    @Override
    public void setCrosshairValueChangedListener(CrosshairValueChangedListener listener) {
        this.crosshairValueChangedListener = listener;
    }

    @Override
    public void setCrosshairPosition(double xVal, Double yVal) {
        boolean notify = this.plot.isNotify();
        this.plot.setNotify(false);
        this.plot.setDomainCrosshairValue(xVal);
        if (yVal != null) {
            this.plot.setRangeCrosshairValue(yVal.doubleValue());
        }
        this.plot.setNotify(notify);
    }

    @Override
    public ProgressIndicatorPane getProgressIndicatorPane() {
        return this.progressIndicator;
    }

    @Override
    public Object getExportableElement() {
        return this.chart;
    }

    public Pair<Double, Double> getXAxisBounds() {
        return new Pair((Object)this.xAxis.getLowerBound(), (Object)this.xAxis.getUpperBound());
    }

    @Override
    public void clearSelection() {
        this.mouseSelectionClusterValue = Double.NaN;
    }

    public void unzoom() {
        this.plot.unzoomAxes();
    }

    public void resetZoom() {
        this.plot.resetAxesZoom();
    }

    public boolean canUnzoom() {
        return this.plot.canUnzoom();
    }

    public void initAxes(Collection<YAxis> yAxes) throws IllegalConfigException {
        boolean notify = this.chart.isNotify();
        this.chart.setNotify(false);
        this.plot.clearRangeAxes();
        this.yAxesToNumberAxisMap.clear();
        this.seriesGroupDatasets.clear();
        this.seriesGroupIndexes.clear();
        this.seriesGroupRenderers.clear();
        int datasetIndex = 0;
        for (IChartViewAddonSkin<?> addonSkin : this.addonSkins.values()) {
            datasetIndex = addonSkin.initAxes(datasetIndex, yAxes);
        }
        XAxisType xAxisType = ((Chart2DView)this.getSkinnable()).getConfig().getXAxisType();
        if (yAxes.isEmpty()) {
            return;
        }
        for (YAxis yAxis : yAxes) {
            if (yAxis.getSeriesGroups().isEmpty() && yAxis.getSeries().isEmpty()) continue;
            UnzoomableNumberAxis valuesAxis = this.getOrCreateNumberAxis(yAxis);
            for (SeriesGroup seriesGroup : yAxis.getSeriesGroups()) {
                XYSeriesCollection dataset = null;
                Object renderer = null;
                switch (seriesGroup.getType()) {
                    case Line: {
                        if (xAxisType == XAxisType.Time) {
                            dataset = new FixedLengthTimeSeriesCollection(TimeZone.getTimeZone("UTC"));
                            renderer = new EfficientXYLineAndShapeRenderer();
                            renderer.setDefaultToolTipGenerator(new XYChartTooltipGenerator(yAxis, (Chart2DView)this.getSkinnable()));
                            break;
                        }
                        dataset = new XYSeriesCollection();
                        renderer = new EfficientXYLineAndOptionalShapeRenderer();
                        renderer.setDefaultToolTipGenerator(new XYChartTooltipGenerator(yAxis, (Chart2DView)this.getSkinnable()));
                        break;
                    }
                    case Area: {
                        if (xAxisType != XAxisType.Time) {
                            throw new IllegalConfigException(Messages.chart_renderers_XYChartRenderer_Area_renderer_not_compatible);
                        }
                        dataset = new FixedLengthTimeTableXYDataset(TimeZone.getTimeZone("UTC"));
                        renderer = new EfficientXYAreaRenderer();
                        renderer.setDefaultToolTipGenerator(new XYChartTooltipGenerator(yAxis, (Chart2DView)this.getSkinnable()));
                        break;
                    }
                    case StackedArea: {
                        if (xAxisType != XAxisType.Time) {
                            throw new IllegalConfigException(Messages.chart_renderers_XYChartRenderer_Area_renderer_not_compatible);
                        }
                        dataset = new FixedLengthTimeTableXYDataset(TimeZone.getTimeZone("UTC"));
                        renderer = new EfficientStackedXYAreaRenderer();
                        renderer.setDefaultToolTipGenerator(new XYChartTooltipGenerator(yAxis, (Chart2DView)this.getSkinnable()));
                        break;
                    }
                }
                renderer.setDefaultItemLabelGenerator(new XYItemLabelGenerator(){

                    public String generateLabel(XYDataset dataset, int series, int item) {
                        double value = dataset.getYValue(series, item);
                        return Double.isFinite(value) ? NumberFormats.DEFAULT_DOUBLE.format(value) : null;
                    }
                });
                ((AbstractXYItemRenderer)renderer).setDefaultEntityRadius(10);
                this.seriesGroupDatasets.put(seriesGroup, (XYDataset)dataset);
                this.seriesGroupIndexes.put(seriesGroup, datasetIndex);
                this.seriesGroupRenderers.put((Object)seriesGroup, renderer);
                this.addDatasetToNumberAxis(datasetIndex++, (XYDataset)dataset, valuesAxis, (XYItemRenderer)renderer);
            }
        }
        this.chart.setNotify(notify);
    }

    public UnzoomableNumberAxis getNumberAxis(YAxis yAxis) {
        return (UnzoomableNumberAxis)this.yAxesToNumberAxisMap.get((Object)yAxis);
    }

    public UnzoomableNumberAxis getOrCreateNumberAxis(YAxis yAxis) {
        UnzoomableNumberAxis numberAxis = (UnzoomableNumberAxis)this.yAxesToNumberAxisMap.get((Object)yAxis);
        if (numberAxis != null) {
            return numberAxis;
        }
        UnzoomableNumberAxis valueAxis = new UnzoomableNumberAxis(yAxis.getLocalTitle());
        DefaultJFreeChartTheme.getChartTheme().applyToRangeAxis((ValueAxis)valueAxis);
        int yAxisIndex = this.plot.getRangeAxisCount();
        this.plot.setRangeAxis(yAxisIndex, (ValueAxis)valueAxis);
        this.plot.setRangeAxisLocation(yAxisIndex, yAxis.getAxisLocation() == YAxisLocation.Left ? AxisLocation.BOTTOM_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
        if (yAxis.getAxisLocation() == YAxisLocation.Right) {
            valueAxis.setLabelAngle(Math.PI);
        }
        if (yAxis.getColor() != null) {
            Color awtColor = FXUtils.getAwtColor((javafx.scene.paint.Paint)yAxis.getColor());
            valueAxis.setLabelPaint((Paint)awtColor);
            valueAxis.setTickLabelPaint((Paint)awtColor);
        }
        valueAxis.setAutoRangeIncludesZero(false);
        this.yAxesToNumberAxisMap.put((Object)yAxis, (Object)valueAxis);
        return valueAxis;
    }

    public Integer getNumberAxisIndex(NumberAxis numberAxis) {
        int index = this.plot.getRangeAxisIndex((ValueAxis)numberAxis);
        return index >= 0 ? Integer.valueOf(index) : null;
    }

    public void addDatasetToNumberAxis(int datasetCount, XYDataset dataset, UnzoomableNumberAxis numberAxis, XYItemRenderer renderer) {
        int numberAxisIndex = this.getNumberAxisIndex((NumberAxis)numberAxis);
        this.plot.setRenderer(datasetCount, renderer);
        this.plot.setDataset(datasetCount, dataset);
        this.plot.mapDatasetToRangeAxis(datasetCount, numberAxisIndex);
    }

    private void applyAxisPrefs(AxisViewPrefs prefs) {
        ValueAxis axis = prefs.getYAxis() != null ? (ValueAxis)this.yAxesToNumberAxisMap.get((Object)prefs.getYAxis()) : this.xAxis;
        axis.setLabel(prefs.getFullTitle());
    }

    public void updateAxisBounds() {
        this.updateAxisBounds(this.axisViewPreferences);
    }

    private void updateAxisBounds(Map<ValueAxis, AxisViewPrefs> preferences) {
        int datasets = this.plot.getDatasetCount();
        HashMap<ValueAxis, Pair> axesBounds = new HashMap<ValueAxis, Pair>();
        int datasetIndex = 0;
        while (datasetIndex < datasets) {
            XYDataset dataset = this.plot.getDataset(datasetIndex);
            ValueAxis rangeAxis = this.plot.getRangeAxisForDataset(datasetIndex);
            ValueAxis domainAxis = this.plot.getDomainAxisForDataset(datasetIndex);
            int seriesCount = dataset.getSeriesCount();
            Double maxY = null;
            Double minY = null;
            Double maxX = null;
            Double minX = null;
            int series = 0;
            while (series < seriesCount) {
                int itemsCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemsCount) {
                    double x = dataset.getXValue(series, item);
                    double y = dataset.getYValue(series, item);
                    if (Double.isFinite(x) && Double.isFinite(y)) {
                        if (minX == null || x < minX) {
                            minX = x;
                        }
                        if (maxX == null || x > maxX) {
                            maxX = x;
                        }
                        if (minY == null || y < minY) {
                            minY = y;
                        }
                        if (maxY == null || y > maxY) {
                            maxY = y;
                        }
                    }
                    ++item;
                }
                ++series;
            }
            if (minY != null) {
                Pair domainAxisBounds = (Pair)axesBounds.get(domainAxis);
                if (domainAxisBounds == null) {
                    domainAxisBounds = new Pair(minX, maxX);
                } else {
                    Double prevMin = (Double)domainAxisBounds.getKey();
                    Double prevMax = (Double)domainAxisBounds.getValue();
                    Double newMin = prevMin != null ? Math.min(prevMin, minX) : minX;
                    Double newMax = prevMax != null ? Math.max(prevMax, maxX) : maxX;
                    domainAxisBounds = new Pair((Object)newMin, (Object)newMax);
                }
                axesBounds.put(domainAxis, domainAxisBounds);
                Pair rangeAxisBounds = (Pair)axesBounds.get(rangeAxis);
                if (rangeAxisBounds == null) {
                    rangeAxisBounds = new Pair((Object)minY, (Object)maxY);
                } else {
                    Double prevMin = (Double)rangeAxisBounds.getKey();
                    Double prevMax = (Double)rangeAxisBounds.getValue();
                    Double newMin = prevMin != null ? Math.min(prevMin, minY) : minY;
                    Double newMax = prevMax != null ? Math.max(prevMax, maxY) : maxY;
                    rangeAxisBounds = new Pair((Object)newMin, (Object)newMax);
                }
                axesBounds.put(rangeAxis, rangeAxisBounds);
            }
            ++datasetIndex;
        }
        for (Map.Entry<ValueAxis, AxisViewPrefs> axisPrefs : preferences.entrySet()) {
            Double upperBound;
            ValueAxis axis = axisPrefs.getKey();
            if (axis instanceof NumberAxis) {
                ((NumberAxis)axis).setAutoRangeIncludesZero(false);
            }
            Pair bounds = (Pair)axesBounds.get(axis);
            AxisViewPrefs prefs = axisPrefs.getValue();
            Double lowerBound = bounds != null ? (Double)bounds.getKey() : null;
            Double d = upperBound = bounds != null ? (Double)bounds.getValue() : null;
            if (lowerBound != null && upperBound != null) {
                double delta = upperBound - lowerBound;
                boolean negitvLowerBound = lowerBound < 0.0;
                lowerBound = lowerBound - delta * 0.02;
                if (!negitvLowerBound) {
                    lowerBound = Math.max(0.0, lowerBound);
                }
                upperBound = upperBound + delta * 0.02;
            }
            if (prefs.getLowerRange() != null && (lowerBound == null || prefs.getLowerRange() < upperBound)) {
                lowerBound = prefs.getLowerRange();
            }
            if (prefs.getUpperRange() != null && (upperBound == null || prefs.getUpperRange() > lowerBound)) {
                upperBound = prefs.getUpperRange();
            }
            boolean autoRange = lowerBound != null && upperBound != null;
            axis.setAutoRange(autoRange);
            if (axis instanceof UnzoomableNumberAxis) {
                UnzoomableNumberAxis una = (UnzoomableNumberAxis)axis;
                una.setOriginalLowerBound(lowerBound);
                una.setOriginalUpperBound(upperBound);
                continue;
            }
            axis.setLowerBound(lowerBound.doubleValue());
            axis.setUpperBound(upperBound.doubleValue());
        }
    }

    protected void removeAllSeries() {
        for (XYDataset xYDataset : this.seriesGroupDatasets.values()) {
            if (xYDataset instanceof FixedLengthTimeSeriesCollection) {
                ((FixedLengthTimeSeriesCollection)xYDataset).removeAllSeries();
                continue;
            }
            if (xYDataset instanceof XYSeriesCollection) {
                ((XYSeriesCollection)xYDataset).removeAllSeries();
                continue;
            }
            if (xYDataset instanceof FixedLengthTimeTableXYDataset) {
                ((FixedLengthTimeTableXYDataset)xYDataset).removeAllSeries();
                continue;
            }
            throw new IllegalArgumentException(Messages.chart_renderers_XYChartRenderer_Dataset_type_not_supported);
        }
        for (IChartViewAddonSkin iChartViewAddonSkin : this.addonSkins.values()) {
            iChartViewAddonSkin.removeAllSeries();
        }
    }

    @Override
    public void draw(Chart2DDrawData chartDrawData) {
        Object varSeries;
        if (this.getSkinnable() == null) {
            return;
        }
        boolean saved = this.plot.isNotify();
        this.plot.setNotify(false);
        this.removeAllSeries();
        this.plot.clearRangeMarkers();
        this.plot.clearDomainMarkers();
        ComplexRaster raster = chartDrawData.getRaster();
        Chart2D config = ((Chart2DView)this.getSkinnable()).getConfig();
        Chart2DViewPrefs viewPrefs = ((Chart2DView)this.getSkinnable()).getViewPrefs();
        StructureObject structureObject = ((Chart2DView)this.getSkinnable()).getStructureObject();
        HashMap newSeries = new HashMap();
        HashBasedTable visibleValuesBounds = HashBasedTable.create();
        this.yAxesToNumberAxisMap.values().forEach(a -> a.setVisible(false));
        for (IChartViewAddonSkin<?> addonSkin : this.addonSkins.values()) {
            addonSkin.draw(chartDrawData);
        }
        for (Series2DViewPrefs seriesViewPrefs : chartDrawData.getSeriesViewPrefs()) {
            List<SeriesPoint> list = chartDrawData.getSeriesPoints(seriesViewPrefs);
            varSeries = seriesViewPrefs.getSeries();
            SeriesGroup seriesGroup = varSeries.getSeriesGroup();
            YAxis yAxis = varSeries.getYAxis();
            AxisViewPrefs yAxisViewPrefs = viewPrefs.getYAxesViewPrefs().stream().filter(y -> y.getYAxis().equals((Object)yAxis)).findAny().get();
            this.getNumberAxis(yAxis).setVisible(true);
            String seriesTitle = this.createSeriesTitle(seriesViewPrefs);
            Series series = this.createSeries(seriesGroup, seriesTitle, list, raster);
            LinkedList<Object> seriesList = (LinkedList<Object>)newSeries.get(seriesGroup);
            if (seriesList == null) {
                seriesList = new LinkedList<Object>();
                newSeries.put(seriesGroup, seriesList);
            }
            XYItemRenderer renderer = (XYItemRenderer)this.seriesGroupRenderers.get((Object)varSeries.getSeriesGroup());
            seriesList.add(series);
            this.applySeriesStyle(renderer, seriesList.size() - 1, list, seriesViewPrefs);
            if (!seriesViewPrefs.isShowValuesBounds() || seriesViewPrefs.getVariableInstance().getResultValuesBounds() == null) continue;
            ValuesBounds valuesBounds = seriesViewPrefs.getVariableInstance().getResultValuesBounds();
            LinkedList<Series2DViewPrefs> boundsSeriesPrefs = (LinkedList<Series2DViewPrefs>)visibleValuesBounds.get((Object)yAxisViewPrefs, (Object)valuesBounds);
            if (boundsSeriesPrefs == null) {
                boundsSeriesPrefs = new LinkedList<Series2DViewPrefs>();
                visibleValuesBounds.put((Object)yAxisViewPrefs, (Object)valuesBounds, boundsSeriesPrefs);
            }
            boundsSeriesPrefs.add(seriesViewPrefs);
        }
        this.axisViewPreferences.clear();
        if (viewPrefs.getXAxisViewPrefs() != null && config.getXAxisType() == XAxisType.Variable) {
            this.applyAxisPrefs(viewPrefs.getXAxisViewPrefs());
            this.axisViewPreferences.put(this.xAxis, viewPrefs.getXAxisViewPrefs());
        }
        for (AxisViewPrefs axisViewPref : viewPrefs.getYAxesViewPrefs()) {
            this.applyAxisPrefs(axisViewPref);
            this.axisViewPreferences.put((ValueAxis)this.yAxesToNumberAxisMap.get((Object)axisViewPref.getYAxis()), axisViewPref);
            for (Map.Entry entry : visibleValuesBounds.row((Object)axisViewPref).entrySet()) {
                ValueMarker valuemarker;
                String boundsLabel;
                ValuesBounds valuesBounds = (ValuesBounds)entry.getKey();
                String seriesNames = "";
                int index = 0;
                for (Series2DViewPrefs svp : (List)entry.getValue()) {
                    if (index > 0) {
                        seriesNames = String.valueOf(seriesNames) + ", ";
                    }
                    if (index > 3) {
                        seriesNames = String.valueOf(seriesNames) + "...";
                        break;
                    }
                    seriesNames = String.valueOf(seriesNames) + this.createSeriesTitle(svp);
                    ++index;
                }
                javafx.scene.paint.Color markerColor = axisViewPref.getYAxis().getColor() != null ? axisViewPref.getYAxis().getColor() : javafx.scene.paint.Color.BLACK;
                TreeSet<Integer> datasetMarkerIndexes = new TreeSet<Integer>();
                for (Series2DViewPrefs series : (List)entry.getValue()) {
                    datasetMarkerIndexes.add(this.seriesGroupIndexes.get(series.getSeries().getSeriesGroup()));
                }
                if (valuesBounds.getHighLimit() != null) {
                    double highLimit = axisViewPref.getMeasuringUnit().convert(valuesBounds.getHighLimit().doubleValue(), valuesBounds.getMeasuringUnit());
                    boundsLabel = String.format("\u2912  %s (%s)", valuesBounds.getName(), seriesNames);
                    valuemarker = new ValueMarker(highLimit);
                    valuemarker.setLabelOffsetType(LengthAdjustmentType.EXPAND);
                    valuemarker.setPaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)markerColor));
                    valuemarker.setStroke(LineType.ShortDash.createStroke(1.0f));
                    valuemarker.setLabel(boundsLabel);
                    valuemarker.setLabelFont(new Font("SansSerif", 0, 11));
                    valuemarker.setLabelPaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)markerColor));
                    valuemarker.setLabelBackgroundColor(new Color(1, 1, 1, 0));
                    valuemarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                    valuemarker.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
                    for (Integer datasetMarkerIndex : datasetMarkerIndexes) {
                        this.plot.addRangeMarker(datasetMarkerIndex.intValue(), (Marker)valuemarker, Layer.BACKGROUND);
                    }
                }
                if (valuesBounds.getLowLimit() == null) continue;
                double highLimit = axisViewPref.getMeasuringUnit().convert(valuesBounds.getLowLimit().doubleValue(), valuesBounds.getMeasuringUnit());
                boundsLabel = String.format("\u2913  %s  (%s)", valuesBounds.getName(), seriesNames);
                valuemarker = new ValueMarker(highLimit);
                valuemarker.setLabelOffsetType(LengthAdjustmentType.EXPAND);
                valuemarker.setPaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)markerColor));
                valuemarker.setStroke(LineType.ShortDash.createStroke(1.0f));
                valuemarker.setLabel(boundsLabel);
                valuemarker.setLabelFont(new Font("SansSerif", 0, 11));
                valuemarker.setLabelPaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)markerColor));
                valuemarker.setLabelBackgroundColor(new Color(1, 1, 1, 0));
                valuemarker.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                valuemarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                for (Integer datasetMarkerIndex : datasetMarkerIndexes) {
                    this.plot.addRangeMarker(datasetMarkerIndex.intValue(), (Marker)valuemarker, Layer.BACKGROUND);
                }
            }
        }
        varSeries = chartDrawData.getNotes();
        int n = ((Note[])varSeries).length;
        int n2 = 0;
        while (n2 < n) {
            Note note = varSeries[n2];
            boolean openNote = note.getTo() == null;
            IntervalMarker intervalMarker = new IntervalMarker((double)note.getFrom().toEpochMilli(), (double)(openNote ? Long.MAX_VALUE : note.getTo().toEpochMilli()));
            intervalMarker.setLabelOffsetType(LengthAdjustmentType.EXPAND);
            String text = note.getLocalName();
            if (!note.getStructureObject().equals((Object)structureObject)) {
                text = String.format("%s\r\n(%s)", text, note.getStructureObject());
            }
            intervalMarker.setPaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)((javafx.scene.paint.Color)note.getType().getTextFill()).deriveColor(1.0, 1.0, 1.0, 0.4)));
            intervalMarker.setLabel(text);
            intervalMarker.setOutlinePaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)note.getType().getTextFill()));
            intervalMarker.setLabelFont(new Font("SansSerif", 0, 11));
            intervalMarker.setLabelPaint((Paint)FXUtils.getAwtColor((javafx.scene.paint.Paint)javafx.scene.paint.Color.BLACK));
            intervalMarker.setLabelAnchor(openNote ? RectangleAnchor.TOP_LEFT : RectangleAnchor.TOP_RIGHT);
            intervalMarker.setLabelBackgroundColor(new Color(1, 1, 1, 0));
            if (openNote) {
                intervalMarker.setLabelOffset(new RectangleInsets(0.0, -5.0, 0.0, 0.0));
            }
            intervalMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            this.plot.addDomainMarker((Marker)intervalMarker, Layer.BACKGROUND);
            ++n2;
        }
        for (Map.Entry ns : newSeries.entrySet()) {
            SeriesGroup seriesGroup = (SeriesGroup)ns.getKey();
            XYDataset oldDataset = this.seriesGroupDatasets.get(seriesGroup);
            FixedLengthTimeSeriesCollection newDataset = null;
            if (oldDataset instanceof FixedLengthTimeSeriesCollection) {
                newDataset = new FixedLengthTimeSeriesCollection(TimeZone.getTimeZone("UTC"));
            } else if (oldDataset instanceof XYSeriesCollection) {
                newDataset = new XYSeriesCollection();
            } else if (oldDataset instanceof FixedLengthTimeTableXYDataset) {
                newDataset = new FixedLengthTimeTableXYDataset(TimeZone.getTimeZone("UTC"));
            }
            Integer datasetIndex = this.seriesGroupIndexes.get(seriesGroup);
            for (Series series : (List)ns.getValue()) {
                this.addSeriesToDataSet((XYDataset)newDataset, series);
            }
            this.seriesGroupDatasets.put(seriesGroup, (XYDataset)newDataset);
            this.plot.setDataset(datasetIndex.intValue(), (XYDataset)newDataset);
        }
        this.updateAxisBounds();
        if (this.plot.canUnzoom()) {
            this.plot.applyLastZoom();
        } else {
            this.plot.resetAxesZoom();
        }
        this.plot.setNotify(saved);
    }

    private Series createSeries(SeriesGroup seriesGroup, String seriesName, List<SeriesPoint> points, ComplexRaster complexRaster) {
        XAxisType xAxisType = ((Chart2DView)this.getSkinnable()).getConfig().getXAxisType();
        if (xAxisType == XAxisType.Time) {
            FixedLengthTimeSeries timeSeries = new FixedLengthTimeSeries(points, (Comparable)((Object)seriesName));
            return timeSeries;
        }
        if (xAxisType == XAxisType.Duration) {
            XYTimeSeries durationSeries = new XYTimeSeries((Comparable<?>)((Object)seriesName), false);
            if (points.isEmpty()) {
                return durationSeries;
            }
            if (points.get(0).getTimestamp() != null) {
                MeasuringUnit durationMU = ((Chart2DView)this.getSkinnable()).getConfig().getXAxisResultMU();
                if (durationMU == null) {
                    durationMU = Time.DAY;
                }
                Instant startTime = complexRaster.getRasterBegin(Instant.ofEpochMilli(points.get(0).getTimestamp())).minusNanos(1L);
                OffsetDateTime localStartTime = VirtualZone.INSTANCE.getOffsetDateTime(startTime);
                for (SeriesPoint point : points) {
                    Instant timestamp = Instant.ofEpochMilli(point.getTimestamp());
                    long millisecondsSinceBegin = ChronoUnit.MILLIS.between(localStartTime, VirtualZone.INSTANCE.getOffsetDateTime(timestamp));
                    double daysSinceBegin = durationMU.convert((double)millisecondsSinceBegin, (MeasuringUnit)Time.MILLISECOND);
                    durationSeries.add(daysSinceBegin, point.getYValue(), timestamp, null);
                }
            } else {
                for (SeriesPoint point : points) {
                    durationSeries.add(point.getXValue(), point.getYValue(), null, null);
                }
            }
            return durationSeries;
        }
        XYTimeSeries xySeries = new XYTimeSeries((Comparable<?>)((Object)seriesName), false);
        SeriesPointList spl = points instanceof SeriesPointList ? (SeriesPointList)points : null;
        int index = 0;
        for (SeriesPoint point : points) {
            Double cluster = spl != null ? Double.valueOf(spl.getMetaValue(index)) : null;
            xySeries.add(point.getXValue(), point.getYValue(), Instant.ofEpochMilli(point.getTimestamp()), cluster);
            ++index;
        }
        return xySeries;
    }

    private void applySeriesStyle(XYItemRenderer renderer, int seriesIndex, List<SeriesPoint> points, Series2DViewPrefs viewPrefs) {
        if (renderer instanceof XYLineAndShapeRenderer) {
            int itemsCount = points.size();
            XYLineAndShapeRenderer lineAndShapeRenderer = (XYLineAndShapeRenderer)renderer;
            Stroke stroke = viewPrefs.getLineType().createStroke((float)(viewPrefs.getLineWidth() != null ? viewPrefs.getLineWidth() : 1));
            Color color = viewPrefs.getAwtColor();
            if (color != null) {
                lineAndShapeRenderer.setSeriesPaint(seriesIndex, (Paint)color);
            }
            if (lineAndShapeRenderer instanceof EfficientXYLineAndOptionalShapeRenderer && ((Chart2DView)this.getSkinnable()).getConfig().getXAxisType() == XAxisType.Variable) {
                EfficientXYLineAndOptionalShapeRenderer optionalShapeRenderer = (EfficientXYLineAndOptionalShapeRenderer)lineAndShapeRenderer;
                SeriesPointList spl = points instanceof SeriesPointList ? (SeriesPointList)points : null;
                int item2 = 0;
                while (item2 < itemsCount) {
                    Color derivedColor = this.getXYItemColor(color, item2, itemsCount);
                    if (((Chart2DView)this.getSkinnable()).getConfig().getClusteringVariable() != null && Double.isFinite(this.mouseSelectionClusterValue)) {
                        double clusteringDVal = spl.getMetaValue(item2);
                        boolean matchingCluster = clusteringDVal == this.mouseSelectionClusterValue;
                        derivedColor = matchingCluster ? color : XYChartViewSkin.gray(derivedColor);
                    }
                    optionalShapeRenderer.setItemPaint(seriesIndex, item2, derivedColor);
                    optionalShapeRenderer.setItemFillPaint(seriesIndex, item2, derivedColor);
                    ++item2;
                }
            }
            if (stroke != null) {
                lineAndShapeRenderer.setSeriesLinesVisible(seriesIndex, true);
                lineAndShapeRenderer.setSeriesStroke(seriesIndex, stroke);
            } else {
                lineAndShapeRenderer.setSeriesLinesVisible(seriesIndex, false);
            }
            Shape shape = viewPrefs.getShapeType().createAWTShape((float)(viewPrefs.getShapeSize() != null ? viewPrefs.getShapeSize() : 4));
            if (shape != null) {
                lineAndShapeRenderer.setSeriesShapesVisible(seriesIndex, true);
                lineAndShapeRenderer.setSeriesShape(seriesIndex, shape);
                lineAndShapeRenderer.setSeriesShapesFilled(seriesIndex, true);
                if (color != null) {
                    lineAndShapeRenderer.setUseFillPaint(true);
                    lineAndShapeRenderer.setSeriesFillPaint(seriesIndex, (Paint)color);
                    if (color == null || stroke == null) {
                        lineAndShapeRenderer.setSeriesPaint(seriesIndex, (Paint)color);
                    }
                }
            } else {
                lineAndShapeRenderer.setSeriesShapesVisible(seriesIndex, false);
            }
        } else if (renderer instanceof XYAreaRenderer2) {
            XYAreaRenderer2 xyAreaRenderer = (XYAreaRenderer2)renderer;
            if (viewPrefs.getColor() != null) {
                xyAreaRenderer.setSeriesPaint(seriesIndex, (Paint)viewPrefs.getAwtColor());
            }
        }
        renderer.setSeriesItemLabelsVisible(seriesIndex, viewPrefs.getSeries().isShowValuesLabels());
        if (viewPrefs.getSeries().getCustomItemLabelGenerator() != null) {
            renderer.setSeriesItemLabelGenerator(seriesIndex, (dataset, series, item) -> viewPrefs.getSeries().getCustomItemLabelGenerator().generateLabel(dataset, series, item));
        } else {
            renderer.setSeriesItemLabelGenerator(seriesIndex, null);
        }
    }

    private Color getXYItemColor(Color color, int item, int itemsCount) {
        double ratio = (1.0 - (double)item / (double)(itemsCount - 1)) * 0.5;
        Color derivedColor = new Color((int)((double)color.getRed() + (double)(255 - color.getRed()) * ratio), (int)((double)color.getGreen() + (double)(255 - color.getGreen()) * ratio), (int)((double)color.getBlue() + (double)(255 - color.getBlue()) * ratio));
        if (item > itemsCount - 10) {
            Color darkerColor = FXUtils.getAwtColor((javafx.scene.paint.Paint)FXUtils.getFXColor((Paint)derivedColor).darker());
            return darkerColor;
        }
        return derivedColor;
    }

    private static Color gray(Color rgbColor) {
        int gray = (int)(0.299 * (double)rgbColor.getRed() + 0.587 * (double)rgbColor.getGreen() + 0.114 * (double)rgbColor.getBlue());
        int r = (int)((double)gray + (double)(rgbColor.getRed() - gray) * 0.3);
        int g = (int)((double)gray + (double)(rgbColor.getGreen() - gray) * 0.3);
        int b = (int)((double)gray + (double)(rgbColor.getBlue() - gray) * 0.3);
        return new Color(r, g, b, 100);
    }

    private void addSeriesToDataSet(XYDataset dataset, Series series) {
        if (dataset instanceof FixedLengthTimeSeriesCollection) {
            ((FixedLengthTimeSeriesCollection)dataset).addSeries((FixedLengthTimeSeries)series);
        } else if (dataset instanceof XYSeriesCollection) {
            ((XYSeriesCollection)dataset).addSeries((XYSeries)series);
        } else if (dataset instanceof FixedLengthTimeTableXYDataset) {
            ((FixedLengthTimeTableXYDataset)dataset).addSeries((FixedLengthTimeSeries)series);
        } else {
            throw new IllegalArgumentException(Messages.chart_renderers_XYChartRenderer_Dataset_type_not_supported);
        }
    }

    final class ClickedIndexMouseListeneFX
    implements ChartMouseListenerFX {
        ClickedIndexMouseListeneFX() {
        }

        public void chartMouseMoved(ChartMouseEventFX event) {
        }

        public void chartMouseClicked(ChartMouseEventFX event) {
            try {
                XYSeriesCollection sc;
                XYSeries s;
                XYItemEntity ce = (XYItemEntity)event.getEntity();
                int item = ce.getItem();
                int series = ce.getSeriesIndex();
                if (ce.getDataset() instanceof XYSeriesCollection && (s = (sc = (XYSeriesCollection)ce.getDataset()).getSeries(series)) instanceof XYTimeSeries) {
                    double clusterDval;
                    XYTimeSeries xyts = (XYTimeSeries)s;
                    Double cluster = xyts.getItemMeta(item);
                    double d = clusterDval = cluster != null && Double.isFinite(cluster) ? cluster : Double.NaN;
                    if (Double.isFinite(clusterDval)) {
                        if (XYChartViewSkin.this.mouseSelectionClusterValue == clusterDval) {
                            return;
                        }
                        XYChartViewSkin.this.mouseSelectionClusterValue = cluster;
                    } else {
                        if (Double.isNaN(XYChartViewSkin.this.mouseSelectionClusterValue)) {
                            return;
                        }
                        XYChartViewSkin.this.mouseSelectionClusterValue = Double.NaN;
                    }
                    ((Chart2DView)XYChartViewSkin.this.getSkinnable()).draw();
                }
            }
            catch (Exception exception) {}
        }
    }
}

