/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.xy.XYSeries;

class XYTimeSeries
extends XYSeries {
    private static final long serialVersionUID = -8373594311257291761L;
    private int itemNumber = 0;
    private Map<Integer, Instant> itemTs = new HashMap<Integer, Instant>();
    private Map<Integer, Double> itemMeta = new HashMap<Integer, Double>();

    public XYTimeSeries(Comparable<?> key, boolean autoSort) {
        super(key, autoSort);
    }

    public void add(Number x, Number y, Instant timestamp, Double meta) {
        this.add(x, y, false);
        if (timestamp != null) {
            this.itemTs.put(this.itemNumber, timestamp);
        }
        if (meta != null) {
            this.itemMeta.put(this.itemNumber, meta);
        }
        ++this.itemNumber;
    }

    public Instant getItemTimestamp(int item) {
        return this.itemTs.get(item);
    }

    public double getItemMeta(int item) {
        return this.itemMeta.get(item);
    }

    public void removeLast() {
        --this.itemNumber;
        this.remove(this.itemNumber);
        this.itemTs.remove(this.itemNumber);
        this.itemMeta.remove(this.itemNumber);
    }

    public void clear() {
        super.clear();
        this.itemTs.clear();
        this.itemMeta.clear();
        this.itemNumber = 0;
    }
}

