/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.charts.skins;

import de.elpro.ewms.core.characteristic.Characteristic3DFunction;
import de.elpro.ewms.core.characteristic.ExtremePoint;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.FunctionSeries3D;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.charts.viewprefs.Chart3DViewPrefs;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.Chart3DView;
import de.elpro.ewms.core.fx.charts.skins.Chart3DDrawData;
import de.elpro.ewms.core.fx.charts.skins.Chart3DViewSkinBase;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ui.fx.charts.xyz.XYZChart2D;
import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries3DRenderer;
import de.elpro.ui.fx.charts.xyz.series.XYZFunctionSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.util.Pair;

public class XYZChart3DViewSkin
extends Chart3DViewSkinBase {
    protected final SplitPane verticalSplitPane;
    protected final SplitPane horizontalSplitPane;
    protected final StackPane stackPane;
    protected final XYZChart3D xyzChart3D;
    protected XYZChart2D xyzChart2D;
    protected final Label infoLabel;
    protected final ProgressIndicatorPane progressIndicatorPane;
    private XYZItemSeries maximumZSeries;

    public XYZChart3DViewSkin(Chart3DView control) {
        super(control);
        Chart3D config = control.getConfig();
        Chart3DWAxisType wAxisType = config.getWAxisType();
        this.xyzChart3D = new XYZChart3D(switch (wAxisType) {
            case Chart3DWAxisType.None -> new XYZAxes(null, null, null);
            case Chart3DWAxisType.Time, Chart3DWAxisType.Variable -> new XYZAxes(null, null, null, null);
            default -> null;
        });
        this.xyzChart3D.invertYAxisProperty().bind((ObservableValue)config.yAxisInvertedProperty());
        boolean swapZWAxes = config.isSwapZWAxes();
        this.xyzChart3D.setSwapZWAxes(swapZWAxes);
        this.xyzChart3D.setItemColorPolicy(swapZWAxes && config.getZAxisItemColorPolicy() != null ? config.getZAxisItemColorPolicy().toItemColorPolicy() : config.getWAxisItemColorPolicy().toItemColorPolicy());
        if (config.getWAxisType() != Chart3DWAxisType.None && config.isSwapZWAxes()) {
            this.xyzChart3D.setSwapZWAxes(true);
        }
        control.swapZWAxesProperty().addListener((o, ov, nv) -> {
            boolean notify = this.xyzChart3D.isNotify();
            this.xyzChart3D.setNotify(false);
            try {
                this.xyzChart3D.setSwapZWAxes(nv.booleanValue());
                this.xyzChart3D.setItemColorPolicy(nv != false && config.getZAxisItemColorPolicy() != null ? config.getZAxisItemColorPolicy().toItemColorPolicy() : config.getWAxisItemColorPolicy().toItemColorPolicy());
            }
            finally {
                this.xyzChart3D.setNotify(notify);
            }
            if (this.xyzChart2D != null) {
                notify = this.xyzChart2D.isNotify();
                try {
                    this.xyzChart2D.setNotify(false);
                    this.xyzChart2D.setDeriveItemColorFromZAxis(nv.booleanValue());
                }
                finally {
                    this.xyzChart2D.setNotify(notify);
                }
            }
        });
        this.xyzChart3D.getSeriesRenderers().stream().filter(r -> r instanceof XYZAreaSeries3DRenderer).forEach(r -> ((XYZAreaSeries3DRenderer)r).setResulution(200));
        this.infoLabel = new Label();
        this.infoLabel.textProperty().bind((ObservableValue)control.infoLabelTextProperty());
        this.stackPane = new StackPane(new Node[]{this.xyzChart3D, this.infoLabel});
        this.horizontalSplitPane = new SplitPane(new Node[]{this.stackPane});
        this.verticalSplitPane = new SplitPane(new Node[]{this.horizontalSplitPane});
        StackPane.setAlignment((Node)this.infoLabel, (Pos)Pos.BOTTOM_LEFT);
        StackPane.setMargin((Node)this.infoLabel, (Insets)new Insets(0.0, 0.0, 20.0, 20.0));
        this.infoLabel.setStyle("-fx-font-family: \"Allerta Stencil\"; -fx-font-weight: bold;");
        control.show2DViewProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.show2DView();
            } else {
                this.hide2DView();
            }
        });
        this.progressIndicatorPane = new ProgressIndicatorPane((Node)this.verticalSplitPane);
        this.updateChartConfig();
        this.getChildren().add((Object)this.progressIndicatorPane);
    }

    public XYZChart3D getXYZChart() {
        return this.xyzChart3D;
    }

    @Override
    public void updateChartConfig() {
        this.updateAxes();
    }

    @Override
    public ObservableList<XYZItem> getSelectedItems() {
        return this.xyzChart3D.getSelectedItems();
    }

    @Override
    public void selectItems(Instant from, Instant to) {
        ArrayList<XYZItem> selectedItems = new ArrayList<XYZItem>();
        for (XYZSeries series : this.xyzChart3D.getSeriesList()) {
            if (!(series instanceof XYZItemSeries)) continue;
            XYZItemSeries itemSeries = (XYZItemSeries)series;
            for (XYZItem item : itemSeries.getItems()) {
                if (item.getTimetamp().isBefore(from) || item.getTimetamp().isAfter(to) || !this.xyzChart3D.getDataViewRange().contains(item)) continue;
                selectedItems.add(item);
            }
        }
        this.xyzChart3D.getSelectedItems().setAll(selectedItems);
    }

    protected void updateAxes() {
        Chart3DView chart3dView = (Chart3DView)this.getSkinnable();
        boolean notify = this.xyzChart3D.isNotify();
        this.xyzChart3D.setNotify(false);
        Chart3D config = chart3dView.getConfig();
        Chart3DViewPrefs viewPrefs = chart3dView.getViewPrefs();
        XYZAxes axes = this.xyzChart3D.getAxes();
        boolean swapZWAxes = chart3dView.isSwapZWAxes();
        this.xyzChart3D.setSwapZWAxes(swapZWAxes);
        this.xyzChart3D.setItemColorPolicy(swapZWAxes && config.getZAxisItemColorPolicy() != null ? config.getZAxisItemColorPolicy().toItemColorPolicy() : config.getWAxisItemColorPolicy().toItemColorPolicy());
        axes.getXAxis().setName(config.getXAxisLocalName());
        if (config.getXAxisColor() != null) {
            axes.getXAxis().setColor(config.getXAxisColor());
        }
        axes.getYAxis().setName(config.getYAxisLocalName());
        if (config.getYAxisColor() != null) {
            axes.getYAxis().setColor(config.getYAxisColor());
        }
        axes.getZAxis().setName(config.getZAxisLocalName());
        if (config.getZAxisColor() != null) {
            axes.getZAxis().setColor(config.getZAxisColor());
        }
        if (config.getWAxisType() != Chart3DWAxisType.None) {
            axes.getWAxis().setName(config.getWAxisLocalName());
        }
        if (viewPrefs != null) {
            axes.getXAxis().setMeasuringUnit(viewPrefs.getXAxisResultMeasuringUnit().getDisplayUnitText());
            axes.getXAxis().setLowerBound(viewPrefs.getXAxisLowerRange());
            axes.getXAxis().setUpperBound(viewPrefs.getXAxisUpperRange());
            axes.getYAxis().setMeasuringUnit(viewPrefs.getYAxisResultMeasuringUnit().getDisplayUnitText());
            axes.getYAxis().setLowerBound(viewPrefs.getYAxisLowerRange());
            axes.getYAxis().setUpperBound(viewPrefs.getYAxisUpperRange());
            axes.getZAxis().setMeasuringUnit(viewPrefs.getZAxisResultMeasuringUnit().getDisplayUnitText());
            axes.getZAxis().setLowerBound(viewPrefs.getZAxisLowerRange());
            axes.getZAxis().setUpperBound(viewPrefs.getZAxisUpperRange());
            if (config.getWAxisType() == Chart3DWAxisType.Variable) {
                axes.getWAxis().setMeasuringUnit(viewPrefs.getWAxisResultMeasuringUnit().getDisplayUnitText());
                axes.getWAxis().setLowerBound(viewPrefs.getWAxisLowerRange());
                axes.getWAxis().setUpperBound(viewPrefs.getWAxisUpperRange());
            }
        }
        this.xyzChart3D.setNotify(notify);
    }

    @Override
    public void draw(Chart3DDrawData data) {
        this.xyzChart3D.setNotify(false);
        try {
            String title;
            this.xyzChart3D.getSeriesList().clear();
            ArrayList<XYZItem> selectedItems = new ArrayList<XYZItem>();
            for (VarSeries3D varSeries : ((Chart3DView)this.getSkinnable()).getConfig().getVarSeries()) {
                for (StructureObject structureObject : data.getStructureObjects(varSeries)) {
                    title = varSeries.getLocalTitle();
                    if (title == null || title.isEmpty()) {
                        title = structureObject.getLocalName();
                    } else if (!structureObject.equals((Object)((Chart3DView)this.getSkinnable()).getStructureObject())) {
                        title = String.valueOf(title) + "\r\n" + String.format("<%s>", structureObject.getLocalName());
                    }
                    XYZItemSeries series = new XYZItemSeries(title);
                    series.setBaseColor(varSeries.getDefaultColor() != null ? varSeries.getDefaultColor() : structureObject.getDefaultColor());
                    List<XYZItem> items = data.getVarSeriesPoints(varSeries, structureObject);
                    series.addItems(items);
                    this.xyzChart3D.getSeriesList().add((Object)series);
                    if (items.isEmpty()) continue;
                    selectedItems.add(items.get(items.size() - 1));
                }
            }
            this.xyzChart3D.getSelectedItems().setAll(selectedItems);
            for (FunctionSeries3D functionSeries : ((Chart3DView)this.getSkinnable()).getConfig().getFunctionSeries()) {
                for (StructureObject structureObject : data.getStructureObjects(functionSeries)) {
                    title = functionSeries.getLocalTitle();
                    if (title == null || title.isEmpty()) {
                        title = structureObject.getLocalName();
                    } else if (!structureObject.equals((Object)((Chart3DView)this.getSkinnable()).getStructureObject())) {
                        title = String.valueOf(title) + "\r\n" + String.format("<%s>", structureObject.getLocalName());
                    }
                    Pair<XYZFunctionSeries.ZFunction, XYZFunctionSeries.WFunction> calc = data.getFunctionSeriesCalc(functionSeries, structureObject);
                    XYZFunctionSeries series = new XYZFunctionSeries(title, (XYZFunctionSeries.ZFunction)calc.getKey(), (XYZFunctionSeries.WFunction)calc.getValue());
                    series.setOpacityFactor(0.7);
                    series.setBaseColor(functionSeries.getDefaultColor() != null ? functionSeries.getDefaultColor() : structureObject.getDefaultColor());
                    this.xyzChart3D.getSeriesList().add((Object)series);
                }
            }
            if (data.getCharacteristic3dFunctionEntry() != null) {
                Map.Entry<Instant, Characteristic3DFunction> entry = data.getCharacteristic3dFunctionEntry();
                String char3dSeriesTitle = ((Chart3DView)this.getSkinnable()).getConfig().getCharacteristic3DSeries().getLocalTitle();
                String title2 = String.format("%s (%s)", Messages.charts_Chart3DView_ai, char3dSeriesTitle);
                Chart3DView.XYZKIAreaSeries kiSeries = new Chart3DView.XYZKIAreaSeries(title2, ((Chart3DView)this.getSkinnable()).getViewPrefs(), entry.getValue());
                Color baseColor = this.xyzChart3D.getSeriesList().size() > 0 ? ((XYZSeries)this.xyzChart3D.getSeriesList().get(0)).getBaseColor() : null;
                Color kiSeriesColor = baseColor != null ? baseColor : Color.color((double)Math.random(), (double)Math.random(), (double)Math.random());
                kiSeriesColor = kiSeriesColor.deriveColor(1.0 + (-0.5 + Math.random()) * 0.2, 1.0, 1.0, 1.0);
                kiSeries.setBaseColor(kiSeriesColor);
                this.xyzChart3D.getSeriesList().add((Object)kiSeries);
            }
        }
        finally {
            this.xyzChart3D.setNotify(true);
        }
        this.draw2DView();
    }

    protected void draw2DView() {
        if (this.xyzChart2D == null) {
            return;
        }
        this.xyzChart2D.setNotify(false);
        try {
            Chart3DView skinnable = (Chart3DView)this.getSkinnable();
            Chart3D config = skinnable.getConfig();
            ItemColorPolicy zAxisColorPolicy = config.getZAxisItemColorPolicy() == null ? ItemColorPolicy.SeriesBaseColor : config.getZAxisItemColorPolicy().toItemColorPolicy();
            ItemColorPolicy wAxisColorPolicy = config.getWAxisItemColorPolicy() != null ? config.getWAxisItemColorPolicy().toItemColorPolicy() : zAxisColorPolicy;
            this.xyzChart2D.setDeriveItemColorFromZAxis(skinnable.isSwapZWAxes());
            this.xyzChart2D.setZAxisColorPolicy(zAxisColorPolicy);
            this.xyzChart2D.setWAxisColorPolicy(wAxisColorPolicy);
            this.xyzChart2D.setShowWIsolines(true);
            this.xyzChart2D.setDefaultViewRange(this.xyzChart3D.getDataViewRange());
            this.xyzChart2D.getSeriesList().setAll((Collection)this.xyzChart3D.getSeriesList());
            Chart3DView.XYZKIAreaSeries editAreaSeries = this.xyzChart3D.getSeriesList().stream().filter(s -> s instanceof Chart3DView.XYZKIAreaSeries).findFirst().orElse(null);
            if (editAreaSeries != null) {
                if (this.maximumZSeries != null) {
                    this.xyzChart2D.getSeriesList().remove((Object)this.maximumZSeries);
                }
                this.maximumZSeries = new XYZItemSeries("Maximum Z");
                this.maximumZSeries.setDefaultItemSize(Double.NaN);
                this.maximumZSeries.setLineWidth(2.0);
                MeasuringUnit xAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getXAxisResultMeasuringUnit();
                MeasuringUnit yAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getYAxisResultMeasuringUnit();
                MeasuringUnit zAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getZAxisResultMeasuringUnit();
                MeasuringUnit wAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getWAxisResultMeasuringUnit();
                Characteristic3DFunction characteristic3dFunction = editAreaSeries.getCharacteristic();
                for (ExtremePoint p : characteristic3dFunction.getExtremeXLine(false, true).getPoints(xAxisMU, yAxisMU, zAxisMU, wAxisMU)) {
                    this.maximumZSeries.addItem(new XYZItem(p.getX(), p.getY(), p.getZ(), p.getW()));
                }
                this.maximumZSeries.setBaseColor(Color.VIOLET);
                this.xyzChart2D.getSeriesList().add((Object)this.maximumZSeries);
            }
            this.xyzChart2D.setEditAreaSeries((XYZAreaSeries)editAreaSeries);
            if (editAreaSeries != null) {
                this.xyzChart2D.setEditEventListener(() -> {
                    editAreaSeries.update();
                    if (this.maximumZSeries != null) {
                        this.xyzChart2D.getSeriesList().remove((Object)this.maximumZSeries);
                        this.maximumZSeries.clearItems();
                        MeasuringUnit xAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getXAxisResultMeasuringUnit();
                        MeasuringUnit yAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getYAxisResultMeasuringUnit();
                        MeasuringUnit zAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getZAxisResultMeasuringUnit();
                        MeasuringUnit wAxisMU = ((Chart3DView)this.getSkinnable()).getViewPrefs().getWAxisResultMeasuringUnit();
                        for (ExtremePoint p : editAreaSeries.getCharacteristic().getExtremeXLine(false, true).getPoints(xAxisMU, yAxisMU, zAxisMU, wAxisMU)) {
                            this.maximumZSeries.addItem(new XYZItem(p.getX(), p.getY(), p.getZ(), p.getW()));
                        }
                        this.xyzChart2D.getSeriesList().add((Object)this.maximumZSeries);
                    }
                    ((Chart3DView)this.getSkinnable()).currentCharacteristicCurveChanged();
                });
            }
        }
        finally {
            this.xyzChart2D.setNotify(true);
        }
    }

    protected void show2DView() {
        if (this.xyzChart2D == null) {
            this.xyzChart2D = new XYZChart2D(this.xyzChart3D.getAxes());
        }
        this.draw2DView();
        if (!this.horizontalSplitPane.getItems().contains((Object)this.xyzChart2D)) {
            this.horizontalSplitPane.getItems().add((Object)this.xyzChart2D);
        }
    }

    protected void hide2DView() {
        if (this.xyzChart2D != null) {
            this.horizontalSplitPane.getItems().remove((Object)this.xyzChart2D);
        }
    }

    @Override
    public ProgressIndicatorPane getProgressIndicatorPane() {
        return this.progressIndicatorPane;
    }

    @Override
    public Object getExportableElement() {
        return this.xyzChart3D;
    }

    @Override
    public Region getViewContent() {
        return this.xyzChart3D;
    }
}

