/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.dialogs;

import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.rawvalues.RawValuesViewDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.rawvalues.RawValuesViewCreateRequest;
import de.elpro.ewms.core.rawvalues.RawValuesViewPrepareCreateResponse;
import de.elpro.ewms.core.rawvalues.RawValuesViewState;
import de.elpro.ewms.core.rawvalues.RawValuesViewStateResponse;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.text.LocaleText;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;

public class CreateRawValuesViewDialog
extends Dialog<Integer> {
    private StringProperty name = new SimpleStringProperty();
    private ObjectProperty<LocalDateTime> from = new SimpleObjectProperty();
    private ObjectProperty<LocalDateTime> to = new SimpleObjectProperty();
    private ObjectProperty<Raster> raster = new SimpleObjectProperty();

    public CreateRawValuesViewDialog(Window owner, ThreadSynchronize sync, LocalDateTime from, LocalDateTime to, Raster defaultRaster) {
        LocalDateTime maxTo;
        LocalDateTime minFrom;
        this.initOwner(owner);
        this.from.setValue((Object)from);
        this.to.setValue((Object)to);
        this.raster.set((Object)defaultRaster);
        TimeRange globalArchiveTimeRange = ServerDAO.getGlobalViewArchiveTimeRange();
        if (globalArchiveTimeRange != null) {
            minFrom = LocalDateTime.ofInstant(globalArchiveTimeRange.getFrom(), ZoneId.systemDefault());
            maxTo = LocalDateTime.ofInstant(globalArchiveTimeRange.getTo(), ZoneId.systemDefault());
        } else {
            minFrom = null;
            maxTo = null;
        }
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem(Messages.dialogs_CreateRawValuesViewDialog_Name, (ObservableValue)this.name);
        LocalDateTimePropertyItem fromItem = new LocalDateTimePropertyItem(Messages.dialogs_CreateRawValuesViewDialog_From, this.from);
        LocalDateTimePropertyItem toItem = new LocalDateTimePropertyItem(Messages.dialogs_CreateRawValuesViewDialog_To, this.to);
        EnumPropertyItem rasterItem = new EnumPropertyItem(Messages.dialogs_CreateRawValuesViewDialog_Raster, Raster.class, this.raster);
        rasterItem.setNullable(false);
        fromItem.valueProperty().addListener(il -> toItem.forceValidate());
        toItem.valueProperty().addListener(il -> fromItem.forceValidate());
        fromItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator(), Validators.createValidator((o, ov, nv) -> this.getFrom() == null || this.getTo() == null || this.getFrom().isBefore(this.getTo()), (String)Messages.dialogs_CreateRawValuesViewDialog_fromBeforeTo), Validators.createValidator((o, ov, nv) -> this.getFrom() == null || minFrom == null || !minFrom.isAfter(this.getFrom()), (EventType)ValidationEvent.VALIDATION_WARNING, (String)Messages.dialogs_CreateRawValuesViewDialog_fromBeforeBegin)}));
        toItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator(), Validators.createValidator((o, ov, nv) -> this.getFrom() == null || this.getTo() == null || this.getFrom().isBefore(this.getTo()), (String)Messages.dialogs_CreateRawValuesViewDialog_fromBeforeTo), Validators.createValidator((o, ov, nv) -> this.getFrom() == null || maxTo == null || !maxTo.isBefore(this.getTo()), (EventType)ValidationEvent.VALIDATION_WARNING, (String)Messages.dialogs_CreateRawValuesViewDialog_toAfterEnd)}));
        PropertySheet sheet = new PropertySheet();
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{nameItem, fromItem, toItem, rasterItem});
        sheet.setPrefWidth(400.0);
        sheet.setPrefHeight(210.0);
        BorderPane pane = new BorderPane((Node)sheet);
        this.getDialogPane().setContent((Node)pane);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.setOnCloseRequest(event -> {
            Integer index = (Integer)this.getResult();
            if (index != null && index == -1) {
                event.consume();
            }
        });
        this.setResultConverter(type -> {
            sheet.setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().unbind();
            this.getDialogPane().lookupButton(ButtonType.OK).setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(true);
            if (type != ButtonType.OK) {
                return null;
            }
            try {
                ProgressBar progressBar = new ProgressBar(0.0);
                progressBar.setPadding(new Insets(3.0));
                progressBar.setMaxWidth(Double.MAX_VALUE);
                Label progressLabel = new Label();
                progressLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
                VBox box = new VBox(3.0, new Node[]{progressBar, progressLabel});
                VBox.setVgrow((Node)progressBar, (Priority)Priority.ALWAYS);
                pane.setBottom((Node)box);
                RawValuesViewCreateRequest request = this.getCreateRequest();
                RawValuesViewPrepareCreateResponse prepareResult = RawValuesViewDAO.prepareCreateView((RawValuesViewCreateRequest)request);
                switch (prepareResult.getType()) {
                    case Ok: {
                        break;
                    }
                    case Warning: {
                        Alert warning = new Alert(Alert.AlertType.CONFIRMATION);
                        warning.initOwner(owner);
                        warning.setContentText(String.format(Messages.dialogs_CreateRawValuesViewDialog_warning_to_big, prepareResult.getExpectedRamSizeGb(), prepareResult.getExpectedHddSizeGb()));
                        ButtonType result = warning.showAndWait().orElse(ButtonType.CANCEL);
                        if (result == ButtonType.OK) break;
                        Integer n = -1;
                        return n;
                    }
                    default: {
                        Alert error = new Alert(Alert.AlertType.ERROR);
                        error.initOwner(owner);
                        error.setContentText(String.format(Messages.dialogs_CreateRawValuesViewDialog_error_to_big, prepareResult.getExpectedRamSizeGb(), prepareResult.getExpectedHddSizeGb()));
                        error.showAndWait();
                        Integer n = -1;
                        return n;
                    }
                }
                ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
                Runnable task = () -> {
                    try {
                        RawValuesViewStateResponse response;
                        Integer index = RawValuesViewDAO.createView((RawValuesViewCreateRequest)request);
                        do {
                            Thread.sleep(500L);
                            response = RawValuesViewDAO.getViewState((RawValuesViewType)RawValuesViewType.CustomView, (Integer)index);
                            Platform.runLater(() -> {
                                progressBar.setProgress(response.getProgress());
                                progressLabel.setText(String.format(Messages.dialogs_CreateRawValuesViewDialog_progressMsg, response.getState().toString(), response.getProgress() * 100.0));
                            });
                        } while (response.getState() != RawValuesViewState.Idle);
                        sync.asyncExec(() -> condition.release((Object)index));
                        return;
                    }
                    catch (DAOOperationException | InterruptedException e) {
                        Platform.runLater(() -> CreateRawValuesViewDialog.lambda$11((Exception)e, owner));
                        sync.asyncExec(() -> condition.release(null));
                        return;
                    }
                };
                new Thread(task).start();
                Integer n = (Integer)sync.block(condition);
                return n;
            }
            finally {
                sheet.setDisable(false);
                pane.setBottom(null);
                this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
                this.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(false);
            }
        });
    }

    public LocaleText getName() {
        return LocaleText.tryParse((String)((String)this.name.get()));
    }

    public LocalDateTime getFrom() {
        return (LocalDateTime)this.from.get();
    }

    public LocalDateTime getTo() {
        return (LocalDateTime)this.to.get();
    }

    public Raster getRaster() {
        return (Raster)this.raster.get();
    }

    public RawValuesViewCreateRequest getCreateRequest() {
        return new RawValuesViewCreateRequest(this.getName(), this.getRaster(), this.getFrom().atZone(ZoneOffset.systemDefault()).toInstant(), this.getTo().atZone(ZoneOffset.systemDefault()).toInstant());
    }

    private static /* synthetic */ void lambda$11(Exception exception, Window window) {
        ExceptionDialog excDlg = new ExceptionDialog((Throwable)exception);
        excDlg.initOwner(window);
        excDlg.show();
    }
}

