/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.dialogs;

import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.variable.snapshot.VariableInstanceSnapshotGroupDAO;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.snapshot.CreateVariableInstancesSnapshotRequest;
import de.elpro.ui.fx.binding.Bindings;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.controls.DateTimePicker;
import de.elpro.ui.fx.controls.LocaleTextField;
import de.elpro.ui.fx.validator.Validators;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import jidefx.scene.control.validation.ValidationGroup;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;

public class CreateVariableInstanceSnapshotDialog
extends Dialog<Integer> {
    private StringProperty name = new SimpleStringProperty();
    private ObjectProperty<LocalDateTime> from = new SimpleObjectProperty();
    private ObjectProperty<LocalDateTime> to = new SimpleObjectProperty();
    private BooleanProperty isForecast = new SimpleBooleanProperty();
    private BooleanProperty isPublic = new SimpleBooleanProperty();
    private ObjectProperty<Raster> baseRaster = new SimpleObjectProperty();
    private ObservableList<VariableInstanceRow> instances = FXCollections.observableArrayList();

    public CreateVariableInstanceSnapshotDialog(Window owner, ThreadSynchronize sync, RawValuesViewType viewType, Integer viewIndex, LocalDateTime from, LocalDateTime to, LocalDateTime minFrom, LocalDateTime maxFrom, Raster baseRaster, VariableInstance[] obligatoryInstances, VariableInstance[] optionalInstances) {
        VariableInstance instance;
        this.initOwner(owner);
        this.setResizable(true);
        this.setTitle(Messages.dialogs_CreateVariableInstanceSnapshotDialog_createValuesSnapshot);
        this.from.setValue((Object)from);
        this.to.setValue((Object)to);
        this.baseRaster.set((Object)baseRaster);
        Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)viewType, (Integer)viewIndex);
        VariableInstance[] variableInstanceArray = obligatoryInstances;
        int n = obligatoryInstances.length;
        int n2 = 0;
        while (n2 < n) {
            instance = variableInstanceArray[n2];
            this.instances.add((Object)new VariableInstanceRow(instance));
            ++n2;
        }
        variableInstanceArray = optionalInstances;
        n = optionalInstances.length;
        n2 = 0;
        while (n2 < n) {
            instance = variableInstanceArray[n2];
            this.instances.add((Object)new VariableInstanceRow(instance));
            ++n2;
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        ColumnConstraints c1 = new ColumnConstraints(150.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c1, c2});
        LocaleTextField nameTF = new LocaleTextField();
        nameTF.localeTextProperty().bindBidirectional((Property)this.name);
        gridPane.addRow(0, new Node[]{new Label(Messages.dialogs_CreateVariableInstanceSnapshotDialog_name), nameTF});
        DateTimePicker fromDTP = new DateTimePicker();
        fromDTP.dateTimeValueProperty().bindBidirectional(this.from);
        gridPane.addRow(1, new Node[]{new Label(Messages.dialogs_CreateVariableInstanceSnapshotDialog_from), fromDTP});
        DateTimePicker toDTP = new DateTimePicker();
        toDTP.dateTimeValueProperty().bindBidirectional(this.to);
        gridPane.addRow(2, new Node[]{new Label(Messages.dialogs_CreateVariableInstanceSnapshotDialog_to), toDTP});
        ComboBox rasterCB = new ComboBox(FXCollections.observableArrayList((Object[])minRaster.getCompatibleAggregationRasters()));
        rasterCB.getSelectionModel().select((Object)baseRaster);
        this.baseRaster.bind((ObservableValue)rasterCB.getSelectionModel().selectedItemProperty());
        gridPane.addRow(3, new Node[]{new Label(Messages.dialogs_CreateVariableInstanceSnapshotDialog_raster), rasterCB});
        TableView instancesTable = new TableView(this.instances);
        instancesTable.setEditable(true);
        TableColumn checkedColumn = new TableColumn();
        checkedColumn.setCellFactory(cf -> new CheckBoxTableCell());
        checkedColumn.setCellValueFactory(cf -> {
            VariableInstance instance = ((VariableInstanceRow)cf.getValue()).instance;
            VariableInstance[] variableInstanceArray2 = obligatoryInstances;
            int n = obligatoryInstances.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstance c = variableInstanceArray2[n2];
                if (c.equals((Object)instance)) {
                    return new ReadOnlyBooleanWrapper(true);
                }
                ++n2;
            }
            return ((VariableInstanceRow)cf.getValue()).checked;
        });
        checkedColumn.setEditable(true);
        TableColumn variableColumn = new TableColumn(Messages.dialogs_CreateVariableInstanceSnapshotDialog_variable);
        variableColumn.setCellFactory(cf -> new UIModelTableCell());
        variableColumn.setCellValueFactory(cf -> ((VariableInstanceRow)cf.getValue()).instance.variableProperty());
        variableColumn.setMinWidth(200.0);
        TableColumn objectColumn = new TableColumn(Messages.dialogs_CreateVariableInstanceSnapshotDialog_object);
        objectColumn.setCellFactory(cf -> new UIModelTableCell());
        objectColumn.setCellValueFactory(cf -> ((VariableInstanceRow)cf.getValue()).instance.structureObjectProperty());
        objectColumn.setMinWidth(200.0);
        TableColumn descriptionColumn = new TableColumn(Messages.dialogs_CreateVariableInstanceSnapshotDialog_description);
        descriptionColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((VariableInstanceRow)cf.getValue()).instance.getResultDescription()));
        descriptionColumn.setMinWidth(300.0);
        instancesTable.getColumns().addAll((Object[])new TableColumn[]{checkedColumn, variableColumn, objectColumn, descriptionColumn});
        GridPane.setColumnSpan((Node)instancesTable, (Integer)2);
        GridPane.setVgrow((Node)instancesTable, (Priority)Priority.ALWAYS);
        gridPane.addRow(4, new Node[]{instancesTable});
        CheckBox isForecastCB = new CheckBox();
        isForecastCB.selectedProperty().bindBidirectional((Property)this.isForecast);
        gridPane.addRow(5, new Node[]{new Label(Messages.dialogs_CreateVariableInstanceSnapshotDialog_futureValues), isForecastCB});
        CheckBox isPublicCB = new CheckBox();
        isPublicCB.selectedProperty().bindBidirectional((Property)this.isPublic);
        gridPane.addRow(6, new Node[]{new Label(Messages.dialogs_CreateVariableInstanceSnapshotDialog_public), isPublicCB});
        Separator bottomSeparator = new Separator(Orientation.HORIZONTAL);
        GridPane.setColumnSpan((Node)bottomSeparator, (Integer)2);
        gridPane.addRow(7, new Node[]{bottomSeparator});
        ValidationUtils.install((Node)fromDTP, this.from, (Validator)Validators.createValidator((s, ov, nv) -> from != null && to != null && ((LocalDateTime)this.from.get()).isBefore((ChronoLocalDateTime)this.to.get()), (String)Messages.dialogs_CreateVariableInstanceSnapshotDialog_fromMustBeBeforeTo), (ValidationMode)ValidationMode.ON_FLY);
        ValidationUtils.install((Node)toDTP, this.to, (Validator)Validators.createValidator((s, ov, nv) -> from != null && to != null && ((LocalDateTime)this.from.get()).isBefore((ChronoLocalDateTime)this.to.get()), (String)Messages.dialogs_CreateVariableInstanceSnapshotDialog_fromMustBeBeforeTo), (ValidationMode)ValidationMode.ON_FLY);
        ObservableBooleanValue someInstancesChecked = Bindings.or((ObservableBooleanValue[])((ObservableBooleanValue[])this.instances.stream().map(r -> r.checked).toArray(BooleanProperty[]::new)));
        ValidationUtils.install((Node)instancesTable, (ObservableValue)someInstancesChecked, (Validator)Validators.createValidator((s, ov, nv) -> nv, (String)Messages.dialogs_CreateVariableInstanceSnapshotDialog_noInstancesToCreateSnapshot), (ValidationMode)ValidationMode.ON_FLY);
        ValidationGroup validationGroup = new ValidationGroup(new Node[]{fromDTP, toDTP, instancesTable});
        this.getDialogPane().setContent((Node)gridPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().setPrefWidth(900.0);
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)validationGroup.invalidProperty());
        this.setOnCloseRequest(event -> {
            Integer index = (Integer)this.getResult();
            if (index != null && index == -1) {
                event.consume();
            }
        });
        this.setResultConverter(type -> {
            gridPane.setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().unbind();
            this.getDialogPane().lookupButton(ButtonType.OK).setDisable(true);
            this.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(true);
            if (type != ButtonType.OK) {
                return null;
            }
            try {
                ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
                Runnable task = () -> {
                    try {
                        VariableInstance[] checkedInstances = (VariableInstance[])this.instances.stream().filter(f -> f.checked.get()).map(e -> e.instance).toArray(VariableInstance[]::new);
                        Instant fromTS = ((LocalDateTime)this.from.get()).atZone(ZoneId.systemDefault()).toInstant();
                        Instant toTS = ((LocalDateTime)this.to.get()).atZone(ZoneId.systemDefault()).toInstant();
                        CreateVariableInstancesSnapshotRequest request = new CreateVariableInstancesSnapshotRequest(viewType, viewIndex, (Raster)this.baseRaster.get(), (String)this.name.get(), fromTS, toTS, this.isForecast.get(), this.isPublic.get(), checkedInstances);
                        int id = VariableInstanceSnapshotGroupDAO.create((CreateVariableInstancesSnapshotRequest)request);
                        sync.asyncExec(() -> condition.release((Object)id));
                    }
                    catch (Exception exc) {
                        Platform.runLater(() -> {
                            ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                            excDlg.initOwner(owner);
                            excDlg.show();
                        });
                        sync.asyncExec(() -> condition.release(null));
                    }
                };
                new Thread(task).start();
                Integer n2 = (Integer)sync.block(condition);
                return n2;
            }
            finally {
                gridPane.setDisable(false);
                this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)validationGroup.invalidProperty());
                this.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(false);
            }
        });
    }

    private static class VariableInstanceRow {
        private final BooleanProperty checked = new SimpleBooleanProperty(true);
        private final VariableInstance instance;

        public VariableInstanceRow(VariableInstance instance) {
            this.instance = instance;
        }
    }
}

