/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.dialogs;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.snapshot.VariableInstanceSnapshotGroupDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.snapshot.GetVariableInstanceSnapshotGroupsRequest;
import de.elpro.ewms.core.variable.snapshot.VariableInstanceSnapshotGroup;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.cells.DataSizeTableCell;
import de.elpro.ui.fx.cells.LocalDateTimeTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.controls.DateTimePicker;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.eclipse.fx.core.ThreadSynchronize;

public class SelectOrEditVariableInstanceSnapshotDialog
extends Dialog<ButtonType> {
    private final VariableInstance[] containInstancesFilter;
    private final ObjectProperty<LocalDateTime> fromFilter = new SimpleObjectProperty();
    private final ObjectProperty<LocalDateTime> toFilter = new SimpleObjectProperty();
    private ObservableList<VariableInstanceSnapshotGroup> groups = FXCollections.observableArrayList();
    private ObservableList<VariableInstance> groupInstances = FXCollections.observableArrayList();
    private final TableView<VariableInstanceSnapshotGroup> snapshotGroupsTable = new TableView(this.groups);
    private final ProgressIndicatorPane snapshotGroupsProgressIndicatorPane = new ProgressIndicatorPane(this.snapshotGroupsTable);
    private final TableView<VariableInstance> instancesTable = new TableView(this.groupInstances);
    private final ProgressIndicatorPane instancesProgressIndicatorPane = new ProgressIndicatorPane(this.instancesTable);

    public SelectOrEditVariableInstanceSnapshotDialog(Window owner, ThreadSynchronize sync, VariableInstance[] containInstancesFilter, LocalDateTime fromFilter, LocalDateTime toFilter) {
        this.initOwner(owner);
        this.setResizable(true);
        this.setTitle(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_selectSnapshot);
        this.containInstancesFilter = containInstancesFilter;
        this.fromFilter.setValue((Object)fromFilter);
        this.toFilter.setValue((Object)toFilter);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        ColumnConstraints c1 = new ColumnConstraints(150.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c1, c2});
        int gridRow = 0;
        DateTimePicker fromDTP = new DateTimePicker();
        fromDTP.dateTimeValueProperty().bindBidirectional(this.fromFilter);
        gridPane.addRow(gridRow++, new Node[]{new Label(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_from), fromDTP});
        DateTimePicker toDTP = new DateTimePicker();
        toDTP.dateTimeValueProperty().bindBidirectional(this.toFilter);
        gridPane.addRow(gridRow++, new Node[]{new Label(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_to), toDTP});
        BorderPane centralPane = new BorderPane();
        Button deleteSnapshotGroups = new Button(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_delete);
        deleteSnapshotGroups.setPadding(new Insets(5.0));
        deleteSnapshotGroups.setMinWidth(150.0);
        deleteSnapshotGroups.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.snapshotGroupsTable.getSelectionModel().getSelectedItems()));
        deleteSnapshotGroups.setOnAction(e -> this.deleteSelectedSnapshotGroups());
        VBox buttonsVB = new VBox(10.0, new Node[]{deleteSnapshotGroups});
        buttonsVB.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        centralPane.setRight((Node)buttonsVB);
        TableColumn nameColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_name);
        nameColumn.setCellFactory(cf -> new UIModelTableCell());
        nameColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((VariableInstanceSnapshotGroup)cf.getValue())));
        nameColumn.setMinWidth(200.0);
        TableColumn userColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_owner);
        userColumn.setCellFactory(cf -> new UIModelTableCell());
        userColumn.setCellValueFactory(cf -> ((VariableInstanceSnapshotGroup)cf.getValue()).ownerProperty());
        userColumn.setMinWidth(200.0);
        TableColumn dateColumnGroup = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_valuesTimeRange);
        TableColumn fromColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_from);
        fromColumn.setCellFactory(cf -> new LocalDateTimeTableCell());
        fromColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)LocalDateTime.ofInstant(((VariableInstanceSnapshotGroup)cf.getValue()).getValuesDataFrom(), ZoneId.systemDefault())));
        fromColumn.setMinWidth(140.0);
        TableColumn toColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_to);
        toColumn.setCellFactory(cf -> new LocalDateTimeTableCell());
        toColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)LocalDateTime.ofInstant(((VariableInstanceSnapshotGroup)cf.getValue()).getValuesDataTo(), ZoneId.systemDefault())));
        toColumn.setMinWidth(140.0);
        dateColumnGroup.getColumns().addAll((Object[])new TableColumn[]{fromColumn, toColumn});
        TableColumn baseRaster = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_baseRaster);
        baseRaster.setCellValueFactory(cf -> ((VariableInstanceSnapshotGroup)cf.getValue()).baseRasterProperty());
        TableColumn isPublicColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_public);
        isPublicColumn.setCellFactory(cf -> new CheckBoxTableCell());
        isPublicColumn.setCellValueFactory(cf -> ((VariableInstanceSnapshotGroup)cf.getValue()).isPublicProperty());
        TableColumn dataSizeColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_dataSize);
        dataSizeColumn.setCellFactory(cf -> new DataSizeTableCell());
        dataSizeColumn.setCellValueFactory(cf -> ((VariableInstanceSnapshotGroup)cf.getValue()).snapshotDataSizeProperty());
        this.snapshotGroupsTable.getColumns().addAll((Object[])new TableColumn[]{nameColumn, userColumn, dateColumnGroup, baseRaster, isPublicColumn, dataSizeColumn});
        this.instancesTable.setEditable(true);
        TableColumn variableColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_variable);
        variableColumn.setCellFactory(cf -> new UIModelTableCell());
        variableColumn.setCellValueFactory(cf -> ((VariableInstance)cf.getValue()).variableProperty());
        variableColumn.setMinWidth(200.0);
        TableColumn objectColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_object);
        objectColumn.setCellFactory(cf -> new UIModelTableCell());
        objectColumn.setCellValueFactory(cf -> ((VariableInstance)cf.getValue()).structureObjectProperty());
        objectColumn.setMinWidth(200.0);
        TableColumn descriptionColumn = new TableColumn(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_description);
        descriptionColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((VariableInstance)cf.getValue()).getResultDescription()));
        descriptionColumn.setMinWidth(300.0);
        this.instancesTable.getColumns().addAll((Object[])new TableColumn[]{variableColumn, objectColumn, descriptionColumn});
        SplitPane snapshotSplitPane = new SplitPane(new Node[]{this.snapshotGroupsProgressIndicatorPane, this.instancesProgressIndicatorPane});
        snapshotSplitPane.setOrientation(Orientation.VERTICAL);
        centralPane.setCenter((Node)snapshotSplitPane);
        GridPane.setColumnSpan((Node)centralPane, (Integer)2);
        GridPane.setVgrow((Node)centralPane, (Priority)Priority.ALWAYS);
        gridPane.addRow(gridRow++, new Node[]{centralPane});
        Separator separator = new Separator();
        GridPane.setColumnSpan((Node)separator, (Integer)2);
        gridPane.addRow(gridRow++, new Node[]{separator});
        this.getDialogPane().setContent((Node)gridPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().setPrefWidth(1100.0);
        this.getDialogPane().setPrefHeight(600.0);
        this.loadSnapshotGroups();
        this.snapshotGroupsTable.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.loadInstances((VariableInstanceSnapshotGroup)nv));
        this.fromFilter.addListener(il -> this.loadSnapshotGroups());
        this.toFilter.addListener(il -> this.loadSnapshotGroups());
    }

    public List<VariableInstanceSnapshotGroup> getSelectedGroups() {
        return this.snapshotGroupsTable.getSelectionModel().getSelectedItems();
    }

    private VariableInstanceSnapshotGroup[] getSnapshotsGroups(Transaction trx) throws DAOOperationException {
        Instant from = this.fromFilter.get() != null ? ((LocalDateTime)this.fromFilter.get()).atZone(ZoneId.systemDefault()).toInstant() : null;
        Instant to = this.toFilter.get() != null ? ((LocalDateTime)this.toFilter.get()).atZone(ZoneId.systemDefault()).toInstant() : null;
        GetVariableInstanceSnapshotGroupsRequest request = new GetVariableInstanceSnapshotGroupsRequest(from, to, this.containInstancesFilter);
        return VariableInstanceSnapshotGroupDAO.get((Transaction)trx, (GetVariableInstanceSnapshotGroupsRequest)request);
    }

    protected void loadSnapshotGroups() {
        CallableTask<VariableInstanceSnapshotGroup[]> task = new CallableTask<VariableInstanceSnapshotGroup[]>(){

            public VariableInstanceSnapshotGroup[] call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    VariableInstanceSnapshotGroup[] groups = SelectOrEditVariableInstanceSnapshotDialog.this.getSnapshotsGroups(trx);
                    int[] userIds = Arrays.stream(groups).mapToInt(g -> g.getOwner().getId()).distinct().toArray();
                    Map users = UserDAO.getAsMap((Transaction)trx, (int[])userIds);
                    VariableInstanceSnapshotGroup[] variableInstanceSnapshotGroupArray = groups;
                    int n = groups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableInstanceSnapshotGroup g2 = variableInstanceSnapshotGroupArray[n2];
                        g2.setOwner((User)users.get(g2.getOwner().getId()));
                        ++n2;
                    }
                    VariableInstanceSnapshotGroup[] variableInstanceSnapshotGroupArray2 = groups;
                    return variableInstanceSnapshotGroupArray2;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.snapshotGroupsProgressIndicatorPane, (CallableTask)task).consumeResult((status, result) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    this.groups.setAll((Object[])result);
                    this.groupInstances.clear();
                });
            }
        });
    }

    protected void deleteSelectedSnapshotGroups() {
        Alert confDlg = new Alert(Alert.AlertType.CONFIRMATION);
        confDlg.initOwner(this.getOwner());
        confDlg.setContentText(String.format(Messages.dialogs_SelectOrEditVariableInstanceSnapshotDialog_deleteNSnapshots, this.snapshotGroupsTable.getSelectionModel().getSelectedItems().size()));
        if (confDlg.showAndWait().get() != ButtonType.OK) {
            return;
        }
        CallableTask<VariableInstanceSnapshotGroup[]> task = new CallableTask<VariableInstanceSnapshotGroup[]>(){

            public VariableInstanceSnapshotGroup[] call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    VariableInstanceSnapshotGroup[] groups = (VariableInstanceSnapshotGroup[])SelectOrEditVariableInstanceSnapshotDialog.this.snapshotGroupsTable.getSelectionModel().getSelectedItems().toArray(VariableInstanceSnapshotGroup[]::new);
                    VariableInstanceSnapshotGroupDAO.delete((Transaction)trx, (VariableInstanceSnapshotGroup[])groups);
                    VariableInstanceSnapshotGroup[] newGroups = SelectOrEditVariableInstanceSnapshotDialog.this.getSnapshotsGroups(trx);
                    Transactions.commitSync((Transaction)trx);
                    VariableInstanceSnapshotGroup[] variableInstanceSnapshotGroupArray = newGroups;
                    return variableInstanceSnapshotGroupArray;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.snapshotGroupsProgressIndicatorPane, (CallableTask)task).consumeResult((status, result) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    this.groups.setAll((Object[])result);
                    this.groupInstances.clear();
                });
            }
        });
    }

    protected void loadInstances(final VariableInstanceSnapshotGroup group) {
        if (group == null) {
            this.groupInstances.clear();
            return;
        }
        CallableTask<VariableInstance[]> task = new CallableTask<VariableInstance[]>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public VariableInstance[] call() throws Exception {
                Throwable throwable = null;
                Object var2_3 = null;
                try (Transaction trx = Transactions.begin();){
                    VariableInstance[] instances = VariableInstanceSnapshotGroupDAO.getVariableInstances((VariableInstanceSnapshotGroup)group);
                    if (instances == null) {
                        return null;
                    }
                    Map variables = VariableDAO.getAsMap((Transaction)trx, (int[])Arrays.stream(instances).mapToInt(i -> i.getVariable().getId()).toArray());
                    Map objects = StructureObjectDAO.getAsMap((Transaction)trx, (int[])Arrays.stream(instances).mapToInt(i -> i.getStructureObject().getId()).toArray());
                    VariableInstance[] variableInstanceArray = instances;
                    int n = instances.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return instances;
                        }
                        VariableInstance instance = variableInstanceArray[n2];
                        instance.setVariable((Variable)variables.get(instance.getVariable().getId()));
                        instance.setStructureObject((StructureObject)objects.get(instance.getStructureObject().getId()));
                        ++n2;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.instancesProgressIndicatorPane, (CallableTask)task).consumeResult((status, result) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    boolean bl = this.groupInstances.setAll((Object[])result);
                });
            } else {
                this.groupInstances.clear();
            }
        });
    }
}

