/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.excel;

import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelUtils {
    public static boolean isExportSupported(Object control) {
        return control instanceof TableView || control instanceof TreeTableView;
    }

    public static void export(Object control, Sheet sheet) {
        if (!ExcelUtils.isExportSupported(control)) {
            throw new IllegalArgumentException("Control type unsupported");
        }
        CellStyle headerStyle = sheet.getWorkbook().createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setBorderBottom(BorderStyle.MEDIUM);
        headerStyle.setBorderLeft(BorderStyle.MEDIUM);
        headerStyle.setBorderRight(BorderStyle.MEDIUM);
        headerStyle.setBorderTop(BorderStyle.MEDIUM);
        LinkedList rootColumns = new LinkedList();
        if (control instanceof TableView) {
            rootColumns.addAll(((TableView)control).getColumns());
        } else {
            rootColumns.addAll(((TreeTableView)control).getColumns());
        }
        Font summaryFont = sheet.getWorkbook().createFont();
        summaryFont.setBold(true);
        CellStyle summaryStyle = sheet.getWorkbook().createCellStyle();
        summaryStyle.setFont(summaryFont);
        Font invalidValueFont = sheet.getWorkbook().createFont();
        invalidValueFont.setColor((short)10);
        CellStyle invalidVarValueStyle = sheet.getWorkbook().createCellStyle();
        invalidVarValueStyle.setFont(invalidValueFont);
        CellStyle tsFormat = sheet.getWorkbook().createCellStyle();
        DataFormat tsDF = sheet.getWorkbook().createDataFormat();
        tsFormat.setDataFormat(tsDF.getFormat(TimeFormatType.DateTimeHMs.getPattern()));
        CellStyle ldFormat = sheet.getWorkbook().createCellStyle();
        DataFormat ldDF = sheet.getWorkbook().createDataFormat();
        ldFormat.setDataFormat(ldDF.getFormat(TimeFormatType.Date.getPattern()));
        int totalDepth = 0;
        for (TableColumnBase rootColumn : rootColumns) {
            totalDepth = Math.max(totalDepth, ExcelUtils.getColumnDepth(rootColumn));
        }
        LinkedList leafColumns = new LinkedList();
        int index = 0;
        for (TableColumnBase rootColumn : rootColumns) {
            int leafCount = ExcelUtils.getVisibleLeafsCount(rootColumn);
            if (leafCount > 0) {
                leafColumns.addAll(ExcelUtils.createHeaders(rootColumn, sheet, index, 0, totalDepth, headerStyle));
            }
            index += leafCount;
        }
        int columnIndex = 0;
        for (TableColumnBase tableColumnBase : leafColumns) {
            Object[] items = ExcelUtils.getControlItems(control, tableColumnBase);
            int i = 0;
            while (i < items.length) {
                Object value = items[i];
                if (value != null) {
                    Row row = sheet.getRow(totalDepth + i);
                    if (row == null) {
                        row = sheet.createRow(totalDepth + i);
                    }
                    Cell cell = row.createCell(columnIndex);
                    VarTableCellData vtcd = null;
                    if (value instanceof VarTableCellData) {
                        vtcd = (VarTableCellData)value;
                        if (vtcd.isSummary()) {
                            cell.setCellStyle(summaryStyle);
                        }
                        if ((value = vtcd.getVarValue()) == null) {
                            value = vtcd.getObject();
                        }
                        if (value instanceof Number) {
                            value = vtcd.getDisplayDoubleValue();
                        }
                    }
                    if (value instanceof IVarValue) {
                        IVarValue iVal = (IVarValue)value;
                        if (Double.isFinite(iVal.getValue())) {
                            if (vtcd != null) {
                                cell.setCellValue(vtcd.getDisplayValue());
                            } else {
                                cell.setCellValue(iVal.getValue());
                            }
                            if (!iVal.isValid()) {
                                cell.setCellStyle(invalidVarValueStyle);
                            }
                        }
                    } else if (value instanceof Number) {
                        double doubleValue = ((Number)value).doubleValue();
                        if (Double.isFinite(doubleValue)) {
                            cell.setCellValue(((Number)value).doubleValue());
                        }
                    } else if (value instanceof Instant) {
                        Instant ts = (Instant)value;
                        ZonedDateTime zdt = ts.atZone(ZoneId.systemDefault());
                        GregorianCalendar gc = GregorianCalendar.from(zdt);
                        cell.setCellValue((Calendar)gc);
                        cell.setCellStyle(tsFormat);
                    } else if (value instanceof LocalDate) {
                        LocalDate ld = (LocalDate)value;
                        GregorianCalendar gc = GregorianCalendar.from(ld.atStartOfDay(ZoneId.systemDefault()));
                        cell.setCellValue((Calendar)gc);
                        cell.setCellStyle(ldFormat);
                    } else if (value != null) {
                        cell.setCellValue(value.toString());
                    }
                }
                ++i;
            }
            ++columnIndex;
        }
    }

    private static <S> Object[] getControlItems(Object control, TableColumnBase<?, ?> column) {
        if (control instanceof TableView) {
            TableView tableView = (TableView)control;
            Object[] items = new Object[tableView.getItems().size()];
            int i = 0;
            while (i < items.length) {
                items[i] = column.getCellData(i);
                ++i;
            }
            return items;
        }
        TreeTableView tableView = (TreeTableView)control;
        LinkedList<Object> items = new LinkedList<Object>();
        ExcelUtils.addTreeItems(tableView.getRoot(), items, column);
        return items.toArray();
    }

    private static <S> void addTreeItems(TreeItem<S> rootItem, LinkedList<Object> flatTreeItems, TableColumnBase<TreeItem<S>, ?> column) {
        for (TreeItem child : rootItem.getChildren()) {
            Object cellData = null;
            if (child.getValue() != null) {
                cellData = column.getCellData((Object)child);
            }
            if (cellData != null) {
                flatTreeItems.add(cellData);
            } else {
                flatTreeItems.add(null);
            }
            ExcelUtils.addTreeItems(child, flatTreeItems, column);
        }
    }

    private static int getColumnDepth(TableColumnBase<?, ?> column) {
        if (column.getColumns().isEmpty()) {
            return 1;
        }
        int maxDepth = 0;
        for (TableColumnBase subColumn : column.getColumns()) {
            maxDepth = Math.max(maxDepth, ExcelUtils.getColumnDepth(subColumn) + 1);
        }
        return maxDepth;
    }

    private static int getVisibleLeafsCount(TableColumnBase<?, ?> column) {
        if (column.getColumns().isEmpty()) {
            return column.isVisible() ? 1 : 0;
        }
        int visibleLeafs = 0;
        for (TableColumnBase subColumn : column.getColumns()) {
            visibleLeafs += ExcelUtils.getVisibleLeafsCount(subColumn);
        }
        return visibleLeafs;
    }

    private static Collection<TableColumnBase<?, ?>> createHeaders(TableColumnBase<?, ?> rootColumn, Sheet sheet, int index, int depth, int totalDepth, CellStyle headerStyle) {
        LinkedList leafColumns = new LinkedList();
        if (rootColumn.getColumns().isEmpty()) {
            if (rootColumn.isVisible()) {
                leafColumns.add(rootColumn);
                Row row = sheet.getRow(depth);
                if (row == null) {
                    row = sheet.createRow(depth);
                }
                Cell cell = row.createCell(index);
                cell.setCellValue(rootColumn.getText());
                cell.setCellStyle(headerStyle);
                if (depth < totalDepth - 1) {
                    int i = depth + 1;
                    while (i < totalDepth) {
                        row = sheet.getRow(i);
                        if (row == null) {
                            row = sheet.createRow(i);
                        }
                        Cell mCell = row.createCell(index);
                        mCell.setCellStyle(headerStyle);
                        ++i;
                    }
                    CellRangeAddress region = new CellRangeAddress(depth, totalDepth - 1, index, index);
                    sheet.addMergedRegion(region);
                }
                int columnWidth = (int)rootColumn.getWidth() * 40;
                sheet.setColumnWidth(index, columnWidth);
            }
        } else {
            int leafCount = ExcelUtils.getVisibleLeafsCount(rootColumn);
            if (leafCount == 0) {
                return leafColumns;
            }
            Row row = sheet.getRow(depth);
            if (row == null) {
                row = sheet.createRow(depth);
            }
            Cell cell = row.createCell(index);
            cell.setCellValue(rootColumn.getText());
            cell.setCellStyle(headerStyle);
            if (leafCount > 1) {
                int i = index + 1;
                while (i < index + leafCount) {
                    Cell mCell = row.createCell(i);
                    mCell.setCellStyle(headerStyle);
                    ++i;
                }
                CellRangeAddress region = new CellRangeAddress(depth, depth, index, index + leafCount - 1);
                sheet.addMergedRegion(region);
            }
            int lfIndex = index;
            for (TableColumnBase subColumn : rootColumn.getColumns()) {
                int subLeafCount = ExcelUtils.getVisibleLeafsCount(subColumn);
                leafColumns.addAll(ExcelUtils.createHeaders(subColumn, sheet, lfIndex, depth + 1, totalDepth, headerStyle));
                lfIndex += subLeafCount;
            }
        }
        return leafColumns;
    }
}

