/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.graph.ObjectGroupView;
import de.elpro.ewms.core.fx.graph.ObjectInputValueView;
import de.elpro.ewms.core.fx.graph.ObjectValueView;
import de.elpro.ewms.core.fx.graph.ObjectValuesView;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.graph.ObjectGroup;
import de.elpro.ewms.core.graph.ObjectInputValue;
import de.elpro.ewms.core.graph.ObjectValue;
import de.elpro.ewms.core.graph.ObjectValues;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.resources.Icons;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.PickResult;
import javafx.scene.layout.StackPane;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;

public class GraphChartView
extends Control {
    private final MenuItem edit = new MenuItem("Edit", (Node)new ImageView(Icons.EDIT_ITEM_URL.toString()));
    private final MenuItem copy = new MenuItem("Copy");
    private final MenuItem paste = new MenuItem("Paste");
    private final MenuItem newGroup = new MenuItem("Objects Group");
    private final MenuItem newValues = new MenuItem("Object Values Group");
    private final MenuItem newOutputValue = new MenuItem("Output Value");
    private final MenuItem newInputValue = new MenuItem("Input Value");
    private final Menu create = new Menu("Create", (Node)new ImageView(Icons.ADD_ITEM_URL.toString()), new MenuItem[]{this.newGroup, this.newValues, this.newOutputValue, this.newInputValue});
    private final MenuItem delete = new MenuItem("Delete", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
    private final ContextMenu contextMenu = new ContextMenu(new MenuItem[]{this.edit, this.copy, this.paste, new SeparatorMenuItem(), this.create, this.delete});
    private SimpleStringProperty jsonView = new SimpleStringProperty();
    private ITimeRangeFilter timeRangeFilter;
    private ProgressIndicatorPane progressIndicator;
    private Node lastClick;
    private ObjectValues copyObject;
    private double clickX;
    private double clickY;
    private final StructureObject rootObject;
    private final GraphChart graphChart;
    private final ObjectGroup rootObjectGroup;
    private final Multimap<VariableInstance, ObjectValue> rangeInstanceValues = HashMultimap.create();
    private final Multimap<VariableInstance, ObjectValue> realtimeInstanceValues = HashMultimap.create();
    private final Multimap<VariableInstance, ObjectInputValue> inputInstanceValues = HashMultimap.create();
    private final Map<ObjectInputValue, VariableInstance> inputValuesInstances = new HashMap<ObjectInputValue, VariableInstance>();
    private final HashMap<VariableInstance, SupplementValueChange> supplementValuesChanges = new HashMap();
    private final BooleanProperty hasChanges = new SimpleBooleanProperty();
    private boolean adjustable = true;
    private volatile boolean reloadingData = false;
    private final InputValueChangedCallback inputValueChangedCallback = (objectInputValue, value) -> {
        if (this.reloadingData) {
            return;
        }
        VariableInstance instance = this.inputValuesInstances.get(objectInputValue);
        if (value == null || instance.getSupplementValueStrategy() != SupplementValueStrategy.Unrasterized) {
            return;
        }
        SupplementValueChange change = new SupplementValueChange(instance, null, null, null, value.doubleValue());
        this.supplementValuesChanges.put(instance, change);
        this.hasChanges.set(true);
    };

    public GraphChartView(StructureObject rootObject, GraphChart graphChart, ITimeRangeFilter timeRangePrefs) {
        this.rootObject = rootObject;
        this.graphChart = graphChart;
        this.rootObjectGroup = graphChart.getRootObjectGroup();
        this.timeRangeFilter = timeRangePrefs;
        this.reloadConfiguration();
        this.getStylesheets().add((Object)GraphChartView.class.getResource("object-graph.css").toExternalForm());
        this.getStyleClass().add((Object)"object-graph");
    }

    public boolean isAdjustable() {
        return this.adjustable;
    }

    public void setAdjustable(boolean adjustable) {
        this.adjustable = adjustable;
    }

    protected Skin<?> createDefaultSkin() {
        try {
            DefaultSkin skin = new DefaultSkin(this);
            this.reloadData();
            return skin;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SupplementValueChange> getSupplementValuesChanges() {
        return new ArrayList<SupplementValueChange>(this.supplementValuesChanges.values());
    }

    public void resetChanges() {
        this.supplementValuesChanges.clear();
        this.hasChanges.set(false);
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    public void saveChanges(Instant unrasterizedValuesTs, boolean overwriteLaterUnrasterizedValues) throws DAOOperationException {
        List<SupplementValueChange> supplementValuesChanges = this.getSupplementValuesChanges();
        for (SupplementValueChange svc : supplementValuesChanges) {
            if (!svc.isUnrasterizedValue()) continue;
            svc.setUnrasterizedTs(unrasterizedValuesTs);
        }
        if (!supplementValuesChanges.isEmpty()) {
            VariableInstanceDAO.applySupplementValuesChanges((SupplementValueChange[])supplementValuesChanges.toArray(new SupplementValueChange[0]), (boolean)overwriteLaterUnrasterizedValues);
        }
        this.resetChanges();
    }

    public void reloadData() {
        this.resetChanges();
        final boolean realtime = this.timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView;
        final RawValuesViewType viewType = this.timeRangeFilter.getType().toRawValueViewType();
        final Integer customViewIndex = this.timeRangeFilter.getCustomViewIndex();
        final Instant from = this.timeRangeFilter.getFrom();
        final Instant to = this.timeRangeFilter.getTo();
        VariableInstance[] outputInstances = realtime ? (VariableInstance[])this.realtimeInstanceValues.keySet().toArray(VariableInstance[]::new) : (VariableInstance[])this.rangeInstanceValues.keySet().toArray(VariableInstance[]::new);
        VariableInstance[] inputInstances = (VariableInstance[])this.inputInstanceValues.keys().toArray(VariableInstance[]::new);
        final VariableInstance[] instances = Arrays.copyOf(outputInstances, outputInstances.length + inputInstances.length);
        int i = 0;
        while (i < inputInstances.length) {
            instances[outputInstances.length + i] = inputInstances[i];
            ++i;
        }
        CallableTask<IVarValue[]> task = new CallableTask<IVarValue[]>(){

            public IVarValue[] call() throws Exception {
                VarValue[] values;
                if (realtime) {
                    Raster realtimeViewRaster = ServerDAO.getRealtimeViewRaster();
                    values = VariableInstanceDAO.getLastValidVarValues((RawValuesViewType)viewType, null, (VariableInstance[])instances, (long)(realtimeViewRaster.toMilli() * 10L));
                } else {
                    IVarValuesCollection[] lowResValues = VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (VariableInstance[])instances, (Instant)from, (Instant)to, (ComplexRaster)ComplexRaster.OVERALL);
                    values = new IVarValue[lowResValues.length];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = lowResValues[i].getFirst();
                        ++i;
                    }
                }
                return values;
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult((state, values) -> {
            if (state == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    try {
                        IVarValue value;
                        VariableInstance instance;
                        this.reloadingData = true;
                        HashMap<ObjectValue, ObjectValueView> objectValueViews = new HashMap<ObjectValue, ObjectValueView>();
                        for (ObjectValueView ovv : FXUtils.findChildren((Node)this, ObjectValueView.class)) {
                            objectValueViews.put(ovv.getObjectValue(), ovv);
                        }
                        HashMap<ObjectInputValue, ObjectInputValueView> objectInputValueViews = new HashMap<ObjectInputValue, ObjectInputValueView>();
                        for (ObjectInputValueView oivv : FXUtils.findChildren((Node)this, ObjectInputValueView.class)) {
                            objectInputValueViews.put(oivv.getObjectInputValue(), oivv);
                        }
                        int i = 0;
                        while (i < outputInstances.length) {
                            instance = outputInstances[i];
                            value = values[i];
                            for (ObjectValue ov : realtime ? this.realtimeInstanceValues.get((Object)instance) : this.rangeInstanceValues.get((Object)instance)) {
                                ObjectValueView ovv = (ObjectValueView)((Object)((Object)((Object)objectValueViews.get(ov))));
                                if (ovv == null) continue;
                                ovv.updateValue(value, realtime);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < inputInstances.length) {
                            instance = inputInstances[i];
                            value = values[outputInstances.length + i];
                            for (ObjectInputValue oiv : this.inputInstanceValues.get((Object)instance)) {
                                ObjectInputValueView oivv = (ObjectInputValueView)((Object)((Object)((Object)objectInputValueViews.get(oiv))));
                                if (oivv == null) continue;
                                oivv.updateValue(value);
                            }
                            ++i;
                        }
                    }
                    finally {
                        this.reloadingData = false;
                    }
                });
            }
        });
    }

    public void loadData(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        this.reloadData();
    }

    protected void reloadConfiguration() {
        Transaction trx = Transactions.begin();
        try {
            this.rangeInstanceValues.clear();
            this.realtimeInstanceValues.clear();
            this.inputInstanceValues.clear();
            this.inputValuesInstances.clear();
            this.loadConfiguration(trx, this.rootObjectGroup);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.reloadData();
    }

    protected void loadConfiguration(Transaction trx, ObjectGroup group) {
        for (ObjectGroup childGroup : group.getObjectGroups()) {
            this.loadConfiguration(trx, childGroup);
        }
        for (ObjectValues objectValues : group.getObjectValues()) {
            VariableInstance[] instances;
            Variable var;
            StructureObject object = GraphChartView.findStructureObject(trx, this.rootObject, objectValues);
            if (object == null) continue;
            for (ObjectValue objectValue : objectValues.getValues()) {
                if (objectValue.getVariable() == null) continue;
                var = VariableDAO.get((Transaction)trx, (int)objectValue.getVariable().getId());
                if (var == null) {
                    objectValue.setVariable(null);
                    continue;
                }
                objectValue.setVariable(var);
                instances = VariableDAO.findInstances((Transaction)trx, (Variable)var, (StructureObject)object, (SearchPolicy)SearchPolicy.This);
                VariableInstance rangeInstance = null;
                VariableInstance realtimeInstance = null;
                if (instances.length == 1) {
                    rangeInstance = instances[0];
                    rangeInstance.setVariable(var);
                    realtimeInstance = rangeInstance;
                }
                if (objectValue.getRealtimeVariable() != null) {
                    var = VariableDAO.get((Transaction)trx, (int)objectValue.getRealtimeVariable().getId());
                    objectValue.setRealtimeVariable(var);
                    instances = VariableDAO.findInstances((Transaction)trx, (Variable)var, (StructureObject)object, (SearchPolicy)SearchPolicy.This);
                    if (instances.length == 1) {
                        realtimeInstance = instances[0];
                        realtimeInstance.setVariable(var);
                    }
                }
                this.rangeInstanceValues.put((Object)rangeInstance, (Object)objectValue);
                this.realtimeInstanceValues.put((Object)realtimeInstance, (Object)objectValue);
            }
            for (ObjectInputValue objectInputValue : objectValues.getInputValues()) {
                var = VariableDAO.get((Transaction)trx, (int)objectInputValue.getVariable().getId());
                if (var == null) {
                    objectInputValue.setVariable(null);
                    continue;
                }
                objectInputValue.setVariable(var);
                instances = VariableDAO.findInstances((Transaction)trx, (Variable)var, (StructureObject)object, (SearchPolicy)SearchPolicy.This);
                if (instances.length != 1) continue;
                VariableInstance instance = instances[0];
                this.inputInstanceValues.put((Object)instance, (Object)objectInputValue);
                this.inputValuesInstances.put(objectInputValue, instance);
            }
        }
    }

    void childChanged() {
        this.updateJsonView();
    }

    void updateJsonView() {
        if (this.rootObjectGroup == null) {
            this.jsonView.set(null);
        } else {
            this.jsonView.set(this.rootObjectGroup.toJson());
        }
    }

    public SimpleStringProperty jsonViewProperty() {
        return this.jsonView;
    }

    public static StructureObject findStructureObject(Transaction trx, StructureObject rootObject, ObjectValues objectValues) {
        StructureObject object = objectValues.getStructureObject();
        if (object == null) {
            StructureObject[] candidates;
            if (rootObject == null || objectValues.getStructureClass() == null) {
                return null;
            }
            SearchPolicy searchPolicy = objectValues.getStructureObjectSearchPolicy();
            if (searchPolicy == null) {
                searchPolicy = SearchPolicy.Auto;
            }
            if ((candidates = StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)rootObject, (StructureClass)objectValues.getStructureClass(), (SearchPolicy)searchPolicy)).length != 1) {
                return null;
            }
            return candidates[0];
        }
        return StructureObjectDAO.get((Transaction)trx, (int)object.getId());
    }

    private class DefaultSkin
    extends SkinBase<GraphChartView> {
        protected DefaultSkin(GraphChartView control) {
            super((Control)control);
            ObjectGroupView rootOGV = new ObjectGroupView(GraphChartView.this.rootObject, GraphChartView.this.rootObjectGroup, GraphChartView.this.isAdjustable());
            ScrollPane scrollPane = new ScrollPane((Node)new StackPane(new Node[]{new InfiniteCanvas(), rootOGV}));
            for (ObjectInputValueView oivv : FXUtils.findChildren((Node)rootOGV, ObjectInputValueView.class)) {
                oivv.setInputValueChangedCallback(GraphChartView.this.inputValueChangedCallback);
            }
            scrollPane.setFitToHeight(true);
            scrollPane.setFitToWidth(true);
            GraphChartView.this.progressIndicator = new ProgressIndicatorPane((Node)scrollPane);
            this.getChildren().add((Object)GraphChartView.this.progressIndicator);
            GraphChartView.this.rootObjectGroup.contentWidthProperty().bind((ObservableValue)rootOGV.widthProperty());
            GraphChartView.this.rootObjectGroup.contentHeightProperty().bind((ObservableValue)rootOGV.heightProperty());
            if (!GraphChartView.this.isAdjustable()) {
                return;
            }
            GraphChartView.this.setContextMenu(GraphChartView.this.contextMenu);
            GraphChartView.this.setOnMouseClicked(e -> {
                PickResult pickResult = e.getPickResult();
                GraphChartView.this.lastClick = FXUtils.findParent((Node)pickResult.getIntersectedNode(), ObjectValueView.class);
                if (GraphChartView.this.lastClick == null) {
                    GraphChartView.this.lastClick = FXUtils.findParent((Node)pickResult.getIntersectedNode(), ObjectInputValueView.class);
                }
                if (GraphChartView.this.lastClick == null) {
                    GraphChartView.this.lastClick = FXUtils.findParent((Node)pickResult.getIntersectedNode(), ObjectValuesView.class);
                }
                GraphChartView.this.newOutputValue.setDisable(GraphChartView.this.lastClick == null);
                GraphChartView.this.newInputValue.setDisable(GraphChartView.this.lastClick == null);
                GraphChartView.this.copy.setDisable(GraphChartView.this.lastClick == null);
                if (GraphChartView.this.lastClick == null) {
                    GraphChartView.this.lastClick = FXUtils.findParent((Node)pickResult.getIntersectedNode(), ObjectGroupView.class);
                }
                if (GraphChartView.this.lastClick != null) {
                    Bounds clickBounds = GraphChartView.this.lastClick.localToScene(GraphChartView.this.lastClick.getBoundsInLocal());
                    GraphChartView.this.clickX = e.getSceneX() - clickBounds.getMinX();
                    GraphChartView.this.clickY = e.getSceneY() - clickBounds.getMinY();
                }
            });
            GraphChartView.this.edit.setOnAction(e -> {
                if (GraphChartView.this.lastClick instanceof ObjectGroupView) {
                    ObjectGroupView ogv = (ObjectGroupView)GraphChartView.this.lastClick;
                    if (ObjectGroupView.edit(GraphChartView.this.getScene().getWindow(), ogv.getObjectGroup())) {
                        ogv.updateMinBounds();
                        GraphChartView.this.requestLayout();
                        GraphChartView.this.childChanged();
                    }
                } else if (GraphChartView.this.lastClick instanceof ObjectValuesView) {
                    ObjectValuesView ovv = (ObjectValuesView)GraphChartView.this.lastClick;
                    if (ObjectValuesView.edit(GraphChartView.this.getScene().getWindow(), ovv.getObjectValues())) {
                        ovv.updateView();
                        GraphChartView.this.childChanged();
                        GraphChartView.this.reloadConfiguration();
                    }
                } else if (GraphChartView.this.lastClick instanceof ObjectValueView) {
                    ObjectValueView ov = (ObjectValueView)GraphChartView.this.lastClick;
                    ObjectValuesView ovv = (ObjectValuesView)FXUtils.findParent((Node)ov, ObjectValuesView.class);
                    StructureClass structureClass = ovv.getObjectValues().getStructureClass();
                    if (structureClass == null) {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.initOwner(GraphChartView.this.getScene().getWindow());
                        alert.setContentText("Structure Class ist Null. Please set Structure Class at ObjectValues first!");
                        alert.showAndWait();
                        return;
                    }
                    if (ObjectValueView.edit(GraphChartView.this.getScene().getWindow(), structureClass, ov.getObjectValue())) {
                        ov.updateValueView();
                        GraphChartView.this.childChanged();
                        GraphChartView.this.reloadConfiguration();
                    }
                } else if (GraphChartView.this.lastClick instanceof ObjectInputValueView) {
                    ObjectInputValueView ov = (ObjectInputValueView)GraphChartView.this.lastClick;
                    ObjectValuesView ovv = (ObjectValuesView)FXUtils.findParent((Node)ov, ObjectValuesView.class);
                    StructureClass structureClass = ovv.getObjectValues().getStructureClass();
                    if (structureClass == null) {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.initOwner(GraphChartView.this.getScene().getWindow());
                        alert.setContentText("Structure Class ist Null. Please set Structure Class at ObjectValues first!");
                        alert.showAndWait();
                        return;
                    }
                    if (ObjectInputValueView.edit(GraphChartView.this.getScene().getWindow(), structureClass, ov.getObjectInputValue())) {
                        ov.updateInputValueView();
                        GraphChartView.this.childChanged();
                        GraphChartView.this.reloadConfiguration();
                    }
                }
            });
            GraphChartView.this.newGroup.setOnAction(e -> {
                if (GraphChartView.this.lastClick instanceof ObjectGroupView) {
                    ObjectGroup clickOg = ((ObjectGroupView)GraphChartView.this.lastClick).getObjectGroup();
                    ObjectGroup og = new ObjectGroup();
                    og.setLabel("Subgroup");
                    og.setContentHeight(clickOg.getContentHeight() / 2.0);
                    og.setContentWidth(clickOg.getContentWidth() / 2.0);
                    og.setContentLayoutX(Math.max(0.0, Math.min(GraphChartView.this.clickX - 10.0, clickOg.getContentWidth() - og.getContentWidth() - 12.0)));
                    og.setContentLayoutY(Math.max(0.0, Math.min(GraphChartView.this.clickY - 30.0, clickOg.getContentHeight() - og.getContentHeight() - 12.0 - 20.0)));
                    clickOg.getObjectGroups().add((Object)og);
                }
                GraphChartView.this.childChanged();
            });
            GraphChartView.this.newValues.setOnAction(e -> {
                if (GraphChartView.this.lastClick instanceof ObjectGroupView) {
                    ObjectGroup clickOg = ((ObjectGroupView)GraphChartView.this.lastClick).getObjectGroup();
                    ObjectValues ov = new ObjectValues();
                    ov.setContentWidth(Math.min(clickOg.getContentWidth() / 2.0, 130.0));
                    ov.setContentLayoutX(Math.max(0.0, Math.min(GraphChartView.this.clickX - 10.0, clickOg.getContentWidth() - ov.getContentWidth() - 12.0)));
                    ov.setContentLayoutY(Math.max(0.0, Math.min(GraphChartView.this.clickY - 30.0, clickOg.getContentHeight() - 40.0 - 12.0 - 20.0)));
                    if (ObjectValuesView.edit(GraphChartView.this.getScene().getWindow(), ov)) {
                        clickOg.getObjectValues().add((Object)ov);
                        GraphChartView.this.childChanged();
                    }
                }
            });
            GraphChartView.this.newOutputValue.setOnAction(e -> {
                if (GraphChartView.this.lastClick instanceof ObjectValuesView || GraphChartView.this.lastClick instanceof ObjectValueView || GraphChartView.this.lastClick instanceof ObjectInputValueView) {
                    ObjectValues clickOV = GraphChartView.this.lastClick instanceof ObjectValuesView ? ((ObjectValuesView)GraphChartView.this.lastClick).getObjectValues() : ((ObjectValuesView)FXUtils.findParent((Node)GraphChartView.this.lastClick, ObjectValuesView.class)).getObjectValues();
                    ObjectValue ov = new ObjectValue();
                    StructureClass clazz = clickOV.getStructureClass();
                    if (clazz == null) {
                        StructureClass structureClass = clazz = clickOV.getStructureObject() != null ? clickOV.getStructureObject().getStructureClass() : null;
                    }
                    if (ObjectValueView.edit(GraphChartView.this.getScene().getWindow(), clazz, ov)) {
                        clickOV.getValues().add((Object)ov);
                        GraphChartView.this.childChanged();
                    }
                }
                GraphChartView.this.reloadConfiguration();
            });
            GraphChartView.this.newInputValue.setOnAction(e -> {
                if (GraphChartView.this.lastClick instanceof ObjectValuesView || GraphChartView.this.lastClick instanceof ObjectValueView || GraphChartView.this.lastClick instanceof ObjectInputValueView) {
                    ObjectValues clickOV = GraphChartView.this.lastClick instanceof ObjectValuesView ? ((ObjectValuesView)GraphChartView.this.lastClick).getObjectValues() : ((ObjectValuesView)FXUtils.findParent((Node)GraphChartView.this.lastClick, ObjectValuesView.class)).getObjectValues();
                    ObjectInputValue ov = new ObjectInputValue();
                    StructureClass clazz = clickOV.getStructureClass();
                    if (clazz == null) {
                        StructureClass structureClass = clazz = clickOV.getStructureObject() != null ? clickOV.getStructureObject().getStructureClass() : null;
                    }
                    if (ObjectInputValueView.edit(GraphChartView.this.getScene().getWindow(), clazz, ov)) {
                        clickOV.getInputValues().add((Object)ov);
                        GraphChartView.this.childChanged();
                    }
                }
                GraphChartView.this.reloadConfiguration();
            });
            GraphChartView.this.copy.setOnAction(e -> {
                if (GraphChartView.this.lastClick instanceof ObjectValuesView) {
                    GraphChartView.this.copyObject = ((ObjectValuesView)GraphChartView.this.lastClick).getObjectValues();
                } else if (GraphChartView.this.lastClick instanceof ObjectValueView) {
                    GraphChartView.this.copyObject = ((ObjectValuesView)FXUtils.findParent((Node)GraphChartView.this.lastClick, ObjectValuesView.class)).getObjectValues();
                }
                if (GraphChartView.this.copyObject != null) {
                    GraphChartView.this.paste.setDisable(false);
                }
            });
            GraphChartView.this.paste.setDisable(true);
            GraphChartView.this.paste.setOnAction(e -> {
                if (GraphChartView.this.copyObject == null) {
                    return;
                }
                ObjectValues ov = GraphChartView.this.copyObject.copy();
                ov.setContentLayoutX(GraphChartView.this.clickX);
                ov.setContentLayoutY(GraphChartView.this.clickY);
                ObjectGroupView clickOGV = (ObjectGroupView)FXUtils.findParent((Node)GraphChartView.this.lastClick, ObjectGroupView.class);
                clickOGV.getObjectGroup().getObjectValues().add((Object)ov);
                GraphChartView.this.childChanged();
                GraphChartView.this.reloadConfiguration();
            });
            GraphChartView.this.delete.setOnAction(e -> {
                ObjectInputValueView clickOV;
                ObjectValuesView ovv;
                if (GraphChartView.this.lastClick instanceof ObjectGroupView) {
                    ObjectGroupView clickOGV = (ObjectGroupView)GraphChartView.this.lastClick;
                    if (clickOGV.getObjectGroupViewParent() != null) {
                        clickOGV.getObjectGroupViewParent().getObjectGroup().getObjectGroups().remove((Object)clickOGV.getObjectGroup());
                        GraphChartView.this.childChanged();
                    }
                } else if (GraphChartView.this.lastClick instanceof ObjectValuesView) {
                    ObjectValuesView clickOV2 = (ObjectValuesView)GraphChartView.this.lastClick;
                    if (clickOV2.getObjectGroupViewParent() != null) {
                        clickOV2.getObjectGroupViewParent().getObjectGroup().getObjectValues().remove((Object)clickOV2.getObjectValues());
                        GraphChartView.this.childChanged();
                    }
                } else if (GraphChartView.this.lastClick instanceof ObjectValueView) {
                    ObjectValueView clickOV3 = (ObjectValueView)GraphChartView.this.lastClick;
                    ObjectValuesView ovv2 = (ObjectValuesView)FXUtils.findParent((Node)clickOV3, ObjectValuesView.class);
                    if (ovv2 != null) {
                        ovv2.getObjectValues().getValues().remove((Object)clickOV3.getObjectValue());
                        GraphChartView.this.childChanged();
                    }
                } else if (GraphChartView.this.lastClick instanceof ObjectInputValueView && (ovv = (ObjectValuesView)FXUtils.findParent((Node)(clickOV = (ObjectInputValueView)GraphChartView.this.lastClick), ObjectValuesView.class)) != null) {
                    ovv.getObjectValues().getInputValues().remove((Object)clickOV.getObjectInputValue());
                    GraphChartView.this.childChanged();
                }
                GraphChartView.this.reloadConfiguration();
            });
        }
    }

    static interface InputValueChangedCallback {
        public void onEdit(ObjectInputValue var1, Double var2);
    }
}

