/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.graph.ObjectGroup;
import de.elpro.ui.fx.propertysheet.DoublePropertyItem;
import de.elpro.ui.fx.propertysheet.FileTextPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;

class ObjectGroupPrefsDialog
extends Dialog<ButtonType> {
    private final SimpleStringProperty label = new SimpleStringProperty();
    private final SimpleObjectProperty<Color> background = new SimpleObjectProperty();
    private final SimpleStringProperty backgroundSvg = new SimpleStringProperty();
    private final SimpleDoubleProperty contentWidth = new SimpleDoubleProperty(300.0);
    private final SimpleDoubleProperty contentHeight = new SimpleDoubleProperty(300.0);
    private final SimpleDoubleProperty contentLayoutX = new SimpleDoubleProperty();
    private final SimpleDoubleProperty contentLayoutY = new SimpleDoubleProperty();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    public ObjectGroupPrefsDialog(Window window, ObjectGroup objectGroup) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner(window);
        PropertySheet sheet = new PropertySheet();
        this.label.set(objectGroup.getLabel());
        LocaleStringPropertyItem labelItem = new LocaleStringPropertyItem("Label", (ObservableValue)this.label);
        this.background.set((Object)objectGroup.getBackgroundColor());
        PaintPropertyItem backgroundColorItem = new PaintPropertyItem("Background", this.background);
        this.backgroundSvg.set(objectGroup.getBackgroundSvg());
        FileTextPropertyItem backgroundSvgItem = new FileTextPropertyItem("SVG", (ObservableValue)this.backgroundSvg);
        backgroundSvgItem.setExtensionFilters(Collections.singletonList(new FileChooser.ExtensionFilter("SVG Image (*.svg)", new String[]{"*.svg"})));
        this.contentWidth.set(objectGroup.getContentWidth());
        DoublePropertyItem widthItem = new DoublePropertyItem("Width", (ObservableValue)this.contentWidth);
        this.contentHeight.set(objectGroup.getContentHeight());
        DoublePropertyItem heightItem = new DoublePropertyItem("Height", (ObservableValue)this.contentHeight);
        this.contentLayoutX.set(objectGroup.getContentLayoutX());
        DoublePropertyItem xItem = new DoublePropertyItem("Layout X", (ObservableValue)this.contentLayoutX);
        this.contentLayoutY.set(objectGroup.getContentLayoutY());
        DoublePropertyItem yItem = new DoublePropertyItem("Layout Y", (ObservableValue)this.contentLayoutY);
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{labelItem, backgroundColorItem, backgroundSvgItem, widthItem, heightItem, xItem, yItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.getDialogPane().setPrefWidth(400.0);
        this.getDialogPane().setPrefHeight(350.0);
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.hasChanges));
    }

    public String getLabel() {
        return this.label.get();
    }

    public Color getBackgroundColor() {
        return (Color)this.background.get();
    }

    public String getBackgroundSvg() {
        return this.backgroundSvg.get();
    }

    public double getContentWidth() {
        return this.contentWidth.get();
    }

    public double getContentHeight() {
        return this.contentHeight.get();
    }

    public double getContentLayoutX() {
        return this.contentLayoutX.get();
    }

    public double getContentLayoutY() {
        return this.contentLayoutY.get();
    }
}

