/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.fx.graph.GraphChartView;
import de.elpro.ewms.core.fx.graph.ObjectGroupPrefsDialog;
import de.elpro.ewms.core.fx.graph.ObjectValuesView;
import de.elpro.ewms.core.fx.graph.ResizableContentView;
import de.elpro.ewms.core.graph.ObjectGroup;
import de.elpro.ewms.core.graph.ObjectValues;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.fx.utils.FXUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import org.controlsfx.dialog.ExceptionDialog;

class ObjectGroupView
extends Chart
implements ResizableContentView {
    private static final Border DEFAULT_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)});
    private static final int RESIZE_MARGIN = 5;
    private final StructureObject rootObject;
    private final ObjectGroup objectGroup;
    private ObjectGroupView parent;
    private final Map<ObjectGroup, ObjectGroupView> childGroupViews = new HashMap<ObjectGroup, ObjectGroupView>();
    private final Map<ObjectValues, ObjectValuesView> objectValuesViews = new HashMap<ObjectValues, ObjectValuesView>();
    private double originalX;
    private double originalY;
    private double chartContentWidth;
    private double chartContentHeight;
    private boolean dragging;
    private boolean xResizing;
    private boolean yResizing;
    private final boolean adjustable;
    protected Label titleLabel;

    public ObjectGroupView(StructureObject rootObject, ObjectGroup objectGroup, boolean adjustable) {
        this.getStyleClass().add((Object)"object-group");
        this.rootObject = rootObject;
        this.objectGroup = objectGroup;
        this.adjustable = adjustable;
        objectGroup.labelProperty().addListener(il -> this.setTitle(objectGroup.getLocalLabel()));
        this.setTitle(objectGroup.getLocalLabel());
        this.updateBackground();
        objectGroup.backgroundColorProperty().addListener(il -> this.updateBackground());
        objectGroup.backgroundSvgProperty().addListener(il -> this.updateBackground());
        for (ObjectGroup childGroup : objectGroup.getObjectGroups()) {
            this.addChildObjectGroup(childGroup);
        }
        for (ObjectValues objectValues : objectGroup.getObjectValues()) {
            this.addChildObjectValues(objectValues);
        }
        objectGroup.getObjectGroups().addListener(li -> {
            while (li.next()) {
                for (ObjectGroup newGroup : li.getAddedSubList()) {
                    this.addChildObjectGroup(newGroup);
                    this.updateMinBounds();
                    this.requestChartLayout();
                }
                for (ObjectGroup removedGroup : li.getRemoved()) {
                    ObjectGroupView removedObjectGroupView = this.childGroupViews.remove(removedGroup);
                    this.getChartChildren().remove((Object)removedObjectGroupView);
                    this.updateMinBounds();
                    this.requestChartLayout();
                }
            }
        });
        objectGroup.getObjectValues().addListener(li -> {
            while (li.next()) {
                for (ObjectValues newValues : li.getAddedSubList()) {
                    this.addChildObjectValues(newValues);
                    this.updateMinBounds();
                    this.requestChartLayout();
                }
                for (ObjectValues removedGroup : li.getRemoved()) {
                    ObjectValuesView removedObjectValuesView = this.objectValuesViews.remove(removedGroup);
                    this.getChartChildren().remove((Object)removedObjectValuesView);
                    this.updateMinBounds();
                    this.requestChartLayout();
                }
            }
        });
        this.updateMinBounds();
        this.requestChartLayout();
    }

    public boolean isAdjustable() {
        return this.adjustable;
    }

    public ObjectGroup getObjectGroup() {
        return this.objectGroup;
    }

    @Override
    public ObjectGroupView getObjectGroupViewParent() {
        return this.parent;
    }

    public static boolean edit(Window window, ObjectGroup objectGroup) {
        ObjectGroupPrefsDialog dlg = new ObjectGroupPrefsDialog(window, objectGroup);
        ButtonType btn = (ButtonType)dlg.showAndWait().get();
        if (btn.equals(ButtonType.OK)) {
            objectGroup.setLabel(dlg.getLabel());
            objectGroup.setBackgroundColor(dlg.getBackgroundColor());
            objectGroup.setBackgroundSvg(dlg.getBackgroundSvg());
            if (objectGroup.getParent() != null) {
                objectGroup.setContentWidth(dlg.getContentWidth());
                objectGroup.setContentHeight(dlg.getContentHeight());
                objectGroup.setContentLayoutX(dlg.getContentLayoutX());
                objectGroup.setContentLayoutY(dlg.getContentLayoutY());
            }
            return true;
        }
        return false;
    }

    private void addChildObjectGroup(ObjectGroup childGroup) {
        childGroup.setParent(this.objectGroup);
        ObjectGroupView childGroupView = new ObjectGroupView(this.rootObject, childGroup, this.adjustable);
        childGroupView.parent = this;
        childGroupView.setBorder(DEFAULT_BORDER);
        if (this.isAdjustable()) {
            ObjectGroupView.makeDraggableAndResizable(childGroupView);
        }
        this.childGroupViews.put(childGroup, childGroupView);
        this.getChartChildren().add((Object)childGroupView);
    }

    private void addChildObjectValues(ObjectValues objectValues) {
        ObjectValuesView objectValuesView = new ObjectValuesView(this.rootObject, objectValues, this.isAdjustable());
        this.objectValuesViews.put(objectValues, objectValuesView);
        objectValuesView.setObjectGroupViewParent(this);
        if (this.isAdjustable()) {
            ObjectGroupView.makeDraggableAndResizable(objectValuesView);
        }
        this.getChartChildren().add((Object)objectValuesView);
    }

    private void updateBackground() {
        BackgroundFill fill = null;
        BackgroundImage backgroundImage = null;
        if (this.objectGroup.getBackgroundColor() != null) {
            fill = new BackgroundFill((Paint)this.objectGroup.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY);
        }
        if (this.objectGroup.getBackgroundSvg() != null) {
            try {
                byte[] bytes = this.objectGroup.getBackgroundSvg().getBytes(StandardCharsets.UTF_8);
                Image image = new Image((InputStream)new ByteArrayInputStream(bytes));
                BackgroundPosition position = this.objectGroup.getParent() == null ? BackgroundPosition.DEFAULT : BackgroundPosition.CENTER;
                backgroundImage = new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, position, BackgroundSize.DEFAULT);
            }
            catch (Exception exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.show();
            }
        }
        if (fill == null && backgroundImage == null) {
            this.setBackground(null);
        } else if (fill != null && backgroundImage == null) {
            this.setBackground(new Background(new BackgroundFill[]{fill}));
        } else if (fill == null && backgroundImage != null) {
            this.setBackground(new Background(new BackgroundImage[]{backgroundImage}));
        } else {
            this.setBackground(new Background(new BackgroundFill[]{fill}, new BackgroundImage[]{backgroundImage}));
        }
    }

    protected static void makeDraggableAndResizable(ResizableContentView resizable) {
        Region dragNode = resizable.getDragNode();
        Region mhn = resizable.getMouseHandleNode();
        mhn.setOnMouseMoved(t -> {
            boolean inV = ObjectGroupView.isInVResizeZone(mhn, t);
            boolean inH = ObjectGroupView.isInHResizeZone(mhn, t);
            if (inV && !inH || resizable.getYResizing() && !resizable.getXResizing()) {
                mhn.setCursor(Cursor.S_RESIZE);
            }
            if (inH && !inV || resizable.getXResizing() && !resizable.getYResizing()) {
                mhn.setCursor(Cursor.W_RESIZE);
            }
            if (inH && inV || resizable.getXResizing() && resizable.getYResizing()) {
                mhn.setCursor(Cursor.NW_RESIZE);
            }
            if (!(inV || inH || resizable.getXResizing() || resizable.getYResizing())) {
                if (ObjectGroupView.isInDraggableZone(dragNode, t) || resizable.getDragging()) {
                    mhn.setCursor(Cursor.MOVE);
                } else {
                    mhn.setCursor(Cursor.DEFAULT);
                }
            }
        });
        mhn.setOnMousePressed(t -> {
            if (t.getButton() == MouseButton.PRIMARY) {
                resizable.setXResizing(ObjectGroupView.isInHResizeZone(mhn, t));
                resizable.setYResizing(ObjectGroupView.isInVResizeZone(mhn, t));
                resizable.setDragging(ObjectGroupView.isInDraggableZone(dragNode, t) && !resizable.getXResizing() && !resizable.getYResizing());
                if (!(resizable.getDragging() || resizable.getXResizing() || resizable.getYResizing())) {
                    return;
                }
                resizable.setOriginalX(t.getSceneX());
                resizable.setOriginalY(t.getSceneY());
            } else {
                resizable.setXResizing(false);
                resizable.setYResizing(false);
                resizable.setDragging(false);
                mhn.setCursor(Cursor.DEFAULT);
            }
        });
        mhn.setOnMouseDragged(t -> {
            if (!(resizable.getDragging() || resizable.getXResizing() || resizable.getYResizing())) {
                return;
            }
            ResizableContentView resizableContentView2 = resizable;
            synchronized (resizableContentView2) {
                double mousex = t.getSceneX();
                double mousey = t.getSceneY();
                if (resizable.getDragging()) {
                    double maxX = Double.MAX_VALUE;
                    double maxY = Double.MAX_VALUE;
                    if (resizable.getObjectGroupViewParent().getObjectGroupViewParent() != null) {
                        maxX = resizableContentView.getObjectGroupViewParent().chartContentWidth - resizable.getContentWidth();
                        maxY = resizableContentView.getObjectGroupViewParent().chartContentHeight - resizable.getContentHeight();
                    }
                    resizable.setContentLayoutX(Math.max(0.0, Math.min(maxX, resizable.getContentLayoutX() + mousex - resizable.getOriginalX())));
                    resizable.setContentLayoutY(Math.max(0.0, Math.min(maxY, resizable.getContentLayoutY() + mousey - resizable.getOriginalY())));
                } else {
                    double minHeight = resizable instanceof ObjectGroupView ? 50 : 20;
                    double minWidth = 50.0;
                    if (resizable.getXResizing()) {
                        double maxWidth = resizableContentView.getObjectGroupViewParent().chartContentWidth - resizable.getContentLayoutX();
                        resizable.setContentWidth(Math.max(minWidth, Math.min(maxWidth, resizable.getContentWidth() + mousex - resizable.getOriginalX())));
                    }
                    if (resizable.getYResizing()) {
                        double maxHeigth = resizableContentView.getObjectGroupViewParent().chartContentHeight - resizable.getContentLayoutY();
                        resizable.setContentHeight(Math.max(minHeight, Math.min(maxHeigth, resizable.getContentHeight() + mousey - resizable.getOriginalY())));
                    }
                }
                resizable.setOriginalX(mousex);
                resizable.setOriginalY(mousey);
            }
            resizable.getObjectGroupViewParent().updateMinBounds();
            resizable.getObjectGroupViewParent().requestChartLayout();
        });
        mhn.setOnMouseReleased(t -> {
            resizable.setDragging(false);
            resizable.setXResizing(false);
            resizable.setYResizing(false);
            mhn.setCursor(Cursor.DEFAULT);
        });
    }

    protected static boolean isInDraggableZone(Region region, MouseEvent event) {
        return event.getY() > region.getLayoutY() && event.getY() < region.getLayoutY() + region.getHeight() && event.getX() > region.getLayoutX() && event.getX() < region.getLayoutX() + region.getWidth();
    }

    protected static boolean isInVResizeZone(Region region, MouseEvent event) {
        return event.getY() > region.getHeight() - 5.0;
    }

    protected static boolean isInHResizeZone(Region region, MouseEvent event) {
        return event.getX() > region.getWidth() - 5.0;
    }

    protected Label getTitleLabel() {
        if (this.titleLabel == null) {
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label) || !node.getStyleClass().contains((Object)"chart-title")) continue;
                this.titleLabel = (Label)node;
            }
        }
        return this.titleLabel;
    }

    protected void layoutChartChildren(double top, double left, double width, double height) {
        this.chartContentWidth = width + 20.0;
        this.chartContentHeight = height + 20.0;
        for (Map.Entry<ObjectGroup, ObjectGroupView> entry : this.childGroupViews.entrySet()) {
            ObjectGroup og = entry.getKey();
            ObjectGroupView ogv = entry.getValue();
            ogv.relocate(og.getContentLayoutX(), og.getContentLayoutY());
            if (og.getContentWidth() > 0.0) {
                ogv.setWidth(og.getContentWidth());
            }
            if (!(og.getContentHeight() > 0.0)) continue;
            ogv.setHeight(og.getContentHeight());
        }
        for (Map.Entry<Object, ResizableContentView> entry : this.objectValuesViews.entrySet()) {
            ObjectValues ov = (ObjectValues)entry.getKey();
            ObjectValuesView ovv = (ObjectValuesView)entry.getValue();
            ovv.relocate(ov.getContentLayoutX(), ov.getContentLayoutY());
            if (this.getContentWidth() > 0.0) {
                ovv.setWidth(ov.getContentWidth());
            }
            if (!(ov.getContentHeight() > 0.0)) continue;
            ovv.setHeight(ov.getContentHeight());
        }
        ((GraphChartView)FXUtils.findParent((Node)this, GraphChartView.class)).childChanged();
    }

    protected void updateMinBounds() {
        ObjectGroup og;
        double minWidth = 210.0;
        double minHeight = 182.0;
        for (Map.Entry<ObjectGroup, ObjectGroupView> entry : this.childGroupViews.entrySet()) {
            og = entry.getKey();
            minWidth = Math.max(minWidth, og.getContentLayoutX() + og.getContentWidth() + 10.0);
            minHeight = Math.max(minHeight, og.getContentLayoutY() + og.getContentHeight() + 12.0 + 20.0);
        }
        for (Map.Entry<Object, ResizableContentView> entry : this.objectValuesViews.entrySet()) {
            og = (ObjectValues)entry.getKey();
            minWidth = Math.max(minWidth, og.getContentLayoutX() + og.getContentWidth() + 10.0);
            minHeight = Math.max(minHeight, og.getContentLayoutY() + og.getContentHeight() + 12.0 + 20.0);
        }
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    @Override
    public double getContentWidth() {
        return this.objectGroup.getContentWidth();
    }

    @Override
    public void setContentWidth(double width) {
        this.objectGroup.setContentWidth(width);
    }

    @Override
    public double getContentHeight() {
        return this.objectGroup.getContentHeight();
    }

    @Override
    public void setContentHeight(double height) {
        this.objectGroup.setContentHeight(height);
    }

    @Override
    public double getContentLayoutX() {
        return this.objectGroup.getContentLayoutX();
    }

    @Override
    public void setContentLayoutX(double layoutX) {
        this.objectGroup.setContentLayoutX(layoutX);
    }

    @Override
    public double getContentLayoutY() {
        return this.objectGroup.getContentLayoutY();
    }

    @Override
    public void setContentLayoutY(double layoutY) {
        this.objectGroup.setContentLayoutY(layoutY);
    }

    @Override
    public Region getDragNode() {
        return this.getTitleLabel();
    }

    @Override
    public Region getMouseHandleNode() {
        return this;
    }

    @Override
    public double getOriginalX() {
        return this.originalX;
    }

    @Override
    public void setOriginalX(double originalX) {
        this.originalX = originalX;
    }

    @Override
    public double getOriginalY() {
        return this.originalY;
    }

    @Override
    public void setOriginalY(double originalY) {
        this.originalY = originalY;
    }

    @Override
    public boolean getXResizing() {
        return this.xResizing;
    }

    @Override
    public void setXResizing(boolean xDragging) {
        this.xResizing = xDragging;
    }

    @Override
    public boolean getYResizing() {
        return this.yResizing;
    }

    @Override
    public void setYResizing(boolean yDragging) {
        this.yResizing = yDragging;
    }

    @Override
    public boolean getDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

